<?php

/**
 * @package     Joomla.Site
 * @subpackage  mod_articles_news
 *
 * @copyright   (C) 2010 Open Source Matters, Inc. <https://www.joomla.org>
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die;

use Joomla\CMS\Layout\LayoutHelper;
?>

<article class="el-item jl-panel jl-margin-remove-first-child">

<div class="jl-child-width-expand jl-grid" jl-grid>

<?php if ($params->get('img_intro_full') !== 'none' && !empty($item->imageSrc)) : ?>

<div class="jl-width-1-2@s jl-flex-last@s">

<?php if ($item->link !== '' && $params->get('link_titles')) : ?>
	<a href="<?php echo $item->link; ?>">
<?php endif; ?>

    <figure class="item-image">
        <?php echo LayoutHelper::render(
            'joomla.html.image',
            [
                'src' => $item->imageSrc,
                'alt' => $item->imageAlt,
            ]
        ); ?>
        <?php if (!empty($item->imageCaption)) : ?>
            <figcaption>
                <?php echo $item->imageCaption; ?>
            </figcaption>
        <?php endif; ?>
    </figure>


<?php if ($item->link !== '' && $params->get('link_titles')) : ?>
	</a>
<?php endif; ?>

</div>

<?php endif; ?>

<div class="jl-margin-remove-first-child">
       
<?php if ($params->get('item_title')) : ?>
    <?php $item_heading = $params->get('item_heading', 'h4'); ?>
    <<?php echo $item_heading; ?> class="el-title jl-margin-small-top jl-margin-remove-bottom">
    <?php if ($item->link !== '' && $params->get('link_titles')) : ?>
        <a href="<?php echo $item->link; ?>" class="jl-link-heading">
            <?php echo $item->title; ?>
        </a>
    <?php else : ?>
        <?php echo $item->title; ?>
    <?php endif; ?>
    </<?php echo $item_heading; ?>>
<?php endif; ?>      

<?php if (!$params->get('intro_only')) : ?>
    <?php echo $item->afterDisplayTitle; ?>
<?php endif; ?>

<?php echo $item->beforeDisplayContent; ?>

<?php if ($params->get('show_introtext', 1)) : ?>
	<div class="el-content jl-panel jl-margin-top">
		<?php echo $item->introtext; ?>
	</div>
<?php endif; ?>

<?php echo $item->afterDisplayContent; ?>

<?php if (isset($item->link) && $item->readmore != 0 && $params->get('readmore')) : ?>
    <?php echo LayoutHelper::render('joomla.content.readmore', ['item' => $item, 'params' => $item->params, 'link' => $item->link]); ?>
<?php endif; ?>

</div>
</div>

</article>