/**ABDB**/CREATE TABLE `#__action_log_config` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `type_title` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `type_alias` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `id_holder` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `title_holder` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `table_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `text_prefix` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=24 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__action_log_config`  VALUES 
('1', 'article', 'com_content.article', 'id', 'title', '#__content', 'PLG_ACTIONLOG_JOOMLA'),
('2', 'article', 'com_content.form', 'id', 'title', '#__content', 'PLG_ACTIONLOG_JOOMLA'),
('3', 'banner', 'com_banners.banner', 'id', 'name', '#__banners', 'PLG_ACTIONLOG_JOOMLA'),
('4', 'user_note', 'com_users.note', 'id', 'subject', '#__user_notes', 'PLG_ACTIONLOG_JOOMLA'),
('5', 'media', 'com_media.file', '', 'name', '', 'PLG_ACTIONLOG_JOOMLA'),
('6', 'category', 'com_categories.category', 'id', 'title', '#__categories', 'PLG_ACTIONLOG_JOOMLA'),
('7', 'menu', 'com_menus.menu', 'id', 'title', '#__menu_types', 'PLG_ACTIONLOG_JOOMLA'),
('8', 'menu_item', 'com_menus.item', 'id', 'title', '#__menu', 'PLG_ACTIONLOG_JOOMLA'),
('9', 'newsfeed', 'com_newsfeeds.newsfeed', 'id', 'name', '#__newsfeeds', 'PLG_ACTIONLOG_JOOMLA'),
('10', 'link', 'com_redirect.link', 'id', 'old_url', '#__redirect_links', 'PLG_ACTIONLOG_JOOMLA'),
('11', 'tag', 'com_tags.tag', 'id', 'title', '#__tags', 'PLG_ACTIONLOG_JOOMLA'),
('12', 'style', 'com_templates.style', 'id', 'title', '#__template_styles', 'PLG_ACTIONLOG_JOOMLA'),
('13', 'plugin', 'com_plugins.plugin', 'extension_id', 'name', '#__extensions', 'PLG_ACTIONLOG_JOOMLA'),
('14', 'component_config', 'com_config.component', 'extension_id', 'name', '', 'PLG_ACTIONLOG_JOOMLA'),
('15', 'contact', 'com_contact.contact', 'id', 'name', '#__contact_details', 'PLG_ACTIONLOG_JOOMLA'),
('16', 'module', 'com_modules.module', 'id', 'title', '#__modules', 'PLG_ACTIONLOG_JOOMLA'),
('17', 'access_level', 'com_users.level', 'id', 'title', '#__viewlevels', 'PLG_ACTIONLOG_JOOMLA'),
('18', 'banner_client', 'com_banners.client', 'id', 'name', '#__banner_clients', 'PLG_ACTIONLOG_JOOMLA'),
('19', 'application_config', 'com_config.application', '', 'name', '', 'PLG_ACTIONLOG_JOOMLA'),
('20', 'task', 'com_scheduler.task', 'id', 'title', '#__scheduler_tasks', 'PLG_ACTIONLOG_JOOMLA'),
('21', 'field', 'com_fields.field', 'id', 'title', '#__fields', 'PLG_ACTIONLOG_JOOMLA'),
('22', 'guidedtour', 'com_guidedtours.state', 'id', 'title', '#__guidedtours', 'PLG_ACTIONLOG_JOOMLA'),
('23', 'contact', 'com_contact.form', 'id', 'name', '#__contact_details', 'PLG_ACTIONLOG_JOOMLA');
/**ABDB**/CREATE TABLE `#__action_logs` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `message_language_key` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `message` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `log_date` datetime NOT NULL,
  `extension` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_id` int NOT NULL DEFAULT '0',
  `item_id` int NOT NULL DEFAULT '0',
  `ip_address` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '0.0.0.0',
  PRIMARY KEY (`id`),
  KEY `idx_user_id` (`user_id`),
  KEY `idx_user_id_logdate` (`user_id`,`log_date`),
  KEY `idx_user_id_extension` (`user_id`,`extension`),
  KEY `idx_extension_item_id` (`extension`,`item_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/CREATE TABLE `#__action_logs_extensions` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `extension` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=22 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__action_logs_extensions`  VALUES 
('1', 'com_banners'),
('2', 'com_cache'),
('3', 'com_categories'),
('4', 'com_config'),
('5', 'com_contact'),
('6', 'com_content'),
('7', 'com_installer'),
('8', 'com_media'),
('9', 'com_menus'),
('10', 'com_messages'),
('11', 'com_modules'),
('12', 'com_newsfeeds'),
('13', 'com_plugins'),
('14', 'com_redirect'),
('15', 'com_tags'),
('16', 'com_templates'),
('17', 'com_users'),
('18', 'com_checkin'),
('19', 'com_scheduler'),
('20', 'com_fields'),
('21', 'com_guidedtours');
/**ABDB**/CREATE TABLE `#__action_logs_users` (
  `user_id` int unsigned NOT NULL,
  `notify` tinyint unsigned NOT NULL,
  `extensions` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`user_id`),
  KEY `idx_notify` (`notify`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/CREATE TABLE `#__akeeba_common` (
  `key` varchar(190) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `value` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__akeeba_common`  VALUES 
('file_fef', '[]'),
('fof30', '[]'),
('fof40', '[]'),
('stats_lastrun', '1761044412'),
('stats_siteid', '02534e60cd706b5679768a8df90f6907a9a498d7'),
('stats_siteurl', 'a39c766769eac82ad7db5eefa122ac9f');
/**ABDB**/CREATE TABLE `#__akeebabackup_backups` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `description` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `comment` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `backupstart` timestamp NULL DEFAULT NULL,
  `backupend` timestamp NULL DEFAULT NULL,
  `status` enum('run','fail','complete') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'run',
  `origin` varchar(30) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'backend',
  `type` varchar(30) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'full',
  `profile_id` bigint NOT NULL DEFAULT '1',
  `archivename` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `absolute_path` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `multipart` int NOT NULL DEFAULT '0',
  `tag` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `backupid` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `filesexist` tinyint NOT NULL DEFAULT '1',
  `remote_filename` varchar(1000) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `total_size` bigint NOT NULL DEFAULT '0',
  `frozen` tinyint(1) NOT NULL DEFAULT '0',
  `instep` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_fullstatus` (`filesexist`,`status`),
  KEY `idx_stale` (`status`,`origin`)
) ENGINE=InnoDB AUTO_INCREMENT=95 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__akeebabackup_backups`  VALUES 
('94', 'Backup taken on Friday, 24 October 2025 05:34 UTC', '', '2025-10-24 05:34:03', '2025-10-24 05:34:12', 'complete', 'backend', 'full', '1', 'besto_joomla_quickstart_j6-L-rGKKknjPnKmfM7.zip', '/Users/phongto/Sites/besto/administrator/components/com_akeebabackup/backup/besto_joomla_quickstart_j6-L-rGKKknjPnKmfM7.zip', '0', 'backend', 'id-20251024-053403-960911', '1', NULL, '0', '0', '1');
/**ABDB**/CREATE TABLE `#__akeebabackup_profiles` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `description` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `configuration` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `filters` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `quickicon` tinyint NOT NULL DEFAULT '1',
  `access` int DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__akeebabackup_profiles`  VALUES 
('1', 'Default Backup Profile', '###AES128###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', '', '1', '1');
/**ABDB**/CREATE TABLE `#__akeebabackup_storage` (
  `tag` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `lastupdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `data` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`tag`(100))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/CREATE TABLE `#__assets` (
  `id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Primary Key',
  `parent_id` int NOT NULL DEFAULT '0' COMMENT 'Nested set parent.',
  `lft` int NOT NULL DEFAULT '0' COMMENT 'Nested set lft.',
  `rgt` int NOT NULL DEFAULT '0' COMMENT 'Nested set rgt.',
  `level` int unsigned NOT NULL COMMENT 'The cached level in the nested tree.',
  `name` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'The unique name for the asset.\n',
  `title` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'The descriptive title for the asset.',
  `rules` varchar(5120) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'JSON encoded access control.',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_asset_name` (`name`),
  KEY `idx_lft_rgt` (`lft`,`rgt`),
  KEY `idx_parent_id` (`parent_id`)
) ENGINE=InnoDB AUTO_INCREMENT=327 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__assets`  VALUES 
('1', '0', '1', '448', '0', 'root.1', 'Root Asset', '{\"core.login.site\":{\"6\":1,\"2\":1},\"core.login.admin\":{\"6\":1},\"core.admin\":{\"8\":1},\"core.manage\":{\"7\":1},\"core.create\":{\"6\":1,\"3\":1},\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1},\"core.edit.own\":{\"6\":1,\"3\":1}}'),
('2', '1', '1', '2', '1', 'com_admin', 'com_admin', '{}'),
('3', '1', '3', '6', '1', 'com_banners', 'com_banners', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1},\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'),
('4', '1', '7', '8', '1', 'com_cache', 'com_cache', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"7\":1}}'),
('5', '1', '9', '10', '1', 'com_checkin', 'com_checkin', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"7\":1}}'),
('6', '1', '11', '12', '1', 'com_config', 'com_config', '{}'),
('7', '1', '13', '18', '1', 'com_contact', 'com_contact', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1}}'),
('8', '1', '19', '84', '1', 'com_content', 'com_content', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1},\"core.create\":{\"3\":1},\"core.edit\":{\"4\":1},\"core.edit.state\":{\"5\":1}}'),
('9', '1', '85', '86', '1', 'com_cpanel', 'com_cpanel', '{}'),
('10', '1', '87', '88', '1', 'com_installer', 'com_installer', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"7\":1},\"core.delete\":[],\"core.edit.state\":[]}'),
('11', '1', '89', '90', '1', 'com_languages', 'com_languages', '{\"core.admin\":{\"7\":1},\"core.manage\":[],\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'),
('12', '1', '91', '92', '1', 'com_login', 'com_login', '{}'),
('13', '1', '93', '94', '1', 'com_mailto', 'com_mailto', '{}'),
('14', '1', '95', '96', '1', 'com_massmail', 'com_massmail', '{}'),
('15', '1', '97', '98', '1', 'com_media', 'com_media', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1},\"core.create\":{\"3\":1},\"core.delete\":{\"5\":1}}'),
('16', '1', '99', '104', '1', 'com_menus', 'com_menus', '{\"core.admin\":{\"7\":1},\"core.manage\":[],\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'),
('17', '1', '105', '106', '1', 'com_messages', 'com_messages', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"7\":1}}'),
('18', '1', '107', '130', '1', 'com_modules', 'com_modules', '{\"core.admin\":{\"7\":1},\"core.manage\":[],\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'),
('19', '1', '131', '132', '1', 'com_newsfeeds', 'com_newsfeeds', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1},\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"core.edit.own\":[]}'),
('27', '8', '20', '37', '2', 'com_content.category.2', 'Uncategorised', '{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"core.edit.own\":[]}'),
('28', '3', '4', '5', '2', 'com_banners.category.3', 'Uncategorised', '{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'),
('29', '7', '14', '15', '2', 'com_contact.category.4', 'Uncategorised', '{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"core.edit.own\":[]}'),
('32', '8', '38', '63', '2', 'com_content.category.7', 'Blog', '{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"core.edit.own\":[]}'),
('33', '256', '77', '78', '3', 'com_content.article.1', 'Theme Typography', '{}'),
('36', '27', '23', '24', '3', 'com_content.article.4', 'UIkit Overview', '{}'),
('40', '32', '39', '40', '3', 'com_content.article.8', 'Key factors for productive work as a team', '{}'),
('41', '32', '41', '42', '3', 'com_content.article.9', 'Our guide to 3D graphic design for beginners', '{}'),
('42', '32', '43', '44', '3', 'com_content.article.10', 'Working with pleasure is crucial for your career', '{}'),
('56', '7', '16', '17', '2', 'com_contact.category.8', 'Contacts', '{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"core.edit.own\":[]}'),
('59', '1', '386', '387', '1', 'com_finder', 'com_finder', '{\"core.admin\":[],\"core.manage\":[]}'),
('63', '1', '390', '391', '1', 'com_joomlaupdate', 'com_joomlaupdate', '{\"core.admin\":{\"8\":1},\"core.manage\":{\"7\":1},\"core.delete\":{\"6\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}'),
('71', '1', '404', '405', '1', 'com_tags', 'com_tags', '{}'),
('72', '1', '406', '407', '1', 'com_contenthistory', 'com_contenthistory', '{}'),
('73', '1', '408', '409', '1', 'com_ajax', 'com_ajax', '{}'),
('74', '1', '410', '411', '1', 'com_postinstall', 'com_postinstall', '{}'),
('99', '18', '132', '133', '2', 'com_modules.module.41', 'Sub Menu', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}'),
('100', '18', '134', '135', '2', 'com_modules.module.42', 'Sidebar Menu', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1},\"module.edit.frontend\":[]}'),
('104', '18', '136', '137', '2', 'com_modules.module.49', 'Login', '{}'),
('127', '18', '140', '141', '2', 'com_modules.module.76', 'Twitter List', ''),
('129', '18', '142', '143', '2', 'com_modules.module.78', 'Twitter Bubbles', ''),
('130', '18', '144', '145', '2', 'com_modules.module.79', 'Twitter Single', ''),
('132', '18', '146', '147', '2', 'com_modules.module.83', 'ZOO Item', ''),
('133', '18', '148', '149', '2', 'com_modules.module.84', 'ZOO Comment', ''),
('134', '18', '150', '151', '2', 'com_modules.module.85', 'ZOO Tag', ''),
('135', '18', '152', '153', '2', 'com_modules.module.86', 'ZOO Category', ''),
('136', '18', '154', '155', '2', 'com_modules.module.88', 'App Bundle', ''),
('141', '18', '156', '157', '2', 'com_modules.module.94', 'Offcanvas Menu', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1},\"module.edit.frontend\":[]}'),
('151', '32', '51', '52', '3', 'com_content.article.24', 'Why planning ahead is wrong for designers?', '{}'),
('153', '32', '53', '54', '3', 'com_content.article.25', 'How Interior Designers Get Inspired', '{}'),
('156', '32', '57', '58', '3', 'com_content.article.26', 'Modern Architectural Solutions for Condos', '{}'),
('164', '8', '64', '65', '2', 'com_content.category.10', 'News', '{\"core.create\":{\"6\":1,\"3\":1},\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1},\"core.edit.own\":{\"6\":1,\"3\":1}}'),
('191', '32', '59', '60', '3', 'com_content.article.23', 'How to not get lost in the virtual world', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}'),
('193', '256', '75', '76', '3', 'com_content.article.46', 'Layout content | right sidebar', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}'),
('194', '256', '73', '74', '3', 'com_content.article.47', 'Layout Left Sidebar | Content', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}'),
('195', '256', '71', '72', '3', 'com_content.article.48', 'Left | Content | Right', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}'),
('196', '256', '69', '70', '3', 'com_content.article.49', 'Content | Left | Right', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}'),
('197', '256', '67', '68', '3', 'com_content.article.50', 'Main Content Only', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}'),
('239', '18', '108', '109', '2', 'com_modules.module.147', 'RokSprocket Module', '{}'),
('256', '8', '66', '83', '2', 'com_content.category.11', 'Features', '{\"core.create\":{\"6\":1,\"3\":1},\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1},\"core.edit.own\":{\"6\":1,\"3\":1}}'),
('273', '1', '418', '419', '1', 'com_fields', 'com_fields', '{}'),
('274', '1', '420', '421', '1', 'com_associations', 'com_associations', '{}'),
('275', '1', '422', '423', '1', 'com_privacy', 'com_privacy', '{}'),
('276', '1', '424', '425', '1', 'com_actionlogs', 'com_actionlogs', '{}'),
('280', '1', '426', '427', '1', 'com_gantry5', 'com_gantry5', '{}'),
('281', '16', '100', '101', '2', 'com_menus.menu.5', 'Main Menu', '{}'),
('282', '18', '110', '111', '2', 'com_modules.module.172', 'Breadcrumbs', '{}'),
('286', '256', '79', '80', '3', 'com_content.article.58', 'Variations', '{}'),
('287', '18', '112', '113', '2', 'com_modules.module.195', 'Latest News', '{}'),
('288', '1', '428', '429', '1', 'com_users', 'com_users', '{\"core.admin\":{\"8\":1},\"core.manage\":{\"7\":1},\"core.create\":{\"6\":1,\"3\":1},\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}'),
('297', '18', '114', '115', '2', 'com_modules.module.204', 'Footer Search', '{}'),
('298', '1', '430', '431', '1', 'com_akeebabackup', 'com_akeebabackup', '{}'),
('299', '32', '61', '62', '3', 'com_content.article.59', 'Replacing Social Media with Modern Art', '{}'),
('310', '18', '116', '117', '2', 'com_modules.module.213', 'Video module', '{}'),
('311', '256', '81', '82', '3', 'com_content.article.60', 'Header Layouts', '{}'),
('312', '16', '102', '103', '2', 'com_menus.menu.7', 'Hidden Menu', '{}'),
('313', '1', '432', '433', '1', 'com_convertforms', 'COM_CONVERTFORMS', '{}'),
('314', '18', '118', '119', '2', 'com_modules.module.215', 'Newsletter', '{}'),
('315', '18', '120', '121', '2', 'com_modules.module.216', 'Recent Articles', '{}'),
('316', '18', '122', '123', '2', 'com_modules.module.217', 'Slideshow Animated text', '{}'),
('317', '18', '124', '125', '2', 'com_modules.module.218', 'Progressbar module', '{}'),
('318', '18', '126', '127', '2', 'com_modules.module.219', 'Contact form', '{}'),
('319', '18', '128', '129', '2', 'com_modules.module.220', 'FAQ module', '{}'),
('320', '1', '434', '435', '1', 'com_guidedtours', 'com_guidedtours', '{}'),
('321', '1', '436', '437', '1', 'com_mails', 'com_mails', '{}'),
('322', '1', '438', '439', '1', 'com_scheduler', 'com_scheduler', '{}'),
('323', '1', '440', '441', '1', 'com_workflow', 'com_workflow', '{}'),
('324', '1', '442', '443', '1', 'com_scheduler.task.1', 'com_scheduler.task.1', '{}'),
('325', '1', '444', '445', '1', 'com_scheduler.task.2', 'com_scheduler.task.2', '{}'),
('326', '1', '446', '447', '1', 'com_scheduler.task.3', 'com_scheduler.task.3', '{}');
/**ABDB**/CREATE TABLE `#__associations` (
  `id` int NOT NULL COMMENT 'A reference to the associated item.',
  `context` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'The context of the associated item.',
  `key` char(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'The key for the association computed from an md5 on associated ids.',
  PRIMARY KEY (`context`,`id`),
  KEY `idx_key` (`key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/CREATE TABLE `#__banner_clients` (
  `id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `contact` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `email` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `extrainfo` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `state` tinyint NOT NULL DEFAULT '0',
  `checked_out` int unsigned DEFAULT NULL,
  `checked_out_time` datetime DEFAULT NULL,
  `metakey` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `own_prefix` tinyint NOT NULL DEFAULT '0',
  `metakey_prefix` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `purchase_type` tinyint NOT NULL DEFAULT '-1',
  `track_clicks` tinyint NOT NULL DEFAULT '-1',
  `track_impressions` tinyint NOT NULL DEFAULT '-1',
  PRIMARY KEY (`id`),
  KEY `idx_own_prefix` (`own_prefix`),
  KEY `idx_metakey_prefix` (`metakey_prefix`(100))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/CREATE TABLE `#__banner_tracks` (
  `track_date` datetime NOT NULL,
  `track_type` int unsigned NOT NULL,
  `banner_id` int unsigned NOT NULL,
  `count` int unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`track_date`,`track_type`,`banner_id`),
  KEY `idx_track_date` (`track_date`),
  KEY `idx_track_type` (`track_type`),
  KEY `idx_banner_id` (`banner_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/CREATE TABLE `#__banners` (
  `id` int NOT NULL AUTO_INCREMENT,
  `cid` int NOT NULL DEFAULT '0',
  `type` int NOT NULL DEFAULT '0',
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `alias` varchar(400) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL DEFAULT '',
  `imptotal` int NOT NULL DEFAULT '0',
  `impmade` int NOT NULL DEFAULT '0',
  `clicks` int NOT NULL DEFAULT '0',
  `clickurl` varchar(2048) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `state` tinyint NOT NULL DEFAULT '0',
  `catid` int unsigned NOT NULL DEFAULT '0',
  `description` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `custombannercode` varchar(2048) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `sticky` tinyint unsigned NOT NULL DEFAULT '0',
  `ordering` int NOT NULL DEFAULT '0',
  `metakey` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `params` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `own_prefix` tinyint(1) NOT NULL DEFAULT '0',
  `metakey_prefix` varchar(400) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `purchase_type` tinyint NOT NULL DEFAULT '-1',
  `track_clicks` tinyint NOT NULL DEFAULT '-1',
  `track_impressions` tinyint NOT NULL DEFAULT '-1',
  `checked_out` int unsigned DEFAULT NULL,
  `checked_out_time` datetime DEFAULT NULL,
  `publish_up` datetime DEFAULT NULL,
  `publish_down` datetime DEFAULT NULL,
  `reset` datetime DEFAULT NULL,
  `created` datetime NOT NULL,
  `language` char(7) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `created_by` int unsigned NOT NULL DEFAULT '0',
  `created_by_alias` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `modified` datetime NOT NULL,
  `modified_by` int unsigned NOT NULL DEFAULT '0',
  `version` int unsigned NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `idx_state` (`state`),
  KEY `idx_own_prefix` (`own_prefix`),
  KEY `idx_banner_catid` (`catid`),
  KEY `idx_language` (`language`),
  KEY `idx_metakey_prefix` (`metakey_prefix`(100))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/CREATE TABLE `#__categories` (
  `id` int NOT NULL AUTO_INCREMENT,
  `asset_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'FK to the #__assets table.',
  `parent_id` int unsigned NOT NULL DEFAULT '0',
  `lft` int NOT NULL DEFAULT '0',
  `rgt` int NOT NULL DEFAULT '0',
  `level` int unsigned NOT NULL DEFAULT '0',
  `path` varchar(400) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `extension` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `title` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `alias` varchar(400) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL DEFAULT '',
  `note` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `description` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `published` tinyint(1) NOT NULL DEFAULT '0',
  `checked_out` int unsigned DEFAULT NULL,
  `checked_out_time` datetime DEFAULT NULL,
  `access` int unsigned DEFAULT NULL,
  `params` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `metadesc` varchar(1024) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'The meta description for the page.',
  `metakey` varchar(1024) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'The meta keywords for the page.',
  `metadata` varchar(2048) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'JSON encoded metadata properties.',
  `created_user_id` int unsigned NOT NULL DEFAULT '0',
  `created_time` datetime NOT NULL,
  `modified_user_id` int unsigned NOT NULL DEFAULT '0',
  `modified_time` datetime NOT NULL,
  `hits` int unsigned NOT NULL DEFAULT '0',
  `language` char(7) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `version` int unsigned NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `cat_idx` (`extension`,`published`,`access`),
  KEY `idx_access` (`access`),
  KEY `idx_checkout` (`checked_out`),
  KEY `idx_left_right` (`lft`,`rgt`),
  KEY `idx_language` (`language`),
  KEY `idx_path` (`path`(100)),
  KEY `idx_alias` (`alias`(100))
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__categories`  VALUES 
('1', '0', '0', '0', '21', '0', '', 'system', 'ROOT', 'root', '', '', '1', NULL, NULL, '1', '{}', '', '', '', '107', '2009-10-18 16:07:09', '107', '2009-10-18 16:07:09', '0', '*', '1'),
('2', '27', '1', '1', '2', '1', 'uncategorised', 'com_content', 'Uncategorised', 'uncategorised', '', '', '1', NULL, NULL, '1', '{\"target\":\"\",\"image\":\"\"}', '', '', '{\"page_title\":\"\",\"author\":\"\",\"robots\":\"\"}', '107', '2010-06-28 13:26:37', '107', '2010-06-28 13:26:37', '5', '*', '1'),
('3', '28', '1', '3', '4', '1', 'uncategorised', 'com_banners', 'Uncategorised', 'uncategorised', '', '', '1', NULL, NULL, '1', '{\"target\":\"\",\"image\":\"\",\"foobar\":\"\"}', '', '', '{\"page_title\":\"\",\"author\":\"\",\"robots\":\"\"}', '107', '2010-06-28 13:27:35', '107', '2010-06-28 13:27:35', '0', '*', '1'),
('4', '29', '1', '5', '6', '1', 'uncategorised', 'com_contact', 'Uncategorised', 'uncategorised', '', '', '1', NULL, NULL, '1', '{\"target\":\"\",\"image\":\"\"}', '', '', '{\"page_title\":\"\",\"author\":\"\",\"robots\":\"\"}', '107', '2010-06-28 13:27:57', '107', '2010-06-28 13:27:57', '0', '*', '1'),
('5', '30', '1', '7', '8', '1', 'uncategorised', 'com_newsfeeds', 'Uncategorised', 'uncategorised', '', '', '1', NULL, NULL, '1', '{\"target\":\"\",\"image\":\"\"}', '', '', '{\"page_title\":\"\",\"author\":\"\",\"robots\":\"\"}', '107', '2010-06-28 13:28:15', '107', '2010-06-28 13:28:15', '0', '*', '1'),
('6', '31', '1', '9', '10', '1', 'uncategorised', 'com_weblinks', 'Uncategorised', 'uncategorised', '', '', '1', NULL, NULL, '1', '{\"target\":\"\",\"image\":\"\"}', '', '', '{\"page_title\":\"\",\"author\":\"\",\"robots\":\"\"}', '107', '2010-06-28 13:28:33', '107', '2010-06-28 13:28:33', '0', '*', '1'),
('7', '32', '1', '11', '12', '1', 'blog', 'com_content', 'Blog', 'blog', '', '', '1', NULL, NULL, '1', '{\"category_layout\":\"\",\"image\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', '107', '2011-05-02 11:42:21', '107', '2011-05-02 11:42:21', '170', '*', '1'),
('8', '56', '1', '13', '14', '1', 'contacts', 'com_contact', 'Contacts', 'contacts', '', '', '1', NULL, NULL, '1', '{\"category_layout\":\"\",\"image\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', '107', '2011-11-18 16:32:10', '42', '2011-11-18 16:32:13', '0', '*', '1'),
('9', '57', '1', '15', '16', '1', 'yootheme-links', 'com_weblinks', 'YOOtheme Links', 'yootheme-links', '', '', '1', NULL, NULL, '1', '{\"category_layout\":\"\",\"image\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', '107', '2012-01-22 12:45:00', '107', '2012-01-22 12:45:00', '0', '*', '1'),
('10', '164', '1', '17', '18', '1', 'news', 'com_content', 'News', 'news', '', '', '1', NULL, NULL, '1', '{\"category_layout\":\"\",\"image\":\"\",\"image_alt\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', '107', '2015-08-14 03:00:37', '107', '2016-09-03 04:19:44', '0', '*', '1'),
('11', '256', '1', '19', '20', '1', 'features', 'com_content', 'Features', 'features', '', '', '1', NULL, NULL, '1', '{\"category_layout\":\"\",\"image\":\"\",\"image_alt\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', '107', '2015-12-21 15:03:17', '107', '2021-05-13 20:39:44', '0', '*', '1');
/**ABDB**/CREATE TABLE `#__contact_details` (
  `id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `alias` varchar(400) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
  `con_position` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `address` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `suburb` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `state` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `country` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `postcode` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `telephone` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `fax` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `misc` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `image` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `email_to` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `default_con` tinyint unsigned NOT NULL DEFAULT '0',
  `published` tinyint(1) NOT NULL DEFAULT '0',
  `checked_out` int unsigned DEFAULT NULL,
  `checked_out_time` datetime DEFAULT NULL,
  `ordering` int NOT NULL DEFAULT '0',
  `params` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_id` int NOT NULL DEFAULT '0',
  `catid` int NOT NULL DEFAULT '0',
  `access` int unsigned DEFAULT NULL,
  `mobile` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `webpage` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `sortname1` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `sortname2` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `sortname3` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `language` varchar(7) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created` datetime NOT NULL,
  `created_by` int unsigned NOT NULL DEFAULT '0',
  `created_by_alias` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `modified` datetime NOT NULL,
  `modified_by` int unsigned NOT NULL DEFAULT '0',
  `metakey` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `metadesc` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `metadata` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `featured` tinyint unsigned NOT NULL DEFAULT '0' COMMENT 'Set if article is featured.',
  `publish_up` datetime DEFAULT NULL,
  `publish_down` datetime DEFAULT NULL,
  `version` int unsigned NOT NULL DEFAULT '1',
  `hits` int unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_access` (`access`),
  KEY `idx_checkout` (`checked_out`),
  KEY `idx_state` (`published`),
  KEY `idx_catid` (`catid`),
  KEY `idx_createdby` (`created_by`),
  KEY `idx_featured_catid` (`featured`,`catid`),
  KEY `idx_language` (`language`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__contact_details`  VALUES 
('1', 'John Q. Public', 'john-q-public', '', '15th Avenue at St. Marks Place, Cathedral District Brooklyn, NY', '', '', '', '', '0100-5200-369', '', '<p>\r\n  Please feel free to get in touch anytime, whether for work inquiries or to just say hello@website.com.\r\n</p>\r\n<p>\r\n  We\'re currently accepting new freelance design projects, and always excited to hear interesting proposals.\r\n</p>', 'images/lead/blog_themes.jpg#joomlaImage://local-images/lead/blog_themes.jpg?width=970&height=450', 'support@my-domain.com', '0', '1', NULL, NULL, '1', '{\"show_contact_category\":\"\",\"show_contact_list\":\"\",\"show_tags\":\"\",\"show_info\":\"\",\"show_name\":\"\",\"show_position\":\"\",\"show_email\":\"\",\"add_mailto_link\":\"\",\"show_street_address\":\"\",\"show_suburb\":\"\",\"show_state\":\"\",\"show_postcode\":\"\",\"show_country\":\"\",\"show_telephone\":\"\",\"show_mobile\":\"\",\"show_fax\":\"\",\"show_webpage\":\"\",\"show_image\":\"\",\"show_misc\":\"\",\"allow_vcard\":\"\",\"show_articles\":\"\",\"articles_display_num\":\"\",\"show_profile\":\"\",\"contact_layout\":\"\",\"show_links\":\"\",\"linka_name\":\"\",\"linka\":\"\",\"linkb_name\":\"\",\"linkb\":\"\",\"linkc_name\":\"\",\"linkc\":\"\",\"linkd_name\":\"\",\"linkd\":\"\",\"linke_name\":\"\",\"linke\":\"\",\"show_email_form\":\"\",\"show_email_copy\":\"\",\"validate_session\":\"\",\"custom_reply\":\"\",\"redirect\":\"\"}', '107', '8', '1', '', '', '', '', '', '*', '2011-11-18 16:33:47', '107', '', '2023-04-22 14:28:39', '107', '', '', '{\"robots\":\"\",\"rights\":\"\"}', '0', '2021-05-15 23:48:51', NULL, '13', '246'),
('2', 'Jane Q. Public', 'jane-q-public', 'Chief Information Officer', '1 Infinite Loop', 'Cupertino', 'California', 'USA', '95014', '1-212-555555-1', '1-212-555555-2', 'Lorem ipsum dolor sit amet, consetetur sadipscing elitr.', '', 'email@0.0.0.0', '0', '-2', NULL, NULL, '2', '{\"show_contact_category\":\"\",\"show_contact_list\":\"\",\"presentation_style\":\"\",\"show_name\":\"\",\"show_position\":\"\",\"show_email\":\"\",\"show_street_address\":\"\",\"show_suburb\":\"\",\"show_state\":\"\",\"show_postcode\":\"\",\"show_country\":\"\",\"show_telephone\":\"\",\"show_mobile\":\"\",\"show_fax\":\"\",\"show_webpage\":\"\",\"show_misc\":\"\",\"show_image\":\"\",\"allow_vcard\":\"\",\"show_articles\":\"\",\"show_profile\":\"\",\"show_links\":\"\",\"linka_name\":\"\",\"linka\":\"\",\"linkb_name\":\"\",\"linkb\":\"\",\"linkc_name\":\"\",\"linkc\":\"\",\"linkd_name\":\"\",\"linkd\":\"\",\"linke_name\":\"\",\"linke\":\"\",\"contact_layout\":\"\",\"show_email_form\":\"\",\"show_email_copy\":\"\",\"banned_email\":\"\",\"banned_subject\":\"\",\"banned_text\":\"\",\"validate_session\":\"\",\"custom_reply\":\"\",\"redirect\":\"\"}', '0', '8', '1', '', '', '', '', '', '*', '2011-11-18 16:35:05', '107', '', '2012-01-19 16:37:23', '42', '', '', '{\"robots\":\"\",\"rights\":\"\"}', '0', '2021-05-15 23:48:51', NULL, '1', '47');
/**ABDB**/CREATE TABLE `#__content` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `asset_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'FK to the #__assets table.',
  `title` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `alias` varchar(400) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL DEFAULT '',
  `introtext` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `fulltext` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `state` tinyint NOT NULL DEFAULT '0',
  `catid` int unsigned NOT NULL DEFAULT '0',
  `created` datetime NOT NULL,
  `created_by` int unsigned NOT NULL DEFAULT '0',
  `created_by_alias` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `modified` datetime NOT NULL,
  `modified_by` int unsigned NOT NULL DEFAULT '0',
  `checked_out` int unsigned DEFAULT NULL,
  `checked_out_time` datetime DEFAULT NULL,
  `publish_up` datetime DEFAULT NULL,
  `publish_down` datetime DEFAULT NULL,
  `images` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `urls` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `attribs` varchar(5120) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `version` int unsigned NOT NULL DEFAULT '1',
  `ordering` int NOT NULL DEFAULT '0',
  `metakey` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `metadesc` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `access` int unsigned NOT NULL DEFAULT '0',
  `hits` int unsigned NOT NULL DEFAULT '0',
  `metadata` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `featured` tinyint unsigned NOT NULL DEFAULT '0' COMMENT 'Set if article is featured.',
  `language` char(7) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'The language code for the article.',
  `note` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `idx_access` (`access`),
  KEY `idx_checkout` (`checked_out`),
  KEY `idx_state` (`state`),
  KEY `idx_catid` (`catid`),
  KEY `idx_createdby` (`created_by`),
  KEY `idx_featured_catid` (`featured`,`catid`),
  KEY `idx_language` (`language`),
  KEY `idx_alias` (`alias`(191))
) ENGINE=InnoDB AUTO_INCREMENT=61 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__content`  VALUES 
('1', '33', 'Theme Typography', 'theme-typography', '<p>We\'ve used <a href=\"https://rsms.me/inter\">Inter</a> font family for all of the themes because it\'s a beautiful font for UI design and is completely open-source and free. Using a custom font is nice because it allows us to make the components look the same on all browsers and operating systems. You can choose Google font via theme settings instead using local font. It\'s optional.</p>\r\n <h1>Headings</h1>\r\n    <p>All HTML headings, <code>&lt;h1&gt;</code> through <code>&lt;h6&gt;</code> are available.</p>\r\n<h1>Typography (h1)</h1><p>Lorem ipsum dolor sit amet, consectetuer adipiscing elit, sed diam nonummy nibh euismod tincidunt ut laoreet dolore magna aliquam erat volutpat. Ut wisi enim ad minim veniam, quis nostrud exerci tation ullamcorper suscipit lobortis nisl ut aliquip ex. (p)</p><h2>Lorem Ipsum Dolor Sit Amet (h2)</h2><p><strong>Lorem ipsum dolor sit amet, consectetuer adipiscing elit </strong> (strong), sed diam nonummy nibh euismod tincidunt ut laoreet dolore magna aliquam erat volutpat. Ut wisi enim ad minim veniam, quis nostrud exerci tation ullamcorper suscipit lobortis nisl ut aliquip ex. (p)</p><h3>Lorem Ipsum Dolor Sit Amet (h3)</h3><p>Lorem ipsum dolor sit amet, consectetuer adipiscing elit, sed diam nonummy nibh euismod tincidunt ut laoreet dolore magna aliquam erat volutpat. Ut wisi enim ad minim veniam, quis nostrud exerci tation ullamcorper suscipit lobortis nisl ut aliquip ex. (p)</p><h4>Lorem Ipsum Dolor Sit Amet (h4)</h4><p>Lorem ipsum dolor sit amet, consectetuer adipiscing elit, sed diam nonummy nibh euismod tincidunt ut laoreet dolore magna aliquam erat volutpat. Ut wisi enim ad minim veniam, quis nostrud exerci tation ullamcorper suscipit lobortis nisl ut aliquip ex. (p)</p><h5>Lorem Ipsum Dolor Sit Amet (h5)</h5>\r\n<h1>Joomla 4 bootstrap 5 button</h1> <p> <span class=\"btn btn-secondary\">secondary</span>   <span class=\"btn btn-primary\">primary</span>   <span class=\"btn btn-info\">info</span>   <span class=\"btn btn-success\">success</span>   <span class=\"btn btn-warning\">warning</span>   <span class=\"btn btn-danger\">danger</span> </p> <p><span class=\"text text-secondary\">text-secondary</span>  <span class=\"text text-primary\">text-primary</span>  <span class=\"text text-info\">text-info</span>  <span class=\"text text-success\">text-success</span>  <span class=\"text text-warning\">text-warning</span>  <span class=\"text text-danger\">text-danger</span></p><p>Lorem ipsum dolor sit amet, consectetuer adipiscing elit, sed diam nonummy nibh euismod tincidunt ut laoreet dolore magna aliquam erat volutpat. Ut wisi enim ad minim veniam, quis nostrud exerci tation ullamcorper suscipit lobortis nisl ut aliquip ex. (p)</p> <p><a href=\"index.php\"> Lorem ipsum dolor (a)</a></p><h1>Lists</h1> <p>(ol)(li)</p> <ol> <li>Lorem ipsum dolor sit amet consectetur</li> <li>Lorem ipsum dolor sit amet consectetur</li> </ol> <p>(ul)(li)</p> <ul> <li>Lorem ipsum dolor sit amet consectetur</li> <li>Lorem ipsum dolor sit amet consectetur</li> </ul> \r\n\r\n<h2>Theme Buttons</h2>\r\n\r\n<p>Buttons have a number of great variations to choose from. You should note that in the HTML breakdown we have added a <code>button</code> class in addition to the variation, which is a requirement for these particular variations to work. You can also combine these variations.</p>\r\n\r\n<p><a href=\"#\" class=\"jl-button jl-button-default\">Default Button</a>&nbsp;&nbsp;&nbsp;<a href=\"#\" class=\"jl-button jl-button-primary\">Button Primary</a>&nbsp;&nbsp;&nbsp;<a href=\"#\" class=\"jl-button jl-button-secondary\">Button Secondary</a>&nbsp;&nbsp;&nbsp;<a href=\"#\" class=\"jl-button jl-button-danger\">Button Danger</a>&nbsp;&nbsp;&nbsp;<a href=\"#\" class=\"jl-button jl-button-text\">Button Text</a></p>\r\n<pre>&#x3C;a href=&#x22;#&#x22; class=&#x22;jl-button jl-button-default&#x22;&#x3E;Default Button&#x3C;/a&#x3E;\r\n&#x3C;a href=&#x22;#&#x22; class=&#x22;jl-button jl-button-primary&#x22;&#x3E;Button Primary&#x3C;/a&#x3E;\r\n&#x3C;a href=&#x22;#&#x22; class=&#x22;jl-button jl-button-secondary&#x22;&#x3E;Button Secondary&#x3C;/a&#x3E;\r\n&#x3C;a href=&#x22;#&#x22; class=&#x22;jl-button jl-button-danger&#x22;&#x3E;Button Danger&#x3C;/a&#x3E;\r\n&#x3C;a href=&#x22;#&#x22; class=&#x22;jl-button jl-button-text&#x22;&#x3E;Button Text&#x3C;/a&#x3E;\r\n\r\n</pre>\r\n\r\n<h1>Notice Styles</h1>\r\n<p class=\"alert alert-success\">Nullam quis risus eget urna mollis ornare vel eu leo. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus.</p>\r\n<pre>&lt;p class=\"alert alert-success\"&gt;&hellip;&lt;/p&gt;</pre>\r\n<p class=\"alert alert-info\">Nullam quis risus eget urna mollis ornare vel eu leo. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus.</p>\r\n<pre>&lt;p class=\"alert alert-info\"&gt;&hellip;&lt;/p&gt;</pre>\r\n<p class=\"alert alert-warning\">Nullam quis risus eget urna mollis ornare vel eu leo. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus.</p>\r\n<pre>&lt;p class=\"alert alert-warning\"&gt;&hellip;&lt;/p&gt;</pre>\r\n<p class=\"alert alert-error\">Nullam quis risus eget urna mollis ornare vel eu leo. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus.</p>\r\n<pre>&lt;p class=\"alert alert-error\"&gt;&hellip;&lt;/p&gt;</pre>\r\n\r\n<h1>Blockquotes</h1>\r\n<p>For quoting blocks of content from another source within your document.</p>\r\n<h3>Default blockquote</h3>\r\n<p>Wrap <code>&lt;blockquote&gt;</code> around any <abbr title=\r\n\"HyperText Markup Language\">HTML</abbr> as the quote. For straight quotes we\r\nrecommend a <code>&lt;p&gt;</code>.</p>\r\n<blockquote>\r\n    <p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Integer posuere\r\n    erat a ante.</p>\r\n</blockquote>\r\n<pre>&lt;blockquote&gt;\r\n&lt;p&gt;Lorem ipsum dolor sit amet, consectetur adipiscing elit. Integer posuere erat a ante.&lt;/p&gt;\r\n&lt;/blockquote&gt;</pre>\r\n<h3>Blockquote options</h3><span>Style and content changes for simple\r\nvariations on a standard blockquote.</span><br>\r\n<h4>Naming a source</h4>\r\n<p>Add <code>&lt;small&gt;</code> tag for identifying the source. Wrap the name\r\nof the source work in <code>&lt;cite&gt;</code>.</p>\r\n<blockquote>\r\n    <p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Integer posuere\r\n    erat a ante.</p><small>Someone famous in <cite title=\"Source Title\">Source\r\n    Title</cite></small>\r\n</blockquote>\r\n<pre>&lt;blockquote&gt;&lt;p&gt;Lorem ipsum dolor sit amet, consectetur adipiscing elit. Integer posuere erat a ante.&lt;/p&gt;&lt;small&gt;Someone famous &lt;cite title=\"Source Title\"&gt;Source Title&lt;/cite&gt;&lt;/small&gt;&lt;/blockquote&gt;</pre>\r\n\r\n<blockquote class=\"jl-margin-medium\" cite=\"#\">\r\n    <p>The blockquote element represents content that is quoted from another source, optionally with a\r\n        citation which must be within a footer or cite element.</p>\r\n    <footer>Someone famous in <cite><a href=\"#\">Source Title</a></cite></footer>\r\n</blockquote>\r\n\r\n<h1>Tables</h1>\r\n<table>\r\n    <thead><tr>\r\n        <th>#</th>\r\n        <th>First Name</th>\r\n        <th>Last Name</th>\r\n        <th>Username</th>\r\n    </tr></thead>\r\n    <tbody>\r\n    <tr>\r\n        <td>1</td>\r\n        <td>John</td>\r\n        <td>Doe</td>\r\n        <td>JohnDoe</td>\r\n    </tr>\r\n    <tr>\r\n        <td>2</td>\r\n        <td>Jane</td>\r\n        <td>Doe</td>\r\n        <td>JaneDoe</td>\r\n    </tr>\r\n    <tr>\r\n        <td>3</td>\r\n        <td>Bob</td>\r\n        <td>Doe</td>\r\n        <td>BobDoe</td>\r\n    </tr>\r\n    </tbody>\r\n</table>\r\n<p>\r\n  <pre>&lt;table class=\"table\"&gt;&hellip;&lt;/table&gt;</pre>\r\n</p>', '', '1', '11', '1980-01-01 00:00:00', '107', '', '2021-10-25 17:52:15', '107', NULL, NULL, '2021-05-16 02:42:00', NULL, '{\"image_intro\":\"\",\"image_intro_alt\":\"\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', '64', '2', '', '', '1', '783', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', '0', '*', ''),
('4', '36', 'UIkit Overview', 'uikit-overview', '        <nav class=\"jl-navbar-container\">\r\n                <div jl-navbar class=\"jl-navbar-container g-content nomargintop nomarginbottom nomarginleft nomarginright nopaddingtop nopaddingbottom\">\r\n                    <div class=\"jl-navbar-left\">\r\n\r\n                        <a class=\"jl-navbar-item jl-logo\" href=\"#\">Logo</a>\r\n\r\n                        <ul class=\"jl-navbar-nav\">\r\n                            <li class=\"jl-active\"><a href=\"#\">Active</a></li>\r\n                            <li>\r\n                                <a href>Dropdown <span jl-navbar-parent-icon></span></a>\r\n                                <div class=\"jl-navbar-dropdown\">\r\n                                    <ul class=\"jl-nav jl-navbar-dropdown-nav\">\r\n                                        <li class=\"jl-active\"><a href=\"#\">Active</a></li>\r\n                                        <li class=\"jl-parent\">\r\n                                            <a href=\"#\">Parent</a>\r\n                                            <ul class=\"jl-nav-sub\">\r\n                                                <li><a href=\"#\">Sub item</a></li>\r\n                                                <li><a href=\"#\">Sub item</a></li>\r\n                                            </ul>\r\n                                        </li>\r\n                                        <li class=\"jl-nav-header\">Header</li>\r\n                                        <li><a href=\"#\"><span class=\"jl-margin-xsmall-right\" jl-icon=\"icon: table\"></span> Item</a></li>\r\n                                        <li><a href=\"#\"><span class=\"jl-margin-xsmall-right\" jl-icon=\"icon: thumbnails\"></span> Item</a></li>\r\n                                        <li class=\"jl-nav-divider\"></li>\r\n                                        <li><a href=\"#\"><span class=\"jl-margin-xsmall-right\" jl-icon=\"icon: trash\"></span> Item</a></li>\r\n                                    </ul>\r\n                                </div>\r\n                            </li>\r\n                            <li>\r\n                                <a href>Dropbar <span jl-navbar-parent-icon></span></a>\r\n                                <div class=\"jl-dropbar jl-dropbar-top\" jl-drop=\"pos: bottom-left; stretch: x; target-y: !.jl-navbar-container; animation: slide-top; animate-out: true\">\r\n                                    <ul class=\"jl-nav jl-navbar-dropdown-nav\">\r\n                                        <li class=\"jl-active\"><a href=\"#\">Active</a></li>\r\n                                        <li class=\"jl-parent\">\r\n                                            <a href=\"#\">Parent</a>\r\n                                            <ul class=\"jl-nav-sub\">\r\n                                                <li><a href=\"#\">Sub item</a></li>\r\n                                                <li><a href=\"#\">Sub item</a></li>\r\n                                            </ul>\r\n                                        </li>\r\n                                        <li class=\"jl-nav-header\">Header</li>\r\n                                        <li><a href=\"#\"><span class=\"jl-margin-xsmall-right\" jl-icon=\"icon: table\"></span> Item</a></li>\r\n                                        <li><a href=\"#\"><span class=\"jl-margin-xsmall-right\" jl-icon=\"icon: thumbnails\"></span> Item</a></li>\r\n                                        <li class=\"jl-nav-divider\"></li>\r\n                                        <li><a href=\"#\"><span class=\"jl-margin-xsmall-right\" jl-icon=\"icon: trash\"></span> Item</a></li>\r\n                                    </ul>\r\n                                </div>\r\n                            </li>\r\n                            <li><a href=\"#\">Item</a></li>\r\n                            <li><a href=\"#\">Item</a></li>\r\n                        </ul>\r\n\r\n                    </div>\r\n                    <div class=\"jl-navbar-right\">\r\n\r\n                        <div class=\"jl-navbar-item\">\r\n                            <form class=\"jl-search jl-search-navbar jl-width-1-1\">\r\n                                <span jl-search-icon></span>\r\n                                <input class=\"jl-search-input\" type=\"search\" placeholder=\"Search\" aria-label=\"Search\">\r\n                            </form>\r\n                        </div>\r\n                        <a class=\"jl-navbar-toggle\" href=\"#modal\" jl-icon=\"icon: more-vertical\" jl-toggle></a>\r\n                        <a class=\"jl-navbar-toggle\" href=\"#modal-search\" jl-search-icon jl-toggle></a>\r\n                        <a class=\"jl-navbar-toggle\" href=\"#offcanvas\" jl-navbar-toggle-icon jl-toggle></a>\r\n                    </div>\r\n                </div>\r\n        </nav>\r\n\r\n        <div class=\"jl-section jl-section-default\">\r\n                <div jl-grid>\r\n                    <div class=\"jl-width-2-3@m\">\r\n\r\n                        <article class=\"jl-article\">\r\n\r\n                            <h1 class=\"jl-article-title\"><a class=\"jl-link-reset\" href=\"#\">Article Title</a></h1>\r\n\r\n                            <hr class=\"jl-divider-small\">\r\n\r\n                            <p class=\"jl-text-lead\">Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.</p>\r\n\r\n                            <p class=\"jl-column-1-2@s jl-dropcap\">Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.</p>\r\n\r\n                            <p class=\"jl-article-meta\">Written by <a href=\"#\">Super User</a> on 12 April 2012. Posted in <a href=\"#\">Blog</a></p>\r\n\r\n                            <hr class=\"jl-divider-icon jl-margin-medium\">\r\n\r\n                            <div class=\"jl-grid-small jl-child-width-auto jl-flex-middle jl-margin-medium\" jl-grid>\r\n                                <div>\r\n                                    <button class=\"jl-button jl-button-default\">Default</button>\r\n                                    <div class=\"jl-dropdown\" jl-drop=\"mode: click\">\r\n                                        <ul class=\"jl-nav jl-dropdown-nav\">\r\n                                            <li class=\"jl-active\"><a href=\"#\">Active</a></li>\r\n                                            <li class=\"jl-parent\">\r\n                                                <a href=\"#\">Parent</a>\r\n                                                <ul class=\"jl-nav-sub\">\r\n                                                    <li><a href=\"#\">Sub item</a></li>\r\n                                                    <li><a href=\"#\">Sub item</a></li>\r\n                                                </ul>\r\n                                            </li>\r\n                                            <li class=\"jl-nav-header\">Header</li>\r\n                                            <li><a href=\"#\"><span class=\"jl-margin-xsmall-right\" jl-icon=\"icon: table\"></span> Item</a></li>\r\n                                            <li><a href=\"#\"><span class=\"jl-margin-xsmall-right\" jl-icon=\"icon: thumbnails\"></span> Item</a></li>\r\n                                            <li class=\"jl-nav-divider\"></li>\r\n                                            <li><a href=\"#\"><span class=\"jl-margin-xsmall-right\" jl-icon=\"icon: trash\"></span> Item</a></li>\r\n                                        </ul>\r\n                                    </div>\r\n                                </div>\r\n                                <div>\r\n                                    <button class=\"jl-button jl-button-primary\">Primary</button>\r\n                                </div>\r\n                                <div>\r\n                                    <button class=\"jl-button jl-button-secondary\">Secondary</button>\r\n                                </div>\r\n                                <div>\r\n                                    <button class=\"jl-button jl-button-danger\">Danger</button>\r\n                                </div>\r\n                                <div>\r\n                                    <button class=\"jl-button jl-button-default\" disabled>Disabled</button>\r\n                                </div>\r\n                            </div>\r\n\r\n                            <hr class=\"jl-margin-medium\">\r\n\r\n                            <div class=\"jl-child-width-1-2 jl-child-width-1-4@s jl-margin\" jl-grid>\r\n                                <div>\r\n                                    <ul class=\"jl-list\">\r\n                                        <li><a href=\"#\">a element</a></li>\r\n                                        <li><abbr title=\"Title text\">abbr element</abbr></li>\r\n                                        <li><code>code element</code></li>\r\n                                        <li><del>del element</del></li>\r\n                                        <li><dfn title=\"Title text\">dfn element</dfn></li>\r\n                                        <li><a href=\"#\" class=\"jl-link-muted\">Link Muted</a></li>\r\n                                    </ul>\r\n                                </div>\r\n                                <div>\r\n                                    <ul class=\"jl-list\">\r\n                                        <li><em>em element</em></li>\r\n                                        <li><ins>ins element</ins></li>\r\n                                        <li><mark>mark element</mark></li>\r\n                                        <li><q>q <q>inside</q> a q</q></li>\r\n                                        <li><strong>strong element</strong></li>\r\n                                        <li><a href=\"#\" class=\"jl-link-reset\">Link Reset</a></li>\r\n                                    </ul>\r\n                                </div>\r\n                                <div>\r\n                                    <ul class=\"jl-list\">\r\n                                        <li class=\"jl-text-muted\">Text Muted</li>\r\n                                        <li class=\"jl-text-emphasis\">Text Emphasis</li>\r\n                                        <li class=\"jl-text-primary\">Text Primary</li>\r\n                                        <li class=\"jl-text-secondary\">Text Secondary</li>\r\n                                        <li class=\"jl-text-success\">Text Success</li>\r\n                                        <li class=\"jl-text-warning\">Text Warning</li>\r\n                                        <li class=\"jl-text-danger\">Text Danger</li>\r\n                                        <li class=\"jl-text-meta\">Text Meta</li>\r\n                                    </ul>\r\n                                </div>\r\n                                <div>\r\n                                    <ul class=\"jl-list\">\r\n                                        <li><span class=\"jl-label\">Default</span></li>\r\n                                        <li><span class=\"jl-label jl-label-success\">Success</span></li>\r\n                                        <li><span class=\"jl-label jl-label-warning\">Warning</span></li>\r\n                                        <li><span class=\"jl-label jl-label-danger\">Danger</span></li>\r\n                                        <li><a class=\"jl-badge\" href=\"#\">1</a></li>\r\n                                        <li>\r\n                                            <a class=\"jl-icon-button jl-icon\" href=\"#\" jl-icon=\"icon: home\"><svg width=\"20\" height=\"20\" viewBox=\"0 0 20 20\" aria-hidden=\"true\"><polygon points=\"18.65 11.35 10 2.71 1.35 11.35 0.65 10.65 10 1.29 19.35 10.65\"></polygon><polygon points=\"15 4 18 4 18 7 17 7 17 5 15 5\"></polygon><polygon points=\"3 11 4 11 4 18 7 18 7 12 12 12 12 18 16 18 16 11 17 11 17 19 11 19 11 13 8 13 8 19 3 19\"></polygon></svg></a>\r\n                                            <a class=\"jl-icon-button jl-icon\" href=\"#\" jl-icon=\"icon: github\"><svg width=\"20\" height=\"20\" viewBox=\"0 0 20 20\" aria-hidden=\"true\"><path d=\"M10,1 C5.03,1 1,5.03 1,10 C1,13.98 3.58,17.35 7.16,18.54 C7.61,18.62 7.77,18.34 7.77,18.11 C7.77,17.9 7.76,17.33 7.76,16.58 C5.26,17.12 4.73,15.37 4.73,15.37 C4.32,14.33 3.73,14.05 3.73,14.05 C2.91,13.5 3.79,13.5 3.79,13.5 C4.69,13.56 5.17,14.43 5.17,14.43 C5.97,15.8 7.28,15.41 7.79,15.18 C7.87,14.6 8.1,14.2 8.36,13.98 C6.36,13.75 4.26,12.98 4.26,9.53 C4.26,8.55 4.61,7.74 5.19,7.11 C5.1,6.88 4.79,5.97 5.28,4.73 C5.28,4.73 6.04,4.49 7.75,5.65 C8.47,5.45 9.24,5.35 10,5.35 C10.76,5.35 11.53,5.45 12.25,5.65 C13.97,4.48 14.72,4.73 14.72,4.73 C15.21,5.97 14.9,6.88 14.81,7.11 C15.39,7.74 15.73,8.54 15.73,9.53 C15.73,12.99 13.63,13.75 11.62,13.97 C11.94,14.25 12.23,14.8 12.23,15.64 C12.23,16.84 12.22,17.81 12.22,18.11 C12.22,18.35 12.38,18.63 12.84,18.54 C16.42,17.35 19,13.98 19,10 C19,5.03 14.97,1 10,1 L10,1 Z\"></path></svg></a>\r\n                                            <a class=\"jl-icon-link jl-icon\" href=\"#\" jl-icon=\"icon: trash\"><svg width=\"20\" height=\"20\" viewBox=\"0 0 20 20\" aria-hidden=\"true\"><polyline fill=\"none\" stroke=\"#000\" points=\"6.5 3 6.5 1.5 13.5 1.5 13.5 3\"></polyline><polyline fill=\"none\" stroke=\"#000\" points=\"4.5 4 4.5 18.5 15.5 18.5 15.5 4\"></polyline><rect width=\"1\" height=\"9\" x=\"8\" y=\"7\"></rect><rect width=\"1\" height=\"9\" x=\"11\" y=\"7\"></rect><rect width=\"16\" height=\"1\" x=\"2\" y=\"3\"></rect></svg></a>\r\n                                        </li>\r\n                                    </ul>\r\n                                </div>\r\n                            </div>\r\n\r\n                            <pre class=\"jl-pre jl-margin-medium\"><code>&lt;div class=\"myclass\"&gt;…&lt;div&gt;</code></pre>\r\n\r\n                            <blockquote class=\"jl-margin-medium\" cite=\"#\">\r\n                                <p>The blockquote element represents content that is quoted from another source, optionally with a citation which must be within a footer or cite element.</p>\r\n                                <footer>Someone famous in <cite><a href=\"#\">Source Title</a></cite></footer>\r\n                            </blockquote>\r\n\r\n                            <div class=\"jl-grid-small\" jl-grid>\r\n                                <div>\r\n                                    <a class=\"jl-button jl-button-text\" href=\"#\">Read more</a>\r\n                                </div>\r\n                                <div>\r\n                                    <a class=\"jl-button jl-button-text\" href=\"#\">5 Comments</a>\r\n                                </div>\r\n                                <div>\r\n                                    <a class=\"jl-button jl-button-link\" href=\"#\">Button Link</a>\r\n                                </div>\r\n                            </div>\r\n\r\n                                                    <div class=\"jl-overflow-auto jl-margin-medium-top\">\r\n                            <table class=\"jl-table jl-table-divider jl-table-hover jl-table-small\">\r\n                                <thead>\r\n                                    <tr>\r\n                                        <th>Table Heading</th>\r\n                                        <th>Table Heading</th>\r\n                                        <th>Table Heading</th>\r\n                                    </tr>\r\n                                </thead>\r\n                                <tbody>\r\n                                    <tr>\r\n                                        <td>Table Data</td>\r\n                                        <td>Table Data</td>\r\n                                        <td>Table Data</td>\r\n                                    </tr>\r\n                                    <tr>\r\n                                        <td>Table Data</td>\r\n                                        <td>Table Data</td>\r\n                                        <td>Table Data</td>\r\n                                    </tr>\r\n                                    <tr>\r\n                                        <td>Table Data</td>\r\n                                        <td>Table Data</td>\r\n                                        <td>Table Data</td>\r\n                                    </tr>\r\n                                    <tr>\r\n                                        <td>Table Data</td>\r\n                                        <td>Table Data</td>\r\n                                        <td>Table Data</td>\r\n                                    </tr>\r\n                                </tbody>\r\n                            </table>\r\n                        </div>\r\n\r\n\r\n                        </article>\r\n\r\n                        <hr class=\"jl-margin-medium\">\r\n\r\n                        <nav aria-label=\"Pagination\">\r\n                            <ul class=\"jl-pagination jl-flex-center\" jl-margin>\r\n                                <li><a href=\"#\"><span jl-pagination-previous></span></a></li>\r\n                                <li><a href=\"#\">1</a></li>\r\n                                <li class=\"jl-disabled\"><span>…</span></li>\r\n                                <li><a href=\"#\">4</a></li>\r\n                                <li><a href=\"#\">5</a></li>\r\n                                <li><a href=\"#\">6</a></li>\r\n                                <li class=\"jl-active\"><span aria-current=\"page\">7</span></li>\r\n                                <li><a href=\"#\">8</a></li>\r\n                                <li><a href=\"#\">9</a></li>\r\n                                <li><a href=\"#\">10</a></li>\r\n                                <li class=\"jl-disabled\"><span>…</span></li>\r\n                                <li><a href=\"#\">20</a></li>\r\n                                <li><a href=\"#\"><span jl-pagination-next></span></a></li>\r\n                            </ul>\r\n                        </nav>\r\n\r\n                    </div>\r\n                    <div class=\"jl-width-expand@m\">\r\n\r\n                        <div class=\"jl-margin-medium-bottom\">\r\n                            <form class=\"jl-search jl-search-default jl-width-1-1\">\r\n                                <span jl-search-icon></span>\r\n                                <input class=\"jl-search-input\" type=\"search\" placeholder=\"Search\" aria-label=\"Search\">\r\n                            </form>\r\n                        </div>\r\n\r\n                        <ul class=\"jl-nav-default jl-margin-medium\" jl-nav>\r\n                            <li class=\"jl-active\"><a href=\"#\">Active</a></li>\r\n                            <li class=\"jl-parent\">\r\n                                <a href=\"#\">Parent <span jl-nav-parent-icon></span></a>\r\n                                <ul class=\"jl-nav-sub\">\r\n                                    <li><a href=\"#\">Sub item</a></li>\r\n                                    <li><a href=\"#\">Sub item</a>\r\n                                        <ul>\r\n                                            <li><a href=\"#\">Sub item</a></li>\r\n                                            <li><a href=\"#\">Sub item</a></li>\r\n                                        </ul>\r\n                                    </li>\r\n                                </ul>\r\n                            </li>\r\n                            <li class=\"jl-parent\">\r\n                                <a href=\"#\">Parent <span jl-nav-parent-icon></span></a>\r\n                                <ul class=\"jl-nav-sub\">\r\n                                    <li><a href=\"#\">Sub item</a></li>\r\n                                    <li><a href=\"#\">Sub item</a></li>\r\n                                </ul>\r\n                            </li>\r\n                            <li class=\"jl-nav-header\">Header</li>\r\n                            <li><a href=\"#\"><span class=\"jl-margin-xsmall-right jl-icon\" jl-icon=\"icon: table\"><svg width=\"20\" height=\"20\" viewBox=\"0 0 20 20\" aria-hidden=\"true\"><rect width=\"18\" height=\"1\" x=\"1\" y=\"3\"></rect><rect width=\"18\" height=\"1\" x=\"1\" y=\"7\"></rect><rect width=\"18\" height=\"1\" x=\"1\" y=\"11\"></rect><rect width=\"18\" height=\"1\" x=\"1\" y=\"15\"></rect></svg></span> Item</a></li>\r\n                            <li><a href=\"#\"><span class=\"jl-margin-xsmall-right jl-icon\" jl-icon=\"icon: thumbnails\"><svg width=\"20\" height=\"20\" viewBox=\"0 0 20 20\" aria-hidden=\"true\"><rect width=\"5\" height=\"5\" fill=\"none\" stroke=\"#000\" x=\"3.5\" y=\"3.5\"></rect><rect width=\"5\" height=\"5\" fill=\"none\" stroke=\"#000\" x=\"11.5\" y=\"3.5\"></rect><rect width=\"5\" height=\"5\" fill=\"none\" stroke=\"#000\" x=\"11.5\" y=\"11.5\"></rect><rect width=\"5\" height=\"5\" fill=\"none\" stroke=\"#000\" x=\"3.5\" y=\"11.5\"></rect></svg></span> Item</a></li>\r\n                            <li class=\"jl-nav-divider\"></li>\r\n                            <li><a href=\"#\"><span class=\"jl-margin-xsmall-right jl-icon\" jl-icon=\"icon: trash\"><svg width=\"20\" height=\"20\" viewBox=\"0 0 20 20\" aria-hidden=\"true\"><polyline fill=\"none\" stroke=\"#000\" points=\"6.5 3 6.5 1.5 13.5 1.5 13.5 3\"></polyline><polyline fill=\"none\" stroke=\"#000\" points=\"4.5 4 4.5 18.5 15.5 18.5 15.5 4\"></polyline><rect width=\"1\" height=\"9\" x=\"8\" y=\"7\"></rect><rect width=\"1\" height=\"9\" x=\"11\" y=\"7\"></rect><rect width=\"16\" height=\"1\" x=\"2\" y=\"3\"></rect></svg></span> Item</a></li>\r\n                        </ul>\r\n\r\n                        <div class=\"jl-card jl-card-body jl-card-default jl-card-hover\">\r\n                            <h3 class=\"jl-card-title\">Default</h3>\r\n                            <p>Lorem ipsum <a href=\"#\">dolor</a> sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.</p>\r\n                        </div>\r\n\r\n                        <div class=\"jl-margin jl-card jl-card-body jl-card-primary jl-light jl-card-hover\">\r\n                            <h3 class=\"jl-card-title\">Primary</h3>\r\n                            <p>Lorem ipsum <a href=\"#\">dolor</a> sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.</p>\r\n                        </div>\r\n\r\n                        <div class=\"jl-margin jl-card jl-card-body jl-card-secondary jl-light jl-card-hover\">\r\n                            <h3 class=\"jl-card-title\">Secondary</h3>\r\n                            <p>Lorem ipsum <a href=\"#\">dolor</a> sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.</p>\r\n                        </div>\r\n\r\n                        <div class=\"jl-margin jl-card jl-card-body jl-card-hover\">\r\n                            <h3 class=\"jl-card-title\">Hover</h3>\r\n                            <p>Lorem ipsum <a href=\"#\">dolor</a> sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.</p>\r\n                        </div>\r\n\r\n                    </div>\r\n                </div>\r\n\r\n                <hr class=\"jl-margin-large\">\r\n\r\n                <div class=\"jl-grid-divider\" jl-grid>\r\n                    <div class=\"jl-width-2-3@m\">\r\n\r\n                        <h1 class=\"jl-heading-2xlarge jl-margin-small\">2X-Large</h1>\r\n                        <h1 class=\"jl-heading-xlarge jl-margin-small\">X-Large</h1>\r\n                        <h1 class=\"jl-heading-large jl-margin-small\">Heading L</h1>\r\n                        <h1 class=\"jl-heading-medium jl-margin-small\">Heading M</h1>\r\n                        <h1 class=\"jl-heading-small jl-margin-small\">Heading S</h1>\r\n\r\n                        <h1 class=\"jl-margin-small\">Heading H1</h1>\r\n                        <h2 class=\"jl-margin-small\">Heading H2</h2>\r\n                        <h3 class=\"jl-margin-small\">Heading H3</h3>\r\n                        <h4 class=\"jl-margin-small\">Heading H4</h4>\r\n                        <h5 class=\"jl-margin-small\">Heading H5</h5>\r\n                        <h6 class=\"jl-margin-small\">Heading H6</h6>\r\n\r\n                        <h3 class=\"jl-heading-divider\">Heading Divider</h3>\r\n                        <h3 class=\"jl-heading-bullet\">Heading Bullet</h3>\r\n                        <h3 class=\"jl-heading-line\"><span>Heading Line</span></h3>\r\n                        <div class=\"jl-heading-medium jl-grid-small jl-child-width-auto jl-flex-middle jl-margin-medium-top\" jl-grid js-countdown>\r\n                            <div>\r\n                                <div class=\"jl-countdown-number jl-countdown-days\">365</div>\r\n                            </div>\r\n                            <div class=\"jl-countdown-separator\">:</div>\r\n                            <div>\r\n                                <div class=\"jl-countdown-number jl-countdown-hours\">18</div>\r\n                            </div>\r\n                            <div class=\"jl-countdown-separator\">:</div>\r\n                            <div>\r\n                                <div class=\"jl-countdown-number jl-countdown-minutes\">21</div>\r\n                            </div>\r\n                            <div class=\"jl-countdown-separator\">:</div>\r\n                            <div>\r\n                                <div class=\"jl-countdown-number jl-countdown-seconds\">05</div>\r\n                            </div>\r\n                        </div>\r\n                    </div>\r\n                    <div class=\"jl-width-1-3@m\">\r\n\r\n                        <ul class=\"jl-nav jl-nav-primary jl-margin-medium\">\r\n                            <li class=\"jl-active\"><a href=\"#\">Active</a></li>\r\n                            <li><a href=\"#\">Item</a></li>\r\n                            <li><a href=\"#\">Item</a></li>\r\n                            <li><a href=\"#\">Item</a></li>\r\n                        </ul>\r\n\r\n                        <ul class=\"jl-nav jl-nav-secondary jl-margin-medium\">\r\n                            <li class=\"jl-active\"><a href=\"#\"><div>Active<div class=\"jl-nav-subtitle\">Subtitle lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do.</div></div></a></li>\r\n                            <li><a href=\"#\"><div>Item<div class=\"jl-nav-subtitle\">Subtitle lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do.</div></div></a></li>\r\n                            <li><a href=\"#\"><div>Item<div class=\"jl-nav-subtitle\">Subtitle lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do.</div></div></a></li>\r\n                            <li><a href=\"#\"><div>Item<div class=\"jl-nav-subtitle\">Subtitle lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do.</div></div></a></li>\r\n                        </ul>\r\n\r\n                        <div class=\"jl-margin-medium-top\" jl-alert>\r\n                            <a href=\"#\" class=\"jl-alert-close\" jl-close></a>\r\n                            <p>Default</p>\r\n                        </div>\r\n\r\n                        <div class=\"jl-alert-primary\" jl-alert>\r\n                            <a href=\"#\" class=\"jl-alert-close\" jl-close></a>\r\n                            <p>Primary</p>\r\n                        </div>\r\n\r\n                        <div class=\"jl-alert-success\" jl-alert>\r\n                            <a href=\"#\" class=\"jl-alert-close\" jl-close></a>\r\n                            <p>Success</p>\r\n                        </div>\r\n\r\n                        <div class=\"jl-alert-warning\" jl-alert>\r\n                            <a href=\"#\" class=\"jl-alert-close\" jl-close></a>\r\n                            <p>Warning</p>\r\n                        </div>\r\n\r\n                        <div class=\"jl-alert-danger jl-margin-remove-bottom\" jl-alert>\r\n                            <a href=\"#\" class=\"jl-alert-close\" jl-close></a>\r\n                            <p>Danger</p>\r\n                        </div>\r\n\r\n                    </div>\r\n                </div>\r\n\r\n                <hr class=\"jl-margin-medium\">\r\n\r\n                <div class=\"jl-grid-divider jl-child-width-auto@m\" jl-grid>\r\n                    <div>\r\n\r\n                        <ul class=\"jl-dotnav\">\r\n                            <li class=\"jl-active\"><a href=\"#\">Item 1</a></li>\r\n                            <li><a href=\"#\">Item 2</a></li>\r\n                            <li><a href=\"#\">Item 3</a></li>\r\n                            <li><a href=\"#\">Item 4</a></li>\r\n                            <li><a href=\"#\">Item 5</a></li>\r\n                            <li><a href=\"#\">Item 6</a></li>\r\n                        </ul>\r\n\r\n                    </div>\r\n                    <div>\r\n\r\n                        <a href=\"#\" jl-slidenav-previous></a>\r\n                        <a href=\"#\" jl-slidenav-next></a>\r\n\r\n                    </div>\r\n                    <div>\r\n\r\n                        <ul class=\"jl-thumbnav\">\r\n                            <li class=\"jl-active\"><a href=\"#\"><img src=\"images/sampledata/overview/photo.jpg\" width=\"60\" height=\"40\" alt=\"\"></a></li>\r\n                            <li><a href=\"#\"><img src=\"images/sampledata/overview/dark.jpg\" width=\"60\" height=\"40\" alt=\"\"></a></li>\r\n                            <li><a href=\"#\"><img src=\"images/sampledata/overview/light.jpg\" width=\"60\" height=\"40\" alt=\"\"></a></li>\r\n                        </ul>\r\n\r\n                    </div>\r\n                    <div>\r\n\r\n                        <div class=\"jl-tooltip jl-tooltip-top-center jl-display-inline-block jl-margin-remove jl-position-relative\">Tooltip</div>\r\n\r\n                    </div>\r\n                    <div class=\"jl-width-expand@m\">\r\n\r\n                        <ul class=\"jl-iconnav\">\r\n                            <li class=\"jl-active\"><a href=\"#\" jl-icon=\"icon: plus\" class=\"jl-icon\"><svg width=\"20\" height=\"20\" viewBox=\"0 0 20 20\" aria-hidden=\"true\"><rect width=\"1\" height=\"17\" x=\"9\" y=\"1\"></rect><rect width=\"17\" height=\"1\" x=\"1\" y=\"9\"></rect></svg></a></li>\r\n                            <li><a href=\"#\" jl-icon=\"icon: pencil\" class=\"jl-icon\"><svg width=\"20\" height=\"20\" viewBox=\"0 0 20 20\" aria-hidden=\"true\"><path fill=\"none\" stroke=\"#000\" d=\"M17.25,6.01 L7.12,16.1 L3.82,17.2 L5.02,13.9 L15.12,3.88 C15.71,3.29 16.66,3.29 17.25,3.88 C17.83,4.47 17.83,5.42 17.25,6.01 L17.25,6.01 Z\"></path><path fill=\"none\" stroke=\"#000\" d=\"M15.98,7.268 L13.851,5.148\"></path></svg></a></li>\r\n                            <li><a href=\"#\"><span jl-icon=\"icon: bag\" class=\"jl-icon\"><svg width=\"20\" height=\"20\" viewBox=\"0 0 20 20\" aria-hidden=\"true\"><path fill=\"none\" stroke=\"#000\" d=\"M7.5,7.5V4A2.48,2.48,0,0,1,10,1.5,2.54,2.54,0,0,1,12.5,4V7.5\"></path><polygon fill=\"none\" stroke=\"#000\" points=\"16.5 7.5 3.5 7.5 2.5 18.5 17.5 18.5 16.5 7.5\"></polygon></svg></span> (2)</a></li>\r\n                        </ul>\r\n\r\n                    </div>\r\n                    <div>\r\n\r\n                        <button type=\"button\" jl-close></button>\r\n\r\n                    </div>\r\n                    <div>\r\n\r\n                        <a href=\"#\" jl-totop></a>\r\n\r\n                    </div>\r\n                </div>\r\n\r\n                <hr class=\"jl-margin-medium\">\r\n\r\n                <div class=\"jl-grid-divider jl-child-width-auto@m\" jl-grid>\r\n                    <div>\r\n\r\n                        <nav jl-dropnav=\"mode: click\">\r\n                            <ul class=\"jl-subnav jl-subnav-divider\" jl-margin>\r\n                                <li class=\"jl-active\"><a href=\"#\">Active</a></li>\r\n                                <li>\r\n                                    <a href>Parent <span jl-drop-parent-icon></span></a>\r\n                                    <div class=\"jl-dropdown\">\r\n                                        <ul class=\"jl-nav jl-dropdown-nav\">\r\n                                            <li class=\"jl-active\"><a href=\"#\">Active</a></li>\r\n                                            <li><a href=\"#\">Item</a></li>\r\n                                            <li class=\"jl-nav-header\">Header</li>\r\n                                            <li><a href=\"#\">Item</a></li>\r\n                                            <li><a href=\"#\">Item</a></li>\r\n                                            <li class=\"jl-nav-divider\"></li>\r\n                                            <li><a href=\"#\">Item</a></li>\r\n                                        </ul>\r\n                                    </div>\r\n                                </li>\r\n                                <li class=\"jl-disabled\"><a>Disabled</a></li>\r\n                            </ul>\r\n                        </nav>\r\n\r\n                    </div>\r\n                    <div>\r\n\r\n                        <nav jl-dropnav=\"mode: click\">\r\n                            <ul class=\"jl-subnav jl-subnav-pill\" jl-margin>\r\n                                <li class=\"jl-active\"><a href=\"#\">Active</a></li>\r\n                                <li>\r\n                                    <a href>Parent <span jl-drop-parent-icon></span></a>\r\n                                    <div class=\"jl-dropdown\">\r\n                                        <ul class=\"jl-nav jl-dropdown-nav\">\r\n                                            <li class=\"jl-active\"><a href=\"#\">Active</a></li>\r\n                                            <li><a href=\"#\">Item</a></li>\r\n                                            <li class=\"jl-nav-header\">Header</li>\r\n                                            <li><a href=\"#\">Item</a></li>\r\n                                            <li><a href=\"#\">Item</a></li>\r\n                                            <li class=\"jl-nav-divider\"></li>\r\n                                            <li><a href=\"#\">Item</a></li>\r\n                                        </ul>\r\n                                    </div>\r\n                                </li>\r\n                                <li class=\"jl-disabled\"><a>Disabled</a></li>\r\n                            </ul>\r\n                        </nav>\r\n\r\n                    </div>\r\n                    <div>\r\n\r\n                        <ul jl-tab>\r\n                            <li class=\"jl-active\"><a href=\"#\">Active</a></li>\r\n                            <li>\r\n                                <a href>Parent <span jl-drop-parent-icon></span></a>\r\n                                <div class=\"jl-dropdown\" jl-drop=\"mode: click\">\r\n                                    <ul class=\"jl-nav jl-dropdown-nav\">\r\n                                        <li class=\"jl-active\"><a href=\"#\">Active</a></li>\r\n                                        <li><a href=\"#\">Item</a></li>\r\n                                        <li class=\"jl-nav-header\">Header</li>\r\n                                        <li><a href=\"#\">Item</a></li>\r\n                                        <li><a href=\"#\">Item</a></li>\r\n                                        <li class=\"jl-nav-divider\"></li>\r\n                                        <li><a href=\"#\">Item</a></li>\r\n                                    </ul>\r\n                                </div>\r\n                            </li>\r\n                            <li class=\"jl-disabled\"><a>Disabled</a></li>\r\n                        </ul>\r\n\r\n                    </div>\r\n\r\n                </div>\r\n\r\n                <hr class=\"jl-margin-medium\">\r\n\r\n                <div class=\"jl-grid-divider\" jl-grid>\r\n                    <div class=\"jl-width-2-3@m\">\r\n\r\n                        <div class=\"jl-child-width-1-2@s\" jl-grid>\r\n                            <div>\r\n\r\n                                <div class=\"jl-inline\">\r\n                                    <img src=\"images/sampledata/overview/light.jpg\" width=\"1800\" height=\"1200\" alt=\"\">\r\n                                    <a class=\"jl-position-absolute jl-transform-center\" style=\"left: 20%; top: 30%\" href=\"#\" jl-marker></a>\r\n                                    <a class=\"jl-position-absolute jl-transform-center\" style=\"left: 60%; top: 40%\" href=\"#\" jl-marker></a>\r\n                                    <a class=\"jl-position-absolute jl-transform-center\" style=\"left: 80%; top: 70%\" href=\"#\" jl-marker></a>\r\n                                </div>\r\n\r\n                            </div>\r\n                            <div>\r\n\r\n                                <a href class=\"jl-inline\">\r\n                                    <img src=\"images/sampledata/overview/light.jpg\" width=\"1800\" height=\"1200\" alt=\"\">\r\n                                    <div class=\"jl-position-center\">\r\n                                        <span class=\"jl-icon-overlay jl-icon\" href=\"#\" jl-icon=\"ratio: 3; icon: play-circle\"><svg width=\"60\" height=\"60\" viewBox=\"0 0 20 20\" aria-hidden=\"true\"><polygon fill=\"none\" stroke=\"#000\" stroke-width=\"1.1\" points=\"8.5 7 13.5 10 8.5 13\"></polygon><circle fill=\"none\" stroke=\"#000\" stroke-width=\"1.1\" cx=\"10\" cy=\"10\" r=\"9\"></circle></svg></span>\r\n                                    </div>\r\n                                </a>\r\n\r\n                            </div>\r\n                            <div>\r\n\r\n                                <div class=\"jl-inline-clip\">\r\n                                    <img src=\"images/sampledata/overview/photo.jpg\" width=\"1800\" height=\"1200\" alt=\"\">\r\n                                    <div class=\"jl-overlay jl-overlay-default jl-position-bottom\">\r\n                                        <p>Default Lorem ipsum dolor sit amet, consectetur.</p>\r\n                                    </div>\r\n                                </div>\r\n\r\n                            </div>\r\n                            <div>\r\n\r\n                                <div class=\"jl-inline-clip\">\r\n                                    <img src=\"images/sampledata/overview/photo.jpg\" width=\"1800\" height=\"1200\" alt=\"\">\r\n                                    <div class=\"jl-overlay jl-overlay-primary jl-light jl-position-bottom\">\r\n                                        <p>Primary Lorem ipsum dolor sit amet, consectetur.</p>\r\n                                    </div>\r\n                                </div>\r\n\r\n                            </div>\r\n                            <div>\r\n\r\n                                <div class=\"jl-inline-clip\">\r\n                                    <img src=\"images/sampledata/overview/photo.jpg\" width=\"1800\" height=\"1200\" alt=\"\">\r\n                                    <div class=\"jl-card jl-card-body jl-card-overlay jl-card-hover jl-position-cover jl-position-medium\">\r\n                                        <h3 class=\"jl-card-title\">Card Overlay</h3>\r\n                                        <p>Lorem ipsum <a href=\"#\">dolor</a> sit amet, consectetur adipiscing elit.</p>\r\n                                    </div>\r\n                                </div>\r\n\r\n                            </div>\r\n                        </div>\r\n\r\n                    </div>\r\n                    <div class=\"jl-width-expand@m\">\r\n\r\n                        <ul class=\"jl-list jl-list-bullet jl-margin-medium\">\r\n                            <li>List item 1</li>\r\n                            <li>List item 2</li>\r\n                            <li>List item 3</li>\r\n                         </ul>\r\n\r\n                        <ul class=\"jl-list jl-list-striped jl-margin-medium\">\r\n                            <li>List item 1</li>\r\n                            <li>List item 2</li>\r\n                            <li>List item 3</li>\r\n                        </ul>\r\n\r\n                        <ul class=\"jl-list jl-list-divider jl-margin-medium\">\r\n                            <li>List item 1</li>\r\n                            <li>List item 2</li>\r\n                            <li>List item 3</li>\r\n                        </ul>\r\n\r\n                        <dl class=\"jl-description-list jl-description-list-divider jl-margin-medium\">\r\n                            <dt>Description lists</dt>\r\n                            <dd>A description text</dd>\r\n                            <dt>Description lists</dt>\r\n                            <dd>A description text</dd>\r\n                        </dl>\r\n\r\n                        <ul jl-accordion>\r\n                            <li class=\"jl-open\">\r\n\r\n                                <a class=\"jl-accordion-title\" href=\"#\">Item 1</a>\r\n                                <div class=\"jl-accordion-content\">\r\n                                    <p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco.</p>\r\n                                </div>\r\n\r\n                            </li>\r\n                            <li>\r\n\r\n                                <a class=\"jl-accordion-title\" href=\"#\">Item 2</a>\r\n                                <div class=\"jl-accordion-content\">\r\n                                    <p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco.</p>\r\n                                </div>\r\n\r\n                            </li>\r\n                            <li>\r\n\r\n                                <a class=\"jl-accordion-title\" href=\"#\">Item 3</a>\r\n                                <div class=\"jl-accordion-content\">\r\n                                    <p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco.</p>\r\n                                </div>\r\n\r\n                            </li>\r\n                        </ul>\r\n\r\n                    </div>\r\n                </div>\r\n        </div>\r\n\r\n        <div class=\"jl-section jl-padding-remove-vertical\">\r\n            <div class=\"jl-child-width-1-2@s jl-child-width-1-4@l jl-grid-collapse jl-grid-match\" jl-grid>\r\n                <div>\r\n                    <div class=\"jl-tile jl-tile-default\">Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor.</div>\r\n                </div>\r\n                <div>\r\n                    <div class=\"jl-tile jl-tile-muted\">Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor.</div>\r\n                </div>\r\n                <div>\r\n                    <div class=\"jl-tile jl-tile-primary jl-light\">Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor.</div>\r\n                </div>\r\n                <div>\r\n                    <div class=\"jl-tile jl-tile-secondary jl-light\">Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor.</div>\r\n                </div>\r\n            </div>\r\n        </div>\r\n\r\n        <div class=\"jl-section jl-section-default\">\r\n            <div class=\"jl-grid-large jl-flex-middle\" jl-grid>\r\n                <div class=\"jl-width-expand@m\">\r\n                    <p class=\"jl-text-large\">Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor.</p>\r\n                </div>\r\n                <div class=\"jl-width-auto@m\">\r\n                    <a class=\"jl-button jl-button-default jl-button-large\" href=\"#\">Button</a>\r\n                </div>\r\n            </div>\r\n        </div>\r\n\r\n        <div class=\"jl-section jl-section-muted jl-padding\">\r\n            <div class=\"jl-grid-large jl-flex-middle\" jl-grid>\r\n                <div class=\"jl-width-expand@m\">\r\n                    <p class=\"jl-text-large\">Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor.</p>\r\n                </div>\r\n                <div class=\"jl-width-auto@m\">\r\n                    <a class=\"jl-button jl-button-default jl-button-large\" href=\"#\">Button</a>\r\n                </div>\r\n            </div>\r\n        </div>\r\n\r\n        <div class=\"jl-section jl-section-primary jl-padding jl-light\">\r\n            <div class=\"jl-grid-large jl-flex-middle\" jl-grid>\r\n                <div class=\"jl-width-expand@m\">\r\n                    <p class=\"jl-text-large\">Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor.</p>\r\n                </div>\r\n                <div class=\"jl-width-auto@m\">\r\n                    <a class=\"jl-button jl-button-default jl-button-large\" href=\"#\">Button</a>\r\n                </div>\r\n            </div>\r\n        </div>\r\n\r\n        <div class=\"jl-section jl-section-secondary jl-padding jl-light\">\r\n            <div class=\"jl-grid-large jl-flex-middle\" jl-grid>\r\n                <div class=\"jl-width-expand@m\">\r\n                    <p class=\"jl-text-large\">Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor.</p>\r\n                </div>\r\n                <div class=\"jl-width-auto@m\">\r\n                    <a class=\"jl-button jl-button-default jl-button-large\" href=\"#\">Button</a>\r\n                </div>\r\n            </div>\r\n        </div>\r\n\r\n        <div id=\"modal\" jl-modal>\r\n            <div class=\"jl-modal-dialog\">\r\n                <button class=\"jl-modal-close-default\" type=\"button\" jl-close></button>\r\n                <div class=\"jl-modal-header\">\r\n                    <h2 class=\"jl-modal-title\">Headline</h2>\r\n                </div>\r\n                <div class=\"jl-modal-body\">\r\n                    <p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.</p>\r\n                </div>\r\n                <div class=\"jl-modal-footer jl-text-right\">\r\n                    <button class=\"jl-button jl-button-default jl-modal-close\" type=\"button\">Cancel</button>\r\n                    <button class=\"jl-button jl-button-primary\" type=\"button\">Save</button>\r\n                </div>\r\n            </div>\r\n        </div>\r\n\r\n        <div id=\"modal-search\" class=\"jl-modal-full\" jl-modal>\r\n            <div class=\"jl-modal-dialog jl-flex jl-flex-center jl-flex-middle\" jl-height-viewport>\r\n\r\n                <button class=\"jl-modal-close-full jl-close-large\" type=\"button\" jl-close></button>\r\n\r\n                <div>\r\n\r\n                    <ul class=\"jl-nav-primary jl-nav-center\" jl-nav>\r\n                        <li class=\"jl-active\"><a href=\"#\">Active</a></li>\r\n                        <li><a href=\"#\">Item</a></li>\r\n                        <li><a href=\"#\">Item</a></li>\r\n                        <li><a href=\"#\">Item</a></li>\r\n                    </ul>\r\n\r\n                    <div class=\"jl-margin\">\r\n                        <form class=\"jl-search jl-search-large\">\r\n                            <input class=\"jl-search-input jl-text-center\" type=\"search\" placeholder=\"Search\" aria-label=\"Search\">\r\n                        </form>\r\n                    </div>\r\n\r\n                </div>\r\n\r\n            </div>\r\n        </div>\r\n\r\n        <div id=\"offcanvas\" jl-offcanvas=\"flip: true; overlay: true\">\r\n            <div class=\"jl-offcanvas-bar\">\r\n\r\n                <button class=\"jl-offcanvas-close\" type=\"button\" jl-close></button>\r\n\r\n                <ul class=\"jl-nav jl-nav-default\">\r\n                    <li class=\"jl-active\"><a href=\"#\">Active</a></li>\r\n                    <li class=\"jl-parent\">\r\n                        <a href=\"#\">Parent</a>\r\n                        <ul class=\"jl-nav-sub\">\r\n                            <li><a href=\"#\">Sub item</a></li>\r\n                            <li><a href=\"#\">Sub item</a></li>\r\n                        </ul>\r\n                    </li>\r\n                    <li class=\"jl-nav-header\">Header</li>\r\n                    <li><a href=\"#\"><span class=\"jl-margin-xsmall-right\" jl-icon=\"icon: table\"></span> Item</a></li>\r\n                    <li><a href=\"#\"><span class=\"jl-margin-xsmall-right\" jl-icon=\"icon: thumbnails\"></span> Item</a></li>\r\n                    <li class=\"jl-nav-divider\"></li>\r\n                    <li><a href=\"#\"><span class=\"jl-margin-xsmall-right\" jl-icon=\"icon: trash\"></span> Item</a></li>\r\n                </ul>\r\n\r\n                <h3>Title</h3>\r\n\r\n                <p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat.</p>\r\n\r\n            </div>\r\n        </div>', '', '1', '2', '1980-01-01 00:00:00', '107', '', '2025-10-07 11:21:34', '107', NULL, NULL, '2021-05-15 23:36:07', NULL, '{\"image_intro\":\"\",\"image_intro_alt\":\"\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', '52', '2', '', '', '1', '451', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', '0', '*', ''),
('8', '40', 'Key factors for productive work as a team', 'key-factors-for-productive-work-as-a-team', '<p>Lorem ipsum dolor sit amet, consectetur adipisici elit, sed eiusmod tempor incidunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquid ex ea commodi consequat.</p>', '\r\n<p>Quis aute iure reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint obcaecat cupiditat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum. Duis autem vel eum iriure dolor in hendrerit in vulputate velit esse molestie consequat, vel illum dolore eu feugiat nulla facilisis at vero eros et accumsan et iusto odio dignissim qui blandit praesent luptatum zzril delenit augue duis dolore te feugait nulla facilisi.</p>\r\n \r\n<p>Lorem ipsum dolor sit amet, consectetuer adipiscing elit, sed diam nonummy nibh euismod tincidunt ut laoreet dolore magna aliquam erat volutpat. Ut wisi enim ad minim veniam, quis nostrud exerci tation ullamcorper suscipit lobortis nisl ut aliquip ex ea commodo consequat. Nam liber tempor cum soluta nobis eleifend option congue nihil imperdiet doming id quod mazim placerat facer possim assum. Lorem ipsum dolor sit amet, consectetuer adipiscing elit, sed diam nonummy nibh euismod tincidunt ut laoreet dolore magna aliquam erat volutpat. Ut wisi enim ad minim veniam, quis nostrud exerci tation ullamcorper suscipit lobortis nisl ut aliquip ex ea commodo consequat.</p>\r\n<h2>Daily Inspiration</h2>\r\n<p>Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, At accusam aliquyam diam diam dolore dolores duo eirmod eos erat, et nonumy sed tempor et et invidunt justo labore Stet clita ea et gubergren, kasd magna no rebum. sanctus sea sed takimata ut vero voluptua.</p>\r\n\r\n<p class=\"jl-margin-medium\">\r\n    <img width=\"900\" height=\"300\" alt=\"\" src=\"images/lead/blog_themes.jpg\">\r\n</p>\r\n\r\n<p>Consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.</p>\r\n<blockquote class=\"jl-margin-medium\">It comes after new research revealed that late payments and poor cash flow were causing up to 50,000 small businesses to fail each year.<footer>John Doe</footer></blockquote>\r\n<p>At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.</p>\r\n\r\n<h2>Wrapping Up</h2>\r\n\r\n<p>Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.</p>\r\n\r\n<p>Consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.</p>', '1', '7', '1980-01-01 00:00:00', '107', '', '2021-11-19 17:13:21', '107', NULL, NULL, '2021-05-15 20:52:53', NULL, '{\"image_intro\":\"images\\/sampledata\\/blog7.jpg#joomlaImage:\\/\\/local-images\\/sampledata\\/blog7.jpg?width=1170&height=780\",\"image_intro_alt\":\"\",\"float_intro\":\"none\",\"image_intro_caption\":\"\",\"image_fulltext\":\"images\\/sampledata\\/blog7.jpg#joomlaImage:\\/\\/local-images\\/sampledata\\/blog7.jpg?width=1170&height=780\",\"image_fulltext_alt\":\"\",\"float_fulltext\":\"none\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', '69', '1', '', '', '1', '125', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', '0', '*', ''),
('9', '41', 'Our guide to 3D graphic design for beginners', 'our-guide-to-3d-graphic-design-for-beginners', '<p>Lorem ipsum dolor sit amet, consectetur adipisici elit, sed eiusmod tempor incidunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquid ex ea commodi consequat.</p>', '\r\n<p>Quis aute iure reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint obcaecat cupiditat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum. Duis autem vel eum iriure dolor in hendrerit in vulputate velit esse molestie consequat, vel illum dolore eu feugiat nulla facilisis at vero eros et accumsan et iusto odio dignissim qui blandit praesent luptatum zzril delenit augue duis dolore te feugait nulla facilisi.</p>\r\n \r\n<p>Lorem ipsum dolor sit amet, consectetuer adipiscing elit, sed diam nonummy nibh euismod tincidunt ut laoreet dolore magna aliquam erat volutpat. Ut wisi enim ad minim veniam, quis nostrud exerci tation ullamcorper suscipit lobortis nisl ut aliquip ex ea commodo consequat. Nam liber tempor cum soluta nobis eleifend option congue nihil imperdiet doming id quod mazim placerat facer possim assum. Lorem ipsum dolor sit amet, consectetuer adipiscing elit, sed diam nonummy nibh euismod tincidunt ut laoreet dolore magna aliquam erat volutpat. Ut wisi enim ad minim veniam, quis nostrud exerci tation ullamcorper suscipit lobortis nisl ut aliquip ex ea commodo consequat.</p>\r\n<h2>Daily Inspiration</h2>\r\n<p>Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, At accusam aliquyam diam diam dolore dolores duo eirmod eos erat, et nonumy sed tempor et et invidunt justo labore Stet clita ea et gubergren, kasd magna no rebum. sanctus sea sed takimata ut vero voluptua.</p>\r\n\r\n<p class=\"jl-margin-medium\">\r\n    <img width=\"900\" height=\"300\" alt=\"\" src=\"images/lead/blog_themes.jpg\">\r\n</p>\r\n\r\n<p>Consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.</p>\r\n<blockquote class=\"jl-margin-medium\">It comes after new research revealed that late payments and poor cash flow were causing up to 50,000 small businesses to fail each year.<footer>John Doe</footer></blockquote>\r\n<p>At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.</p>\r\n\r\n<h2>Wrapping Up</h2>\r\n\r\n<p>Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.</p>\r\n\r\n<p>Consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.</p>', '1', '7', '1980-01-01 00:00:00', '107', '', '2021-11-19 17:13:00', '107', NULL, NULL, '2021-05-15 20:55:59', NULL, '{\"image_intro\":\"images\\/sampledata\\/blog5.jpg#joomlaImage:\\/\\/local-images\\/sampledata\\/blog5.jpg?width=2400&height=1599\",\"image_intro_alt\":\"\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"images\\/sampledata\\/blog5.jpg#joomlaImage:\\/\\/local-images\\/sampledata\\/blog5.jpg?width=2400&height=1599\",\"image_fulltext_alt\":\"\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', '31', '4', '', '', '1', '70', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', '0', '*', ''),
('10', '42', 'Working with pleasure is crucial for your career', 'working-with-pleasure-is-crucial-for-your-career', '<p>Lorem ipsum dolor sit amet, consectetur adipisici elit, sed eiusmod tempor incidunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquid ex ea commodi consequat.</p>', '\r\n<p>Quis aute iure reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint obcaecat cupiditat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum. Duis autem vel eum iriure dolor in hendrerit in vulputate velit esse molestie consequat, vel illum dolore eu feugiat nulla facilisis at vero eros et accumsan et iusto odio dignissim qui blandit praesent luptatum zzril delenit augue duis dolore te feugait nulla facilisi.</p>\r\n \r\n<p>Lorem ipsum dolor sit amet, consectetuer adipiscing elit, sed diam nonummy nibh euismod tincidunt ut laoreet dolore magna aliquam erat volutpat. Ut wisi enim ad minim veniam, quis nostrud exerci tation ullamcorper suscipit lobortis nisl ut aliquip ex ea commodo consequat. Nam liber tempor cum soluta nobis eleifend option congue nihil imperdiet doming id quod mazim placerat facer possim assum. Lorem ipsum dolor sit amet, consectetuer adipiscing elit, sed diam nonummy nibh euismod tincidunt ut laoreet dolore magna aliquam erat volutpat. Ut wisi enim ad minim veniam, quis nostrud exerci tation ullamcorper suscipit lobortis nisl ut aliquip ex ea commodo consequat.</p>\r\n<h2>Daily Inspiration</h2>\r\n<p>Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, At accusam aliquyam diam diam dolore dolores duo eirmod eos erat, et nonumy sed tempor et et invidunt justo labore Stet clita ea et gubergren, kasd magna no rebum. sanctus sea sed takimata ut vero voluptua.</p>\r\n\r\n<p class=\"jl-margin-medium\">\r\n    <img width=\"900\" height=\"300\" alt=\"\" src=\"images/lead/blog_themes.jpg\">\r\n</p>\r\n\r\n<p>Consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.</p>\r\n<blockquote class=\"jl-margin-medium\">It comes after new research revealed that late payments and poor cash flow were causing up to 50,000 small businesses to fail each year.<footer>John Doe</footer></blockquote>\r\n<p>At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.</p>\r\n\r\n<h2>Wrapping Up</h2>\r\n\r\n<p>Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.</p>\r\n\r\n<p>Consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.</p>', '1', '7', '1980-01-01 00:00:00', '107', '', '2021-11-19 17:12:46', '107', NULL, NULL, '2021-05-15 20:52:34', NULL, '{\"image_intro\":\"images\\/sampledata\\/blog6.jpg#joomlaImage:\\/\\/local-images\\/sampledata\\/blog6.jpg?width=2400&height=1599\",\"image_intro_alt\":\"\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"images\\/sampledata\\/blog6.jpg#joomlaImage:\\/\\/local-images\\/sampledata\\/blog6.jpg?width=2400&height=1599\",\"image_fulltext_alt\":\"\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', '34', '5', '', '', '1', '28', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', '0', '*', ''),
('23', '191', 'How to not get lost in the virtual world', 'how-to-not-get-lost-in-the-virtual-world', '<p>Lorem ipsum dolor sit amet, consectetur adipisici elit, sed eiusmod tempor incidunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquid ex ea commodi consequat.</p>', '\r\n<p>Quis aute iure reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint obcaecat cupiditat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum. Duis autem vel eum iriure dolor in hendrerit in vulputate velit esse molestie consequat, vel illum dolore eu feugiat nulla facilisis at vero eros et accumsan et iusto odio dignissim qui blandit praesent luptatum zzril delenit augue duis dolore te feugait nulla facilisi.</p>\r\n \r\n<p>Lorem ipsum dolor sit amet, consectetuer adipiscing elit, sed diam nonummy nibh euismod tincidunt ut laoreet dolore magna aliquam erat volutpat. Ut wisi enim ad minim veniam, quis nostrud exerci tation ullamcorper suscipit lobortis nisl ut aliquip ex ea commodo consequat. Nam liber tempor cum soluta nobis eleifend option congue nihil imperdiet doming id quod mazim placerat facer possim assum. Lorem ipsum dolor sit amet, consectetuer adipiscing elit, sed diam nonummy nibh euismod tincidunt ut laoreet dolore magna aliquam erat volutpat. Ut wisi enim ad minim veniam, quis nostrud exerci tation ullamcorper suscipit lobortis nisl ut aliquip ex ea commodo consequat.</p>\r\n<h2>Daily Inspiration</h2>\r\n<p>Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, At accusam aliquyam diam diam dolore dolores duo eirmod eos erat, et nonumy sed tempor et et invidunt justo labore Stet clita ea et gubergren, kasd magna no rebum. sanctus sea sed takimata ut vero voluptua.</p>\r\n\r\n<p class=\"jl-margin-medium\">\r\n    <img width=\"900\" height=\"300\" alt=\"\" src=\"images/lead/blog_themes.jpg\">\r\n</p>\r\n\r\n<p>Consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.</p>\r\n<blockquote class=\"jl-margin-medium\">It comes after new research revealed that late payments and poor cash flow were causing up to 50,000 small businesses to fail each year.<footer>John Doe</footer></blockquote>\r\n<p>At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.</p>\r\n\r\n<h2>Wrapping Up</h2>\r\n\r\n<p>Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.</p>\r\n\r\n<p>Consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.</p>', '1', '7', '1980-01-01 00:00:00', '107', '', '2021-11-19 17:12:32', '107', NULL, NULL, '2021-05-13 15:14:30', NULL, '{\"image_intro\":\"images\\/sampledata\\/blog4.jpg#joomlaImage:\\/\\/local-images\\/sampledata\\/blog4.jpg?width=2400&height=1599\",\"image_intro_alt\":\"\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"images\\/sampledata\\/blog4.jpg#joomlaImage:\\/\\/local-images\\/sampledata\\/blog4.jpg?width=2400&height=1599\",\"image_fulltext_alt\":\"\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', '28', '6', '', '', '1', '6', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', '0', '*', ''),
('24', '151', 'Why planning ahead is wrong for designers?', 'why-planning-ahead-is-wrong-for-designers', '<p>Lorem ipsum dolor sit amet, consectetur adipisici elit, sed eiusmod tempor incidunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquid ex ea commodi consequat.</p>', '\r\n<p>Quis aute iure reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint obcaecat cupiditat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum. Duis autem vel eum iriure dolor in hendrerit in vulputate velit esse molestie consequat, vel illum dolore eu feugiat nulla facilisis at vero eros et accumsan et iusto odio dignissim qui blandit praesent luptatum zzril delenit augue duis dolore te feugait nulla facilisi.</p>\r\n \r\n<p>Lorem ipsum dolor sit amet, consectetuer adipiscing elit, sed diam nonummy nibh euismod tincidunt ut laoreet dolore magna aliquam erat volutpat. Ut wisi enim ad minim veniam, quis nostrud exerci tation ullamcorper suscipit lobortis nisl ut aliquip ex ea commodo consequat. Nam liber tempor cum soluta nobis eleifend option congue nihil imperdiet doming id quod mazim placerat facer possim assum. Lorem ipsum dolor sit amet, consectetuer adipiscing elit, sed diam nonummy nibh euismod tincidunt ut laoreet dolore magna aliquam erat volutpat. Ut wisi enim ad minim veniam, quis nostrud exerci tation ullamcorper suscipit lobortis nisl ut aliquip ex ea commodo consequat.</p>\r\n<h2>Daily Inspiration</h2>\r\n<p>Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, At accusam aliquyam diam diam dolore dolores duo eirmod eos erat, et nonumy sed tempor et et invidunt justo labore Stet clita ea et gubergren, kasd magna no rebum. sanctus sea sed takimata ut vero voluptua.</p>\r\n\r\n<p class=\"jl-margin-medium\">\r\n    <img width=\"900\" height=\"300\" alt=\"\" src=\"images/lead/blog_themes.jpg\">\r\n</p>\r\n\r\n<p>Consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.</p>\r\n<blockquote class=\"jl-margin-medium\">It comes after new research revealed that late payments and poor cash flow were causing up to 50,000 small businesses to fail each year.<footer>John Doe</footer></blockquote>\r\n<p>At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.</p>\r\n\r\n<h2>Wrapping Up</h2>\r\n\r\n<p>Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.</p>\r\n\r\n<p>Consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.</p>', '1', '7', '1980-01-01 00:00:00', '107', '', '2021-11-19 17:12:15', '107', NULL, NULL, '2021-05-13 15:14:10', NULL, '{\"image_intro\":\"images\\/sampledata\\/blog3.jpg#joomlaImage:\\/\\/local-images\\/sampledata\\/blog3.jpg?width=2400&height=1599\",\"image_intro_alt\":\"\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"images\\/sampledata\\/blog3.jpg#joomlaImage:\\/\\/local-images\\/sampledata\\/blog3.jpg?width=2400&height=1599\",\"image_fulltext_alt\":\"\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', '30', '3', '', '', '1', '18', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', '0', '*', ''),
('25', '153', 'How Interior Designers Get Inspired', 'how-interior-designers-get-inspired', '<p>Lorem ipsum dolor sit amet, consectetur adipisici elit, sed eiusmod tempor incidunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquid ex ea commodi consequat.</p>', '\r\n<p>Quis aute iure reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint obcaecat cupiditat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum. Duis autem vel eum iriure dolor in hendrerit in vulputate velit esse molestie consequat, vel illum dolore eu feugiat nulla facilisis at vero eros et accumsan et iusto odio dignissim qui blandit praesent luptatum zzril delenit augue duis dolore te feugait nulla facilisi.</p>\r\n \r\n<p>Lorem ipsum dolor sit amet, consectetuer adipiscing elit, sed diam nonummy nibh euismod tincidunt ut laoreet dolore magna aliquam erat volutpat. Ut wisi enim ad minim veniam, quis nostrud exerci tation ullamcorper suscipit lobortis nisl ut aliquip ex ea commodo consequat. Nam liber tempor cum soluta nobis eleifend option congue nihil imperdiet doming id quod mazim placerat facer possim assum. Lorem ipsum dolor sit amet, consectetuer adipiscing elit, sed diam nonummy nibh euismod tincidunt ut laoreet dolore magna aliquam erat volutpat. Ut wisi enim ad minim veniam, quis nostrud exerci tation ullamcorper suscipit lobortis nisl ut aliquip ex ea commodo consequat.</p>\r\n<h2>Daily Inspiration</h2>\r\n<p>Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, At accusam aliquyam diam diam dolore dolores duo eirmod eos erat, et nonumy sed tempor et et invidunt justo labore Stet clita ea et gubergren, kasd magna no rebum. sanctus sea sed takimata ut vero voluptua.</p>\r\n\r\n<p class=\"jl-margin-medium\">\r\n    <img width=\"900\" height=\"300\" alt=\"\" src=\"images/lead/blog_themes.jpg\">\r\n</p>\r\n\r\n<p>Consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.</p>\r\n<blockquote class=\"jl-margin-medium\">It comes after new research revealed that late payments and poor cash flow were causing up to 50,000 small businesses to fail each year.<footer>John Doe</footer></blockquote>\r\n<p>At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.</p>\r\n\r\n<h2>Wrapping Up</h2>\r\n\r\n<p>Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.</p>\r\n\r\n<p>Consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.</p>', '1', '7', '1980-01-01 00:00:00', '107', '', '2021-11-19 17:12:00', '107', NULL, NULL, '2021-05-13 15:13:50', NULL, '{\"image_intro\":\"images\\/sampledata\\/blog2.jpg#joomlaImage:\\/\\/local-images\\/sampledata\\/blog2.jpg?width=2400&height=1599\",\"image_intro_alt\":\"\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"images\\/sampledata\\/blog1.jpg#joomlaImage:\\/\\/local-images\\/sampledata\\/blog1.jpg?width=2400&height=1599\",\"image_fulltext_alt\":\"\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', '35', '2', '', '', '1', '12', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', '0', '*', ''),
('26', '156', 'Modern Architectural Solutions for Condos', 'modern-architectural-solutions-for-condos', '<p>Lorem ipsum dolor sit amet, consectetur adipisici elit, sed eiusmod tempor incidunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquid ex ea commodi consequat.</p>', '\r\n<p>Quis aute iure reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint obcaecat cupiditat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum. Duis autem vel eum iriure dolor in hendrerit in vulputate velit esse molestie consequat, vel illum dolore eu feugiat nulla facilisis at vero eros et accumsan et iusto odio dignissim qui blandit praesent luptatum zzril delenit augue duis dolore te feugait nulla facilisi.</p>\r\n \r\n<p>Lorem ipsum dolor sit amet, consectetuer adipiscing elit, sed diam nonummy nibh euismod tincidunt ut laoreet dolore magna aliquam erat volutpat. Ut wisi enim ad minim veniam, quis nostrud exerci tation ullamcorper suscipit lobortis nisl ut aliquip ex ea commodo consequat. Nam liber tempor cum soluta nobis eleifend option congue nihil imperdiet doming id quod mazim placerat facer possim assum. Lorem ipsum dolor sit amet, consectetuer adipiscing elit, sed diam nonummy nibh euismod tincidunt ut laoreet dolore magna aliquam erat volutpat. Ut wisi enim ad minim veniam, quis nostrud exerci tation ullamcorper suscipit lobortis nisl ut aliquip ex ea commodo consequat.</p>\r\n<h2>Daily Inspiration</h2>\r\n<p>Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, At accusam aliquyam diam diam dolore dolores duo eirmod eos erat, et nonumy sed tempor et et invidunt justo labore Stet clita ea et gubergren, kasd magna no rebum. sanctus sea sed takimata ut vero voluptua.</p>\r\n\r\n<p class=\"jl-margin-medium\">\r\n    <img width=\"900\" height=\"300\" alt=\"\" src=\"images/lead/blog_themes.jpg\">\r\n</p>\r\n\r\n<p>Consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.</p>\r\n<blockquote class=\"jl-margin-medium\">It comes after new research revealed that late payments and poor cash flow were causing up to 50,000 small businesses to fail each year.<footer>John Doe</footer></blockquote>\r\n<p>At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.</p>\r\n\r\n<h2>Wrapping Up</h2>\r\n\r\n<p>Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.</p>\r\n\r\n<p>Consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.</p>', '1', '7', '1980-01-01 00:00:00', '107', '', '2021-11-19 17:11:42', '107', NULL, NULL, '2021-05-13 15:13:29', NULL, '{\"image_intro\":\"images\\/sampledata\\/blog1.jpg#joomlaImage:\\/\\/local-images\\/sampledata\\/blog1.jpg?width=2400&height=1599\",\"image_intro_alt\":\"\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"images\\/sampledata\\/blog1.jpg#joomlaImage:\\/\\/local-images\\/sampledata\\/blog1.jpg?width=2400&height=1599\",\"image_fulltext_alt\":\"\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', '33', '7', '', '', '1', '28', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', '0', '*', ''),
('46', '193', 'Layout content | right sidebar', 'layout-content-right-sidebar', '<p>Particles are incredibly simple building blocks that Gantry 5 themes thrive on. They are easy to set up, require no coding experience to configure, and are built on an intuitive and human-readable Twig and YAML file structure that makes developing them a breeze. You can use particles to set up your logo, display content in a way that complements the theme design, and more.</p>\r\n\r\n<p>Documentation for Gantry 5 is available on the <a href=\"http://docs.gantry.org\">official Gantry website</a>. You can submit any issues or feature requests for Gantry through <a href=\"http://github.com/gantry/gantry5\">GitHub</a>. A chat room has been set up using <a href=\"https://gitter.im/gantry/gantry5\">Gitter</a> where you can go to talk about the project with developers, contributors, and other members of the community. This is the best place to go to get quick tips and discuss features with others.</p>', '', '-2', '11', '1980-01-01 00:00:00', '107', '', '2021-05-16 07:41:08', '107', NULL, NULL, '2021-05-16 07:41:08', NULL, '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', '11', '6', '', '', '1', '66', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', '0', '*', ''),
('47', '194', 'Layout Left Sidebar | Content', 'layout-left-sidebar-content', '<p>Particles are incredibly simple building blocks that Gantry 5 themes thrive on. They are easy to set up, require no coding experience to configure, and are built on an intuitive and human-readable Twig and YAML file structure that makes developing them a breeze. You can use particles to set up your logo, display content in a way that complements the theme design, and more.</p>\r\n\r\n<p>Documentation for Gantry 5 is available on the <a href=\"http://docs.gantry.org\">official Gantry website</a>. You can submit any issues or feature requests for Gantry through <a href=\"http://github.com/gantry/gantry5\">GitHub</a>. A chat room has been set up using <a href=\"https://gitter.im/gantry/gantry5\">Gitter</a> where you can go to talk about the project with developers, contributors, and other members of the community. This is the best place to go to get quick tips and discuss features with others.</p>', '', '-2', '11', '1980-01-01 00:00:00', '107', '', '2021-05-16 07:40:57', '107', NULL, NULL, '2021-05-16 07:40:57', NULL, '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', '4', '5', '', '', '1', '32', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', '0', '*', ''),
('48', '195', 'Left | Content | Right', 'left-content-right', '<p>Particles are incredibly simple building blocks that Gantry 5 themes thrive on. They are easy to set up, require no coding experience to configure, and are built on an intuitive and human-readable Twig and YAML file structure that makes developing them a breeze. You can use particles to set up your logo, display content in a way that complements the theme design, and more.</p>\r\n\r\n<p>Documentation for Gantry 5 is available on the <a href=\"http://docs.gantry.org\">official Gantry website</a>. You can submit any issues or feature requests for Gantry through <a href=\"http://github.com/gantry/gantry5\">GitHub</a>. A chat room has been set up using <a href=\"https://gitter.im/gantry/gantry5\">Gitter</a> where you can go to talk about the project with developers, contributors, and other members of the community. This is the best place to go to get quick tips and discuss features with others.</p>', '', '-2', '11', '1980-01-01 00:00:00', '107', '', '2021-05-16 07:40:47', '107', NULL, NULL, '2021-05-16 07:40:47', NULL, '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', '4', '4', '', '', '1', '15', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', '0', '*', ''),
('49', '196', 'Content | Left | Right', 'content-left-right', '<p>Particles are incredibly simple building blocks that Gantry 5 themes thrive on. They are easy to set up, require no coding experience to configure, and are built on an intuitive and human-readable Twig and YAML file structure that makes developing them a breeze. You can use particles to set up your logo, display content in a way that complements the theme design, and more.</p>\r\n\r\n<p>Documentation for Gantry 5 is available on the <a href=\"http://docs.gantry.org\">official Gantry website</a>. You can submit any issues or feature requests for Gantry through <a href=\"http://github.com/gantry/gantry5\">GitHub</a>. A chat room has been set up using <a href=\"https://gitter.im/gantry/gantry5\">Gitter</a> where you can go to talk about the project with developers, contributors, and other members of the community. This is the best place to go to get quick tips and discuss features with others.</p>', '', '-2', '11', '1980-01-01 00:00:00', '107', '', '2021-05-16 07:40:39', '107', NULL, NULL, '2021-05-16 07:40:39', NULL, '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', '7', '3', '', '', '1', '13', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', '0', '*', ''),
('50', '197', 'Main Content Only', 'main-content-only', '<p>Particles are incredibly simple building blocks that Gantry 5 themes thrive on. They are easy to set up, require no coding experience to configure, and are built on an intuitive and human-readable Twig and YAML file structure that makes developing them a breeze. You can use particles to set up your logo, display content in a way that complements the theme design, and more.</p>\r\n\r\n<p>Documentation for Gantry 5 is available on the <a href=\"http://docs.gantry.org\">official Gantry website</a>. You can submit any issues or feature requests for Gantry through <a href=\"http://github.com/gantry/gantry5\">GitHub</a>. A chat room has been set up using <a href=\"https://gitter.im/gantry/gantry5\">Gitter</a> where you can go to talk about the project with developers, contributors, and other members of the community. This is the best place to go to get quick tips and discuss features with others.</p>', '', '-2', '11', '1980-01-01 00:00:00', '107', '', '2021-05-16 07:40:28', '107', NULL, NULL, '2021-05-16 07:40:28', NULL, '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', '9', '2', '', '', '1', '40', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', '0', '*', ''),
('58', '286', 'Variations', 'variations', '<div class=\"center g-title-large\">\r\n<h2 class=\"g-title\">Basic Box Variations</h2>\r\n</div>\r\n<div class=\"g-grid\">\r\n<div class=\"g-block box1 size-33-3\">\r\n<div class=\"g-content\">\r\n<h3 class=\"g-title\">Box 1</h3>\r\n<p>Lorem <strong>ipsum dolor</strong> sit amet, <a>consecetur</a> adipiscing elit <em>donec sit</em> amet nibh.</p>\r\n<a class=\"jl-button jl-button-primary\">Read More</a></div>\r\n</div>\r\n<div class=\"g-block box2 size-33-3\">\r\n<div class=\"g-content\">\r\n<h3 class=\"g-title\">Box 2</h3>\r\n<p>Lorem <strong>ipsum dolor</strong> sit amet, <a>consecetur</a> adipiscing elit <em>donec sit</em> amet nibh.</p>\r\n<a class=\"jl-button jl-button-secondary\">Read More</a></div>\r\n</div>\r\n<div class=\"g-block box3 size-33-3\">\r\n<div class=\"g-content\">\r\n<h3 class=\"g-title\">Box 3</h3>\r\n<p>Lorem <strong>ipsum dolor</strong> sit amet, <a>consecetur</a> adipiscing elit <em>donec sit</em> amet nibh.</p>\r\n<a class=\"jl-button jl-button-default\">Read More</a></div>\r\n</div>\r\n</div>\r\n<div class=\"g-grid\">\r\n<div class=\"g-block box4 size-33-3\">\r\n<div class=\"g-content\">\r\n<h3 class=\"g-title\">Box 4</h3>\r\n<p>Lorem <strong>ipsum dolor</strong> sit amet, <a>consecetur</a> adipiscing elit <em>donec sit</em> amet nibh.</p>\r\n<a class=\"jl-button jl-button-primary\">Read More</a></div>\r\n</div>\r\n<div class=\"g-block box5 size-33-3\">\r\n<div class=\"g-content\">\r\n<h3 class=\"g-title\">Box 5</h3>\r\n<p>Lorem <strong>ipsum dolor</strong> sit amet, <a>consecetur</a> adipiscing elit <em>donec sit</em> amet nibh.</p>\r\n<a class=\"jl-button jl-button-default\">Read More</a></div>\r\n</div>\r\n<div class=\"g-block box6 size-33-3\">\r\n<div class=\"g-content\">\r\n<h3 class=\"g-title\">Box 6</h3>\r\n<p>Lorem <strong>ipsum dolor</strong> sit amet, <a>consecetur</a> adipiscing elit <em>donec sit</em> amet nibh.</p>\r\n<a class=\"jl-button jl-button-default\">Read More</a></div>\r\n</div>\r\n</div>\r\n\r\n<hr class=\"jl-margin-large\">\r\n<div class=\"center g-title-large\">\r\n<h2 class=\"g-title\">Inverse (Custom card)</h2>\r\n  <p>\r\n    Add the <code>jl-light</code> class to improve the visibility of objects on dark backgrounds in a light style. When using a dark style, add the <code>jl-dark</code> class to elements on a light background.\r\n  </p>\r\n</div>\r\n\r\n<div class=\"g-grid\">\r\n<div class=\"g-block title-grey size-50\">\r\n<div class=\"g-content\">\r\n        <div class=\"jl-light jl-background-secondary jl-padding\">\r\n            <h3>Light</h3>\r\n            <p>Lorem ipsum <a href=\"#\">dolor</a> sit amet, consectetur adipiscing elit, sed do eiusmod tempor\r\n                    incididunt ut labore et dolore magna aliqua.</p>\r\n            <button class=\"jl-button jl-button-default\">Button</button>\r\n        </div>\r\n</div>\r\n</div>\r\n<div class=\"g-block title-pink size-50\">\r\n<div class=\"g-content\">\r\n        <div class=\"jl-dark jl-background-muted jl-padding\">\r\n            <h3>Dark</h3>\r\n            <p>Lorem ipsum <a href=\"#\">dolor</a> sit amet, consectetur adipiscing elit, sed do eiusmod tempor\r\n                    incididunt ut labore et dolore magna aliqua.</p>\r\n            <button class=\"jl-button jl-button-default\">Button</button>\r\n        </div>\r\n</div>\r\n</div>\r\n\r\n</div>', '', '1', '11', '2021-10-21 02:48:42', '107', '', '2021-10-28 06:32:42', '107', NULL, NULL, '2021-10-21 02:48:42', NULL, '{\"image_intro\":\"\",\"image_intro_alt\":\"\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', '23', '1', '', '', '1', '52', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', '0', '*', ''),
('59', '299', 'Replacing Social Media with Modern Art', 'replacing-social-media-with-modern-art', '<p>Lorem ipsum dolor sit amet, consectetur adipisici elit, sed eiusmod tempor incidunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquid ex ea commodi consequat.</p>', '\r\n<p>Quis aute iure reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint obcaecat cupiditat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum. Duis autem vel eum iriure dolor in hendrerit in vulputate velit esse molestie consequat, vel illum dolore eu feugiat nulla facilisis at vero eros et accumsan et iusto odio dignissim qui blandit praesent luptatum zzril delenit augue duis dolore te feugait nulla facilisi.</p>\r\n \r\n<p>Lorem ipsum dolor sit amet, consectetuer adipiscing elit, sed diam nonummy nibh euismod tincidunt ut laoreet dolore magna aliquam erat volutpat. Ut wisi enim ad minim veniam, quis nostrud exerci tation ullamcorper suscipit lobortis nisl ut aliquip ex ea commodo consequat. Nam liber tempor cum soluta nobis eleifend option congue nihil imperdiet doming id quod mazim placerat facer possim assum. Lorem ipsum dolor sit amet, consectetuer adipiscing elit, sed diam nonummy nibh euismod tincidunt ut laoreet dolore magna aliquam erat volutpat. Ut wisi enim ad minim veniam, quis nostrud exerci tation ullamcorper suscipit lobortis nisl ut aliquip ex ea commodo consequat.</p>\r\n<h2>Daily Inspiration</h2>\r\n<p>Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, At accusam aliquyam diam diam dolore dolores duo eirmod eos erat, et nonumy sed tempor et et invidunt justo labore Stet clita ea et gubergren, kasd magna no rebum. sanctus sea sed takimata ut vero voluptua.</p>\r\n\r\n<p class=\"jl-margin-medium\">\r\n    <img width=\"900\" height=\"300\" alt=\"\" src=\"images/lead/blog_themes.jpg\">\r\n</p>\r\n\r\n<p>Consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.</p>\r\n<blockquote class=\"jl-margin-medium\">It comes after new research revealed that late payments and poor cash flow were causing up to 50,000 small businesses to fail each year.<footer>John Doe</footer></blockquote>\r\n<p>At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.</p>\r\n\r\n<h2>Wrapping Up</h2>\r\n\r\n<p>Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.</p>\r\n\r\n<p>Consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.</p>', '1', '7', '1980-01-01 00:00:00', '107', '', '2021-11-19 17:11:02', '107', NULL, NULL, '2021-05-13 15:13:29', NULL, '{\"image_intro\":\"images\\/sampledata\\/blog3.jpg#joomlaImage:\\/\\/local-images\\/sampledata\\/blog3.jpg?width=1170&height=781\",\"image_intro_alt\":\"\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"images\\/sampledata\\/blog3.jpg#joomlaImage:\\/\\/local-images\\/sampledata\\/blog3.jpg?width=1170&height=781\",\"image_fulltext_alt\":\"\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', '4', '0', '', '', '1', '0', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', '0', '*', ''),
('60', '311', 'Header Layouts', 'header-layouts', '<p>\r\n  Create a navigation bar that can be used for your main site navigation. The theme included JL Navbar particle with 10 predefined header layouts.</p>\r\n\r\n<p> Customize the header and navigation bar of your website can be found in the Base Outline → Navigation section of the theme.\r\n</p>\r\n\r\nCheck the <a href=\"https://demo.joomlead.com/particles/index.php/particles/navbar\">live demo here</a>.\r\n\r\n', '', '1', '11', '2021-12-18 04:40:36', '107', '', '2021-12-18 04:40:36', '107', NULL, NULL, '2021-12-18 04:40:36', NULL, '{\"image_intro\":\"\",\"image_intro_alt\":\"\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', '1', '0', '', '', '1', '0', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', '0', '*', '');/**ABDB**/
/**ABDB**/CREATE TABLE `#__content_frontpage` (
  `content_id` int NOT NULL DEFAULT '0',
  `ordering` int NOT NULL DEFAULT '0',
  `featured_up` datetime DEFAULT NULL,
  `featured_down` datetime DEFAULT NULL,
  PRIMARY KEY (`content_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__content_frontpage`  VALUES 
('12', '1', NULL, NULL);
/**ABDB**/CREATE TABLE `#__content_rating` (
  `content_id` int NOT NULL DEFAULT '0',
  `rating_sum` int unsigned NOT NULL DEFAULT '0',
  `rating_count` int unsigned NOT NULL DEFAULT '0',
  `lastip` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`content_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/CREATE TABLE `#__content_types` (
  `type_id` int unsigned NOT NULL AUTO_INCREMENT,
  `type_title` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `type_alias` varchar(400) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `table` varchar(2048) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `rules` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `field_mappings` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `router` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `content_history_options` varchar(5120) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'JSON string for com_contenthistory options',
  PRIMARY KEY (`type_id`),
  KEY `idx_alias` (`type_alias`(100))
) ENGINE=InnoDB AUTO_INCREMENT=14 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__content_types`  VALUES 
('1', 'Article', 'com_content.article', '{\"special\":{\"dbtable\":\"#__content\",\"key\":\"id\",\"type\":\"ArticleTable\",\"prefix\":\"Joomla\\\\Component\\\\Content\\\\Administrator\\\\Table\\\\\",\"config\":\"array()\"},\"common\":{\"dbtable\":\"#__ucm_content\",\"key\":\"ucm_id\",\"type\":\"Corecontent\",\"prefix\":\"Joomla\\\\CMS\\\\Table\\\\\",\"config\":\"array()\"}}', '', '{\"common\": {\"note\": \"note\", \"asset_id\": \"asset_id\", \"core_body\": \"introtext\", \"core_hits\": \"hits\", \"core_urls\": \"urls\", \"core_alias\": \"alias\", \"core_catid\": \"catid\", \"core_state\": \"state\", \"core_title\": \"title\", \"core_access\": \"access\", \"core_images\": \"images\", \"core_params\": \"attribs\", \"core_metakey\": \"metakey\", \"core_version\": \"version\", \"core_featured\": \"featured\", \"core_language\": \"language\", \"core_metadata\": \"metadata\", \"core_metadesc\": \"metadesc\", \"core_ordering\": \"ordering\", \"core_publish_up\": \"publish_up\", \"core_xreference\": \"xreference\", \"core_created_time\": \"created\", \"core_publish_down\": \"publish_down\", \"core_modified_time\": \"modified\", \"core_content_item_id\": \"id\", \"core_created_user_id\": \"created_by\", \"core_created_by_alias\": \"created_by_alias\"}, \"special\": {\"fulltext\": \"fulltext\"}}', 'ContentHelperRoute::getArticleRoute', '{\"formFile\": \"administrator/components/com_content/models/forms/article.xml\", \"hideFields\": [\"asset_id\", \"checked_out\", \"checked_out_time\", \"version\"], \"convertToInt\": [\"publish_up\", \"publish_down\", \"featured\", \"ordering\"], \"displayLookup\": [{\"targetTable\": \"#__categories\", \"sourceColumn\": \"catid\", \"targetColumn\": \"id\", \"displayColumn\": \"title\"}, {\"targetTable\": \"#__users\", \"sourceColumn\": \"created_by\", \"targetColumn\": \"id\", \"displayColumn\": \"name\"}, {\"targetTable\": \"#__viewlevels\", \"sourceColumn\": \"access\", \"targetColumn\": \"id\", \"displayColumn\": \"title\"}, {\"targetTable\": \"#__users\", \"sourceColumn\": \"modified_by\", \"targetColumn\": \"id\", \"displayColumn\": \"name\"}, {\"targetTable\": \"#__tags\", \"sourceColumn\": \"tags\", \"targetColumn\": \"id\", \"displayColumn\": \"title\"}], \"ignoreChanges\": [\"modified_by\", \"modified\", \"checked_out\", \"checked_out_time\", \"version\", \"hits\", \"ordering\"]}'),
('2', 'Contact', 'com_contact.contact', '{\"special\":{\"dbtable\":\"#__contact_details\",\"key\":\"id\",\"type\":\"ContactTable\",\"prefix\":\"Joomla\\\\Component\\\\Contact\\\\Administrator\\\\Table\\\\\",\"config\":\"array()\"},\"common\":{\"dbtable\":\"#__ucm_content\",\"key\":\"ucm_id\",\"type\":\"Corecontent\",\"prefix\":\"Joomla\\\\CMS\\\\Table\\\\\",\"config\":\"array()\"}}', '', '{\"common\":{\"core_content_item_id\":\"id\",\"core_title\":\"name\",\"core_state\":\"published\",\"core_alias\":\"alias\",\"core_created_time\":\"created\",\"core_modified_time\":\"modified\",\"core_body\":\"address\", \"core_hits\":\"hits\",\"core_publish_up\":\"publish_up\",\"core_publish_down\":\"publish_down\",\"core_access\":\"access\", \"core_params\":\"params\", \"core_featured\":\"featured\", \"core_metadata\":\"metadata\", \"core_language\":\"language\", \"core_images\":\"image\", \"core_urls\":\"webpage\", \"core_version\":\"version\", \"core_ordering\":\"ordering\", \"core_metakey\":\"metakey\", \"core_metadesc\":\"metadesc\", \"core_catid\":\"catid\", \"core_xreference\":\"xreference\", \"asset_id\":\"null\"}, \"special\":{\"con_position\":\"con_position\",\"suburb\":\"suburb\",\"state\":\"state\",\"country\":\"country\",\"postcode\":\"postcode\",\"telephone\":\"telephone\",\"fax\":\"fax\",\"misc\":\"misc\",\"email_to\":\"email_to\",\"default_con\":\"default_con\",\"user_id\":\"user_id\",\"mobile\":\"mobile\",\"sortname1\":\"sortname1\",\"sortname2\":\"sortname2\",\"sortname3\":\"sortname3\"}}', 'ContactHelperRoute::getContactRoute', '{\"formFile\": \"administrator/components/com_contact/models/forms/contact.xml\", \"hideFields\": [\"default_con\", \"checked_out\", \"checked_out_time\", \"version\", \"xreference\"], \"convertToInt\": [\"publish_up\", \"publish_down\", \"featured\", \"ordering\"], \"displayLookup\": [{\"targetTable\": \"#__users\", \"sourceColumn\": \"created_by\", \"targetColumn\": \"id\", \"displayColumn\": \"name\"}, {\"targetTable\": \"#__categories\", \"sourceColumn\": \"catid\", \"targetColumn\": \"id\", \"displayColumn\": \"title\"}, {\"targetTable\": \"#__users\", \"sourceColumn\": \"modified_by\", \"targetColumn\": \"id\", \"displayColumn\": \"name\"}, {\"targetTable\": \"#__viewlevels\", \"sourceColumn\": \"access\", \"targetColumn\": \"id\", \"displayColumn\": \"title\"}, {\"targetTable\": \"#__users\", \"sourceColumn\": \"user_id\", \"targetColumn\": \"id\", \"displayColumn\": \"name\"}, {\"targetTable\": \"#__tags\", \"sourceColumn\": \"tags\", \"targetColumn\": \"id\", \"displayColumn\": \"title\"}], \"ignoreChanges\": [\"modified_by\", \"modified\", \"checked_out\", \"checked_out_time\", \"version\", \"hits\", \"ordering\"]}'),
('3', 'Newsfeed', 'com_newsfeeds.newsfeed', '{\"special\":{\"dbtable\":\"#__newsfeeds\",\"key\":\"id\",\"type\":\"NewsfeedTable\",\"prefix\":\"Joomla\\\\Component\\\\Newsfeeds\\\\Administrator\\\\Table\\\\\",\"config\":\"array()\"},\"common\":{\"dbtable\":\"#__ucm_content\",\"key\":\"ucm_id\",\"type\":\"Corecontent\",\"prefix\":\"Joomla\\\\CMS\\\\Table\\\\\",\"config\":\"array()\"}}', '', '{\"common\":{\"core_content_item_id\":\"id\",\"core_title\":\"name\",\"core_state\":\"published\",\"core_alias\":\"alias\",\"core_created_time\":\"created\",\"core_modified_time\":\"modified\",\"core_body\":\"description\", \"core_hits\":\"hits\",\"core_publish_up\":\"publish_up\",\"core_publish_down\":\"publish_down\",\"core_access\":\"access\", \"core_params\":\"params\", \"core_featured\":\"featured\", \"core_metadata\":\"metadata\", \"core_language\":\"language\", \"core_images\":\"images\", \"core_urls\":\"link\", \"core_version\":\"version\", \"core_ordering\":\"ordering\", \"core_metakey\":\"metakey\", \"core_metadesc\":\"metadesc\", \"core_catid\":\"catid\", \"core_xreference\":\"xreference\", \"asset_id\":\"null\"}, \"special\":{\"numarticles\":\"numarticles\",\"cache_time\":\"cache_time\",\"rtl\":\"rtl\"}}', 'NewsfeedsHelperRoute::getNewsfeedRoute', '{\"formFile\": \"administrator/components/com_newsfeeds/models/forms/newsfeed.xml\", \"hideFields\": [\"asset_id\", \"checked_out\", \"checked_out_time\", \"version\"], \"convertToInt\": [\"publish_up\", \"publish_down\", \"featured\", \"ordering\"], \"displayLookup\": [{\"targetTable\": \"#__categories\", \"sourceColumn\": \"catid\", \"targetColumn\": \"id\", \"displayColumn\": \"title\"}, {\"targetTable\": \"#__users\", \"sourceColumn\": \"created_by\", \"targetColumn\": \"id\", \"displayColumn\": \"name\"}, {\"targetTable\": \"#__viewlevels\", \"sourceColumn\": \"access\", \"targetColumn\": \"id\", \"displayColumn\": \"title\"}, {\"targetTable\": \"#__users\", \"sourceColumn\": \"modified_by\", \"targetColumn\": \"id\", \"displayColumn\": \"name\"}, {\"targetTable\": \"#__tags\", \"sourceColumn\": \"tags\", \"targetColumn\": \"id\", \"displayColumn\": \"title\"}], \"ignoreChanges\": [\"modified_by\", \"modified\", \"checked_out\", \"checked_out_time\", \"version\", \"hits\", \"ordering\"]}'),
('4', 'User', 'com_users.user', '{\"special\":{\"dbtable\":\"#__users\",\"key\":\"id\",\"type\":\"UserTable\",\"prefix\":\"Joomla\\\\Component\\\\Users\\\\Administrator\\\\Table\\\\\",\"config\":\"array()\"},\"common\":{\"dbtable\":\"#__ucm_content\",\"key\":\"ucm_id\",\"type\":\"Corecontent\",\"prefix\":\"Joomla\\\\CMS\\\\Table\\\\\",\"config\":\"array()\"}}', '', '{\"common\":{\"core_content_item_id\":\"id\",\"core_title\":\"name\",\"core_state\":\"null\",\"core_alias\":\"username\",\"core_created_time\":\"registerDate\",\"core_modified_time\":\"null\",\"core_body\":\"null\", \"core_hits\":\"null\",\"core_publish_up\":\"null\",\"core_publish_down\":\"null\",\"access\":\"null\", \"core_params\":\"params\", \"core_featured\":\"null\", \"core_metadata\":\"null\", \"core_language\":\"null\", \"core_images\":\"null\", \"core_urls\":\"null\", \"core_version\":\"null\", \"core_ordering\":\"null\", \"core_metakey\":\"null\", \"core_metadesc\":\"null\", \"core_catid\":\"null\", \"core_xreference\":\"null\", \"asset_id\":\"null\"}, \"special\":{}}', '', ''),
('5', 'Article Category', 'com_content.category', '{\"special\":{\"dbtable\":\"#__categories\",\"key\":\"id\",\"type\":\"Category\",\"prefix\":\"Joomla\\\\CMS\\\\Table\\\\\",\"config\":\"array()\"},\"common\":{\"dbtable\":\"#__ucm_content\",\"key\":\"ucm_id\",\"type\":\"Corecontent\",\"prefix\":\"Joomla\\\\CMS\\\\Table\\\\\",\"config\":\"array()\"}}', '', '{\"common\":{\"core_content_item_id\":\"id\",\"core_title\":\"title\",\"core_state\":\"published\",\"core_alias\":\"alias\",\"core_created_time\":\"created_time\",\"core_modified_time\":\"modified_time\",\"core_body\":\"description\", \"core_hits\":\"hits\",\"core_publish_up\":\"null\",\"core_publish_down\":\"null\",\"core_access\":\"access\", \"core_params\":\"params\", \"core_featured\":\"null\", \"core_metadata\":\"metadata\", \"core_language\":\"language\", \"core_images\":\"null\", \"core_urls\":\"null\", \"core_version\":\"version\", \"core_ordering\":\"null\", \"core_metakey\":\"metakey\", \"core_metadesc\":\"metadesc\", \"core_catid\":\"parent_id\", \"core_xreference\":\"null\", \"asset_id\":\"asset_id\"}, \"special\":{\"parent_id\":\"parent_id\",\"lft\":\"lft\",\"rgt\":\"rgt\",\"level\":\"level\",\"path\":\"path\",\"extension\":\"extension\",\"note\":\"note\"}}', 'ContentHelperRoute::getCategoryRoute', '{\"formFile\": \"administrator/components/com_categories/models/forms/category.xml\", \"hideFields\": [\"asset_id\", \"checked_out\", \"checked_out_time\", \"version\", \"lft\", \"rgt\", \"level\", \"path\", \"extension\"], \"convertToInt\": [\"publish_up\", \"publish_down\"], \"displayLookup\": [{\"targetTable\": \"#__users\", \"sourceColumn\": \"created_user_id\", \"targetColumn\": \"id\", \"displayColumn\": \"name\"}, {\"targetTable\": \"#__viewlevels\", \"sourceColumn\": \"access\", \"targetColumn\": \"id\", \"displayColumn\": \"title\"}, {\"targetTable\": \"#__users\", \"sourceColumn\": \"modified_user_id\", \"targetColumn\": \"id\", \"displayColumn\": \"name\"}, {\"targetTable\": \"#__categories\", \"sourceColumn\": \"parent_id\", \"targetColumn\": \"id\", \"displayColumn\": \"title\"}, {\"targetTable\": \"#__tags\", \"sourceColumn\": \"tags\", \"targetColumn\": \"id\", \"displayColumn\": \"title\"}], \"ignoreChanges\": [\"modified_user_id\", \"modified_time\", \"checked_out\", \"checked_out_time\", \"version\", \"hits\", \"path\"]}'),
('6', 'Contact Category', 'com_contact.category', '{\"special\":{\"dbtable\":\"#__categories\",\"key\":\"id\",\"type\":\"Category\",\"prefix\":\"Joomla\\\\CMS\\\\Table\\\\\",\"config\":\"array()\"},\"common\":{\"dbtable\":\"#__ucm_content\",\"key\":\"ucm_id\",\"type\":\"Corecontent\",\"prefix\":\"Joomla\\\\CMS\\\\Table\\\\\",\"config\":\"array()\"}}', '', '{\"common\":{\"core_content_item_id\":\"id\",\"core_title\":\"title\",\"core_state\":\"published\",\"core_alias\":\"alias\",\"core_created_time\":\"created_time\",\"core_modified_time\":\"modified_time\",\"core_body\":\"description\", \"core_hits\":\"hits\",\"core_publish_up\":\"null\",\"core_publish_down\":\"null\",\"core_access\":\"access\", \"core_params\":\"params\", \"core_featured\":\"null\", \"core_metadata\":\"metadata\", \"core_language\":\"language\", \"core_images\":\"null\", \"core_urls\":\"null\", \"core_version\":\"version\", \"core_ordering\":\"null\", \"core_metakey\":\"metakey\", \"core_metadesc\":\"metadesc\", \"core_catid\":\"parent_id\", \"core_xreference\":\"null\", \"asset_id\":\"asset_id\"}, \"special\":{\"parent_id\":\"parent_id\",\"lft\":\"lft\",\"rgt\":\"rgt\",\"level\":\"level\",\"path\":\"path\",\"extension\":\"extension\",\"note\":\"note\"}}', 'ContactHelperRoute::getCategoryRoute', '{\"formFile\": \"administrator/components/com_categories/models/forms/category.xml\", \"hideFields\": [\"asset_id\", \"checked_out\", \"checked_out_time\", \"version\", \"lft\", \"rgt\", \"level\", \"path\", \"extension\"], \"convertToInt\": [\"publish_up\", \"publish_down\"], \"displayLookup\": [{\"targetTable\": \"#__users\", \"sourceColumn\": \"created_user_id\", \"targetColumn\": \"id\", \"displayColumn\": \"name\"}, {\"targetTable\": \"#__viewlevels\", \"sourceColumn\": \"access\", \"targetColumn\": \"id\", \"displayColumn\": \"title\"}, {\"targetTable\": \"#__users\", \"sourceColumn\": \"modified_user_id\", \"targetColumn\": \"id\", \"displayColumn\": \"name\"}, {\"targetTable\": \"#__categories\", \"sourceColumn\": \"parent_id\", \"targetColumn\": \"id\", \"displayColumn\": \"title\"}, {\"targetTable\": \"#__tags\", \"sourceColumn\": \"tags\", \"targetColumn\": \"id\", \"displayColumn\": \"title\"}], \"ignoreChanges\": [\"modified_user_id\", \"modified_time\", \"checked_out\", \"checked_out_time\", \"version\", \"hits\", \"path\"]}'),
('7', 'Newsfeeds Category', 'com_newsfeeds.category', '{\"special\":{\"dbtable\":\"#__categories\",\"key\":\"id\",\"type\":\"Category\",\"prefix\":\"Joomla\\\\CMS\\\\Table\\\\\",\"config\":\"array()\"},\"common\":{\"dbtable\":\"#__ucm_content\",\"key\":\"ucm_id\",\"type\":\"Corecontent\",\"prefix\":\"Joomla\\\\CMS\\\\Table\\\\\",\"config\":\"array()\"}}', '', '{\"common\":{\"core_content_item_id\":\"id\",\"core_title\":\"title\",\"core_state\":\"published\",\"core_alias\":\"alias\",\"core_created_time\":\"created_time\",\"core_modified_time\":\"modified_time\",\"core_body\":\"description\", \"core_hits\":\"hits\",\"core_publish_up\":\"null\",\"core_publish_down\":\"null\",\"core_access\":\"access\", \"core_params\":\"params\", \"core_featured\":\"null\", \"core_metadata\":\"metadata\", \"core_language\":\"language\", \"core_images\":\"null\", \"core_urls\":\"null\", \"core_version\":\"version\", \"core_ordering\":\"null\", \"core_metakey\":\"metakey\", \"core_metadesc\":\"metadesc\", \"core_catid\":\"parent_id\", \"core_xreference\":\"null\", \"asset_id\":\"asset_id\"}, \"special\":{\"parent_id\":\"parent_id\",\"lft\":\"lft\",\"rgt\":\"rgt\",\"level\":\"level\",\"path\":\"path\",\"extension\":\"extension\",\"note\":\"note\"}}', 'NewsfeedsHelperRoute::getCategoryRoute', '{\"formFile\": \"administrator/components/com_categories/models/forms/category.xml\", \"hideFields\": [\"asset_id\", \"checked_out\", \"checked_out_time\", \"version\", \"lft\", \"rgt\", \"level\", \"path\", \"extension\"], \"convertToInt\": [\"publish_up\", \"publish_down\"], \"displayLookup\": [{\"targetTable\": \"#__users\", \"sourceColumn\": \"created_user_id\", \"targetColumn\": \"id\", \"displayColumn\": \"name\"}, {\"targetTable\": \"#__viewlevels\", \"sourceColumn\": \"access\", \"targetColumn\": \"id\", \"displayColumn\": \"title\"}, {\"targetTable\": \"#__users\", \"sourceColumn\": \"modified_user_id\", \"targetColumn\": \"id\", \"displayColumn\": \"name\"}, {\"targetTable\": \"#__categories\", \"sourceColumn\": \"parent_id\", \"targetColumn\": \"id\", \"displayColumn\": \"title\"}, {\"targetTable\": \"#__tags\", \"sourceColumn\": \"tags\", \"targetColumn\": \"id\", \"displayColumn\": \"title\"}], \"ignoreChanges\": [\"modified_user_id\", \"modified_time\", \"checked_out\", \"checked_out_time\", \"version\", \"hits\", \"path\"]}'),
('8', 'Tag', 'com_tags.tag', '{\"special\":{\"dbtable\":\"#__tags\",\"key\":\"tag_id\",\"type\":\"TagTable\",\"prefix\":\"Joomla\\\\Component\\\\Tags\\\\Administrator\\\\Table\\\\\",\"config\":\"array()\"},\"common\":{\"dbtable\":\"#__ucm_content\",\"key\":\"ucm_id\",\"type\":\"Corecontent\",\"prefix\":\"Joomla\\\\CMS\\\\Table\\\\\",\"config\":\"array()\"}}', '', '{\"common\":{\"core_content_item_id\":\"id\",\"core_title\":\"title\",\"core_state\":\"published\",\"core_alias\":\"alias\",\"core_created_time\":\"created_time\",\"core_modified_time\":\"modified_time\",\"core_body\":\"description\", \"core_hits\":\"hits\",\"core_publish_up\":\"null\",\"core_publish_down\":\"null\",\"core_access\":\"access\", \"core_params\":\"params\", \"core_featured\":\"featured\", \"core_metadata\":\"metadata\", \"core_language\":\"language\", \"core_images\":\"images\", \"core_urls\":\"urls\", \"core_version\":\"version\", \"core_ordering\":\"null\", \"core_metakey\":\"metakey\", \"core_metadesc\":\"metadesc\", \"core_catid\":\"null\", \"core_xreference\":\"null\", \"asset_id\":\"null\"}, \"special\":{\"parent_id\":\"parent_id\",\"lft\":\"lft\",\"rgt\":\"rgt\",\"level\":\"level\",\"path\":\"path\"}}', 'TagsHelperRoute::getTagRoute', '{\"formFile\":\"administrator\\/components\\/com_tags\\/models\\/forms\\/tag.xml\", \"hideFields\":[\"checked_out\",\"checked_out_time\",\"version\", \"lft\", \"rgt\", \"level\", \"path\", \"urls\", \"publish_up\", \"publish_down\"],\"ignoreChanges\":[\"modified_user_id\", \"modified_time\", \"checked_out\", \"checked_out_time\", \"version\", \"hits\", \"path\"],\"convertToInt\":[\"publish_up\", \"publish_down\"], \"displayLookup\":[{\"sourceColumn\":\"created_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"}, {\"sourceColumn\":\"access\",\"targetTable\":\"#__viewlevels\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"}, {\"sourceColumn\":\"modified_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"}]}'),
('9', 'Banner', 'com_banners.banner', '{\"special\":{\"dbtable\":\"#__banners\",\"key\":\"id\",\"type\":\"BannerTable\",\"prefix\":\"Joomla\\\\Component\\\\Banners\\\\Administrator\\\\Table\\\\\",\"config\":\"array()\"},\"common\":{\"dbtable\":\"#__ucm_content\",\"key\":\"ucm_id\",\"type\":\"Corecontent\",\"prefix\":\"Joomla\\\\CMS\\\\Table\\\\\",\"config\":\"array()\"}}', '', '{\"common\":{\"core_content_item_id\":\"id\",\"core_title\":\"name\",\"core_state\":\"published\",\"core_alias\":\"alias\",\"core_created_time\":\"created\",\"core_modified_time\":\"modified\",\"core_body\":\"description\", \"core_hits\":\"null\",\"core_publish_up\":\"publish_up\",\"core_publish_down\":\"publish_down\",\"core_access\":\"access\", \"core_params\":\"params\", \"core_featured\":\"null\", \"core_metadata\":\"metadata\", \"core_language\":\"language\", \"core_images\":\"images\", \"core_urls\":\"link\", \"core_version\":\"version\", \"core_ordering\":\"ordering\", \"core_metakey\":\"metakey\", \"core_metadesc\":\"metadesc\", \"core_catid\":\"catid\", \"core_xreference\":\"null\", \"asset_id\":\"null\"}, \"special\":{\"imptotal\":\"imptotal\", \"impmade\":\"impmade\", \"clicks\":\"clicks\", \"clickurl\":\"clickurl\", \"custombannercode\":\"custombannercode\", \"cid\":\"cid\", \"purchase_type\":\"purchase_type\", \"track_impressions\":\"track_impressions\", \"track_clicks\":\"track_clicks\"}}', '', '{\"formFile\":\"administrator\\/components\\/com_banners\\/models\\/forms\\/banner.xml\", \"hideFields\":[\"checked_out\",\"checked_out_time\",\"version\", \"reset\"],\"ignoreChanges\":[\"modified_by\", \"modified\", \"checked_out\", \"checked_out_time\", \"version\", \"imptotal\", \"impmade\", \"reset\"], \"convertToInt\":[\"publish_up\", \"publish_down\", \"ordering\"], \"displayLookup\":[{\"sourceColumn\":\"catid\",\"targetTable\":\"#__categories\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"}, {\"sourceColumn\":\"cid\",\"targetTable\":\"#__banner_clients\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"}, {\"sourceColumn\":\"created_by\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"modified_by\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"} ]}'),
('10', 'Banners Category', 'com_banners.category', '{\"special\":{\"dbtable\":\"#__categories\",\"key\":\"id\",\"type\":\"Category\",\"prefix\":\"Joomla\\\\CMS\\\\Table\\\\\",\"config\":\"array()\"},\"common\":{\"dbtable\":\"#__ucm_content\",\"key\":\"ucm_id\",\"type\":\"Corecontent\",\"prefix\":\"Joomla\\\\CMS\\\\Table\\\\\",\"config\":\"array()\"}}', '', '{\"common\":{\"core_content_item_id\":\"id\",\"core_title\":\"title\",\"core_state\":\"published\",\"core_alias\":\"alias\",\"core_created_time\":\"created_time\",\"core_modified_time\":\"modified_time\",\"core_body\":\"description\", \"core_hits\":\"hits\",\"core_publish_up\":\"null\",\"core_publish_down\":\"null\",\"core_access\":\"access\", \"core_params\":\"params\", \"core_featured\":\"null\", \"core_metadata\":\"metadata\", \"core_language\":\"language\", \"core_images\":\"null\", \"core_urls\":\"null\", \"core_version\":\"version\", \"core_ordering\":\"null\", \"core_metakey\":\"metakey\", \"core_metadesc\":\"metadesc\", \"core_catid\":\"parent_id\", \"core_xreference\":\"null\", \"asset_id\":\"asset_id\"}, \"special\": {\"parent_id\":\"parent_id\",\"lft\":\"lft\",\"rgt\":\"rgt\",\"level\":\"level\",\"path\":\"path\",\"extension\":\"extension\",\"note\":\"note\"}}', '', '{\"formFile\": \"administrator/components/com_categories/models/forms/category.xml\", \"hideFields\": [\"asset_id\", \"checked_out\", \"checked_out_time\", \"version\", \"lft\", \"rgt\", \"level\", \"path\", \"extension\"], \"convertToInt\": [\"publish_up\", \"publish_down\"], \"displayLookup\": [{\"targetTable\": \"#__users\", \"sourceColumn\": \"created_user_id\", \"targetColumn\": \"id\", \"displayColumn\": \"name\"}, {\"targetTable\": \"#__viewlevels\", \"sourceColumn\": \"access\", \"targetColumn\": \"id\", \"displayColumn\": \"title\"}, {\"targetTable\": \"#__users\", \"sourceColumn\": \"modified_user_id\", \"targetColumn\": \"id\", \"displayColumn\": \"name\"}, {\"targetTable\": \"#__categories\", \"sourceColumn\": \"parent_id\", \"targetColumn\": \"id\", \"displayColumn\": \"title\"}, {\"targetTable\": \"#__tags\", \"sourceColumn\": \"tags\", \"targetColumn\": \"id\", \"displayColumn\": \"title\"}], \"ignoreChanges\": [\"modified_user_id\", \"modified_time\", \"checked_out\", \"checked_out_time\", \"version\", \"hits\", \"path\"]}'),
('11', 'Banner Client', 'com_banners.client', '{\"special\":{\"dbtable\":\"#__banner_clients\",\"key\":\"id\",\"type\":\"ClientTable\",\"prefix\":\"Joomla\\\\Component\\\\Banners\\\\Administrator\\\\Table\\\\\"}}', '', '', '', '{\"formFile\":\"administrator\\/components\\/com_banners\\/models\\/forms\\/client.xml\", \"hideFields\":[\"checked_out\",\"checked_out_time\"], \"ignoreChanges\":[\"checked_out\", \"checked_out_time\"], \"convertToInt\":[], \"displayLookup\":[]}'),
('12', 'User Notes', 'com_users.note', '{\"special\":{\"dbtable\":\"#__user_notes\",\"key\":\"id\",\"type\":\"NoteTable\",\"prefix\":\"Joomla\\\\Component\\\\Users\\\\Administrator\\\\Table\\\\\"}}', '', '', '', '{\"formFile\":\"administrator\\/components\\/com_users\\/models\\/forms\\/note.xml\", \"hideFields\":[\"checked_out\",\"checked_out_time\", \"publish_up\", \"publish_down\"],\"ignoreChanges\":[\"modified_user_id\", \"modified_time\", \"checked_out\", \"checked_out_time\"], \"convertToInt\":[\"publish_up\", \"publish_down\"],\"displayLookup\":[{\"sourceColumn\":\"catid\",\"targetTable\":\"#__categories\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"}, {\"sourceColumn\":\"created_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"}, {\"sourceColumn\":\"user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"}, {\"sourceColumn\":\"modified_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"}]}'),
('13', 'User Notes Category', 'com_users.category', '{\"special\":{\"dbtable\":\"#__categories\",\"key\":\"id\",\"type\":\"Category\",\"prefix\":\"Joomla\\\\CMS\\\\Table\\\\\",\"config\":\"array()\"},\"common\":{\"dbtable\":\"#__ucm_content\",\"key\":\"ucm_id\",\"type\":\"Corecontent\",\"prefix\":\"Joomla\\\\CMS\\\\Table\\\\\",\"config\":\"array()\"}}', '', '{\"common\":{\"core_content_item_id\":\"id\",\"core_title\":\"title\",\"core_state\":\"published\",\"core_alias\":\"alias\",\"core_created_time\":\"created_time\",\"core_modified_time\":\"modified_time\",\"core_body\":\"description\", \"core_hits\":\"hits\",\"core_publish_up\":\"null\",\"core_publish_down\":\"null\",\"core_access\":\"access\", \"core_params\":\"params\", \"core_featured\":\"null\", \"core_metadata\":\"metadata\", \"core_language\":\"language\", \"core_images\":\"null\", \"core_urls\":\"null\", \"core_version\":\"version\", \"core_ordering\":\"null\", \"core_metakey\":\"metakey\", \"core_metadesc\":\"metadesc\", \"core_catid\":\"parent_id\", \"core_xreference\":\"null\", \"asset_id\":\"asset_id\"}, \"special\":{\"parent_id\":\"parent_id\",\"lft\":\"lft\",\"rgt\":\"rgt\",\"level\":\"level\",\"path\":\"path\",\"extension\":\"extension\",\"note\":\"note\"}}', '', '{\"formFile\": \"administrator/components/com_categories/models/forms/category.xml\", \"hideFields\": [\"checked_out\", \"checked_out_time\", \"version\", \"lft\", \"rgt\", \"level\", \"path\", \"extension\"], \"convertToInt\": [\"publish_up\", \"publish_down\"], \"displayLookup\": [{\"targetTable\": \"#__users\", \"sourceColumn\": \"created_user_id\", \"targetColumn\": \"id\", \"displayColumn\": \"name\"}, {\"targetTable\": \"#__viewlevels\", \"sourceColumn\": \"access\", \"targetColumn\": \"id\", \"displayColumn\": \"title\"}, {\"targetTable\": \"#__users\", \"sourceColumn\": \"modified_user_id\", \"targetColumn\": \"id\", \"displayColumn\": \"name\"}, {\"targetTable\": \"#__categories\", \"sourceColumn\": \"parent_id\", \"targetColumn\": \"id\", \"displayColumn\": \"title\"}, {\"targetTable\": \"#__tags\", \"sourceColumn\": \"tags\", \"targetColumn\": \"id\", \"displayColumn\": \"title\"}], \"ignoreChanges\": [\"modified_user_id\", \"modified_time\", \"checked_out\", \"checked_out_time\", \"version\", \"hits\", \"path\"]}');
/**ABDB**/CREATE TABLE `#__contentitem_tag_map` (
  `type_alias` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `core_content_id` int unsigned NOT NULL COMMENT 'PK from the core content table',
  `content_item_id` int NOT NULL COMMENT 'PK from the content type table',
  `tag_id` int unsigned NOT NULL COMMENT 'PK from the tag table',
  `tag_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT 'Date of most recent save for this tag-item',
  `type_id` mediumint NOT NULL COMMENT 'PK from the content_type table',
  UNIQUE KEY `uc_ItemnameTagid` (`type_id`,`content_item_id`,`tag_id`),
  KEY `idx_tag_type` (`tag_id`,`type_id`),
  KEY `idx_date_id` (`tag_date`,`tag_id`),
  KEY `idx_core_content_id` (`core_content_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='Maps items from content tables to tags';
/**ABDB**/CREATE TABLE `#__convertforms` (
  `id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `state` tinyint NOT NULL DEFAULT '0',
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `ordering` int NOT NULL DEFAULT '0',
  `params` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__convertforms`  VALUES 
('1', 'Newsletter', '1', '2022-03-06 07:45:08', '0', '{\"fields\":{\"fields0\":{\"key\":\"0\",\"type\":\"email\",\"name\":\"email\",\"label\":\"Enter your email\",\"description\":\"\",\"required\":\"1\",\"dnscheck\":\"0\",\"size\":\"\",\"value\":\"\",\"placeholder\":\"Enter your email\",\"cssclass\":\"cf-two-thirds\",\"inputcssclass\":\"\",\"hidelabel\":\"1\",\"browserautocomplete\":\"0\",\"readonly\":\"0\"},\"fields1\":{\"key\":\"1\",\"type\":\"submit\",\"text\":\"Sign up\",\"align\":\"left\",\"fontsize\":\"14\",\"bg\":\"#0043ed\",\"textcolor\":\"#ffffff\",\"borderradius\":\"0\",\"vpadding\":\"11\",\"hpadding\":\"15\",\"size\":\"\",\"cssclass\":\"cf-one-third\",\"inputcssclass\":\"\"}},\"autowidth\":\"auto\",\"width\":\"600\",\"bgcolor\":\"rgba(255, 255, 255, 0)\",\"bgimage\":\"0\",\"bgurl\":\"\",\"bgfile\":\"\",\"bgrepeat\":\"repeat\",\"bgsize\":\"auto\",\"bgposition\":\"center top\",\"text\":\"\",\"font\":\"Arial\",\"padding\":\"0\",\"borderradius\":\"0\",\"borderstyle\":\"none\",\"bordercolor\":\"#f28395\",\"borderwidth\":\"10\",\"image\":\"0\",\"imageurl\":\"\",\"imagefile\":\"\",\"imgposition\":\"img-above\",\"imageautowidth\":\"auto\",\"imagewidth\":\"150\",\"imagesize\":\"5\",\"imagehposition\":\"0\",\"imagevposition\":\"0\",\"imagealt\":\"\",\"hideimageonmobile\":\"0\",\"formposition\":\"form-bottom\",\"formsize\":\"6\",\"formbgcolor\":\"rgba(255, 255, 255, 0)\",\"labelscolor\":\"#888888\",\"labelsfontsize\":\"13\",\"labelweight\":\"400\",\"labelposition\":\"top\",\"required_indication\":\"1\",\"inputfontsize\":\"14\",\"inputcolor\":\"#333333\",\"inputbg\":\"#eeeeee\",\"inputalign\":\"left\",\"inputbordercolor\":\"#ffffff\",\"inputborderradius\":\"0\",\"inputvpadding\":\"11\",\"inputhpadding\":\"20\",\"help_text_position\":\"after\",\"customcss\":\"\",\"customcode\":\"\",\"footer\":\"\",\"classsuffix\":\"nopaddingall mail-form\",\"honeypot\":\"1\",\"phpscripts\":{\"formprepare\":\"\",\"formdisplay\":\"\",\"formprocess\":\"\",\"afterformsubmission\":\"\"},\"sendnotifications\":\"0\",\"emails\":{\"emails0\":{\"recipient\":\"{site.email}\",\"subject\":\"New Submission #{submission.id}: Contact Form\",\"from_name\":\"{site.name}\",\"from_email\":\"{site.email}\",\"reply_to\":\"\",\"reply_to_name\":\"\",\"body\":\"{all_fields}\",\"attachments\":\"\"}},\"save_data_to_db\":\"1\",\"submission_state\":\"1\",\"campaign\":\"1\",\"onsuccess\":\"msg\",\"successmsg\":\"You\'ve successfully subscribed. Thank you!\",\"resetform\":\"1\",\"hideform\":\"1\",\"hidetext\":\"0\",\"successurl\":\"\",\"redirectmenu\":\"1242\",\"passdata\":\"\",\"enable_min_time_to_submit\":\"0\"}'),
('3', 'Contact form', '1', '2021-10-11 16:13:01', '0', '{\"fields\":{\"fields1\":{\"key\":\"1\",\"type\":\"text\",\"name\":\"name\",\"label\":\"Name\",\"description\":\"\",\"required\":\"0\",\"size\":\"\",\"value\":\"\",\"placeholder\":\"\",\"cssclass\":\"\",\"inputcssclass\":\"\",\"hidelabel\":\"0\",\"browserautocomplete\":\"0\",\"filter\":\"html\",\"inputmask\":{\"options\":\"\",\"custom\":\"\"},\"readonly\":\"0\",\"minchars\":\"0\",\"maxchars\":\"0\",\"minwords\":\"0\",\"maxwords\":\"0\"},\"fields0\":{\"key\":\"0\",\"type\":\"email\",\"name\":\"email\",\"label\":\"Email\",\"description\":\"\",\"required\":\"0\",\"dnscheck\":\"0\",\"size\":\"\",\"value\":\"\",\"placeholder\":\"\",\"cssclass\":\"cf-one-half\",\"inputcssclass\":\"\",\"hidelabel\":\"0\",\"browserautocomplete\":\"0\",\"readonly\":\"0\"},\"fields10\":{\"key\":\"10\",\"type\":\"tel\",\"name\":\"tel_10\",\"label\":\"Phone Number\",\"description\":\"\",\"required\":\"0\",\"size\":\"\",\"value\":\"\",\"placeholder\":\"+1 ( __ ) ____ - ____\",\"cssclass\":\"cf-one-half\",\"inputcssclass\":\"\",\"hidelabel\":\"0\",\"browserautocomplete\":\"0\",\"inputmask\":{\"options\":\"custom\",\"custom\":\"\"},\"readonly\":\"0\"},\"fields7\":{\"key\":\"7\",\"type\":\"text\",\"name\":\"text_7\",\"label\":\"Company Name\",\"description\":\"\",\"required\":\"0\",\"size\":\"\",\"value\":\"\",\"placeholder\":\"\",\"cssclass\":\"cf-one-half\",\"inputcssclass\":\"\",\"hidelabel\":\"0\",\"browserautocomplete\":\"0\",\"filter\":\"html\",\"inputmask\":{\"options\":\"\",\"custom\":\"\"},\"readonly\":\"0\",\"minchars\":\"0\",\"maxchars\":\"0\",\"minwords\":\"0\",\"maxwords\":\"0\"},\"fields8\":{\"key\":\"8\",\"type\":\"url\",\"name\":\"url_8\",\"label\":\"Website \\/ URL\",\"description\":\"\",\"required\":\"0\",\"size\":\"\",\"value\":\"\",\"placeholder\":\"http:\\/\\/www.example.com\",\"cssclass\":\"cf-one-half\",\"inputcssclass\":\"\",\"hidelabel\":\"0\",\"browserautocomplete\":\"0\",\"readonly\":\"0\"},\"fields9\":{\"key\":\"9\",\"type\":\"textarea\",\"name\":\"textarea_9\",\"label\":\"Message\",\"description\":\"\",\"required\":\"0\",\"textareaheight\":\"3\",\"size\":\"\",\"value\":\"\",\"placeholder\":\"Tell us more about your needs...\",\"cssclass\":\"\",\"inputcssclass\":\"\",\"hidelabel\":\"0\",\"browserautocomplete\":\"0\",\"filter\":\"html\",\"readonly\":\"0\",\"minchars\":\"0\",\"maxchars\":\"0\",\"minwords\":\"0\",\"maxwords\":\"0\"},\"fields2\":{\"key\":\"2\",\"type\":\"submit\",\"text\":\"Submit\",\"align\":\"left\",\"fontsize\":\"15\",\"bg\":\"#153fd6\",\"textcolor\":\"#ffffff\",\"borderradius\":\"0\",\"vpadding\":\"15\",\"hpadding\":\"25\",\"size\":\"cf-width-auto\",\"cssclass\":\"\",\"inputcssclass\":\"\"}},\"autowidth\":\"auto\",\"width\":\"800\",\"bgcolor\":\"rgba(255, 255, 255, 1)\",\"bgimage\":\"0\",\"bgurl\":\"\",\"bgfile\":\"\",\"bgrepeat\":\"no-repeat\",\"bgsize\":\"auto\",\"bgposition\":\"left top\",\"text\":\"<h3 class=\\\"jl-h5 jl-margin-remove-bottom jl-text-uppercase\\\">Get in touch<\\/h3>\\r\\n<div class=\\\"pre-heading-line jl-margin-remove-top\\\">\\u00a0<\\/div>\",\"font\":\"Arial\",\"padding\":\"0\",\"borderradius\":\"0\",\"borderstyle\":\"none\",\"bordercolor\":\"\",\"borderwidth\":\"2\",\"image\":\"0\",\"imageurl\":\"\",\"imagefile\":\"\",\"imgposition\":\"img-above\",\"imageautowidth\":\"auto\",\"imagewidth\":\"200\",\"imagesize\":\"6\",\"imagehposition\":\"0\",\"imagevposition\":\"0\",\"imagealt\":\"\",\"hideimageonmobile\":\"0\",\"formposition\":\"form-bottom\",\"formsize\":\"16\",\"formbgcolor\":\"rgba(255, 255, 255, 1)\",\"labelscolor\":\"#161616\",\"labelsfontsize\":\"15\",\"labelweight\":\"400\",\"labelposition\":\"top\",\"required_indication\":\"1\",\"inputfontsize\":\"15\",\"inputcolor\":\"#666666\",\"inputbg\":\"#ffffff\",\"inputalign\":\"left\",\"inputbordercolor\":\"#69727d\",\"inputborderradius\":\"0\",\"inputvpadding\":\"12\",\"inputhpadding\":\"10\",\"help_text_position\":\"after\",\"customcss\":\"\",\"customcode\":\"\",\"footer\":\"\",\"classsuffix\":\"line-heading left\",\"honeypot\":\"1\",\"enable_min_time_to_submit\":\"0\",\"min_time_to_submit\":\"2\",\"phpscripts\":{\"formprepare\":\"\",\"formdisplay\":\"\",\"formprocess\":\"\",\"afterformsubmission\":\"\"},\"sendnotifications\":\"0\",\"emails\":{\"emails0\":{\"recipient\":\"{site.email}\",\"subject\":\"New Submission #{submission.id}: Contact Form\",\"from_name\":\"{site.name}\",\"from_email\":\"{site.email}\",\"reply_to\":\"\",\"reply_to_name\":\"\",\"body\":\"<p>{all_fields}<\\/p>\",\"attachments\":\"\"}},\"save_data_to_db\":\"1\",\"submission_state\":\"1\",\"campaign\":\"1\",\"onsuccess\":\"msg\",\"successmsg\":\"<p>Thanks for contacting us! We will get in touch with you shortly.<\\/p>\",\"resetform\":\"1\",\"hideform\":\"1\",\"hidetext\":\"0\",\"successurl\":\"\",\"redirectmenu\":\"1242\",\"passdata\":\"\"}');
/**ABDB**/CREATE TABLE `#__convertforms_campaigns` (
  `id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `state` tinyint NOT NULL DEFAULT '0',
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `ordering` int NOT NULL DEFAULT '0',
  `service` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `params` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__convertforms_campaigns`  VALUES 
('1', 'Demo Campaign', '1', '0000-00-00 00:00:00', '0', '0', NULL);
/**ABDB**/CREATE TABLE `#__convertforms_connections` (
  `id` int NOT NULL AUTO_INCREMENT,
  `app` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created` datetime NOT NULL,
  `title` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `params` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/CREATE TABLE `#__convertforms_conversions` (
  `id` int NOT NULL AUTO_INCREMENT,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `campaign_id` int NOT NULL,
  `form_id` int NOT NULL,
  `visitor_id` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user_id` int NOT NULL DEFAULT '0',
  `params` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `state` tinyint NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `state` (`state`),
  KEY `created` (`created`),
  KEY `form_id` (`form_id`),
  KEY `campaign_id` (`campaign_id`),
  KEY `user_id` (`user_id`),
  KEY `state_created` (`state`,`created`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/CREATE TABLE `#__convertforms_submission_meta` (
  `id` int NOT NULL AUTO_INCREMENT,
  `submission_id` int NOT NULL,
  `meta_type` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `meta_key` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `meta_value` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `params` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`),
  KEY `date_created` (`date_created`),
  KEY `submission_id` (`submission_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/CREATE TABLE `#__convertforms_tasks` (
  `id` mediumint NOT NULL AUTO_INCREMENT,
  `form_id` mediumint NOT NULL,
  `title` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `state` tinyint NOT NULL DEFAULT '0',
  `action` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `app` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `trigger` varchar(100) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL,
  `connection_id` mediumint DEFAULT NULL,
  `options` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `conditions` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `silentfail` tinyint NOT NULL DEFAULT '0',
  `modified` datetime DEFAULT NULL,
  `created` datetime NOT NULL,
  `created_by` mediumint NOT NULL,
  `ordering` smallint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/CREATE TABLE `#__convertforms_tasks_history` (
  `id` int NOT NULL AUTO_INCREMENT,
  `created` datetime NOT NULL,
  `created_by` mediumint NOT NULL,
  `task_id` mediumint NOT NULL,
  `payload` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `success` tinyint(1) NOT NULL,
  `errors` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `execution_time` float DEFAULT NULL COMMENT 'The time the action took to finish in seconds',
  `ref_type` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT 'submission',
  `ref_id` int DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/CREATE TABLE `#__core_log_searches` (
  `search_term` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `hits` int unsigned NOT NULL DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/CREATE TABLE `#__extensions` (
  `extension_id` int NOT NULL AUTO_INCREMENT,
  `package_id` int NOT NULL DEFAULT '0' COMMENT 'Parent package ID for extensions installed as a package.',
  `name` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `type` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `element` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `changelogurl` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `folder` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `client_id` tinyint NOT NULL,
  `enabled` tinyint NOT NULL DEFAULT '0',
  `access` int unsigned DEFAULT NULL,
  `protected` tinyint NOT NULL DEFAULT '0' COMMENT 'Flag to indicate if the extension is protected. Protected extensions cannot be disabled.',
  `manifest_cache` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `params` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `custom_data` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `checked_out` int unsigned DEFAULT NULL,
  `checked_out_time` datetime DEFAULT NULL,
  `ordering` int DEFAULT '0',
  `state` int DEFAULT '0',
  `note` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `locked` tinyint NOT NULL DEFAULT '0' COMMENT 'Flag to indicate if the extension is locked. Locked extensions cannot be uninstalled.',
  PRIMARY KEY (`extension_id`),
  KEY `element_clientid` (`element`,`client_id`),
  KEY `element_folder_clientid` (`element`,`folder`,`client_id`),
  KEY `extension` (`type`,`element`,`folder`,`client_id`)
) ENGINE=InnoDB AUTO_INCREMENT=10448 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__extensions`  VALUES 
('2', '0', 'com_wrapper', 'component', 'com_wrapper', '', '', '1', '1', '1', '0', '{\"name\":\"com_wrapper\",\"type\":\"component\",\"creationDate\":\"2006-04\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2007 Open Source Matters, Inc.\\n\\t\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_WRAPPER_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Wrapper\",\"filename\":\"wrapper\"}', '', '', NULL, NULL, '0', '0', NULL, '1'),
('3', '0', 'com_admin', 'component', 'com_admin', '', '', '1', '1', '1', '1', '{\"name\":\"com_admin\",\"type\":\"component\",\"creationDate\":\"2006-04\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_ADMIN_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Admin\"}', '', '', NULL, NULL, '0', '0', NULL, '1'),
('4', '0', 'com_banners', 'component', 'com_banners', '', '', '1', '1', '1', '0', '{\"name\":\"com_banners\",\"type\":\"component\",\"creationDate\":\"2006-04\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_BANNERS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Banners\",\"filename\":\"banners\"}', '{\"purchase_type\":\"3\",\"track_impressions\":\"0\",\"track_clicks\":\"0\",\"metakey_prefix\":\"\"}', '', NULL, NULL, '0', '0', NULL, '1'),
('5', '0', 'com_cache', 'component', 'com_cache', '', '', '1', '1', '1', '1', '{\"name\":\"com_cache\",\"type\":\"component\",\"creationDate\":\"2006-04\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_CACHE_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Cache\"}', '', '', NULL, NULL, '0', '0', NULL, '1'),
('6', '0', 'com_categories', 'component', 'com_categories', '', '', '1', '1', '1', '1', '{\"name\":\"com_categories\",\"type\":\"component\",\"creationDate\":\"2007-12\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2007 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_CATEGORIES_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Categories\"}', '', '', NULL, NULL, '0', '0', NULL, '1'),
('7', '0', 'com_checkin', 'component', 'com_checkin', '', '', '1', '1', '1', '1', '{\"name\":\"com_checkin\",\"type\":\"component\",\"creationDate\":\"2006-04\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_CHECKIN_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Checkin\"}', '', '', NULL, NULL, '0', '0', NULL, '1'),
('8', '0', 'com_contact', 'component', 'com_contact', '', '', '1', '1', '1', '0', '{\"name\":\"com_contact\",\"type\":\"component\",\"creationDate\":\"2006-04\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_CONTACT_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Contact\",\"filename\":\"contact\"}', '{\"contact_layout\":\"jl_besto:grid\",\"show_contact_category\":\"hide\",\"save_history\":\"0\",\"history_limit\":10,\"show_contact_list\":\"0\",\"show_tags\":\"1\",\"show_info\":\"1\",\"show_name\":\"0\",\"show_position\":\"1\",\"show_email\":\"0\",\"add_mailto_link\":\"1\",\"show_street_address\":\"1\",\"show_suburb\":\"1\",\"show_state\":\"1\",\"show_postcode\":\"1\",\"show_country\":\"1\",\"show_telephone\":\"1\",\"show_mobile\":\"1\",\"show_fax\":\"1\",\"show_webpage\":\"1\",\"show_image\":\"1\",\"image\":\"\",\"show_misc\":\"1\",\"allow_vcard\":\"0\",\"show_articles\":\"0\",\"articles_display_num\":\"10\",\"show_profile\":\"0\",\"show_links\":\"0\",\"linka_name\":\"\",\"linkb_name\":\"\",\"linkc_name\":\"\",\"linkd_name\":\"\",\"linke_name\":\"\",\"contact_icons\":\"0\",\"icon_address\":\"\",\"icon_email\":\"\",\"icon_telephone\":\"\",\"icon_mobile\":\"\",\"icon_fax\":\"\",\"icon_webpage\":\"\",\"icon_misc\":\"\",\"category_layout\":\"_:default\",\"show_category_title\":\"1\",\"show_description\":\"1\",\"show_description_image\":\"0\",\"maxLevel\":\"-1\",\"show_no_contacts\":\"1\",\"show_category_heading_title_text\":\"1\",\"show_subcat_desc\":\"1\",\"show_empty_categories\":\"0\",\"show_cat_items\":\"1\",\"show_cat_tags\":\"1\",\"show_base_description\":\"1\",\"maxLevelcat\":\"-1\",\"show_subcat_desc_cat\":\"1\",\"show_empty_categories_cat\":\"0\",\"show_cat_items_cat\":\"1\",\"filter_field\":\"0\",\"show_pagination_limit\":\"1\",\"show_headings\":\"1\",\"show_image_heading\":\"0\",\"show_position_headings\":\"1\",\"show_email_headings\":\"0\",\"show_telephone_headings\":\"1\",\"show_mobile_headings\":\"0\",\"show_fax_headings\":\"0\",\"show_suburb_headings\":\"1\",\"show_state_headings\":\"1\",\"show_country_headings\":\"1\",\"show_pagination\":\"2\",\"show_pagination_results\":\"1\",\"contacts_display_num\":\"10\",\"initial_sort\":\"ordering\",\"captcha\":\"\",\"show_email_form\":\"1\",\"show_email_copy\":\"0\",\"banned_email\":\"\",\"banned_subject\":\"\",\"banned_text\":\"\",\"validate_session\":\"1\",\"custom_reply\":\"0\",\"redirect\":\"\",\"show_feed_link\":\"1\",\"sef_ids\":0,\"custom_fields_enable\":\"1\"}', '', NULL, NULL, '0', '0', NULL, '1'),
('9', '0', 'com_cpanel', 'component', 'com_cpanel', '', '', '1', '1', '1', '1', '{\"name\":\"com_cpanel\",\"type\":\"component\",\"creationDate\":\"2007-06\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2007 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_CPANEL_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Cpanel\"}', '', '', NULL, NULL, '0', '0', NULL, '1'),
('10', '0', 'com_installer', 'component', 'com_installer', '', '', '1', '1', '1', '1', '{\"name\":\"com_installer\",\"type\":\"component\",\"creationDate\":\"2006-04\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_INSTALLER_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Installer\"}', '{}', '', NULL, NULL, '0', '0', NULL, '1'),
('11', '0', 'com_languages', 'component', 'com_languages', '', '', '1', '1', '1', '1', '{\"name\":\"com_languages\",\"type\":\"component\",\"creationDate\":\"2006-04\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_LANGUAGES_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Languages\"}', '{\"administrator\":\"en-GB\",\"site\":\"en-GB\"}', '', NULL, NULL, '0', '0', NULL, '1'),
('12', '0', 'com_login', 'component', 'com_login', '', '', '1', '1', '1', '1', '{\"name\":\"com_login\",\"type\":\"component\",\"creationDate\":\"2006-04\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_LOGIN_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Login\"}', '', '', NULL, NULL, '0', '0', NULL, '1'),
('13', '0', 'com_media', 'component', 'com_media', '', '', '1', '1', '0', '1', '{\"name\":\"com_media\",\"type\":\"component\",\"creationDate\":\"2006-04\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_MEDIA_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Media\",\"filename\":\"media\"}', '{\"upload_extensions\":\"bmp,csv,doc,gif,ico,jpg,jpeg,odg,odp,ods,odt,pdf,png,ppt,swf,txt,xcf,xls,BMP,CSV,DOC,GIF,ICO,JPG,JPEG,ODG,ODP,ODS,ODT,PDF,PNG,PPT,SWF,TXT,XCF,XLS\",\"upload_maxsize\":\"10\",\"file_path\":\"images\",\"image_path\":\"images\",\"restrict_uploads\":\"1\",\"allowed_media_usergroup\":\"3\",\"check_mime\":\"1\",\"image_extensions\":\"bmp,gif,jpg,png\",\"ignore_extensions\":\"\",\"upload_mime\":\"image\\/jpeg,image\\/gif,image\\/png,image\\/bmp,application\\/x-shockwave-flash,application\\/msword,application\\/excel,application\\/pdf,application\\/powerpoint,text\\/plain,application\\/x-zip\",\"upload_mime_illegal\":\"text\\/html\",\"enable_flash\":\"0\"}', '', NULL, NULL, '0', '0', NULL, '1'),
('14', '0', 'com_menus', 'component', 'com_menus', '', '', '1', '1', '1', '1', '{\"name\":\"com_menus\",\"type\":\"component\",\"creationDate\":\"2006-04\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_MENUS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Menus\",\"filename\":\"menus\"}', '{}', '', NULL, NULL, '0', '0', NULL, '1'),
('15', '0', 'com_messages', 'component', 'com_messages', '', '', '1', '1', '1', '1', '{\"name\":\"com_messages\",\"type\":\"component\",\"creationDate\":\"2006-04\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_MESSAGES_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Messages\"}', '', '', NULL, NULL, '0', '0', NULL, '1'),
('16', '0', 'com_modules', 'component', 'com_modules', '', '', '1', '1', '1', '1', '{\"name\":\"com_modules\",\"type\":\"component\",\"creationDate\":\"2006-04\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_MODULES_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Modules\",\"filename\":\"modules\"}', '{}', '', NULL, NULL, '0', '0', NULL, '1'),
('17', '0', 'com_newsfeeds', 'component', 'com_newsfeeds', '', '', '1', '1', '1', '0', '{\"name\":\"com_newsfeeds\",\"type\":\"component\",\"creationDate\":\"2006-04\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_NEWSFEEDS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Newsfeeds\",\"filename\":\"newsfeeds\"}', '{\"show_feed_image\":\"1\",\"show_feed_description\":\"1\",\"show_item_description\":\"1\",\"feed_word_count\":\"0\",\"show_headings\":\"1\",\"show_name\":\"1\",\"show_articles\":\"0\",\"show_link\":\"1\",\"show_description\":\"1\",\"show_description_image\":\"1\",\"display_num\":\"\",\"show_pagination_limit\":\"1\",\"show_pagination\":\"1\",\"show_pagination_results\":\"1\",\"show_cat_items\":\"1\"}', '', NULL, NULL, '0', '0', NULL, '1'),
('18', '0', 'com_plugins', 'component', 'com_plugins', '', '', '1', '1', '1', '1', '{\"name\":\"com_plugins\",\"type\":\"component\",\"creationDate\":\"2006-04\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_PLUGINS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Plugins\"}', '{}', '', NULL, NULL, '0', '0', NULL, '1'),
('20', '0', 'com_templates', 'component', 'com_templates', '', '', '1', '1', '1', '1', '{\"name\":\"com_templates\",\"type\":\"component\",\"creationDate\":\"2006-04\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_TEMPLATES_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Templates\"}', '{\"template_positions_display\":\"0\",\"upload_limit\":\"2\",\"image_formats\":\"gif,bmp,jpg,jpeg,png\",\"source_formats\":\"txt,less,ini,xml,js,php,css,scss,yaml,twig\",\"font_formats\":\"woff,ttf,otf,eot,svg\",\"compressed_formats\":\"zip\",\"difference\":\"SideBySide\"}', '', NULL, NULL, '0', '0', NULL, '1'),
('21', '0', 'com_weblinks', 'component', 'com_weblinks', NULL, '', '1', '1', '1', '0', '{\"name\":\"com_weblinks\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2014 Open Source Matters. All rights reserved.\\n\\t\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_WEBLINKS_XML_DESCRIPTION\",\"group\":\"\"}', '{\"target\":\"0\",\"count_clicks\":\"1\",\"icons\":1,\"link_icons\":\"\",\"category_layout\":\"_:default\",\"show_category_title\":\"1\",\"show_description\":\"1\",\"show_description_image\":\"1\",\"maxLevel\":\"-1\",\"show_empty_categories\":\"0\",\"show_subcat_desc\":\"1\",\"show_cat_num_links\":\"1\",\"show_base_description\":\"1\",\"maxLevelcat\":\"-1\",\"show_empty_categories_cat\":\"0\",\"show_subcat_desc_cat\":\"1\",\"show_cat_num_links_cat\":\"1\",\"show_pagination_limit\":\"1\",\"show_headings\":\"1\",\"show_link_description\":\"1\",\"show_link_hits\":\"1\",\"show_pagination\":\"2\",\"show_pagination_results\":\"1\",\"show_feed_link\":\"1\"}', '', NULL, NULL, '0', '0', NULL, '0'),
('22', '0', 'com_content', 'component', 'com_content', '', '', '1', '1', '0', '1', '{\"name\":\"com_content\",\"type\":\"component\",\"creationDate\":\"2006-04\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_CONTENT_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Content\",\"filename\":\"content\"}', '{\"article_layout\":\"_:default\",\"show_title\":\"1\",\"link_titles\":\"1\",\"show_intro\":\"1\",\"info_block_position\":\"1\",\"info_block_show_title\":\"1\",\"show_category\":\"1\",\"link_category\":\"1\",\"show_parent_category\":\"0\",\"link_parent_category\":\"0\",\"show_associations\":\"0\",\"flags\":\"1\",\"show_author\":\"1\",\"link_author\":\"0\",\"show_create_date\":\"0\",\"show_modify_date\":\"0\",\"show_publish_date\":\"1\",\"show_item_navigation\":\"1\",\"show_vote\":\"0\",\"show_readmore\":\"1\",\"show_readmore_title\":\"0\",\"readmore_limit\":100,\"show_tags\":\"1\",\"record_hits\":\"0\",\"show_hits\":\"0\",\"show_noauth\":\"0\",\"urls_position\":0,\"captcha\":\"\",\"show_publishing_options\":\"1\",\"show_article_options\":\"1\",\"show_configure_edit_options\":\"1\",\"show_permissions\":\"1\",\"show_associations_edit\":\"1\",\"save_history\":\"0\",\"history_limit\":10,\"show_urls_images_frontend\":\"1\",\"show_urls_images_backend\":\"1\",\"targeta\":0,\"targetb\":0,\"targetc\":0,\"float_intro\":\"none\",\"float_fulltext\":\"none\",\"category_layout\":\"_:blog\",\"show_category_title\":\"0\",\"show_description\":\"0\",\"show_description_image\":\"0\",\"maxLevel\":\"1\",\"show_empty_categories\":\"0\",\"show_no_articles\":\"1\",\"show_category_heading_title_text\":\"1\",\"show_subcat_desc\":\"1\",\"show_cat_num_articles\":\"0\",\"show_cat_tags\":\"1\",\"show_base_description\":\"1\",\"maxLevelcat\":\"-1\",\"show_empty_categories_cat\":\"0\",\"show_subcat_desc_cat\":\"1\",\"show_cat_num_articles_cat\":\"1\",\"num_leading_articles\":1,\"blog_class_leading\":\"\",\"num_intro_articles\":4,\"blog_class\":\"\",\"num_columns\":2,\"multi_column_order\":\"0\",\"num_links\":4,\"show_subcategory_content\":\"0\",\"link_intro_image\":\"1\",\"show_pagination_limit\":\"1\",\"filter_field\":\"hide\",\"show_headings\":\"1\",\"list_show_date\":\"0\",\"date_format\":\"\",\"list_show_hits\":\"1\",\"list_show_author\":\"1\",\"list_show_votes\":\"0\",\"list_show_ratings\":\"0\",\"orderby_pri\":\"order\",\"orderby_sec\":\"rdate\",\"order_date\":\"published\",\"show_pagination\":\"2\",\"show_pagination_results\":\"1\",\"show_featured\":\"show\",\"show_feed_link\":\"1\",\"feed_summary\":\"0\",\"feed_show_readmore\":\"0\",\"sef_ids\":1,\"custom_fields_enable\":\"1\",\"workflow_enabled\":\"0\"}', '', NULL, NULL, '0', '0', NULL, '1'),
('23', '0', 'com_config', 'component', 'com_config', '', '', '1', '1', '0', '1', '{\"name\":\"com_config\",\"type\":\"component\",\"creationDate\":\"2006-04\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_CONFIG_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Config\",\"filename\":\"config\"}', '{\"filters\":{\"1\":{\"filter_type\":\"BL\",\"filter_tags\":\"\",\"filter_attributes\":\"\"},\"9\":{\"filter_type\":\"BL\",\"filter_tags\":\"\",\"filter_attributes\":\"\"},\"6\":{\"filter_type\":\"BL\",\"filter_tags\":\"\",\"filter_attributes\":\"\"},\"7\":{\"filter_type\":\"BL\",\"filter_tags\":\"\",\"filter_attributes\":\"\"},\"2\":{\"filter_type\":\"BL\",\"filter_tags\":\"\",\"filter_attributes\":\"\"},\"3\":{\"filter_type\":\"BL\",\"filter_tags\":\"\",\"filter_attributes\":\"\"},\"4\":{\"filter_type\":\"BL\",\"filter_tags\":\"\",\"filter_attributes\":\"\"},\"5\":{\"filter_type\":\"BL\",\"filter_tags\":\"\",\"filter_attributes\":\"\"},\"8\":{\"filter_type\":\"NONE\",\"filter_tags\":\"\",\"filter_attributes\":\"\"}}}', '', NULL, NULL, '0', '0', NULL, '1'),
('24', '0', 'com_redirect', 'component', 'com_redirect', '', '', '1', '1', '0', '0', '{\"name\":\"com_redirect\",\"type\":\"component\",\"creationDate\":\"2006-04\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_REDIRECT_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Redirect\"}', '{}', '', NULL, NULL, '0', '0', NULL, '1'),
('25', '0', 'com_users', 'component', 'com_users', '', '', '1', '1', '0', '1', '{\"name\":\"com_users\",\"type\":\"component\",\"creationDate\":\"2006-04\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_USERS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Users\",\"filename\":\"users\"}', '{\"allowUserRegistration\":\"1\",\"new_usertype\":\"2\",\"guest_usergroup\":\"1\",\"sendpassword\":\"1\",\"useractivation\":\"1\",\"mail_to_admin\":\"1\",\"captcha\":\"\",\"frontend_userparams\":\"1\",\"site_language\":\"0\",\"change_login_name\":\"0\",\"enforce_2fa_options\":0,\"domains\":[],\"reset_count\":10,\"reset_time\":1,\"minimum_length\":12,\"minimum_integers\":0,\"minimum_symbols\":0,\"minimum_uppercase\":0,\"minimum_lowercase\":0,\"save_history\":\"0\",\"history_limit\":5,\"mailSubjectPrefix\":\"\",\"mailBodySuffix\":\"\",\"custom_fields_enable\":\"1\"}', '', NULL, NULL, '0', '0', NULL, '1'),
('27', '0', 'com_finder', 'component', 'com_finder', '', '', '1', '1', '0', '0', '{\"name\":\"com_finder\",\"type\":\"component\",\"creationDate\":\"2011-08\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2011 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_FINDER_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Finder\",\"filename\":\"finder\"}', '{\"show_description\":\"1\",\"description_length\":255,\"allow_empty_query\":\"0\",\"show_url\":\"0\",\"show_autosuggest\":\"1\",\"show_advanced\":\"1\",\"expand_advanced\":\"0\",\"show_date_filters\":\"0\",\"sort_order\":\"relevance\",\"sort_direction\":\"desc\",\"highlight_terms\":\"1\",\"opensearch_name\":\"\",\"opensearch_description\":\"\",\"batch_size\":\"50\",\"memory_table_limit\":30000,\"title_multiplier\":\"1.7\",\"text_multiplier\":\"0.7\",\"meta_multiplier\":\"1.2\",\"path_multiplier\":\"2.0\",\"misc_multiplier\":\"0.3\",\"stem\":\"1\",\"stemmer\":\"porter_en\"}', '', NULL, NULL, '0', '0', NULL, '1'),
('28', '0', 'com_joomlaupdate', 'component', 'com_joomlaupdate', '', '', '1', '1', '0', '1', '{\"name\":\"com_joomlaupdate\",\"type\":\"component\",\"creationDate\":\"2021-08\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2012 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.3\",\"description\":\"COM_JOOMLAUPDATE_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Joomlaupdate\"}', '{\"updatesource\":\"default\",\"minimum_stability\":\"4\",\"customurl\":\"\",\"versioncheck\":\"1\",\"backupcheck\":\"1\",\"autoupdate\":\"0\",\"autoupdate_status\":\"\",\"update_token\":\"\",\"update_last_check\":\"\"}', '', NULL, NULL, '0', '0', NULL, '1'),
('29', '0', 'com_tags', 'component', 'com_tags', '', '', '1', '1', '1', '0', '{\"name\":\"com_tags\",\"type\":\"component\",\"creationDate\":\"2013-12\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2013 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_TAGS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Tags\",\"filename\":\"tags\"}', '{}', '', NULL, NULL, '0', '0', NULL, '1'),
('30', '0', 'com_contenthistory', 'component', 'com_contenthistory', '', '', '1', '1', '1', '0', '{\"name\":\"com_contenthistory\",\"type\":\"component\",\"creationDate\":\"2013-05\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2013 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_CONTENTHISTORY_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Contenthistory\",\"filename\":\"contenthistory\"}', '{}', '', NULL, NULL, '0', '0', NULL, '1'),
('31', '0', 'com_ajax', 'component', 'com_ajax', '', '', '1', '1', '1', '1', '{\"name\":\"com_ajax\",\"type\":\"component\",\"creationDate\":\"2013-08\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2013 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_AJAX_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"filename\":\"ajax\"}', '{}', '', NULL, NULL, '0', '0', NULL, '1'),
('32', '0', 'com_postinstall', 'component', 'com_postinstall', '', '', '1', '1', '1', '1', '{\"name\":\"com_postinstall\",\"type\":\"component\",\"creationDate\":\"2013-09\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2013 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_POSTINSTALL_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Postinstall\"}', '', '', NULL, NULL, '0', '0', NULL, '1'),
('33', '0', 'com_fields', 'component', 'com_fields', '', '', '1', '1', '1', '0', '{\"name\":\"com_fields\",\"type\":\"component\",\"creationDate\":\"2016-03\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_FIELDS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Fields\",\"filename\":\"fields\"}', '', '', NULL, NULL, '0', '0', NULL, '1'),
('34', '0', 'com_associations', 'component', 'com_associations', '', '', '1', '1', '1', '0', '{\"name\":\"com_associations\",\"type\":\"component\",\"creationDate\":\"2017-01\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2017 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_ASSOCIATIONS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Associations\"}', '', '', NULL, NULL, '0', '0', NULL, '1'),
('35', '0', 'com_privacy', 'component', 'com_privacy', '', '', '1', '1', '1', '0', '{\"name\":\"com_privacy\",\"type\":\"component\",\"creationDate\":\"2018-05\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2018 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"COM_PRIVACY_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Privacy\",\"filename\":\"privacy\"}', '', '', NULL, NULL, '0', '0', NULL, '1'),
('36', '0', 'com_actionlogs', 'component', 'com_actionlogs', '', '', '1', '1', '1', '0', '{\"name\":\"com_actionlogs\",\"type\":\"component\",\"creationDate\":\"2018-05\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2018 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"COM_ACTIONLOGS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Actionlogs\"}', '{\"ip_logging\":0,\"csv_delimiter\":\",\",\"loggable_extensions\":[\"com_banners\",\"com_cache\",\"com_categories\",\"com_checkin\",\"com_config\",\"com_contact\",\"com_content\",\"com_installer\",\"com_media\",\"com_menus\",\"com_messages\",\"com_modules\",\"com_newsfeeds\",\"com_plugins\",\"com_redirect\",\"com_tags\",\"com_templates\",\"com_users\"]}', '', NULL, NULL, '0', '0', NULL, '1'),
('100', '0', 'PHPMailer', 'library', 'phpmailer', NULL, '', '0', '1', '1', '1', 'false', '', '', NULL, NULL, '0', '0', NULL, '0'),
('103', '0', 'lib_joomla', 'library', 'joomla', '', '', '0', '1', '1', '1', '{\"name\":\"lib_joomla\",\"type\":\"library\",\"creationDate\":\"2008-01\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2008 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"https:\\/\\/www.joomla.org\",\"version\":\"13.1\",\"description\":\"LIB_JOOMLA_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"filename\":\"joomla\"}', '{\"mediaversion\":\"75270cae7ab8dd03f94449eecaa34576\"}', '', NULL, NULL, '0', '0', NULL, '1'),
('106', '0', 'lib_phpass', 'library', 'phpass', '', '', '0', '1', '1', '1', '{\"name\":\"lib_phpass\",\"type\":\"library\",\"creationDate\":\"2004-01\",\"author\":\"Solar Designer\",\"copyright\":\"\",\"authorEmail\":\"solar@openwall.com\",\"authorUrl\":\"https:\\/\\/www.openwall.com\\/phpass\\/\",\"version\":\"0.5.1\",\"description\":\"LIB_PHPASS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"filename\":\"phpass\"}', '{}', '', NULL, NULL, '0', '0', NULL, '1'),
('200', '0', 'mod_articles_archive', 'module', 'mod_articles_archive', '', '', '0', '1', '1', '0', '{\"name\":\"mod_articles_archive\",\"type\":\"module\",\"creationDate\":\"2006-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_ARTICLES_ARCHIVE_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\ArticlesArchive\",\"filename\":\"mod_articles_archive\"}', '', '', NULL, NULL, '0', '0', NULL, '1'),
('201', '0', 'mod_articles_latest', 'module', 'mod_articles_latest', '', '', '0', '1', '1', '0', '{\"name\":\"mod_articles_latest\",\"type\":\"module\",\"creationDate\":\"2004-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_LATEST_NEWS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\ArticlesLatest\",\"filename\":\"mod_articles_latest\"}', '', '', NULL, NULL, '0', '0', NULL, '1'),
('202', '0', 'mod_articles_popular', 'module', 'mod_articles_popular', '', '', '0', '1', '1', '0', '{\"name\":\"mod_articles_popular\",\"type\":\"module\",\"creationDate\":\"2006-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_POPULAR_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\ArticlesPopular\",\"filename\":\"mod_articles_popular\"}', '', '', NULL, NULL, '0', '0', NULL, '1'),
('203', '0', 'mod_banners', 'module', 'mod_banners', '', '', '0', '1', '1', '0', '{\"name\":\"mod_banners\",\"type\":\"module\",\"creationDate\":\"2006-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_BANNERS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\Banners\",\"filename\":\"mod_banners\"}', '', '', NULL, NULL, '0', '0', NULL, '1'),
('204', '0', 'mod_breadcrumbs', 'module', 'mod_breadcrumbs', '', '', '0', '1', '1', '0', '{\"name\":\"mod_breadcrumbs\",\"type\":\"module\",\"creationDate\":\"2006-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_BREADCRUMBS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\Breadcrumbs\",\"filename\":\"mod_breadcrumbs\"}', '', '', NULL, NULL, '0', '0', NULL, '1'),
('205', '0', 'mod_custom', 'module', 'mod_custom', '', '', '0', '1', '1', '0', '{\"name\":\"mod_custom\",\"type\":\"module\",\"creationDate\":\"2004-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_CUSTOM_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\Custom\",\"filename\":\"mod_custom\"}', '', '', NULL, NULL, '0', '0', NULL, '1'),
('206', '0', 'mod_feed', 'module', 'mod_feed', '', '', '0', '1', '1', '0', '{\"name\":\"mod_feed\",\"type\":\"module\",\"creationDate\":\"2005-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_FEED_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\Feed\",\"filename\":\"mod_feed\"}', '', '', NULL, NULL, '0', '0', NULL, '1'),
('207', '0', 'mod_footer', 'module', 'mod_footer', '', '', '0', '1', '1', '0', '{\"name\":\"mod_footer\",\"type\":\"module\",\"creationDate\":\"2006-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_FOOTER_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\Footer\",\"filename\":\"mod_footer\"}', '', '', NULL, NULL, '0', '0', NULL, '1'),
('208', '0', 'mod_login', 'module', 'mod_login', '', '', '0', '1', '1', '0', '{\"name\":\"mod_login\",\"type\":\"module\",\"creationDate\":\"2006-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_LOGIN_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\Login\",\"filename\":\"mod_login\"}', '', '', NULL, NULL, '0', '0', NULL, '1'),
('209', '0', 'mod_menu', 'module', 'mod_menu', '', '', '0', '1', '1', '0', '{\"name\":\"mod_menu\",\"type\":\"module\",\"creationDate\":\"2004-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_MENU_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\Menu\",\"filename\":\"mod_menu\"}', '', '', NULL, NULL, '0', '0', NULL, '1'),
('210', '0', 'mod_articles_news', 'module', 'mod_articles_news', '', '', '0', '1', '1', '0', '{\"name\":\"mod_articles_news\",\"type\":\"module\",\"creationDate\":\"2006-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_ARTICLES_NEWS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\ArticlesNews\",\"filename\":\"mod_articles_news\"}', '', '', NULL, NULL, '0', '0', NULL, '1'),
('211', '0', 'mod_random_image', 'module', 'mod_random_image', '', '', '0', '1', '1', '0', '{\"name\":\"mod_random_image\",\"type\":\"module\",\"creationDate\":\"2006-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_RANDOM_IMAGE_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\RandomImage\",\"filename\":\"mod_random_image\"}', '', '', NULL, NULL, '0', '0', NULL, '1'),
('212', '0', 'mod_related_items', 'module', 'mod_related_items', '', '', '0', '1', '1', '0', '{\"name\":\"mod_related_items\",\"type\":\"module\",\"creationDate\":\"2004-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_RELATED_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\RelatedItems\",\"filename\":\"mod_related_items\"}', '', '', NULL, NULL, '0', '0', NULL, '1'),
('214', '0', 'mod_stats', 'module', 'mod_stats', '', '', '0', '1', '1', '0', '{\"name\":\"mod_stats\",\"type\":\"module\",\"creationDate\":\"2004-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_STATS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\Stats\",\"filename\":\"mod_stats\"}', '', '', NULL, NULL, '0', '0', NULL, '1'),
('215', '0', 'mod_syndicate', 'module', 'mod_syndicate', '', '', '0', '1', '1', '0', '{\"name\":\"mod_syndicate\",\"type\":\"module\",\"creationDate\":\"2006-05\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_SYNDICATE_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\Syndicate\",\"filename\":\"mod_syndicate\"}', '', '', NULL, NULL, '0', '0', NULL, '1'),
('216', '0', 'mod_users_latest', 'module', 'mod_users_latest', '', '', '0', '1', '1', '0', '{\"name\":\"mod_users_latest\",\"type\":\"module\",\"creationDate\":\"2009-12\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2009 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_USERS_LATEST_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\UsersLatest\",\"filename\":\"mod_users_latest\"}', '', '', NULL, NULL, '0', '0', NULL, '1'),
('217', '0', 'mod_weblinks', 'module', 'mod_weblinks', NULL, '', '0', '1', '1', '0', '{\"name\":\"mod_weblinks\",\"type\":\"module\",\"creationDate\":\"July 2009\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2014 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_WEBLINKS_XML_DESCRIPTION\",\"group\":\"\"}', '', '', NULL, NULL, '0', '0', NULL, '0'),
('218', '0', 'mod_whosonline', 'module', 'mod_whosonline', '', '', '0', '1', '1', '0', '{\"name\":\"mod_whosonline\",\"type\":\"module\",\"creationDate\":\"2004-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_WHOSONLINE_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\Whosonline\",\"filename\":\"mod_whosonline\"}', '', '', NULL, NULL, '0', '0', NULL, '1'),
('219', '0', 'mod_wrapper', 'module', 'mod_wrapper', '', '', '0', '1', '1', '0', '{\"name\":\"mod_wrapper\",\"type\":\"module\",\"creationDate\":\"2004-10\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_WRAPPER_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\Wrapper\",\"filename\":\"mod_wrapper\"}', '', '', NULL, NULL, '0', '0', NULL, '1'),
('220', '0', 'mod_articles_category', 'module', 'mod_articles_category', '', '', '0', '1', '1', '0', '{\"name\":\"mod_articles_category\",\"type\":\"module\",\"creationDate\":\"2010-02\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2010 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_ARTICLES_CATEGORY_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\ArticlesCategory\",\"filename\":\"mod_articles_category\"}', '', '', NULL, NULL, '0', '0', NULL, '1'),
('221', '0', 'mod_articles_categories', 'module', 'mod_articles_categories', '', '', '0', '1', '1', '0', '{\"name\":\"mod_articles_categories\",\"type\":\"module\",\"creationDate\":\"2010-02\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2010 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_ARTICLES_CATEGORIES_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\ArticlesCategories\",\"filename\":\"mod_articles_categories\"}', '', '', NULL, NULL, '0', '0', NULL, '1'),
('222', '0', 'mod_languages', 'module', 'mod_languages', '', '', '0', '1', '1', '0', '{\"name\":\"mod_languages\",\"type\":\"module\",\"creationDate\":\"2010-02\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2010 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.5.0\",\"description\":\"MOD_LANGUAGES_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\Languages\",\"filename\":\"mod_languages\"}', '', '', NULL, NULL, '0', '0', NULL, '1'),
('223', '0', 'mod_finder', 'module', 'mod_finder', '', '', '0', '1', '0', '0', '{\"name\":\"mod_finder\",\"type\":\"module\",\"creationDate\":\"2011-08\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2011 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_FINDER_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\Finder\",\"filename\":\"mod_finder\"}', '', '', NULL, NULL, '0', '0', NULL, '1'),
('300', '0', 'mod_custom', 'module', 'mod_custom', '', '', '1', '1', '1', '0', '{\"name\":\"mod_custom\",\"type\":\"module\",\"creationDate\":\"2004-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_CUSTOM_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\Custom\",\"filename\":\"mod_custom\"}', '', '', NULL, NULL, '0', '0', NULL, '1'),
('301', '0', 'mod_feed', 'module', 'mod_feed', '', '', '1', '1', '1', '0', '{\"name\":\"mod_feed\",\"type\":\"module\",\"creationDate\":\"2005-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_FEED_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\Feed\",\"filename\":\"mod_feed\"}', '', '', NULL, NULL, '0', '0', NULL, '1'),
('302', '0', 'mod_latest', 'module', 'mod_latest', '', '', '1', '1', '1', '0', '{\"name\":\"mod_latest\",\"type\":\"module\",\"creationDate\":\"2004-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_LATEST_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\Latest\",\"filename\":\"mod_latest\"}', '', '', NULL, NULL, '0', '0', NULL, '1'),
('303', '0', 'mod_logged', 'module', 'mod_logged', '', '', '1', '1', '1', '0', '{\"name\":\"mod_logged\",\"type\":\"module\",\"creationDate\":\"2005-01\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_LOGGED_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\Logged\",\"filename\":\"mod_logged\"}', '', '', NULL, NULL, '0', '0', NULL, '1'),
('304', '0', 'mod_login', 'module', 'mod_login', '', '', '1', '1', '1', '0', '{\"name\":\"mod_login\",\"type\":\"module\",\"creationDate\":\"2005-03\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_LOGIN_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\Login\",\"filename\":\"mod_login\"}', '', '', NULL, NULL, '0', '0', NULL, '1'),
('305', '0', 'mod_menu', 'module', 'mod_menu', '', '', '1', '1', '1', '0', '{\"name\":\"mod_menu\",\"type\":\"module\",\"creationDate\":\"2006-03\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_MENU_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\Menu\",\"filename\":\"mod_menu\"}', '', '', NULL, NULL, '0', '0', NULL, '1'),
('306', '0', 'mod_online', 'module', 'mod_online', NULL, '', '1', '1', '1', '0', '', '', '', NULL, NULL, '0', '0', NULL, '0'),
('307', '0', 'mod_popular', 'module', 'mod_popular', '', '', '1', '1', '1', '0', '{\"name\":\"mod_popular\",\"type\":\"module\",\"creationDate\":\"2004-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_POPULAR_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\Popular\",\"filename\":\"mod_popular\"}', '', '', NULL, NULL, '0', '0', NULL, '1'),
('308', '0', 'mod_quickicon', 'module', 'mod_quickicon', '', '', '1', '1', '1', '0', '{\"name\":\"mod_quickicon\",\"type\":\"module\",\"creationDate\":\"2005-11\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_QUICKICON_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\Quickicon\",\"filename\":\"mod_quickicon\"}', '', '', NULL, NULL, '0', '0', NULL, '1'),
('311', '0', 'mod_title', 'module', 'mod_title', '', '', '1', '1', '1', '0', '{\"name\":\"mod_title\",\"type\":\"module\",\"creationDate\":\"2005-11\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_TITLE_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\Title\",\"filename\":\"mod_title\"}', '', '', NULL, NULL, '0', '0', NULL, '1'),
('312', '0', 'mod_toolbar', 'module', 'mod_toolbar', '', '', '1', '1', '1', '0', '{\"name\":\"mod_toolbar\",\"type\":\"module\",\"creationDate\":\"2005-11\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_TOOLBAR_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\Toolbar\",\"filename\":\"mod_toolbar\"}', '', '', NULL, NULL, '0', '0', NULL, '1'),
('313', '0', 'mod_multilangstatus', 'module', 'mod_multilangstatus', '', '', '1', '1', '1', '0', '{\"name\":\"mod_multilangstatus\",\"type\":\"module\",\"creationDate\":\"2011-09\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2011 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_MULTILANGSTATUS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\MultilangStatus\",\"filename\":\"mod_multilangstatus\"}', '{\"cache\":\"0\"}', '', NULL, NULL, '0', '0', NULL, '1'),
('314', '0', 'mod_version', 'module', 'mod_version', '', '', '1', '1', '1', '0', '{\"name\":\"mod_version\",\"type\":\"module\",\"creationDate\":\"2012-01\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2012 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_VERSION_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\Version\",\"filename\":\"mod_version\"}', '{\"format\":\"short\",\"product\":\"1\",\"cache\":\"0\"}', '', NULL, NULL, '0', '0', NULL, '1'),
('315', '0', 'mod_stats_admin', 'module', 'mod_stats_admin', '', '', '1', '1', '1', '0', '{\"name\":\"mod_stats_admin\",\"type\":\"module\",\"creationDate\":\"2004-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_STATS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\StatsAdmin\",\"filename\":\"mod_stats_admin\"}', '{\"serverinfo\":\"0\",\"siteinfo\":\"0\",\"counter\":\"0\",\"increase\":\"0\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"static\"}', '', NULL, NULL, '0', '0', NULL, '1'),
('316', '0', 'mod_tags_popular', 'module', 'mod_tags_popular', '', '', '0', '1', '1', '0', '{\"name\":\"mod_tags_popular\",\"type\":\"module\",\"creationDate\":\"2013-01\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2013 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.1.0\",\"description\":\"MOD_TAGS_POPULAR_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\TagsPopular\",\"filename\":\"mod_tags_popular\"}', '{\"maximum\":\"5\",\"timeframe\":\"alltime\",\"owncache\":\"1\"}', '', NULL, NULL, '0', '0', NULL, '1'),
('317', '0', 'mod_tags_similar', 'module', 'mod_tags_similar', '', '', '0', '1', '1', '0', '{\"name\":\"mod_tags_similar\",\"type\":\"module\",\"creationDate\":\"2013-01\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2013 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.1.0\",\"description\":\"MOD_TAGS_SIMILAR_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\TagsSimilar\",\"filename\":\"mod_tags_similar\"}', '{\"maximum\":\"5\",\"matchtype\":\"any\",\"owncache\":\"1\"}', '', NULL, NULL, '0', '0', NULL, '1'),
('318', '0', 'mod_sampledata', 'module', 'mod_sampledata', '', '', '1', '1', '1', '0', '{\"name\":\"mod_sampledata\",\"type\":\"module\",\"creationDate\":\"2017-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2017 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.8.0\",\"description\":\"MOD_SAMPLEDATA_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\Sampledata\",\"filename\":\"mod_sampledata\"}', '{}', '', NULL, NULL, '0', '0', NULL, '1'),
('319', '0', 'mod_latestactions', 'module', 'mod_latestactions', '', '', '1', '1', '1', '0', '{\"name\":\"mod_latestactions\",\"type\":\"module\",\"creationDate\":\"2018-05\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2018 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"MOD_LATESTACTIONS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\LatestActions\",\"filename\":\"mod_latestactions\"}', '{}', '', NULL, '1970-01-01 00:00:00', '0', '0', NULL, '1'),
('320', '0', 'mod_privacy_dashboard', 'module', 'mod_privacy_dashboard', '', '', '1', '1', '1', '0', '{\"name\":\"mod_privacy_dashboard\",\"type\":\"module\",\"creationDate\":\"2018-06\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2018 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"MOD_PRIVACY_DASHBOARD_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\PrivacyDashboard\",\"filename\":\"mod_privacy_dashboard\"}', '{}', '', NULL, '1970-01-01 00:00:00', '0', '0', NULL, '1'),
('401', '0', 'plg_authentication_joomla', 'plugin', 'joomla', '', 'authentication', '0', '1', '1', '1', '{\"name\":\"plg_authentication_joomla\",\"type\":\"plugin\",\"creationDate\":\"2005-11\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_AUTHENTICATION_JOOMLA_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Authentication\\\\Joomla\",\"filename\":\"joomla\"}', '{}', '', NULL, NULL, '0', '0', NULL, '1'),
('402', '0', 'plg_authentication_ldap', 'plugin', 'ldap', '', 'authentication', '0', '0', '1', '0', '{\"name\":\"plg_authentication_ldap\",\"type\":\"plugin\",\"creationDate\":\"2005-11\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_LDAP_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Authentication\\\\Ldap\",\"filename\":\"ldap\"}', '{\"host\":\"\",\"port\":\"389\",\"use_ldapV3\":\"0\",\"negotiate_tls\":\"0\",\"no_referrals\":\"0\",\"auth_method\":\"bind\",\"base_dn\":\"\",\"search_string\":\"\",\"users_dn\":\"\",\"username\":\"admin\",\"password\":\"bobby7\",\"ldap_fullname\":\"fullName\",\"ldap_email\":\"mail\",\"ldap_uid\":\"uid\"}', '', NULL, NULL, '3', '0', NULL, '1'),
('403', '0', 'plg_content_contact', 'plugin', 'contact', '', 'content', '0', '1', '1', '0', '{\"name\":\"plg_content_contact\",\"type\":\"plugin\",\"creationDate\":\"2014-01\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2014 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.2.2\",\"description\":\"PLG_CONTENT_CONTACT_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Content\\\\Contact\",\"filename\":\"contact\"}', '', '', NULL, NULL, '1', '0', NULL, '1'),
('404', '0', 'plg_content_emailcloak', 'plugin', 'emailcloak', '', 'content', '0', '1', '1', '0', '{\"name\":\"plg_content_emailcloak\",\"type\":\"plugin\",\"creationDate\":\"2005-11\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_CONTENT_EMAILCLOAK_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Content\\\\EmailCloak\",\"filename\":\"emailcloak\"}', '{\"mode\":\"1\"}', '', NULL, NULL, '1', '0', NULL, '1'),
('405', '0', 'plg_content_geshi', 'plugin', 'geshi', NULL, 'content', '0', '0', '1', '0', '{\"legacy\":false,\"name\":\"plg_content_geshi\",\"type\":\"plugin\",\"creationDate\":\"November 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2012 Open Source Matters. All rights reserved.\",\"authorEmail\":\"\",\"authorUrl\":\"qbnz.com\\/highlighter\",\"version\":\"2.5.0\",\"description\":\"PLG_CONTENT_GESHI_XML_DESCRIPTION\",\"group\":\"\"}', '{}', '', NULL, NULL, '2', '0', NULL, '0'),
('406', '0', 'plg_content_loadmodule', 'plugin', 'loadmodule', '', 'content', '0', '1', '1', '0', '{\"name\":\"plg_content_loadmodule\",\"type\":\"plugin\",\"creationDate\":\"2005-11\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_LOADMODULE_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Content\\\\LoadModule\",\"filename\":\"loadmodule\"}', '{\"style\":\"none\"}', '', NULL, NULL, '0', '0', NULL, '1'),
('407', '0', 'plg_content_pagebreak', 'plugin', 'pagebreak', '', 'content', '0', '1', '1', '0', '{\"name\":\"plg_content_pagebreak\",\"type\":\"plugin\",\"creationDate\":\"2005-11\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_CONTENT_PAGEBREAK_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Content\\\\PageBreak\",\"filename\":\"pagebreak\"}', '{\"title\":\"1\",\"multipage_toc\":\"1\",\"showall\":\"1\"}', '', NULL, NULL, '4', '0', NULL, '1'),
('408', '0', 'plg_content_pagenavigation', 'plugin', 'pagenavigation', '', 'content', '0', '0', '1', '0', '{\"name\":\"plg_content_pagenavigation\",\"type\":\"plugin\",\"creationDate\":\"2006-01\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_PAGENAVIGATION_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Content\\\\PageNavigation\",\"filename\":\"pagenavigation\"}', '{\"position\":\"1\"}', '', NULL, NULL, '5', '0', NULL, '1'),
('409', '0', 'plg_content_vote', 'plugin', 'vote', '', 'content', '0', '0', '1', '0', '{\"name\":\"plg_content_vote\",\"type\":\"plugin\",\"creationDate\":\"2005-11\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_VOTE_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Content\\\\Vote\",\"filename\":\"vote\"}', '{}', '', NULL, NULL, '6', '0', NULL, '1'),
('410', '0', 'plg_editors_codemirror', 'plugin', 'codemirror', '', 'editors', '0', '1', '1', '0', '{\"name\":\"plg_editors_codemirror\",\"type\":\"plugin\",\"creationDate\":\"28 March 2011\",\"author\":\"Marijn Haverbeke\",\"copyright\":\"Copyright (C) 2014 - 2021 by Marijn Haverbeke <marijnh@gmail.com> and others\",\"authorEmail\":\"marijnh@gmail.com\",\"authorUrl\":\"https:\\/\\/codemirror.net\\/\",\"version\":\"6.0.0\",\"description\":\"PLG_CODEMIRROR_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Editors\\\\CodeMirror\",\"filename\":\"codemirror\"}', '{\"lineNumbers\":\"1\",\"lineWrapping\":\"1\",\"matchTags\":\"1\",\"matchBrackets\":\"1\",\"marker-gutter\":\"1\",\"autoCloseTags\":\"1\",\"autoCloseBrackets\":\"1\",\"autoFocus\":\"1\",\"theme\":\"default\",\"tabmode\":\"indent\"}', '', NULL, NULL, '1', '0', NULL, '1'),
('411', '0', 'plg_editors_none', 'plugin', 'none', '', 'editors', '0', '1', '1', '1', '{\"name\":\"plg_editors_none\",\"type\":\"plugin\",\"creationDate\":\"2005-09\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_NONE_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Editors\\\\None\",\"filename\":\"none\"}', '{}', '', NULL, NULL, '2', '0', NULL, '1'),
('412', '0', 'plg_editors_tinymce', 'plugin', 'tinymce', '', 'editors', '0', '1', '1', '0', '{\"name\":\"plg_editors_tinymce\",\"type\":\"plugin\",\"creationDate\":\"2005-08\",\"author\":\"Tiny Technologies, Inc\",\"copyright\":\"Tiny Technologies, Inc\",\"authorEmail\":\"N\\/A\",\"authorUrl\":\"https:\\/\\/www.tiny.cloud\",\"version\":\"8.1.2\",\"description\":\"PLG_TINY_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Editors\\\\TinyMCE\",\"filename\":\"tinymce\"}', '{\"mode\":\"1\",\"skin\":\"0\",\"compressed\":\"0\",\"cleanup_startup\":\"0\",\"cleanup_save\":\"2\",\"entity_encoding\":\"raw\",\"lang_mode\":\"0\",\"lang_code\":\"en\",\"text_direction\":\"ltr\",\"content_css\":\"1\",\"content_css_custom\":\"\",\"relative_urls\":\"1\",\"newlines\":\"0\",\"invalid_elements\":\"script,applet,iframe\",\"extended_elements\":\",@[data-lightbox],@[data-spotlight],@[data-lightbox],@[data-spotlight],@[data-lightbox],@[data-spotlight],@[data-lightbox],@[data-spotlight],@[data-lightbox],@[data-spotlight],@[data-lightbox],@[data-spotlight],@[data-lightbox],@[data-spotlight],@[data-lightbox],@[data-spotlight],@[data-lightbox],@[data-spotlight],@[data-lightbox],@[data-spotlight],@[data-lightbox],@[data-spotlight],@[data-lightbox],@[data-spotlight],@[data-lightbox],@[data-spotlight],@[data-lightbox],@[data-spotlight],@[data-lightbox],@[data-spotlight],@[data-lightbox],@[data-spotlight],@[data-lightbox],@[data-spotlight],@[data-lightbox],@[data-spotlight],@[data-lightbox],@[data-spotlight],@[data-lightbox],@[data-spotlight],@[data-lightbox],@[data-spotlight],@[data-lightbox],@[data-spotlight],@[data-lightbox],@[data-spotlight],@[data-lightbox],@[data-spotlight],@[data-lightbox],@[data-spotlight]\",\"toolbar\":\"top\",\"toolbar_align\":\"left\",\"html_height\":\"550\",\"html_width\":\"750\",\"element_path\":\"1\",\"fonts\":\"1\",\"paste\":\"1\",\"searchreplace\":\"1\",\"insertdate\":\"1\",\"format_date\":\"%Y-%m-%d\",\"inserttime\":\"1\",\"format_time\":\"%H:%M:%S\",\"colors\":\"1\",\"table\":\"1\",\"smilies\":\"1\",\"media\":\"1\",\"hr\":\"1\",\"directionality\":\"1\",\"fullscreen\":\"1\",\"style\":\"1\",\"layer\":\"1\",\"xhtmlxtras\":\"1\",\"visualchars\":\"1\",\"nonbreaking\":\"1\",\"template\":\"1\",\"blockquote\":\"1\",\"wordcount\":\"1\",\"advimage\":\"1\",\"advlink\":\"1\",\"autosave\":\"1\",\"contextmenu\":\"1\",\"inlinepopups\":\"1\",\"safari\":\"0\",\"custom_plugin\":\"\",\"custom_button\":\"\"}', '', NULL, NULL, '3', '0', NULL, '1'),
('413', '0', 'plg_editors-xtd_article', 'plugin', 'article', '', 'editors-xtd', '0', '1', '1', '0', '{\"name\":\"plg_editors-xtd_article\",\"type\":\"plugin\",\"creationDate\":\"2009-10\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2009 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_ARTICLE_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\EditorsXtd\\\\Article\",\"filename\":\"article\"}', '{}', '', NULL, NULL, '1', '0', NULL, '1'),
('414', '0', 'plg_editors-xtd_image', 'plugin', 'image', '', 'editors-xtd', '0', '1', '1', '0', '{\"name\":\"plg_editors-xtd_image\",\"type\":\"plugin\",\"creationDate\":\"2004-08\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_IMAGE_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\EditorsXtd\\\\Image\",\"filename\":\"image\"}', '{}', '', NULL, NULL, '2', '0', NULL, '1'),
('415', '0', 'plg_editors-xtd_pagebreak', 'plugin', 'pagebreak', '', 'editors-xtd', '0', '1', '1', '0', '{\"name\":\"plg_editors-xtd_pagebreak\",\"type\":\"plugin\",\"creationDate\":\"2004-08\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_EDITORSXTD_PAGEBREAK_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\EditorsXtd\\\\PageBreak\",\"filename\":\"pagebreak\"}', '{}', '', NULL, NULL, '3', '0', NULL, '1'),
('416', '0', 'plg_editors-xtd_readmore', 'plugin', 'readmore', '', 'editors-xtd', '0', '1', '1', '0', '{\"name\":\"plg_editors-xtd_readmore\",\"type\":\"plugin\",\"creationDate\":\"2006-03\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_READMORE_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\EditorsXtd\\\\ReadMore\",\"filename\":\"readmore\"}', '{}', '', NULL, NULL, '4', '0', NULL, '1'),
('422', '0', 'plg_system_languagefilter', 'plugin', 'languagefilter', '', 'system', '0', '0', '1', '0', '{\"name\":\"plg_system_languagefilter\",\"type\":\"plugin\",\"creationDate\":\"2010-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2010 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_SYSTEM_LANGUAGEFILTER_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\System\\\\LanguageFilter\",\"filename\":\"languagefilter\"}', '{}', '', NULL, NULL, '1', '0', NULL, '1'),
('424', '0', 'plg_system_cache', 'plugin', 'cache', '', 'system', '0', '0', '1', '0', '{\"name\":\"plg_system_cache\",\"type\":\"plugin\",\"creationDate\":\"2007-02\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2007 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_CACHE_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\System\\\\Cache\",\"filename\":\"cache\"}', '{\"browsercache\":\"0\",\"cachetime\":\"15\"}', '', NULL, NULL, '9', '0', NULL, '1'),
('425', '0', 'plg_system_debug', 'plugin', 'debug', '', 'system', '0', '0', '1', '0', '{\"name\":\"plg_system_debug\",\"type\":\"plugin\",\"creationDate\":\"2006-12\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_DEBUG_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\System\\\\Debug\",\"filename\":\"debug\"}', '{\"profile\":\"1\",\"queries\":\"1\",\"memory\":\"1\",\"language_files\":\"1\",\"language_strings\":\"1\",\"strip-first\":\"1\",\"strip-prefix\":\"\",\"strip-suffix\":\"\"}', '', NULL, NULL, '4', '0', NULL, '1'),
('426', '0', 'plg_system_log', 'plugin', 'log', '', 'system', '0', '1', '1', '0', '{\"name\":\"plg_system_log\",\"type\":\"plugin\",\"creationDate\":\"2007-04\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2007 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_LOG_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\System\\\\Log\",\"filename\":\"log\"}', '{}', '', NULL, NULL, '5', '0', NULL, '1'),
('427', '0', 'plg_system_redirect', 'plugin', 'redirect', '', 'system', '0', '1', '1', '0', '{\"name\":\"plg_system_redirect\",\"type\":\"plugin\",\"creationDate\":\"2009-04\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2009 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_SYSTEM_REDIRECT_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\System\\\\Redirect\",\"filename\":\"redirect\"}', '{}', '', NULL, NULL, '6', '0', NULL, '1'),
('428', '0', 'plg_system_remember', 'plugin', 'remember', '', 'system', '0', '1', '1', '0', '{\"name\":\"plg_system_remember\",\"type\":\"plugin\",\"creationDate\":\"2007-04\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2007 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_REMEMBER_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\System\\\\Remember\",\"filename\":\"remember\"}', '{}', '', NULL, NULL, '7', '0', NULL, '1'),
('429', '0', 'plg_system_sef', 'plugin', 'sef', '', 'system', '0', '1', '1', '0', '{\"name\":\"plg_system_sef\",\"type\":\"plugin\",\"creationDate\":\"2007-12\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2007 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_SEF_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\System\\\\Sef\",\"filename\":\"sef\"}', '{}', '', NULL, NULL, '8', '0', NULL, '1'),
('430', '0', 'plg_system_logout', 'plugin', 'logout', '', 'system', '0', '1', '1', '0', '{\"name\":\"plg_system_logout\",\"type\":\"plugin\",\"creationDate\":\"2009-04\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2009 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_SYSTEM_LOGOUT_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\System\\\\Logout\",\"filename\":\"logout\"}', '{}', '', NULL, NULL, '3', '0', NULL, '1'),
('431', '0', 'plg_user_contactcreator', 'plugin', 'contactcreator', '', 'user', '0', '0', '1', '0', '{\"name\":\"plg_user_contactcreator\",\"type\":\"plugin\",\"creationDate\":\"2009-08\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2009 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_CONTACTCREATOR_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\User\\\\ContactCreator\",\"filename\":\"contactcreator\"}', '{\"autowebpage\":\"\",\"category\":\"34\",\"autopublish\":\"0\"}', '', NULL, NULL, '1', '0', NULL, '1'),
('432', '0', 'plg_user_joomla', 'plugin', 'joomla', '', 'user', '0', '1', '1', '0', '{\"name\":\"plg_user_joomla\",\"type\":\"plugin\",\"creationDate\":\"2006-12\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_USER_JOOMLA_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\User\\\\Joomla\",\"filename\":\"joomla\"}', '{\"autoregister\":\"1\"}', '', NULL, NULL, '2', '0', NULL, '1'),
('433', '0', 'plg_user_profile', 'plugin', 'profile', '', 'user', '0', '0', '1', '0', '{\"name\":\"plg_user_profile\",\"type\":\"plugin\",\"creationDate\":\"2008-01\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2008 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_USER_PROFILE_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\User\\\\Profile\",\"filename\":\"profile\"}', '{\"register-require_address1\":\"1\",\"register-require_address2\":\"1\",\"register-require_city\":\"1\",\"register-require_region\":\"1\",\"register-require_country\":\"1\",\"register-require_postal_code\":\"1\",\"register-require_phone\":\"1\",\"register-require_website\":\"1\",\"register-require_favoritebook\":\"1\",\"register-require_aboutme\":\"1\",\"register-require_tos\":\"1\",\"register-require_dob\":\"1\",\"profile-require_address1\":\"1\",\"profile-require_address2\":\"1\",\"profile-require_city\":\"1\",\"profile-require_region\":\"1\",\"profile-require_country\":\"1\",\"profile-require_postal_code\":\"1\",\"profile-require_phone\":\"1\",\"profile-require_website\":\"1\",\"profile-require_favoritebook\":\"1\",\"profile-require_aboutme\":\"1\",\"profile-require_tos\":\"1\",\"profile-require_dob\":\"1\"}', '', NULL, NULL, '0', '0', NULL, '1'),
('434', '0', 'plg_extension_joomla', 'plugin', 'joomla', '', 'extension', '0', '1', '1', '0', '{\"name\":\"plg_extension_joomla\",\"type\":\"plugin\",\"creationDate\":\"2010-05\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2010 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_EXTENSION_JOOMLA_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Extension\\\\Joomla\",\"filename\":\"joomla\"}', '{}', '', NULL, NULL, '1', '0', NULL, '1'),
('435', '0', 'plg_content_joomla', 'plugin', 'joomla', '', 'content', '0', '1', '1', '0', '{\"name\":\"plg_content_joomla\",\"type\":\"plugin\",\"creationDate\":\"2010-11\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2010 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_CONTENT_JOOMLA_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Content\\\\Joomla\",\"filename\":\"joomla\"}', '{}', '', NULL, NULL, '0', '0', NULL, '1'),
('436', '0', 'plg_system_languagecode', 'plugin', 'languagecode', '', 'system', '0', '0', '1', '0', '{\"name\":\"plg_system_languagecode\",\"type\":\"plugin\",\"creationDate\":\"2011-11\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2011 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_SYSTEM_LANGUAGECODE_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\System\\\\LanguageCode\",\"filename\":\"languagecode\"}', '{}', '', NULL, NULL, '10', '0', NULL, '1'),
('437', '0', 'plg_quickicon_joomlaupdate', 'plugin', 'joomlaupdate', '', 'quickicon', '0', '1', '1', '0', '{\"name\":\"plg_quickicon_joomlaupdate\",\"type\":\"plugin\",\"creationDate\":\"2011-08\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2011 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_QUICKICON_JOOMLAUPDATE_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Quickicon\\\\Joomlaupdate\",\"filename\":\"joomlaupdate\"}', '{}', '', NULL, NULL, '0', '0', NULL, '1'),
('438', '0', 'plg_quickicon_extensionupdate', 'plugin', 'extensionupdate', '', 'quickicon', '0', '1', '1', '0', '{\"name\":\"plg_quickicon_extensionupdate\",\"type\":\"plugin\",\"creationDate\":\"2011-08\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2011 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_QUICKICON_EXTENSIONUPDATE_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Quickicon\\\\Extensionupdate\",\"filename\":\"extensionupdate\"}', '{}', '', NULL, NULL, '0', '0', NULL, '1'),
('440', '0', 'plg_system_highlight', 'plugin', 'highlight', '', 'system', '0', '1', '1', '0', '{\"name\":\"plg_system_highlight\",\"type\":\"plugin\",\"creationDate\":\"2011-08\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2011 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_SYSTEM_HIGHLIGHT_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\System\\\\Highlight\",\"filename\":\"highlight\"}', '{}', '', NULL, NULL, '7', '0', NULL, '1'),
('441', '0', 'plg_content_finder', 'plugin', 'finder', '', 'content', '0', '0', '1', '0', '{\"name\":\"plg_content_finder\",\"type\":\"plugin\",\"creationDate\":\"2011-12\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2011 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_CONTENT_FINDER_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Content\\\\Finder\",\"filename\":\"finder\"}', '{}', '', NULL, NULL, '0', '0', NULL, '1'),
('442', '0', 'plg_finder_categories', 'plugin', 'categories', '', 'finder', '0', '1', '1', '0', '{\"name\":\"plg_finder_categories\",\"type\":\"plugin\",\"creationDate\":\"2011-08\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2011 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_FINDER_CATEGORIES_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Finder\\\\Categories\",\"filename\":\"categories\"}', '{}', '', NULL, NULL, '1', '0', NULL, '1'),
('443', '0', 'plg_finder_contacts', 'plugin', 'contacts', '', 'finder', '0', '1', '1', '0', '{\"name\":\"plg_finder_contacts\",\"type\":\"plugin\",\"creationDate\":\"2011-08\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2011 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_FINDER_CONTACTS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Finder\\\\Contacts\",\"filename\":\"contacts\"}', '{}', '', NULL, NULL, '2', '0', NULL, '1'),
('444', '0', 'plg_finder_content', 'plugin', 'content', '', 'finder', '0', '1', '1', '0', '{\"name\":\"plg_finder_content\",\"type\":\"plugin\",\"creationDate\":\"2011-08\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2011 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_FINDER_CONTENT_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Finder\\\\Content\",\"filename\":\"content\"}', '{}', '', NULL, NULL, '3', '0', NULL, '1'),
('445', '0', 'plg_finder_newsfeeds', 'plugin', 'newsfeeds', '', 'finder', '0', '1', '1', '0', '{\"name\":\"plg_finder_newsfeeds\",\"type\":\"plugin\",\"creationDate\":\"2011-08\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2011 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_FINDER_NEWSFEEDS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Finder\\\\Newsfeeds\",\"filename\":\"newsfeeds\"}', '{}', '', NULL, NULL, '4', '0', NULL, '1'),
('447', '0', 'plg_finder_tags', 'plugin', 'tags', '', 'finder', '0', '1', '1', '0', '{\"name\":\"plg_finder_tags\",\"type\":\"plugin\",\"creationDate\":\"2013-02\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2013 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_FINDER_TAGS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Finder\\\\Tags\",\"filename\":\"tags\"}', '{}', '', NULL, NULL, '0', '0', NULL, '1'),
('449', '0', 'plg_authentication_cookie', 'plugin', 'cookie', '', 'authentication', '0', '1', '1', '0', '{\"name\":\"plg_authentication_cookie\",\"type\":\"plugin\",\"creationDate\":\"2013-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2013 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_AUTHENTICATION_COOKIE_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Authentication\\\\Cookie\",\"filename\":\"cookie\"}', '{}', '', NULL, NULL, '0', '0', NULL, '1'),
('453', '0', 'plg_editors-xtd_module', 'plugin', 'module', '', 'editors-xtd', '0', '1', '1', '0', '{\"name\":\"plg_editors-xtd_module\",\"type\":\"plugin\",\"creationDate\":\"2015-10\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2015 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.5.0\",\"description\":\"PLG_MODULE_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\EditorsXtd\\\\Module\",\"filename\":\"module\"}', '', '', NULL, NULL, '0', '0', NULL, '1'),
('454', '0', 'plg_system_stats', 'plugin', 'stats', '', 'system', '0', '0', '1', '0', '{\"name\":\"plg_system_stats\",\"type\":\"plugin\",\"creationDate\":\"2013-11\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2013 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.5.0\",\"description\":\"PLG_SYSTEM_STATS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\System\\\\Stats\",\"filename\":\"stats\"}', '{\"mode\":3,\"lastrun\":1761044733,\"unique_id\":\"0c2f96b4deae9f8ae9a512e1497d3280346b6af8\",\"interval\":12}', '', NULL, NULL, '0', '0', NULL, '1'),
('455', '0', 'plg_installer_packageinstaller', 'plugin', 'packageinstaller', '', 'installer', '0', '1', '1', '0', '{\"name\":\"plg_installer_packageinstaller\",\"type\":\"plugin\",\"creationDate\":\"2016-05\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.6.0\",\"description\":\"PLG_INSTALLER_PACKAGEINSTALLER_PLUGIN_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Installer\\\\Package\",\"filename\":\"packageinstaller\"}', '', '', NULL, NULL, '1', '0', NULL, '1'),
('456', '0', 'plg_installer_folderinstaller', 'plugin', 'folderinstaller', '', 'installer', '0', '1', '1', '0', '{\"name\":\"plg_installer_folderinstaller\",\"type\":\"plugin\",\"creationDate\":\"2016-05\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.6.0\",\"description\":\"PLG_INSTALLER_FOLDERINSTALLER_PLUGIN_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Installer\\\\Folder\",\"filename\":\"folderinstaller\"}', '', '', NULL, NULL, '2', '0', NULL, '1'),
('457', '0', 'plg_installer_urlinstaller', 'plugin', 'urlinstaller', '', 'installer', '0', '1', '1', '0', '{\"name\":\"plg_installer_urlinstaller\",\"type\":\"plugin\",\"creationDate\":\"2016-05\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.6.0\",\"description\":\"PLG_INSTALLER_URLINSTALLER_PLUGIN_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Installer\\\\Url\",\"filename\":\"urlinstaller\"}', '', '', NULL, NULL, '3', '0', NULL, '1'),
('458', '0', 'plg_quickicon_phpversioncheck', 'plugin', 'phpversioncheck', '', 'quickicon', '0', '1', '1', '0', '{\"name\":\"plg_quickicon_phpversioncheck\",\"type\":\"plugin\",\"creationDate\":\"2016-08\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_QUICKICON_PHPVERSIONCHECK_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Quickicon\\\\PhpVersionCheck\",\"filename\":\"phpversioncheck\"}', '', '', NULL, NULL, '0', '0', NULL, '1'),
('459', '0', 'plg_editors-xtd_menu', 'plugin', 'menu', '', 'editors-xtd', '0', '1', '1', '0', '{\"name\":\"plg_editors-xtd_menu\",\"type\":\"plugin\",\"creationDate\":\"2016-08\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_EDITORS-XTD_MENU_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\EditorsXtd\\\\Menu\",\"filename\":\"menu\"}', '', '', NULL, NULL, '0', '0', NULL, '1'),
('460', '0', 'plg_editors-xtd_contact', 'plugin', 'contact', '', 'editors-xtd', '0', '1', '1', '0', '{\"name\":\"plg_editors-xtd_contact\",\"type\":\"plugin\",\"creationDate\":\"2016-10\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_EDITORS-XTD_CONTACT_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\EditorsXtd\\\\Contact\",\"filename\":\"contact\"}', '', '', NULL, NULL, '0', '0', NULL, '1'),
('461', '0', 'plg_system_fields', 'plugin', 'fields', '', 'system', '0', '1', '1', '0', '{\"name\":\"plg_system_fields\",\"type\":\"plugin\",\"creationDate\":\"2016-03\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_SYSTEM_FIELDS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\System\\\\Fields\",\"filename\":\"fields\"}', '', '', NULL, NULL, '0', '0', NULL, '1'),
('462', '0', 'plg_fields_calendar', 'plugin', 'calendar', '', 'fields', '0', '1', '1', '0', '{\"name\":\"plg_fields_calendar\",\"type\":\"plugin\",\"creationDate\":\"2016-03\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_CALENDAR_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Fields\\\\Calendar\",\"filename\":\"calendar\"}', '', '', NULL, NULL, '0', '0', NULL, '1'),
('463', '0', 'plg_fields_checkboxes', 'plugin', 'checkboxes', '', 'fields', '0', '1', '1', '0', '{\"name\":\"plg_fields_checkboxes\",\"type\":\"plugin\",\"creationDate\":\"2016-03\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_CHECKBOXES_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Fields\\\\Checkboxes\",\"filename\":\"checkboxes\"}', '', '', NULL, NULL, '0', '0', NULL, '1'),
('464', '0', 'plg_fields_color', 'plugin', 'color', '', 'fields', '0', '1', '1', '0', '{\"name\":\"plg_fields_color\",\"type\":\"plugin\",\"creationDate\":\"2016-03\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_COLOR_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Fields\\\\Color\",\"filename\":\"color\"}', '', '', NULL, NULL, '0', '0', NULL, '1'),
('465', '0', 'plg_fields_editor', 'plugin', 'editor', '', 'fields', '0', '1', '1', '0', '{\"name\":\"plg_fields_editor\",\"type\":\"plugin\",\"creationDate\":\"2016-03\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_EDITOR_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Fields\\\\Editor\",\"filename\":\"editor\"}', '', '', NULL, NULL, '0', '0', NULL, '1'),
('466', '0', 'plg_fields_imagelist', 'plugin', 'imagelist', '', 'fields', '0', '1', '1', '0', '{\"name\":\"plg_fields_imagelist\",\"type\":\"plugin\",\"creationDate\":\"2016-03\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_IMAGELIST_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Fields\\\\Imagelist\",\"filename\":\"imagelist\"}', '', '', NULL, NULL, '0', '0', NULL, '1'),
('467', '0', 'plg_fields_integer', 'plugin', 'integer', '', 'fields', '0', '1', '1', '0', '{\"name\":\"plg_fields_integer\",\"type\":\"plugin\",\"creationDate\":\"2016-03\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_INTEGER_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Fields\\\\Integer\",\"filename\":\"integer\"}', '{\"multiple\":\"0\",\"first\":\"1\",\"last\":\"100\",\"step\":\"1\"}', '', NULL, NULL, '0', '0', NULL, '1'),
('468', '0', 'plg_fields_list', 'plugin', 'list', '', 'fields', '0', '1', '1', '0', '{\"name\":\"plg_fields_list\",\"type\":\"plugin\",\"creationDate\":\"2016-03\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_LIST_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Fields\\\\ListField\",\"filename\":\"list\"}', '', '', NULL, NULL, '0', '0', NULL, '1'),
('469', '0', 'plg_fields_media', 'plugin', 'media', '', 'fields', '0', '1', '1', '0', '{\"name\":\"plg_fields_media\",\"type\":\"plugin\",\"creationDate\":\"2016-03\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_MEDIA_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Fields\\\\Media\",\"filename\":\"media\"}', '', '', NULL, NULL, '0', '0', NULL, '1'),
('470', '0', 'plg_fields_radio', 'plugin', 'radio', '', 'fields', '0', '1', '1', '0', '{\"name\":\"plg_fields_radio\",\"type\":\"plugin\",\"creationDate\":\"2016-03\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_RADIO_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Fields\\\\Radio\",\"filename\":\"radio\"}', '', '', NULL, NULL, '0', '0', NULL, '1'),
('471', '0', 'plg_fields_sql', 'plugin', 'sql', '', 'fields', '0', '1', '1', '0', '{\"name\":\"plg_fields_sql\",\"type\":\"plugin\",\"creationDate\":\"2016-03\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_SQL_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Fields\\\\SQL\",\"filename\":\"sql\"}', '', '', NULL, NULL, '0', '0', NULL, '1'),
('472', '0', 'plg_fields_text', 'plugin', 'text', '', 'fields', '0', '1', '1', '0', '{\"name\":\"plg_fields_text\",\"type\":\"plugin\",\"creationDate\":\"2016-03\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_TEXT_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Fields\\\\Text\",\"filename\":\"text\"}', '', '', NULL, NULL, '0', '0', NULL, '1'),
('473', '0', 'plg_fields_textarea', 'plugin', 'textarea', '', 'fields', '0', '1', '1', '0', '{\"name\":\"plg_fields_textarea\",\"type\":\"plugin\",\"creationDate\":\"2016-03\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_TEXTAREA_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Fields\\\\Textarea\",\"filename\":\"textarea\"}', '', '', NULL, NULL, '0', '0', NULL, '1'),
('474', '0', 'plg_fields_url', 'plugin', 'url', '', 'fields', '0', '1', '1', '0', '{\"name\":\"plg_fields_url\",\"type\":\"plugin\",\"creationDate\":\"2016-03\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_URL_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Fields\\\\Url\",\"filename\":\"url\"}', '', '', NULL, NULL, '0', '0', NULL, '1'),
('475', '0', 'plg_fields_user', 'plugin', 'user', '', 'fields', '0', '1', '1', '0', '{\"name\":\"plg_fields_user\",\"type\":\"plugin\",\"creationDate\":\"2016-03\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_USER_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Fields\\\\User\",\"filename\":\"user\"}', '', '', NULL, NULL, '0', '0', NULL, '1'),
('476', '0', 'plg_fields_usergrouplist', 'plugin', 'usergrouplist', '', 'fields', '0', '1', '1', '0', '{\"name\":\"plg_fields_usergrouplist\",\"type\":\"plugin\",\"creationDate\":\"2016-03\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_USERGROUPLIST_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Fields\\\\UsergroupList\",\"filename\":\"usergrouplist\"}', '', '', NULL, NULL, '0', '0', NULL, '1'),
('477', '0', 'plg_content_fields', 'plugin', 'fields', '', 'content', '0', '1', '1', '0', '{\"name\":\"plg_content_fields\",\"type\":\"plugin\",\"creationDate\":\"2017-02\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2017 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_CONTENT_FIELDS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Content\\\\Fields\",\"filename\":\"fields\"}', '', '', NULL, NULL, '0', '0', NULL, '1'),
('478', '0', 'plg_editors-xtd_fields', 'plugin', 'fields', '', 'editors-xtd', '0', '1', '1', '0', '{\"name\":\"plg_editors-xtd_fields\",\"type\":\"plugin\",\"creationDate\":\"2017-02\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2017 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_EDITORS-XTD_FIELDS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\EditorsXtd\\\\Fields\",\"filename\":\"fields\"}', '', '', NULL, NULL, '0', '0', NULL, '1'),
('479', '0', 'plg_sampledata_blog', 'plugin', 'blog', '', 'sampledata', '0', '0', '1', '0', '{\"name\":\"plg_sampledata_blog\",\"type\":\"plugin\",\"creationDate\":\"2017-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2017 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.8.0\",\"description\":\"PLG_SAMPLEDATA_BLOG_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\SampleData\\\\Blog\",\"filename\":\"blog\"}', '', '', NULL, NULL, '0', '0', NULL, '1'),
('482', '0', 'plg_content_confirmconsent', 'plugin', 'confirmconsent', '', 'content', '0', '0', '1', '0', '{\"name\":\"plg_content_confirmconsent\",\"type\":\"plugin\",\"creationDate\":\"2018-05\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2018 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"PLG_CONTENT_CONFIRMCONSENT_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Content\\\\ConfirmConsent\",\"filename\":\"confirmconsent\"}', '{}', '', NULL, NULL, '0', '0', NULL, '1'),
('483', '0', 'plg_system_actionlogs', 'plugin', 'actionlogs', '', 'system', '0', '0', '1', '0', '{\"name\":\"plg_system_actionlogs\",\"type\":\"plugin\",\"creationDate\":\"2018-05\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2018 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"PLG_SYSTEM_ACTIONLOGS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\System\\\\ActionLogs\",\"filename\":\"actionlogs\"}', '{}', '', NULL, NULL, '0', '0', NULL, '1'),
('484', '0', 'plg_actionlog_joomla', 'plugin', 'joomla', '', 'actionlog', '0', '1', '1', '0', '{\"name\":\"plg_actionlog_joomla\",\"type\":\"plugin\",\"creationDate\":\"2018-05\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2018 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"PLG_ACTIONLOG_JOOMLA_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Actionlog\\\\Joomla\",\"filename\":\"joomla\"}', '{}', '', NULL, NULL, '0', '0', NULL, '1'),
('485', '0', 'plg_system_privacyconsent', 'plugin', 'privacyconsent', '', 'system', '0', '0', '1', '0', '{\"name\":\"plg_system_privacyconsent\",\"type\":\"plugin\",\"creationDate\":\"2018-04\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2018 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"PLG_SYSTEM_PRIVACYCONSENT_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\System\\\\PrivacyConsent\",\"filename\":\"privacyconsent\"}', '{}', '', NULL, NULL, '0', '0', NULL, '1'),
('487', '0', 'plg_privacy_user', 'plugin', 'user', '', 'privacy', '0', '1', '1', '0', '{\"name\":\"plg_privacy_user\",\"type\":\"plugin\",\"creationDate\":\"2018-05\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2018 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"PLG_PRIVACY_USER_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Privacy\\\\User\",\"filename\":\"user\"}', '{}', '', NULL, NULL, '0', '0', NULL, '1'),
('488', '0', 'plg_quickicon_privacycheck', 'plugin', 'privacycheck', '', 'quickicon', '0', '1', '1', '0', '{\"name\":\"plg_quickicon_privacycheck\",\"type\":\"plugin\",\"creationDate\":\"2018-06\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2018 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"PLG_QUICKICON_PRIVACYCHECK_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Quickicon\\\\PrivacyCheck\",\"filename\":\"privacycheck\"}', '{}', '', NULL, NULL, '0', '0', NULL, '1'),
('489', '0', 'plg_user_terms', 'plugin', 'terms', '', 'user', '0', '0', '1', '0', '{\"name\":\"plg_user_terms\",\"type\":\"plugin\",\"creationDate\":\"2018-06\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2018 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"PLG_USER_TERMS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\User\\\\Terms\",\"filename\":\"terms\"}', '{}', '', NULL, NULL, '0', '0', NULL, '1'),
('490', '0', 'plg_privacy_contact', 'plugin', 'contact', '', 'privacy', '0', '1', '1', '0', '{\"name\":\"plg_privacy_contact\",\"type\":\"plugin\",\"creationDate\":\"2018-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2018 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"PLG_PRIVACY_CONTACT_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Privacy\\\\Contact\",\"filename\":\"contact\"}', '{}', '', NULL, NULL, '0', '0', NULL, '1'),
('491', '0', 'plg_privacy_content', 'plugin', 'content', '', 'privacy', '0', '1', '1', '0', '{\"name\":\"plg_privacy_content\",\"type\":\"plugin\",\"creationDate\":\"2018-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2018 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"PLG_PRIVACY_CONTENT_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Privacy\\\\Content\",\"filename\":\"content\"}', '{}', '', NULL, NULL, '0', '0', NULL, '1'),
('492', '0', 'plg_privacy_message', 'plugin', 'message', '', 'privacy', '0', '1', '1', '0', '{\"name\":\"plg_privacy_message\",\"type\":\"plugin\",\"creationDate\":\"2018-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2018 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"PLG_PRIVACY_MESSAGE_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Privacy\\\\Message\",\"filename\":\"message\"}', '{}', '', NULL, NULL, '0', '0', NULL, '1'),
('493', '0', 'plg_privacy_actionlogs', 'plugin', 'actionlogs', '', 'privacy', '0', '1', '1', '0', '{\"name\":\"plg_privacy_actionlogs\",\"type\":\"plugin\",\"creationDate\":\"2018-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2018 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"PLG_PRIVACY_ACTIONLOGS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Privacy\\\\Actionlogs\",\"filename\":\"actionlogs\"}', '{}', '', NULL, NULL, '0', '0', NULL, '1'),
('494', '0', 'plg_captcha_recaptcha_invisible', 'plugin', 'recaptcha_invisible', NULL, 'captcha', '0', '0', '1', '0', '{\"name\":\"plg_captcha_recaptcha_invisible\",\"type\":\"plugin\",\"creationDate\":\"2017-11\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2017 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.8\",\"description\":\"PLG_CAPTCHA_RECAPTCHA_INVISIBLE_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Captcha\\\\InvisibleReCaptcha\",\"filename\":\"recaptcha_invisible\"}', '{\"public_key\":\"\",\"private_key\":\"\",\"theme\":\"clean\"}', '', NULL, NULL, '0', '0', NULL, '0'),
('495', '0', 'plg_privacy_consents', 'plugin', 'consents', '', 'privacy', '0', '1', '1', '0', '{\"name\":\"plg_privacy_consents\",\"type\":\"plugin\",\"creationDate\":\"2018-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2018 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"PLG_PRIVACY_CONSENTS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Privacy\\\\Consents\",\"filename\":\"consents\"}', '{}', '', NULL, NULL, '0', '0', NULL, '1'),
('600', '802', 'English (en-GB)', 'language', 'en-GB', '', '', '0', '1', '1', '1', '{\"name\":\"English (en-GB)\",\"type\":\"language\",\"creationDate\":\"2025-10\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"6.0.0\",\"description\":\"en-GB site language\",\"group\":\"\",\"changelogurl\":\"\"}', '', '', NULL, NULL, '0', '0', NULL, '1'),
('601', '802', 'English (en-GB)', 'language', 'en-GB', '', '', '1', '1', '1', '1', '{\"name\":\"English (en-GB)\",\"type\":\"language\",\"creationDate\":\"2025-10\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"6.0.0\",\"description\":\"en-GB administrator language\",\"group\":\"\",\"changelogurl\":\"\"}', '', '', NULL, NULL, '0', '0', NULL, '1'),
('700', '0', 'files_joomla', 'file', 'joomla', '', '', '0', '1', '1', '1', '{\"name\":\"files_joomla\",\"type\":\"file\",\"creationDate\":\"2025-10\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"6.0.0\",\"description\":\"FILES_JOOMLA_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\"}', '', '', NULL, NULL, '0', '0', NULL, '1'),
('802', '0', 'English (en-GB) Language Pack', 'package', 'pkg_en-GB', '', '', '0', '1', '1', '1', '{\"name\":\"English (en-GB) Language Pack\",\"type\":\"package\",\"creationDate\":\"2025-10\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"6.0.0.1\",\"description\":\"en-GB language pack\",\"group\":\"\",\"changelogurl\":\"\",\"filename\":\"pkg_en-GB\"}', '', '', NULL, NULL, '0', '0', NULL, '1'),
('10006', '0', 'PKG_JOOMLA', 'package', 'pkg_joomla', NULL, '', '0', '1', '1', '1', '{\"legacy\":false,\"name\":\"PKG_JOOMLA\",\"type\":\"package\",\"creationDate\":\"2006\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2012 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"http:\\/\\/www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"PKG_JOOMLA_XML_DESCRIPTION\",\"group\":\"\"}', '', '', NULL, NULL, '0', '0', NULL, '0'),
('10214', '0', 'F0F (NEW) DO NOT REMOVE', 'library', 'lib_f0f', NULL, '', '0', '1', '1', '0', '{\"name\":\"F0F (NEW) DO NOT REMOVE\",\"type\":\"library\",\"creationDate\":\"2016-04-01\",\"author\":\"Nicholas K. Dionysopoulos \\/ Akeeba Ltd\",\"copyright\":\"(C)2011-2014 Nicholas K. Dionysopoulos\",\"authorEmail\":\"nicholas@akeebabackup.com\",\"authorUrl\":\"https:\\/\\/www.akeebabackup.com\",\"version\":\"revAA17947\",\"description\":\"Framework-on-Framework (FOF) newer version - DO NOT REMOVE - The rapid component development framework for Joomla!. This package is the newer version of FOF, not the one shipped with Joomla! as the official Joomla! RAD Layer. The Joomla! RAD Layer has ceased development in March 2014. DO NOT UNINSTALL THIS PACKAGE, IT IS *** N O T *** A DUPLICATE OF THE \'FOF\' PACKAGE. REMOVING EITHER FOF PACKAGE WILL BREAK YOUR SITE.\",\"group\":\"\",\"filename\":\"lib_f0f\"}', '{}', '', NULL, NULL, '0', '0', NULL, '0'),
('10232', '0', 'Retainful - Next order coupon', 'plugin', 'app_retainfulcoupon', NULL, 'j2store', '0', '0', '1', '0', '{\"name\":\"Retainful - Next order coupon\",\"type\":\"plugin\",\"creationDate\":\"JAN 2019\",\"author\":\"Sathyaseelan\",\"copyright\":\"2019 Cartrabbit Technologies\",\"authorEmail\":\"supports@j2store.org\",\"authorUrl\":\"http:\\/\\/www.j2store.org\",\"version\":\"1.0.1\",\"description\":\"PLG_J2STORE_APP_NEXTORDERCOUPON_DESC\",\"group\":\"\",\"filename\":\"app_retainfulcoupon\"}', '{\"retainful_app_id\":\"\",\"verify\":\"\",\"coupon_payment_status\":\"4\",\"coupon_amount\":\"\",\"is_retainful_connected\":\"0\",\"coupon_type\":\"0\",\"apply_coupon_to\":\"0\",\"coupon_message\":\"\"}', '', NULL, NULL, '0', '0', NULL, '0'),
('10248', '0', 'F0F (NEW) DO NOT REMOVE', 'library', 'f0f', NULL, '', '0', '1', '1', '0', '{\"name\":\"F0F (NEW) DO NOT REMOVE\",\"type\":\"library\",\"creationDate\":\"2016-04-01\",\"author\":\"Nicholas K. Dionysopoulos \\/ Akeeba Ltd\",\"copyright\":\"(C)2011-2014 Nicholas K. Dionysopoulos\",\"authorEmail\":\"nicholas@akeebabackup.com\",\"authorUrl\":\"https:\\/\\/www.akeebabackup.com\",\"version\":\"revAA17947\",\"description\":\"Framework-on-Framework (FOF) newer version - DO NOT REMOVE - The rapid component development framework for Joomla!. This package is the newer version of FOF, not the one shipped with Joomla! as the official Joomla! RAD Layer. The Joomla! RAD Layer has ceased development in March 2014. DO NOT UNINSTALL THIS PACKAGE, IT IS *** N O T *** A DUPLICATE OF THE \'FOF\' PACKAGE. REMOVING EITHER FOF PACKAGE WILL BREAK YOUR SITE.\",\"group\":\"\",\"filename\":\"lib_f0f\"}', '{}', '', NULL, NULL, '0', '0', NULL, '0'),
('10250', '10257', 'plg_system_gantry5', 'plugin', 'gantry5', '', 'system', '0', '1', '1', '0', '{\"name\":\"plg_system_gantry5\",\"type\":\"plugin\",\"creationDate\":\"September 15, 2025\",\"author\":\"Tiger12, LLC\",\"copyright\":\"(C) 2005 - 2021 Tiger12, LLC. All rights reserved.\",\"authorEmail\":\"gantry@tiger12.com\",\"authorUrl\":\"http:\\/\\/tiger12.com\",\"version\":\"5.5.25\",\"description\":\"PLG_SYSTEM_GANTRY5_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"filename\":\"gantry5\"}', '{\"production\":0,\"use_assignments\":\"1\",\"use_media_folder\":\"0\",\"asset_timestamps\":\"1\",\"asset_timestamps_period\":\"7\",\"compile_yaml\":\"1\",\"compile_twig\":\"1\"}', '', NULL, NULL, '0', '0', NULL, '0'),
('10251', '10257', 'plg_quickicon_gantry5', 'plugin', 'gantry5', '', 'quickicon', '0', '1', '1', '0', '{\"name\":\"plg_quickicon_gantry5\",\"type\":\"plugin\",\"creationDate\":\"September 15, 2025\",\"author\":\"Tiger12, LLC\",\"copyright\":\"(C) 2005 - 2021 Tiger12, LLC. All rights reserved.\",\"authorEmail\":\"gantry@tiger12.com\",\"authorUrl\":\"http:\\/\\/tiger12.com\",\"version\":\"5.5.25\",\"description\":\"PLG_QUICKICON_GANTRY5_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"filename\":\"gantry5\"}', '{\"context\":\"mod_quickicon\"}', '', NULL, NULL, '0', '0', NULL, '0'),
('10252', '10257', 'plg_gantry5_preset', 'plugin', 'preset', '', 'gantry5', '0', '1', '1', '0', '{\"name\":\"plg_gantry5_preset\",\"type\":\"plugin\",\"creationDate\":\"September 15, 2025\",\"author\":\"Tiger12, LLC\",\"copyright\":\"(C) 2005 - 2021 Tiger12, LLC. All rights reserved.\",\"authorEmail\":\"gantry@tiger12.com\",\"authorUrl\":\"http:\\/\\/tiger12.com\",\"version\":\"5.5.25\",\"description\":\"PLG_GANTRY5_PRESET_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"filename\":\"preset\"}', '{\"preset\":\"presets\",\"reset\":\"reset-settings\"}', '', NULL, NULL, '0', '0', NULL, '0'),
('10253', '10257', 'mod_gantry5_particle', 'module', 'mod_gantry5_particle', '', '', '0', '1', '0', '0', '{\"name\":\"mod_gantry5_particle\",\"type\":\"module\",\"creationDate\":\"September 15, 2025\",\"author\":\"Tiger12, LLC\",\"copyright\":\"(C) 2005 - 2022 Tiger12, LLC. All rights reserved.\",\"authorEmail\":\"gantry@tiger12.com\",\"authorUrl\":\"http:\\/\\/tiger12.com\",\"version\":\"5.5.25\",\"description\":\"MOD_GANTRY5_PARTICLE_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"filename\":\"mod_gantry5_particle\"}', '{\"owncache\":\"0\",\"cache_time\":\"900\"}', '', NULL, NULL, '0', '0', NULL, '0'),
('10255', '10257', 'gantry5_nucleus', 'file', 'gantry5_nucleus', NULL, '', '0', '1', '0', '0', '{\"name\":\"gantry5_nucleus\",\"type\":\"file\",\"creationDate\":\"September 15, 2025\",\"author\":\"Tiger12, LLC\",\"copyright\":\"(C) 2005 - 2021 Tiger12, LLC. All rights reserved.\",\"authorEmail\":\"gantry@tiger12.com\",\"authorUrl\":\"http:\\/\\/tiger12.com\",\"version\":\"5.5.25\",\"description\":\"GANTRY5_NUCLEUS_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\"}', '', '', NULL, NULL, '0', '0', NULL, '0'),
('10256', '10257', 'com_gantry5', 'component', 'com_gantry5', '', '', '1', '1', '0', '0', '{\"name\":\"com_gantry5\",\"type\":\"component\",\"creationDate\":\"September 15, 2025\",\"author\":\"Tiger12, LLC\",\"copyright\":\"(C) 2005 - 2021 Tiger12, LLC. All rights reserved.\",\"authorEmail\":\"gantry@tiger12.com\",\"authorUrl\":\"http:\\/\\/tiger12.com\",\"version\":\"5.5.25\",\"description\":\"COM_GANTRY5_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"filename\":\"gantry5\"}', '{}', '', NULL, NULL, '0', '0', NULL, '0'),
('10257', '0', 'pkg_gantry5', 'package', 'pkg_gantry5', '', '', '0', '1', '1', '0', '{\"name\":\"pkg_gantry5\",\"type\":\"package\",\"creationDate\":\"September 15, 2025\",\"author\":\"Tiger12, LLC\",\"copyright\":\"(C) 2005 - 2021 Tiger12, LLC. All rights reserved.\",\"authorEmail\":\"gantry@tiger12.com\",\"authorUrl\":\"http:\\/\\/tiger12.com\",\"version\":\"5.5.25\",\"description\":\"PKG_GANTRY5_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"filename\":\"pkg_gantry5\"}', '{}', '', NULL, NULL, '0', '0', NULL, '0'),
('10276', '0', 'plg_behaviour_taggable', 'plugin', 'taggable', '', 'behaviour', '0', '1', '1', '0', '{\"name\":\"plg_behaviour_taggable\",\"type\":\"plugin\",\"creationDate\":\"2015-08\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_BEHAVIOUR_TAGGABLE_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Behaviour\\\\Taggable\",\"filename\":\"taggable\"}', '{}', '', NULL, NULL, '0', '0', NULL, '1'),
('10277', '0', 'plg_behaviour_versionable', 'plugin', 'versionable', '', 'behaviour', '0', '1', '1', '0', '{\"name\":\"plg_behaviour_versionable\",\"type\":\"plugin\",\"creationDate\":\"2015-08\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_BEHAVIOUR_VERSIONABLE_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Behaviour\\\\Versionable\",\"filename\":\"versionable\"}', '{}', '', NULL, NULL, '0', '0', NULL, '1'),
('10278', '0', 'atum', 'template', 'atum', '', '', '1', '1', '1', '0', '{\"name\":\"atum\",\"type\":\"template\",\"creationDate\":\"2016-09\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"\",\"version\":\"1.0\",\"description\":\"TPL_ATUM_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"inheritable\":true,\"filename\":\"templateDetails\"}', '{}', '', NULL, NULL, '0', '0', NULL, '1'),
('10279', '0', 'cassiopeia', 'template', 'cassiopeia', '', '', '0', '1', '1', '0', '{\"name\":\"cassiopeia\",\"type\":\"template\",\"creationDate\":\"2017-02\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2017 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"\",\"version\":\"1.0\",\"description\":\"TPL_CASSIOPEIA_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"inheritable\":true,\"filename\":\"templateDetails\"}', '{}', '', NULL, NULL, '0', '0', NULL, '1'),
('10280', '0', 'plg_filesystem_local', 'plugin', 'local', '', 'filesystem', '0', '1', '1', '0', '{\"name\":\"plg_filesystem_local\",\"type\":\"plugin\",\"creationDate\":\"2017-04\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2017 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_FILESYSTEM_LOCAL_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Filesystem\\\\Local\",\"filename\":\"local\"}', '{}', '', NULL, NULL, '0', '0', NULL, '1'),
('10281', '0', 'plg_media-action_crop', 'plugin', 'crop', '', 'media-action', '0', '1', '1', '0', '{\"name\":\"plg_media-action_crop\",\"type\":\"plugin\",\"creationDate\":\"2017-01\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2017 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_MEDIA-ACTION_CROP_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\MediaAction\\\\Crop\",\"filename\":\"crop\"}', '{}', '', NULL, NULL, '0', '0', NULL, '1'),
('10282', '0', 'plg_media-action_resize', 'plugin', 'resize', '', 'media-action', '0', '1', '1', '0', '{\"name\":\"plg_media-action_resize\",\"type\":\"plugin\",\"creationDate\":\"2017-01\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2017 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_MEDIA-ACTION_RESIZE_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\MediaAction\\\\Resize\",\"filename\":\"resize\"}', '{}', '', NULL, NULL, '0', '0', NULL, '1'),
('10283', '0', 'plg_media-action_rotate', 'plugin', 'rotate', '', 'media-action', '0', '1', '1', '0', '{\"name\":\"plg_media-action_rotate\",\"type\":\"plugin\",\"creationDate\":\"2017-01\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2017 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_MEDIA-ACTION_ROTATE_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\MediaAction\\\\Rotate\",\"filename\":\"rotate\"}', '{}', '', NULL, NULL, '0', '0', NULL, '1'),
('10284', '0', 'plg_system_httpheaders', 'plugin', 'httpheaders', '', 'system', '0', '0', '1', '0', '{\"name\":\"plg_system_httpheaders\",\"type\":\"plugin\",\"creationDate\":\"2017-10\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2018 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_SYSTEM_HTTPHEADERS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\System\\\\Httpheaders\",\"filename\":\"httpheaders\"}', '{}', '', NULL, NULL, '0', '0', NULL, '1'),
('10285', '0', 'com_workflow', 'component', 'com_workflow', '', '', '1', '1', '0', '1', '{\"name\":\"com_workflow\",\"type\":\"component\",\"creationDate\":\"2017-06\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2018 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_WORKFLOW_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Workflow\"}', '{}', '', NULL, NULL, '0', '0', NULL, '1'),
('10286', '0', 'plg_workflow_publishing', 'plugin', 'publishing', '', 'workflow', '0', '1', '1', '0', '{\"name\":\"plg_workflow_publishing\",\"type\":\"plugin\",\"creationDate\":\"2020-03\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2020 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_WORKFLOW_PUBLISHING_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Workflow\\\\Publishing\",\"filename\":\"publishing\"}', '{}', '', NULL, NULL, '0', '0', NULL, '0'),
('10287', '0', 'plg_workflow_featuring', 'plugin', 'featuring', '', 'workflow', '0', '1', '1', '0', '{\"name\":\"plg_workflow_featuring\",\"type\":\"plugin\",\"creationDate\":\"2020-03\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2020 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_WORKFLOW_FEATURING_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Workflow\\\\Featuring\",\"filename\":\"featuring\"}', '{}', '', NULL, NULL, '0', '0', NULL, '0'),
('10288', '0', 'plg_workflow_notification', 'plugin', 'notification', '', 'workflow', '0', '1', '1', '0', '{\"name\":\"plg_workflow_notification\",\"type\":\"plugin\",\"creationDate\":\"2020-05\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2020 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_WORKFLOW_NOTIFICATION_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Workflow\\\\Notification\",\"filename\":\"notification\"}', '{}', '', NULL, NULL, '0', '0', NULL, '0'),
('10289', '0', 'plg_extension_namespacemap', 'plugin', 'namespacemap', '', 'extension', '0', '1', '1', '1', '{\"name\":\"plg_extension_namespacemap\",\"type\":\"plugin\",\"creationDate\":\"2017-05\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2017 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_EXTENSION_NAMESPACEMAP_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Extension\\\\NamespaceMap\",\"filename\":\"namespacemap\"}', '', '', NULL, NULL, '0', '0', NULL, '1'),
('10290', '0', 'plg_installer_override', 'plugin', 'override', '', 'installer', '0', '1', '1', '0', '{\"name\":\"plg_installer_override\",\"type\":\"plugin\",\"creationDate\":\"2018-06\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2018 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_INSTALLER_OVERRIDE_PLUGIN_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Installer\\\\Override\",\"filename\":\"override\"}', '', '', NULL, NULL, '4', '0', NULL, '1'),
('10291', '0', 'plg_quickicon_overridecheck', 'plugin', 'overridecheck', '', 'quickicon', '0', '1', '1', '0', '{\"name\":\"plg_quickicon_overridecheck\",\"type\":\"plugin\",\"creationDate\":\"2018-06\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2018 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_QUICKICON_OVERRIDECHECK_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Quickicon\\\\OverrideCheck\",\"filename\":\"overridecheck\"}', '', '', NULL, NULL, '0', '0', NULL, '1'),
('10292', '0', 'plg_extension_finder', 'plugin', 'finder', '', 'extension', '0', '1', '1', '0', '{\"name\":\"plg_extension_finder\",\"type\":\"plugin\",\"creationDate\":\"2018-06\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_EXTENSION_FINDER_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Extension\\\\Finder\",\"filename\":\"finder\"}', '', '', NULL, NULL, '0', '0', NULL, '1'),
('10293', '0', 'plg_api-authentication_basic', 'plugin', 'basic', '', 'api-authentication', '0', '0', '1', '0', '{\"name\":\"plg_api-authentication_basic\",\"type\":\"plugin\",\"creationDate\":\"2005-11\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_API-AUTHENTICATION_BASIC_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\ApiAuthentication\\\\Basic\",\"filename\":\"basic\"}', '{}', '', NULL, NULL, '0', '0', NULL, '1'),
('10294', '0', 'plg_webservices_content', 'plugin', 'content', '', 'webservices', '0', '1', '1', '0', '{\"name\":\"plg_webservices_content\",\"type\":\"plugin\",\"creationDate\":\"2019-09\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_WEBSERVICES_CONTENT_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\WebServices\\\\Content\",\"filename\":\"content\"}', '{}', '', NULL, NULL, '0', '0', NULL, '1'),
('10295', '0', 'com_mails', 'component', 'com_mails', '', '', '1', '1', '1', '1', '{\"name\":\"com_mails\",\"type\":\"component\",\"creationDate\":\"2019-01\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_MAILS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Mails\"}', '{}', '', NULL, NULL, '0', '0', NULL, '1'),
('10296', '0', 'plg_system_skipto', 'plugin', 'skipto', '', 'system', '0', '1', '1', '0', '{\"name\":\"plg_system_skipto\",\"type\":\"plugin\",\"creationDate\":\"2020-02\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_SYSTEM_SKIPTO_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\System\\\\Skipto\",\"filename\":\"skipto\"}', '{}', '', NULL, NULL, '0', '0', NULL, '1'),
('10297', '0', 'plg_sampledata_multilang', 'plugin', 'multilang', '', 'sampledata', '0', '1', '1', '0', '{\"name\":\"plg_sampledata_multilang\",\"type\":\"plugin\",\"creationDate\":\"2018-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2018 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_SAMPLEDATA_MULTILANG_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\SampleData\\\\MultiLanguage\",\"filename\":\"multilang\"}', '{}', '', NULL, NULL, '0', '0', NULL, '1'),
('10298', '0', 'plg_installer_webinstaller', 'plugin', 'webinstaller', '', 'installer', '0', '0', '1', '0', '{\"name\":\"plg_installer_webinstaller\",\"type\":\"plugin\",\"creationDate\":\"2017-04\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2018 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_INSTALLER_WEBINSTALLER_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Installer\\\\Web\",\"filename\":\"webinstaller\"}', '{}', '', NULL, NULL, '0', '0', NULL, '1'),
('10299', '0', 'plg_fields_subform', 'plugin', 'subform', '', 'fields', '0', '1', '1', '0', '{\"name\":\"plg_fields_subform\",\"type\":\"plugin\",\"creationDate\":\"2017-06\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_FIELDS_SUBFORM_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Fields\\\\Subform\",\"filename\":\"subform\"}', '', '', NULL, NULL, '0', '0', NULL, '1'),
('10300', '0', 'plg_system_webauthn', 'plugin', 'webauthn', '', 'system', '0', '0', '1', '0', '{\"name\":\"plg_system_webauthn\",\"type\":\"plugin\",\"creationDate\":\"2019-07-02\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2020 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_SYSTEM_WEBAUTHN_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\System\\\\Webauthn\",\"filename\":\"webauthn\"}', '{}', '', NULL, NULL, '0', '0', NULL, '1'),
('10301', '0', 'mod_loginsupport', 'module', 'mod_loginsupport', '', '', '1', '1', '1', '0', '{\"name\":\"mod_loginsupport\",\"type\":\"module\",\"creationDate\":\"2019-06\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"MOD_LOGINSUPPORT_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\Loginsupport\",\"filename\":\"mod_loginsupport\"}', '', '', NULL, NULL, '0', '0', NULL, '1'),
('10302', '0', 'mod_frontend', 'module', 'mod_frontend', '', '', '1', '1', '1', '0', '{\"name\":\"mod_frontend\",\"type\":\"module\",\"creationDate\":\"2019-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"MOD_FRONTEND_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\Frontend\",\"filename\":\"mod_frontend\"}', '', '', NULL, NULL, '0', '0', NULL, '1'),
('10303', '0', 'mod_messages', 'module', 'mod_messages', '', '', '1', '1', '1', '0', '{\"name\":\"mod_messages\",\"type\":\"module\",\"creationDate\":\"2019-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"MOD_MESSAGES_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\Messages\",\"filename\":\"mod_messages\"}', '', '', NULL, NULL, '0', '0', NULL, '1'),
('10304', '0', 'mod_post_installation_messages', 'module', 'mod_post_installation_messages', '', '', '1', '1', '1', '0', '{\"name\":\"mod_post_installation_messages\",\"type\":\"module\",\"creationDate\":\"2019-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"MOD_POST_INSTALLATION_MESSAGES_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\PostInstallationMessages\",\"filename\":\"mod_post_installation_messages\"}', '', '', NULL, NULL, '0', '0', NULL, '1'),
('10305', '0', 'mod_user', 'module', 'mod_user', '', '', '1', '1', '1', '0', '{\"name\":\"mod_user\",\"type\":\"module\",\"creationDate\":\"2019-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"MOD_USER_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\User\",\"filename\":\"mod_user\"}', '', '', NULL, NULL, '0', '0', NULL, '1'),
('10306', '0', 'mod_submenu', 'module', 'mod_submenu', '', '', '1', '1', '1', '0', '{\"name\":\"mod_submenu\",\"type\":\"module\",\"creationDate\":\"2006-02\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_SUBMENU_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\Submenu\",\"filename\":\"mod_submenu\"}', '{}', '', NULL, NULL, '0', '0', NULL, '1'),
('10307', '0', 'mod_privacy_status', 'module', 'mod_privacy_status', '', '', '1', '1', '1', '0', '{\"name\":\"mod_privacy_status\",\"type\":\"module\",\"creationDate\":\"2019-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"MOD_PRIVACY_STATUS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\PrivacyStatus\",\"filename\":\"mod_privacy_status\"}', '{}', '', NULL, NULL, '0', '0', NULL, '1'),
('10308', '0', 'plg_webservices_banners', 'plugin', 'banners', '', 'webservices', '0', '1', '1', '0', '{\"name\":\"plg_webservices_banners\",\"type\":\"plugin\",\"creationDate\":\"2019-09\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_WEBSERVICES_BANNERS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\WebServices\\\\Banners\",\"filename\":\"banners\"}', '{}', '', NULL, NULL, '0', '0', NULL, '1'),
('10309', '0', 'plg_webservices_config', 'plugin', 'config', '', 'webservices', '0', '1', '1', '0', '{\"name\":\"plg_webservices_config\",\"type\":\"plugin\",\"creationDate\":\"2019-09\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_WEBSERVICES_CONFIG_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\WebServices\\\\Config\",\"filename\":\"config\"}', '{}', '', NULL, NULL, '0', '0', NULL, '1'),
('10310', '0', 'plg_webservices_contact', 'plugin', 'contact', '', 'webservices', '0', '1', '1', '0', '{\"name\":\"plg_webservices_contact\",\"type\":\"plugin\",\"creationDate\":\"2019-09\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_WEBSERVICES_CONTACT_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\WebServices\\\\Contact\",\"filename\":\"contact\"}', '{}', '', NULL, NULL, '0', '0', NULL, '1'),
('10311', '0', 'plg_webservices_languages', 'plugin', 'languages', '', 'webservices', '0', '1', '1', '0', '{\"name\":\"plg_webservices_languages\",\"type\":\"plugin\",\"creationDate\":\"2019-09\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_WEBSERVICES_LANGUAGES_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\WebServices\\\\Languages\",\"filename\":\"languages\"}', '{}', '', NULL, NULL, '0', '0', NULL, '1');/**ABDB**/
/**ABDB**/INSERT INTO `#__extensions`  VALUES 
('10312', '0', 'plg_webservices_menus', 'plugin', 'menus', '', 'webservices', '0', '1', '1', '0', '{\"name\":\"plg_webservices_menus\",\"type\":\"plugin\",\"creationDate\":\"2019-09\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_WEBSERVICES_MENUS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\WebServices\\\\Menus\",\"filename\":\"menus\"}', '{}', '', NULL, NULL, '0', '0', NULL, '1'),
('10313', '0', 'plg_webservices_messages', 'plugin', 'messages', '', 'webservices', '0', '1', '1', '0', '{\"name\":\"plg_webservices_messages\",\"type\":\"plugin\",\"creationDate\":\"2019-09\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_WEBSERVICES_MESSAGES_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\WebServices\\\\Messages\",\"filename\":\"messages\"}', '{}', '', NULL, NULL, '0', '0', NULL, '1'),
('10314', '0', 'plg_webservices_modules', 'plugin', 'modules', '', 'webservices', '0', '1', '1', '0', '{\"name\":\"plg_webservices_modules\",\"type\":\"plugin\",\"creationDate\":\"2019-09\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_WEBSERVICES_MODULES_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\WebServices\\\\Modules\",\"filename\":\"modules\"}', '{}', '', NULL, NULL, '0', '0', NULL, '1'),
('10315', '0', 'plg_webservices_newsfeeds', 'plugin', 'newsfeeds', '', 'webservices', '0', '1', '1', '0', '{\"name\":\"plg_webservices_newsfeeds\",\"type\":\"plugin\",\"creationDate\":\"2019-09\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_WEBSERVICES_NEWSFEEDS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\WebServices\\\\Newsfeeds\",\"filename\":\"newsfeeds\"}', '{}', '', NULL, NULL, '0', '0', NULL, '1'),
('10316', '0', 'plg_webservices_plugins', 'plugin', 'plugins', '', 'webservices', '0', '1', '1', '0', '{\"name\":\"plg_webservices_plugins\",\"type\":\"plugin\",\"creationDate\":\"2019-09\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_WEBSERVICES_PLUGINS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\WebServices\\\\Plugins\",\"filename\":\"plugins\"}', '{}', '', NULL, NULL, '0', '0', NULL, '1'),
('10317', '0', 'plg_webservices_privacy', 'plugin', 'privacy', '', 'webservices', '0', '1', '1', '0', '{\"name\":\"plg_webservices_privacy\",\"type\":\"plugin\",\"creationDate\":\"2019-09\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_WEBSERVICES_PRIVACY_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\WebServices\\\\Privacy\",\"filename\":\"privacy\"}', '{}', '', NULL, NULL, '0', '0', NULL, '1'),
('10318', '0', 'plg_webservices_redirect', 'plugin', 'redirect', '', 'webservices', '0', '1', '1', '0', '{\"name\":\"plg_webservices_redirect\",\"type\":\"plugin\",\"creationDate\":\"2019-09\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_WEBSERVICES_REDIRECT_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\WebServices\\\\Redirect\",\"filename\":\"redirect\"}', '{}', '', NULL, NULL, '0', '0', NULL, '1'),
('10319', '0', 'plg_webservices_tags', 'plugin', 'tags', '', 'webservices', '0', '1', '1', '0', '{\"name\":\"plg_webservices_tags\",\"type\":\"plugin\",\"creationDate\":\"2019-09\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_WEBSERVICES_TAGS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\WebServices\\\\Tags\",\"filename\":\"tags\"}', '{}', '', NULL, NULL, '0', '0', NULL, '1'),
('10320', '0', 'plg_webservices_templates', 'plugin', 'templates', '', 'webservices', '0', '1', '1', '0', '{\"name\":\"plg_webservices_templates\",\"type\":\"plugin\",\"creationDate\":\"2019-09\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_WEBSERVICES_TEMPLATES_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\WebServices\\\\Templates\",\"filename\":\"templates\"}', '{}', '', NULL, NULL, '0', '0', NULL, '1'),
('10321', '0', 'plg_webservices_users', 'plugin', 'users', '', 'webservices', '0', '1', '1', '0', '{\"name\":\"plg_webservices_users\",\"type\":\"plugin\",\"creationDate\":\"2019-09\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_WEBSERVICES_USERS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\WebServices\\\\Users\",\"filename\":\"users\"}', '{}', '', NULL, NULL, '0', '0', NULL, '1'),
('10322', '0', 'plg_webservices_installer', 'plugin', 'installer', '', 'webservices', '0', '1', '1', '0', '{\"name\":\"plg_webservices_installer\",\"type\":\"plugin\",\"creationDate\":\"2020-06\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2020 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_WEBSERVICES_INSTALLER_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\WebServices\\\\Installer\",\"filename\":\"installer\"}', '{}', '', NULL, NULL, '0', '0', NULL, '0'),
('10323', '0', 'plg_user_token', 'plugin', 'token', '', 'user', '0', '1', '1', '0', '{\"name\":\"plg_user_token\",\"type\":\"plugin\",\"creationDate\":\"2019-11\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2020 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"PLG_USER_TOKEN_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\User\\\\Token\",\"filename\":\"token\"}', '{}', '', NULL, NULL, '0', '0', NULL, '1'),
('10324', '0', 'plg_api-authentication_token', 'plugin', 'token', '', 'api-authentication', '0', '1', '1', '0', '{\"name\":\"plg_api-authentication_token\",\"type\":\"plugin\",\"creationDate\":\"2019-11\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2020 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_API-AUTHENTICATION_TOKEN_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\ApiAuthentication\\\\Token\",\"filename\":\"token\"}', '{}', '', NULL, NULL, '0', '0', NULL, '1'),
('10325', '0', 'plg_system_accessibility', 'plugin', 'accessibility', '', 'system', '0', '0', '1', '0', '{\"name\":\"plg_system_accessibility\",\"type\":\"plugin\",\"creationDate\":\"2020-02-15\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2020 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_SYSTEM_ACCESSIBILITY_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\System\\\\Accessibility\",\"filename\":\"accessibility\"}', '{}', '', NULL, NULL, '0', '0', NULL, '1'),
('10326', '802', 'English (en-GB)', 'language', 'en-GB', '', '', '3', '1', '1', '1', '{\"name\":\"English (en-GB)\",\"type\":\"language\",\"creationDate\":\"2025-10\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2020 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"6.0.0\",\"description\":\"en-GB api language\",\"group\":\"\",\"changelogurl\":\"\"}', '', '', NULL, NULL, '0', '0', NULL, '1'),
('10327', '0', 'plg_quickicon_downloadkey', 'plugin', 'downloadkey', '', 'quickicon', '0', '1', '1', '0', '{\"name\":\"plg_quickicon_downloadkey\",\"type\":\"plugin\",\"creationDate\":\"2019-10\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_QUICKICON_DOWNLOADKEY_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Quickicon\\\\Downloadkey\",\"filename\":\"downloadkey\"}', '', '', NULL, NULL, '0', '0', NULL, '1'),
('10336', '10338', 'com_akeebabackup', 'component', 'com_akeebabackup', '', '', '1', '1', '0', '0', '{\"name\":\"com_akeebabackup\",\"type\":\"component\",\"creationDate\":\"2025-10-13\",\"author\":\"Akeeba Ltd\",\"copyright\":\"Copyright (c)2006-2025 Akeeba Ltd \\/ Nicholas K. Dionysopoulos\",\"authorEmail\":\"no-reply@akeeba.com\",\"authorUrl\":\"www.akeeba.com\",\"version\":\"10.1.0\",\"description\":\"COM_AKEEBABACKUP_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Akeeba\\\\Component\\\\AkeebaBackup\",\"filename\":\"akeebabackup\"}', '{\"frontend_secret_word\":\"###AES128###lNXgJ7cazdKa8DUS11B7ZEpQU1RxWJ9dp4mL0R4xmfP3DOR4UdIttEN3Br0nBnPkfKnOs38bsi9HgQ0q6\\/U2bbpfKLIpn6zfNfIXWZla9nsLe7HPSlBJVhW1sdvW8sPAyuRIueRxoA8AAAAA\",\"confwiz_upgrade\":1,\"siteurl\":\"http:\\/\\/localhost\\/besto\\/\",\"jlibrariesdir\":\"\\/Users\\/phongto\\/Sites\\/besto\\/libraries\",\"show_howtorestoremodal\":0}', '', NULL, NULL, '0', '0', NULL, '0'),
('10337', '10338', 'PLG_QUICKICON_AKEEBABACKUP', 'plugin', 'akeebabackup', '', 'quickicon', '0', '1', '1', '0', '{\"name\":\"PLG_QUICKICON_AKEEBABACKUP\",\"type\":\"plugin\",\"creationDate\":\"2025-10-13\",\"author\":\"Nicholas K. Dionysopoulos\",\"copyright\":\"Copyright (c)2006-2025 Akeeba Ltd \\/ Nicholas K. Dionysopoulos\",\"authorEmail\":\"nicholas@dionysopoulos.me\",\"authorUrl\":\"https:\\/\\/www.akeeba.com\",\"version\":\"10.1.0\",\"description\":\"PLG_QUICKICON_AKEEBABACKUP_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Akeeba\\\\Plugin\\\\QuickIcon\\\\AkeebaBackup\",\"filename\":\"akeebabackup\"}', '{\"enablewarning\":\"1\",\"warnfailed\":\"1\",\"maxbackupperiod\":\"24\",\"profileid\":\"1\"}', '', NULL, NULL, '0', '0', NULL, '0'),
('10338', '0', 'pkg_akeebabackup', 'package', 'pkg_akeebabackup', '', '', '0', '1', '1', '0', '{\"name\":\"pkg_akeebabackup\",\"type\":\"package\",\"creationDate\":\"2025-10-13\",\"author\":\"Nicholas K. Dionysopoulos\",\"copyright\":\"Copyright (c)2006-2025 Nicholas K. Dionysopoulos \\/ Akeeba Ltd\",\"authorEmail\":\"\",\"authorUrl\":\"\",\"version\":\"10.1.0\",\"description\":\"PKG_AKEEBABACKUP_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"filename\":\"pkg_akeebabackup\"}', '{}', '', NULL, NULL, '0', '0', NULL, '0'),
('10341', '0', 'plg_system_nrframework', 'plugin', 'nrframework', '', 'system', '0', '1', '1', '0', '{\"name\":\"plg_system_nrframework\",\"type\":\"plugin\",\"creationDate\":\"August 2016\",\"author\":\"Tassos Marinos\",\"copyright\":\"Copyright \\u00a9 2025 Tassos All Rights Reserved\",\"authorEmail\":\"info@tassos.gr\",\"authorUrl\":\"http:\\/\\/www.tassos.gr\",\"version\":\"6.0.15\",\"description\":\"PLG_SYSTEM_NRFRAMEWORK_DESC\",\"group\":\"\",\"changelogurl\":\"\",\"filename\":\"nrframework\"}', '[]', '', NULL, NULL, '0', '0', NULL, '0'),
('10359', '0', 'com_scheduler', 'component', 'com_scheduler', '', '', '1', '1', '1', '0', '{\"name\":\"com_scheduler\",\"type\":\"component\",\"creationDate\":\"2021-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2021 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.1.0\",\"description\":\"COM_SCHEDULER_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Scheduler\"}', '{}', '', NULL, NULL, '0', '0', NULL, '1'),
('10360', '0', 'plg_system_schedulerunner', 'plugin', 'schedulerunner', '', 'system', '0', '1', '1', '0', '{\"name\":\"plg_system_schedulerunner\",\"type\":\"plugin\",\"creationDate\":\"2021-08\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2021 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.1\",\"description\":\"PLG_SYSTEM_SCHEDULERUNNER_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\System\\\\ScheduleRunner\",\"filename\":\"schedulerunner\"}', '{}', '', NULL, NULL, '15', '0', NULL, '1'),
('10361', '0', 'plg_system_task_notification', 'plugin', 'tasknotification', '', 'system', '0', '1', '1', '0', '{\"name\":\"plg_system_task_notification\",\"type\":\"plugin\",\"creationDate\":\"2021-09\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2021 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.1\",\"description\":\"PLG_SYSTEM_TASK_NOTIFICATION_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\System\\\\TaskNotification\",\"filename\":\"tasknotification\"}', '', '', NULL, NULL, '22', '0', NULL, '1'),
('10362', '0', 'plg_task_check_files', 'plugin', 'checkfiles', '', 'task', '0', '1', '1', '0', '{\"name\":\"plg_task_check_files\",\"type\":\"plugin\",\"creationDate\":\"2021-08\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2021 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.1\",\"description\":\"PLG_TASK_CHECK_FILES_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Task\\\\Checkfiles\",\"filename\":\"checkfiles\"}', '{}', '', NULL, NULL, '15', '0', NULL, '1'),
('10364', '0', 'plg_task_requests', 'plugin', 'requests', '', 'task', '0', '1', '1', '0', '{\"name\":\"plg_task_requests\",\"type\":\"plugin\",\"creationDate\":\"2021-08\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2021 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.1\",\"description\":\"PLG_TASK_REQUESTS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Task\\\\Requests\",\"filename\":\"requests\"}', '{}', '', NULL, NULL, '15', '0', NULL, '1'),
('10365', '0', 'plg_task_site_status', 'plugin', 'sitestatus', '', 'task', '0', '1', '1', '0', '{\"name\":\"plg_task_site_status\",\"type\":\"plugin\",\"creationDate\":\"2021-08\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2021 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.1\",\"description\":\"PLG_TASK_SITE_STATUS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Task\\\\SiteStatus\",\"filename\":\"sitestatus\"}', '{}', '', NULL, NULL, '15', '0', NULL, '1'),
('10366', '0', 'plg_system_jooa11y', 'plugin', 'jooa11y', '', 'system', '0', '1', '1', '0', '{\"name\":\"plg_system_jooa11y\",\"type\":\"plugin\",\"creationDate\":\"2022-02\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2021 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.2.0\",\"description\":\"PLG_SYSTEM_JOOA11Y_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\System\\\\Jooa11y\",\"filename\":\"jooa11y\"}', '', '', NULL, NULL, '0', '0', NULL, '1'),
('10367', '0', 'plg_webservices_media', 'plugin', 'media', '', 'webservices', '0', '1', '1', '0', '{\"name\":\"plg_webservices_media\",\"type\":\"plugin\",\"creationDate\":\"2021-05\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2021 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.1.0\",\"description\":\"PLG_WEBSERVICES_MEDIA_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\WebServices\\\\Media\",\"filename\":\"media\"}', '{}', '', NULL, NULL, '0', '0', NULL, '1'),
('10378', '0', 'plg_multifactorauth_totp', 'plugin', 'totp', '', 'multifactorauth', '0', '0', '1', '0', '{\"name\":\"plg_multifactorauth_totp\",\"type\":\"plugin\",\"creationDate\":\"2013-08\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2013 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.2.0\",\"description\":\"PLG_MULTIFACTORAUTH_TOTP_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Multifactorauth\\\\Totp\",\"filename\":\"totp\"}', '', '', NULL, NULL, '1', '0', NULL, '1'),
('10379', '0', 'plg_multifactorauth_yubikey', 'plugin', 'yubikey', '', 'multifactorauth', '0', '0', '1', '0', '{\"name\":\"plg_multifactorauth_yubikey\",\"type\":\"plugin\",\"creationDate\":\"2013-09\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2013 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.2.0\",\"description\":\"PLG_MULTIFACTORAUTH_YUBIKEY_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Multifactorauth\\\\Yubikey\",\"filename\":\"yubikey\"}', '', '', NULL, NULL, '2', '0', NULL, '1'),
('10380', '0', 'plg_multifactorauth_webauthn', 'plugin', 'webauthn', '', 'multifactorauth', '0', '0', '1', '0', '{\"name\":\"plg_multifactorauth_webauthn\",\"type\":\"plugin\",\"creationDate\":\"2022-05\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2022 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.2.0\",\"description\":\"PLG_MULTIFACTORAUTH_WEBAUTHN_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Multifactorauth\\\\Webauthn\",\"filename\":\"webauthn\"}', '', '', NULL, NULL, '3', '0', NULL, '1'),
('10381', '0', 'plg_multifactorauth_email', 'plugin', 'email', '', 'multifactorauth', '0', '0', '1', '0', '{\"name\":\"plg_multifactorauth_email\",\"type\":\"plugin\",\"creationDate\":\"2022-05\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2022 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.2.0\",\"description\":\"PLG_MULTIFACTORAUTH_EMAIL_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Multifactorauth\\\\Email\",\"filename\":\"email\"}', '', '', NULL, NULL, '4', '0', NULL, '1'),
('10382', '0', 'plg_multifactorauth_fixed', 'plugin', 'fixed', '', 'multifactorauth', '0', '0', '1', '0', '{\"name\":\"plg_multifactorauth_fixed\",\"type\":\"plugin\",\"creationDate\":\"2022-05\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2022 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.2.0\",\"description\":\"PLG_MULTIFACTORAUTH_FIXED_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Multifactorauth\\\\Fixed\",\"filename\":\"fixed\"}', '', '', NULL, NULL, '5', '0', NULL, '1'),
('10383', '0', 'plg_system_shortcut', 'plugin', 'shortcut', '', 'system', '0', '1', '1', '0', '{\"name\":\"plg_system_shortcut\",\"type\":\"plugin\",\"creationDate\":\"2022-06\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2022 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.2.0\",\"description\":\"PLG_SYSTEM_SHORTCUT_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\System\\\\Shortcut\",\"filename\":\"shortcut\"}', '', '', NULL, NULL, '0', '0', NULL, '1'),
('10388', '0', 'com_guidedtours', 'component', 'com_guidedtours', '', '', '1', '1', '0', '0', '{\"name\":\"com_guidedtours\",\"type\":\"component\",\"creationDate\":\"2023-02\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2023 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.3.0\",\"description\":\"COM_GUIDEDTOURS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Guidedtours\"}', '{}', '', NULL, NULL, '0', '0', NULL, '1'),
('10389', '0', 'mod_guidedtours', 'module', 'mod_guidedtours', '', '', '1', '1', '1', '0', '{\"name\":\"mod_guidedtours\",\"type\":\"module\",\"creationDate\":\"2023-02\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2023 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.3.0\",\"description\":\"MOD_GUIDEDTOURS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\GuidedTours\",\"filename\":\"mod_guidedtours\"}', '{}', '', NULL, NULL, '0', '0', NULL, '1'),
('10390', '0', 'plg_system_guidedtours', 'plugin', 'guidedtours', '', 'system', '0', '1', '1', '0', '{\"name\":\"plg_system_guidedtours\",\"type\":\"plugin\",\"creationDate\":\"2023-02\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2023 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.3.0\",\"description\":\"PLG_SYSTEM_GUIDEDTOURS_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\System\\\\GuidedTours\",\"filename\":\"guidedtours\"}', '{}', '', NULL, NULL, '0', '0', NULL, '1'),
('10394', '0', 'jl_besto', 'template', 'jl_besto', '', '', '0', '1', '1', '0', '{\"name\":\"jl_besto\",\"type\":\"template\",\"creationDate\":\"October 24, 2025\",\"author\":\"JoomLead\",\"copyright\":\"(C) 2025 JoomLead. All rights reserved.\",\"authorEmail\":\"support@joomlead.com\",\"authorUrl\":\"http:\\/\\/www.joomlead.com\",\"version\":\"2.0.8\",\"description\":\"TPL_JL_BESTO_DESC\",\"group\":\"\",\"changelogurl\":\"\",\"filename\":\"templateDetails\"}', '[]', '', NULL, NULL, '0', '0', NULL, '0'),
('10396', '0', 'COM_CONVERTFORMS', 'component', 'com_convertforms', '', '', '1', '1', '0', '0', '{\"name\":\"COM_CONVERTFORMS\",\"type\":\"component\",\"creationDate\":\"September 2016\",\"author\":\"Tassos Marinos\",\"copyright\":\"Copyright \\u00a9 2025 Tassos All Rights Reserved\",\"authorEmail\":\"info@tassos.gr\",\"authorUrl\":\"http:\\/\\/www.tassos.gr\",\"version\":\"5.0.4\",\"description\":\"COM_CONVERTFORMS_DESC\",\"group\":\"\",\"changelogurl\":\"\",\"filename\":\"convertforms\"}', '{}', '', NULL, NULL, '0', '0', NULL, '0'),
('10397', '0', 'mod_convertforms', 'module', 'mod_convertforms', '', '', '0', '1', '0', '0', '{\"name\":\"mod_convertforms\",\"type\":\"module\",\"creationDate\":\"October 2016\",\"author\":\"Tassos Marinos\",\"copyright\":\"Copyright \\u00a9 2024 Tassos All Rights Reserved\",\"authorEmail\":\"info@tassos.gr\",\"authorUrl\":\"http:\\/\\/www.tassos.gr\",\"version\":\"1.0\",\"description\":\"MOD_CONVERTFORMS_DESC\",\"group\":\"\",\"changelogurl\":\"\",\"filename\":\"mod_convertforms\"}', '{\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"static\"}', '', NULL, NULL, '0', '0', NULL, '0'),
('10398', '0', 'PLG_CONVERTFORMS_ACYMAILING', 'plugin', 'acymailing', '', 'convertforms', '0', '1', '1', '0', '{\"name\":\"PLG_CONVERTFORMS_ACYMAILING\",\"type\":\"plugin\",\"creationDate\":\"November 2015\",\"author\":\"Tassos Marinos\",\"copyright\":\"Copyright (c) 2020 Tassos Marinos\",\"authorEmail\":\"info@tassos.gr\",\"authorUrl\":\"http:\\/\\/www.tassos.gr\",\"version\":\"1.0\",\"description\":\"PLG_CONVERTFORMS_ACYMAILING_DESC\",\"group\":\"\",\"changelogurl\":\"\",\"filename\":\"acymailing\"}', '{}', '', NULL, NULL, '0', '0', NULL, '0'),
('10399', '0', 'PLG_CONVERTFORMS_EMAILS', 'plugin', 'emails', '', 'convertforms', '0', '1', '1', '0', '{\"name\":\"PLG_CONVERTFORMS_EMAILS\",\"type\":\"plugin\",\"creationDate\":\"January 2017\",\"author\":\"Tassos Marinos\",\"copyright\":\"Copyright (c)2011-2016 Tassos Marinos\",\"authorEmail\":\"info@tassos.gr\",\"authorUrl\":\"http:\\/\\/www.tassos.gr\",\"version\":\"1.0\",\"description\":\"PLG_CONVERTFORMS_EMAILS_DESC\",\"group\":\"\",\"changelogurl\":\"\",\"filename\":\"emails\"}', '{}', '', NULL, NULL, '0', '0', NULL, '0'),
('10400', '0', 'PLG_CONVERTFORMS_ERRORLOGGER', 'plugin', 'errorlogger', '', 'convertforms', '0', '1', '1', '0', '{\"name\":\"PLG_CONVERTFORMS_ERRORLOGGER\",\"type\":\"plugin\",\"creationDate\":\"January 2019\",\"author\":\"Tassos Marinos\",\"copyright\":\"Copyright (c) 2011-2019 Tassos Marinos\",\"authorEmail\":\"info@tassos.gr\",\"authorUrl\":\"http:\\/\\/www.tassos.gr\",\"version\":\"1.0\",\"description\":\"PLG_CONVERTFORMS_ERRORLOGGER_DESC\",\"group\":\"\",\"changelogurl\":\"\",\"filename\":\"errorlogger\"}', '{}', '', NULL, NULL, '0', '0', NULL, '0'),
('10401', '0', 'PLG_CONVERTFORMSAPPS_ACYMAILING', 'plugin', 'acymailing', '', 'convertformsapps', '0', '1', '1', '0', '{\"name\":\"PLG_CONVERTFORMSAPPS_ACYMAILING\",\"type\":\"plugin\",\"creationDate\":\"November 2021\",\"author\":\"Tassos Marinos\",\"copyright\":\"Copyright (c)2011-2016 Tassos Marinos\",\"authorEmail\":\"info@tassos.gr\",\"authorUrl\":\"http:\\/\\/www.tassos.gr\",\"version\":\"1.0\",\"description\":\"PLG_CONVERTFORMSAPPS_ACYMAILING_DESC\",\"group\":\"\",\"changelogurl\":\"\",\"filename\":\"acymailing\"}', '{}', '', NULL, NULL, '0', '0', NULL, '0'),
('10402', '0', 'PLG_CONVERTFORMSAPPS_EMAIL', 'plugin', 'email', '', 'convertformsapps', '0', '1', '1', '0', '{\"name\":\"PLG_CONVERTFORMSAPPS_EMAIL\",\"type\":\"plugin\",\"creationDate\":\"May 2022\",\"author\":\"Tassos Marinos\",\"copyright\":\"Copyright (c) 2011-2022 Tassos Marinos\",\"authorEmail\":\"info@tassos.gr\",\"authorUrl\":\"http:\\/\\/www.tassos.gr\",\"version\":\"1.0\",\"description\":\"PLG_CONVERTFORMSAPPS_EMAIL_DESC\",\"group\":\"\",\"changelogurl\":\"\",\"filename\":\"email\"}', '{}', '', NULL, NULL, '0', '0', NULL, '0'),
('10403', '0', 'PLG_CONVERTFORMSTOOLS_CALCULATIONS', 'plugin', 'calculations', '', 'convertformstools', '0', '1', '1', '0', '{\"name\":\"PLG_CONVERTFORMSTOOLS_CALCULATIONS\",\"type\":\"plugin\",\"creationDate\":\"Apr 2019\",\"author\":\"Tassos Marinos (Tassos.gr)\",\"copyright\":\"Copyright \\u00a9 2024 Tassos All Rights Reserved\",\"authorEmail\":\"info@tassos.gr\",\"authorUrl\":\"http:\\/\\/www.tassos.gr\",\"version\":\"1.0\",\"description\":\"PLG_CONVERTFORMSTOOLS_CALCULATIONS_DESC\",\"group\":\"\",\"changelogurl\":\"\",\"filename\":\"calculations\"}', '{}', '', NULL, NULL, '0', '0', NULL, '0'),
('10404', '0', 'PLG_CONVERTFORMSTOOLS_CONDITIONALLOGIC', 'plugin', 'conditionallogic', '', 'convertformstools', '0', '1', '1', '0', '{\"name\":\"PLG_CONVERTFORMSTOOLS_CONDITIONALLOGIC\",\"type\":\"plugin\",\"creationDate\":\"April 2020\",\"author\":\"Tassos Marinos (Tassos.gr)\",\"copyright\":\"Copyright \\u00a9 2024 Tassos All Rights Reserved\",\"authorEmail\":\"info@tassos.gr\",\"authorUrl\":\"http:\\/\\/www.tassos.gr\",\"version\":\"1.0\",\"description\":\"PLG_CONVERTFORMSTOOLS_CONDITIONALLOGIC_DESC\",\"group\":\"\",\"changelogurl\":\"\",\"filename\":\"conditionallogic\"}', '{}', '', NULL, NULL, '0', '0', NULL, '0'),
('10405', '0', 'PLG_CONVERTFORMSTOOLS_PDF', 'plugin', 'pdf', '', 'convertformstools', '0', '1', '1', '0', '{\"name\":\"PLG_CONVERTFORMSTOOLS_PDF\",\"type\":\"plugin\",\"creationDate\":\"February 2020\",\"author\":\"Tassos Marinos (Tassos.gr)\",\"copyright\":\"Copyright \\u00a9 2024 Tassos All Rights Reserved\",\"authorEmail\":\"info@tassos.gr\",\"authorUrl\":\"http:\\/\\/www.tassos.gr\",\"version\":\"1.0\",\"description\":\"PLG_CONVERTFORMSTOOLS_PDF_DESC\",\"group\":\"\",\"changelogurl\":\"\",\"filename\":\"pdf\"}', '{}', '', NULL, NULL, '0', '0', NULL, '0'),
('10406', '0', 'PLG_CONVERTFORMSTOOLS_TASKS', 'plugin', 'tasks', '', 'convertformstools', '0', '1', '1', '0', '{\"name\":\"PLG_CONVERTFORMSTOOLS_TASKS\",\"type\":\"plugin\",\"creationDate\":\"September 2022\",\"author\":\"Tassos Marinos\",\"copyright\":\"Copyright \\u00a9 2024 Tassos All Rights Reserved\",\"authorEmail\":\"info@tassos.gr\",\"authorUrl\":\"http:\\/\\/www.tassos.gr\",\"version\":\"1.0\",\"description\":\"PLG_CONVERTFORMSTOOLS_TASKS_DESC\",\"group\":\"\",\"changelogurl\":\"\",\"filename\":\"tasks\"}', '{}', '', NULL, NULL, '0', '0', NULL, '0'),
('10407', '0', 'PLG_EDITORS-XTD_CONVERTFORMS', 'plugin', 'convertforms', '', 'editors-xtd', '0', '1', '1', '0', '{\"name\":\"PLG_EDITORS-XTD_CONVERTFORMS\",\"type\":\"plugin\",\"creationDate\":\"June 2017\",\"author\":\"Tassos Marinos\",\"copyright\":\"Copyright \\u00a9 2024 Tassos All Rights Reserved\",\"authorEmail\":\"info@tassos.gr\",\"authorUrl\":\"http:\\/\\/www.tassos.gr\",\"version\":\"1.0\",\"description\":\"PLG_EDITORS-XTD_CONVERTFORMS_DESC\",\"group\":\"\",\"changelogurl\":\"\",\"filename\":\"convertforms\"}', '{}', '', NULL, NULL, '0', '0', NULL, '0'),
('10408', '0', 'PLG_SYSTEM_CONVERTFORMS', 'plugin', 'convertforms', '', 'system', '0', '1', '1', '0', '{\"name\":\"PLG_SYSTEM_CONVERTFORMS\",\"type\":\"plugin\",\"creationDate\":\"September 2016\",\"author\":\"Tassos Marinos\",\"copyright\":\"Copyright \\u00a9 2024 Tassos All Rights Reserved\",\"authorEmail\":\"info@tassos.gr\",\"authorUrl\":\"http:\\/\\/www.tassos.gr\",\"version\":\"1.0\",\"description\":\"PLG_SYSTEM_CONVERTFORMS_DESC\",\"group\":\"\",\"changelogurl\":\"\",\"filename\":\"convertforms\"}', '{}', '', NULL, NULL, '0', '0', NULL, '0'),
('10411', '0', 'plg_quickicon_eos', 'plugin', 'eos', '', 'quickicon', '0', '1', '1', '0', '{\"name\":\"plg_quickicon_eos\",\"type\":\"plugin\",\"creationDate\":\"2023-05\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2023 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.4.0\",\"description\":\"PLG_QUICKICON_EOS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Quickicon\\\\Eos\",\"filename\":\"eos\"}', '', '', NULL, NULL, '7', '0', NULL, '1'),
('10416', '0', 'plg_schemaorg_blogposting', 'plugin', 'blogposting', '', 'schemaorg', '0', '1', '1', '0', '{\"name\":\"plg_schemaorg_blogposting\",\"type\":\"plugin\",\"creationDate\":\"2023-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2023 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"5.0.0\",\"description\":\"PLG_SCHEMAORG_BLOGPOSTING_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Schemaorg\\\\BlogPosting\",\"filename\":\"blogposting\"}', '{}', '', NULL, NULL, '1', '0', NULL, '1'),
('10417', '0', 'plg_schemaorg_book', 'plugin', 'book', '', 'schemaorg', '0', '1', '1', '0', '{\"name\":\"plg_schemaorg_book\",\"type\":\"plugin\",\"creationDate\":\"2023-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2023 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"5.0.0\",\"description\":\"PLG_SCHEMAORG_BOOK_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Schemaorg\\\\Book\",\"filename\":\"book\"}', '{}', '', NULL, NULL, '2', '0', NULL, '1'),
('10418', '0', 'plg_schemaorg_event', 'plugin', 'event', '', 'schemaorg', '0', '1', '1', '0', '{\"name\":\"plg_schemaorg_event\",\"type\":\"plugin\",\"creationDate\":\"2023-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2023 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"5.0.0\",\"description\":\"PLG_SCHEMAORG_EVENT_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Schemaorg\\\\Event\",\"filename\":\"event\"}', '{}', '', NULL, NULL, '3', '0', NULL, '1'),
('10419', '0', 'plg_schemaorg_organization', 'plugin', 'organization', '', 'schemaorg', '0', '1', '1', '0', '{\"name\":\"plg_schemaorg_organization\",\"type\":\"plugin\",\"creationDate\":\"2023-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2023 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"5.0.0\",\"description\":\"PLG_SCHEMAORG_ORGANIZATION_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Schemaorg\\\\Organization\",\"filename\":\"organization\"}', '{}', '', NULL, NULL, '4', '0', NULL, '1'),
('10420', '0', 'plg_schemaorg_person', 'plugin', 'person', '', 'schemaorg', '0', '1', '1', '0', '{\"name\":\"plg_schemaorg_person\",\"type\":\"plugin\",\"creationDate\":\"2023-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2023 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"5.0.0\",\"description\":\"PLG_SCHEMAORG_PERSON_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Schemaorg\\\\Person\",\"filename\":\"person\"}', '{}', '', NULL, NULL, '5', '0', NULL, '1'),
('10421', '0', 'plg_schemaorg_recipe', 'plugin', 'recipe', '', 'schemaorg', '0', '1', '1', '0', '{\"name\":\"plg_schemaorg_recipe\",\"type\":\"plugin\",\"creationDate\":\"2023-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2023 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"5.0.0\",\"description\":\"PLG_SCHEMAORG_RECIPE_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Schemaorg\\\\Recipe\",\"filename\":\"recipe\"}', '{}', '', NULL, NULL, '6', '0', NULL, '1'),
('10422', '0', 'plg_schemaorg_jobposting', 'plugin', 'jobposting', '', 'schemaorg', '0', '1', '1', '0', '{\"name\":\"plg_schemaorg_jobposting\",\"type\":\"plugin\",\"creationDate\":\"2023-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2023 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"5.0.0\",\"description\":\"PLG_SCHEMAORG_JOBPOSTING_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Schemaorg\\\\JobPosting\",\"filename\":\"jobposting\"}', '{}', '', NULL, NULL, '7', '0', NULL, '1'),
('10423', '0', 'plg_system_schemaorg', 'plugin', 'schemaorg', '', 'system', '0', '1', '1', '0', '{\"name\":\"plg_system_schemaorg\",\"type\":\"plugin\",\"creationDate\":\"2023-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2023 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"5.0.0\",\"description\":\"PLG_SYSTEM_SCHEMAORG_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\System\\\\Schemaorg\",\"filename\":\"schemaorg\"}', '{}', '', NULL, NULL, '0', '0', NULL, '1'),
('10424', '0', 'plg_task_globalcheckin', 'plugin', 'globalcheckin', '', 'task', '0', '1', '1', '0', '{\"name\":\"plg_task_globalcheckin\",\"type\":\"plugin\",\"creationDate\":\"2023-06-22\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2023 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"5.0.0\",\"description\":\"PLG_TASK_GLOBALCHECKIN_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Task\\\\Globalcheckin\",\"filename\":\"globalcheckin\"}', '{}', '', NULL, NULL, '5', '0', NULL, '1'),
('10425', '0', 'plg_task_deleteactionlogs', 'plugin', 'deleteactionlogs', '', 'task', '0', '1', '1', '0', '{\"name\":\"plg_task_deleteactionlogs\",\"type\":\"plugin\",\"creationDate\":\"2023-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2023 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"5.0.0\",\"description\":\"PLG_TASK_DELETEACTIONLOGS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Task\\\\DeleteActionLogs\",\"filename\":\"deleteactionlogs\"}', '{}', '', NULL, NULL, '0', '0', NULL, '1'),
('10426', '0', 'plg_task_privacyconsent', 'plugin', 'privacyconsent', '', 'task', '0', '1', '1', '0', '{\"name\":\"plg_task_privacyconsent\",\"type\":\"plugin\",\"creationDate\":\"2023-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2023 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"5.0.0\",\"description\":\"PLG_TASK_PRIVACYCONSENT_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Task\\\\PrivacyConsent\",\"filename\":\"privacyconsent\"}', '{}', '', NULL, NULL, '0', '0', NULL, '1'),
('10427', '0', 'plg_task_rotatelogs', 'plugin', 'rotatelogs', '', 'task', '0', '1', '1', '0', '{\"name\":\"plg_task_rotatelogs\",\"type\":\"plugin\",\"creationDate\":\"2023-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2023 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"5.0.0\",\"description\":\"PLG_TASK_ROTATELOGS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Task\\\\RotateLogs\",\"filename\":\"rotatelogs\"}', '{}', '', NULL, NULL, '0', '0', NULL, '1'),
('10428', '0', 'plg_task_sessiongc', 'plugin', 'sessiongc', '', 'task', '0', '1', '1', '0', '{\"name\":\"plg_task_sessiongc\",\"type\":\"plugin\",\"creationDate\":\"2023-08\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2023 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"5.0.0\",\"description\":\"PLG_TASK_SESSIONGC_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Task\\\\SessionGC\",\"filename\":\"sessiongc\"}', '{}', '', NULL, NULL, '0', '0', NULL, '1'),
('10429', '0', 'plg_task_updatenotification', 'plugin', 'updatenotification', '', 'task', '0', '1', '1', '0', '{\"name\":\"plg_task_updatenotification\",\"type\":\"plugin\",\"creationDate\":\"2023-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2023 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"5.0.0\",\"description\":\"PLG_TASK_UPDATENOTIFICATION_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Task\\\\UpdateNotification\",\"filename\":\"updatenotification\"}', '{}', '', NULL, NULL, '0', '0', NULL, '1'),
('10430', '0', 'plg_schemaorg_article', 'plugin', 'article', '', 'schemaorg', '0', '1', '1', '0', '{\"name\":\"plg_schemaorg_article\",\"type\":\"plugin\",\"creationDate\":\"2024-01\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2024 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"5.1.0\",\"description\":\"PLG_SCHEMAORG_ARTICLE_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Schemaorg\\\\Article\",\"filename\":\"article\"}', '{}', '', NULL, NULL, '0', '0', NULL, '1'),
('10431', '0', 'plg_schemaorg_custom', 'plugin', 'custom', '', 'schemaorg', '0', '1', '1', '0', '{\"name\":\"plg_schemaorg_custom\",\"type\":\"plugin\",\"creationDate\":\"2024-03\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2024 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"5.1.0\",\"description\":\"PLG_SCHEMAORG_CUSTOM_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Schemaorg\\\\Custom\",\"filename\":\"custom\"}', '{}', '', NULL, NULL, '0', '0', NULL, '1'),
('10433', '0', 'MOD_ARTICLES', 'module', 'mod_articles', '', '', '0', '1', '0', '0', '{\"name\":\"MOD_ARTICLES\",\"type\":\"module\",\"creationDate\":\"2024-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2024 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"5.2.0\",\"description\":\"MOD_ARTICLES_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\Articles\",\"filename\":\"mod_articles\"}', '', '', NULL, NULL, '0', '0', NULL, '1'),
('10437', '0', 'plg_extension_joomlaupdate', 'plugin', 'joomlaupdate', '', 'extension', '0', '1', '1', '0', '{\"name\":\"plg_extension_joomlaupdate\",\"type\":\"plugin\",\"creationDate\":\"2025-02\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2025 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"1.0.0\",\"description\":\"PLG_EXTENSION_JOOMLAUPDATE_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Extension\\\\Joomlaupdate\",\"filename\":\"joomlaupdate\"}', '', '', NULL, NULL, '0', '0', NULL, '1'),
('10439', '0', 'PLG_CONVERTFORMSTOOLS_EMAILCLOAK', 'plugin', 'emailcloak', '', 'convertformstools', '0', '1', '1', '0', '{\"name\":\"PLG_CONVERTFORMSTOOLS_EMAILCLOAK\",\"type\":\"plugin\",\"creationDate\":\"Apr 2025\",\"author\":\"Tassos Marinos (Tassos.gr)\",\"copyright\":\"Copyright \\u00a9 2025 Tassos All Rights Reserved\",\"authorEmail\":\"info@tassos.gr\",\"authorUrl\":\"http:\\/\\/www.tassos.gr\",\"version\":\"1.0\",\"description\":\"PLG_CONVERTFORMSTOOLS_EMAILCLOAK_DESC\",\"group\":\"\",\"changelogurl\":\"\",\"filename\":\"emailcloak\"}', '{}', '', NULL, NULL, '0', '0', NULL, '0'),
('10440', '10257', 'Gantry 5 Framework', 'library', 'gantry5', '', '', '0', '1', '1', '0', '{\"name\":\"Gantry 5 Framework\",\"type\":\"library\",\"creationDate\":\"September 15, 2025\",\"author\":\"Tiger12, LLC\",\"copyright\":\"(C) 2005 - 2021 Tiger12, LLC. All rights reserved.\",\"authorEmail\":\"gantry@tiger12.com\",\"authorUrl\":\"http:\\/\\/tiger12.com\",\"version\":\"5.5.25\",\"description\":\"LIB_GANTRY5_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"filename\":\"gantry5\"}', '{}', '', NULL, NULL, '0', '0', NULL, '0'),
('10442', '0', 'plg_behaviour_compat6', 'plugin', 'compat6', '', 'behaviour', '0', '1', '1', '0', '{\"name\":\"plg_behaviour_compat6\",\"type\":\"plugin\",\"creationDate\":\"2025-04\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2025 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"6.0.0\",\"description\":\"PLG_COMPAT6_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Behaviour\\\\Compat6\",\"filename\":\"compat6\"}', '{\"classes_aliases\":\"1\",\"legacy_classes\":\"1\"}', '', NULL, NULL, '-1', '0', NULL, '1'),
('10443', '0', 'plg_quickicon_autoupdate', 'plugin', 'autoupdate', '', 'quickicon', '0', '1', '1', '0', '{\"name\":\"plg_quickicon_autoupdate\",\"type\":\"plugin\",\"creationDate\":\"2025-03\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2025 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"5.4.0\",\"description\":\"PLG_QUICKICON_AUTOUPDATE_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Quickicon\\\\Autoupdate\",\"filename\":\"autoupdate\"}', '', '', NULL, NULL, '-1', '0', NULL, '1'),
('10444', '0', 'plg_webservices_joomlaupdate', 'plugin', 'joomlaupdate', '', 'webservices', '0', '1', '1', '0', '{\"name\":\"plg_webservices_joomlaupdate\",\"type\":\"plugin\",\"creationDate\":\"2025-03\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2025 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"5.4.0\",\"description\":\"PLG_WEBSERVICES_JOOMLAUPDATE_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\WebServices\\\\Joomlaupdate\",\"filename\":\"joomlaupdate\"}', '', '', NULL, NULL, '-1', '0', NULL, '1'),
('10445', '0', 'plg_fields_note', 'plugin', 'note', '', 'fields', '0', '1', '1', '0', '{\"name\":\"plg_fields_note\",\"type\":\"plugin\",\"creationDate\":\"2025-03\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2025 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"6.0.0\",\"description\":\"PLG_FIELDS_NOTE_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Fields\\\\Note\",\"filename\":\"note\"}', '{\"class\":\"alert alert-info\",\"heading\":\"h4\"}', '', NULL, NULL, '-1', '0', NULL, '1'),
('10446', '0', 'plg_fields_number', 'plugin', 'number', '', 'fields', '0', '1', '1', '0', '{\"name\":\"plg_fields_number\",\"type\":\"plugin\",\"creationDate\":\"2025-03\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2025 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"6.0.0\",\"description\":\"PLG_FIELDS_NUMBER_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Fields\\\\Number\",\"filename\":\"number\"}', '{\"min\":\"1.0\",\"max\":\"100.0\",\"step\":\"0.1\",\"currency\":\"0\",\"position\":\"0\",\"decimals\":\"2\"}', '', NULL, NULL, '-1', '0', NULL, '1'),
('10447', '0', 'cassiopeia_extended', 'template', 'cassiopeia_extended', '', '', '0', '1', '1', '0', '{\"name\":\"cassiopeia_extended\",\"type\":\"template\",\"creationDate\":\"2017-02\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2017 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"\",\"version\":\"1.0\",\"description\":\"TPL_CASSIOPEIA_EXTENDED_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"inheritable\":false,\"parent\":\"cassiopeia\",\"filename\":\"templateDetails\"}', '{\"brand\":\"1\",\"logoFile\":\"\",\"siteTitle\":\"\",\"siteDescription\":\"\",\"useFontScheme\":\"0\",\"systemFontBody\":\"\",\"systemFontHeading\":\"\",\"colorName\":\"colors_standard\",\"fluidContainer\":\"0\",\"stickyHeader\":\"0\",\"backTop\":\"0\",\"colorSettings\":\"0\",\"headerbg\":\"rgb(193, 205, 207)\",\"headercolor\":\"rgb(23, 23, 23)\",\"bodybg\":\"rgb(254, 254, 254)\",\"bodycolor\":\"rgb(23, 23, 23)\",\"linkcolor\":\"rgb(29, 121, 137)\",\"linkcolorh\":\"rgb(14, 59, 67)\",\"btnbg\":\"rgb(206, 60, 55)\",\"btnbgh\":\"rgb(131, 35, 32)\",\"btncolor\":\"rgb(254, 254, 254)\",\"btncolorh\":\"rgb(254, 254, 254)\",\"footerbg\":\"rgb(29, 121, 137)\",\"footercolor\":\"rgb(254, 254, 254)\",\"fontSettings\":\"0\",\"bodysize\":\"1\",\"h1size\":\"2\",\"h2size\":\"1.7\",\"h3size\":\"1.5\"}', '', NULL, NULL, '0', '0', NULL, '1');
/**ABDB**/CREATE TABLE `#__fields` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `asset_id` int unsigned NOT NULL DEFAULT '0',
  `context` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `group_id` int unsigned NOT NULL DEFAULT '0',
  `title` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `label` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `default_value` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `type` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'text',
  `note` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `description` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `state` tinyint(1) NOT NULL DEFAULT '0',
  `required` tinyint(1) NOT NULL DEFAULT '0',
  `checked_out` int unsigned DEFAULT NULL,
  `checked_out_time` datetime DEFAULT NULL,
  `ordering` int NOT NULL DEFAULT '0',
  `params` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `fieldparams` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `language` char(7) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `created_time` datetime NOT NULL,
  `created_user_id` int unsigned NOT NULL DEFAULT '0',
  `modified_time` datetime NOT NULL,
  `modified_by` int unsigned NOT NULL DEFAULT '0',
  `access` int NOT NULL DEFAULT '1',
  `only_use_in_subform` tinyint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_checkout` (`checked_out`),
  KEY `idx_state` (`state`),
  KEY `idx_created_user_id` (`created_user_id`),
  KEY `idx_access` (`access`),
  KEY `idx_context` (`context`(191)),
  KEY `idx_language` (`language`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/CREATE TABLE `#__fields_categories` (
  `field_id` int NOT NULL DEFAULT '0',
  `category_id` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`field_id`,`category_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/CREATE TABLE `#__fields_groups` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `asset_id` int unsigned NOT NULL DEFAULT '0',
  `context` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `title` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `note` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `description` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `state` tinyint(1) NOT NULL DEFAULT '0',
  `checked_out` int unsigned DEFAULT NULL,
  `checked_out_time` datetime DEFAULT NULL,
  `ordering` int NOT NULL DEFAULT '0',
  `params` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `language` char(7) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `created` datetime NOT NULL,
  `created_by` int unsigned NOT NULL DEFAULT '0',
  `modified` datetime NOT NULL,
  `modified_by` int unsigned NOT NULL DEFAULT '0',
  `access` int NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `idx_checkout` (`checked_out`),
  KEY `idx_state` (`state`),
  KEY `idx_created_by` (`created_by`),
  KEY `idx_access` (`access`),
  KEY `idx_context` (`context`(191)),
  KEY `idx_language` (`language`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/CREATE TABLE `#__fields_values` (
  `field_id` int unsigned NOT NULL,
  `item_id` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'Allow references to items which have strings as ids, eg. none db systems.',
  `value` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  KEY `idx_field_id` (`field_id`),
  KEY `idx_item_id` (`item_id`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/CREATE TABLE `#__finder_filters` (
  `filter_id` int unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `alias` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `state` tinyint(1) NOT NULL DEFAULT '1',
  `created` datetime NOT NULL,
  `created_by` int unsigned NOT NULL DEFAULT '0',
  `created_by_alias` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `modified` datetime NOT NULL,
  `modified_by` int unsigned NOT NULL DEFAULT '0',
  `checked_out` int unsigned DEFAULT NULL,
  `checked_out_time` datetime DEFAULT NULL,
  `map_count` int unsigned NOT NULL DEFAULT '0',
  `data` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `params` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`filter_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/CREATE TABLE `#__finder_links` (
  `link_id` int unsigned NOT NULL AUTO_INCREMENT,
  `url` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `route` varchar(400) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `title` varchar(400) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `indexdate` datetime NOT NULL,
  `md5sum` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `published` tinyint(1) NOT NULL DEFAULT '1',
  `state` int NOT NULL DEFAULT '1',
  `access` int NOT NULL DEFAULT '0',
  `language` char(7) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `publish_start_date` datetime DEFAULT NULL,
  `publish_end_date` datetime DEFAULT NULL,
  `start_date` datetime DEFAULT NULL,
  `end_date` datetime DEFAULT NULL,
  `list_price` double unsigned NOT NULL DEFAULT '0',
  `sale_price` double unsigned NOT NULL DEFAULT '0',
  `type_id` int NOT NULL,
  `object` mediumblob NOT NULL,
  PRIMARY KEY (`link_id`),
  KEY `idx_type` (`type_id`),
  KEY `idx_md5` (`md5sum`),
  KEY `idx_url` (`url`(75)),
  KEY `idx_published_list` (`published`,`state`,`access`,`publish_start_date`,`publish_end_date`,`list_price`),
  KEY `idx_published_sale` (`published`,`state`,`access`,`publish_start_date`,`publish_end_date`,`sale_price`),
  KEY `idx_title` (`title`(100)),
  KEY `idx_language` (`language`)
) ENGINE=InnoDB AUTO_INCREMENT=27 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__finder_links`  VALUES 
('1', 'index.php?option=com_content&view=category&id=2', 'index.php?option=com_content&view=category&id=2', 'Uncategorised', '', '2023-04-26 12:28:27', 'a3d6dd2ed74d3a60acb2204dc9317d92', '1', '1', '1', '*', NULL, NULL, '2010-06-28 13:26:37', NULL, '0', '0', '2', 'O:52:\"Joomla\\Component\\Finder\\Administrator\\Indexer\\Result\":19:{i:0;i:1;i:1;s:5:\"en-GB\";i:2;s:0:\"\";i:3;a:18:{s:2:\"id\";i:2;s:5:\"alias\";s:13:\"uncategorised\";s:9:\"extension\";s:11:\"com_content\";s:7:\"metakey\";s:0:\"\";s:8:\"metadesc\";s:0:\"\";s:8:\"metadata\";O:24:\"Joomla\\Registry\\Registry\":3:{s:7:\"\0*\0data\";O:8:\"stdClass\":3:{s:10:\"page_title\";s:0:\"\";s:6:\"author\";s:0:\"\";s:6:\"robots\";s:0:\"\";}s:14:\"\0*\0initialized\";b:1;s:12:\"\0*\0separator\";s:1:\".\";}s:3:\"lft\";i:1;s:9:\"parent_id\";i:1;s:5:\"level\";i:1;s:6:\"params\";O:24:\"Joomla\\Registry\\Registry\":3:{s:7:\"\0*\0data\";O:8:\"stdClass\":2:{s:6:\"target\";s:0:\"\";s:5:\"image\";s:0:\"\";}s:14:\"\0*\0initialized\";b:1;s:12:\"\0*\0separator\";s:1:\".\";}s:7:\"summary\";s:0:\"\";s:10:\"created_by\";i:107;s:8:\"modified\";s:19:\"2010-06-28 13:26:37\";s:11:\"modified_by\";i:107;s:4:\"slug\";s:15:\"2:uncategorised\";s:4:\"mime\";N;s:6:\"layout\";s:8:\"category\";s:10:\"metaauthor\";N;}i:4;N;i:5;a:5:{i:1;a:3:{i:0;s:5:\"title\";i:1;s:8:\"subtitle\";i:2;s:2:\"id\";}i:2;a:2:{i:0;s:7:\"summary\";i:1;s:4:\"body\";}i:3;a:8:{i:0;s:4:\"meta\";i:1;s:10:\"list_price\";i:2;s:10:\"sale_price\";i:3;s:4:\"link\";i:4;s:7:\"metakey\";i:5;s:8:\"metadesc\";i:6;s:10:\"metaauthor\";i:7;s:6:\"author\";}i:4;a:2:{i:0;s:4:\"path\";i:1;s:5:\"alias\";}i:5;a:1:{i:0;s:8:\"comments\";}}i:6;s:1:\"*\";i:7;N;i:8;N;i:9;N;i:10;N;i:11;s:47:\"index.php?option=com_content&view=category&id=2\";i:12;N;i:13;s:19:\"2010-06-28 13:26:37\";i:14;i:1;i:15;a:2:{s:4:\"Type\";a:1:{i:0;O:8:\"stdClass\":6:{s:5:\"title\";s:8:\"Category\";s:5:\"state\";i:1;s:6:\"access\";i:1;s:8:\"language\";s:0:\"\";s:6:\"nested\";b:0;s:2:\"id\";i:3;}}s:8:\"Language\";a:1:{i:0;O:8:\"stdClass\":6:{s:5:\"title\";s:1:\"*\";s:5:\"state\";i:1;s:6:\"access\";i:1;s:8:\"language\";s:0:\"\";s:6:\"nested\";b:0;s:2:\"id\";i:5;}}}i:16;s:13:\"Uncategorised\";i:17;i:2;i:18;s:47:\"index.php?option=com_content&view=category&id=2\";}'),
('2', 'index.php?option=com_contact&view=category&id=4', 'index.php?option=com_contact&view=category&id=4', 'Uncategorised', '', '2023-04-26 12:28:27', '44ec241ff802e9556377457180d441fc', '1', '1', '1', '*', NULL, NULL, '2010-06-28 13:27:57', NULL, '0', '0', '2', 'O:52:\"Joomla\\Component\\Finder\\Administrator\\Indexer\\Result\":19:{i:0;i:1;i:1;s:5:\"en-GB\";i:2;s:0:\"\";i:3;a:18:{s:2:\"id\";i:4;s:5:\"alias\";s:13:\"uncategorised\";s:9:\"extension\";s:11:\"com_contact\";s:7:\"metakey\";s:0:\"\";s:8:\"metadesc\";s:0:\"\";s:8:\"metadata\";O:24:\"Joomla\\Registry\\Registry\":3:{s:7:\"\0*\0data\";O:8:\"stdClass\":3:{s:10:\"page_title\";s:0:\"\";s:6:\"author\";s:0:\"\";s:6:\"robots\";s:0:\"\";}s:14:\"\0*\0initialized\";b:1;s:12:\"\0*\0separator\";s:1:\".\";}s:3:\"lft\";i:5;s:9:\"parent_id\";i:1;s:5:\"level\";i:1;s:6:\"params\";O:24:\"Joomla\\Registry\\Registry\":3:{s:7:\"\0*\0data\";O:8:\"stdClass\":2:{s:6:\"target\";s:0:\"\";s:5:\"image\";s:0:\"\";}s:14:\"\0*\0initialized\";b:1;s:12:\"\0*\0separator\";s:1:\".\";}s:7:\"summary\";s:0:\"\";s:10:\"created_by\";i:107;s:8:\"modified\";s:19:\"2010-06-28 13:27:57\";s:11:\"modified_by\";i:107;s:4:\"slug\";s:15:\"4:uncategorised\";s:4:\"mime\";N;s:6:\"layout\";s:8:\"category\";s:10:\"metaauthor\";N;}i:4;N;i:5;a:5:{i:1;a:3:{i:0;s:5:\"title\";i:1;s:8:\"subtitle\";i:2;s:2:\"id\";}i:2;a:2:{i:0;s:7:\"summary\";i:1;s:4:\"body\";}i:3;a:8:{i:0;s:4:\"meta\";i:1;s:10:\"list_price\";i:2;s:10:\"sale_price\";i:3;s:4:\"link\";i:4;s:7:\"metakey\";i:5;s:8:\"metadesc\";i:6;s:10:\"metaauthor\";i:7;s:6:\"author\";}i:4;a:2:{i:0;s:4:\"path\";i:1;s:5:\"alias\";}i:5;a:1:{i:0;s:8:\"comments\";}}i:6;s:1:\"*\";i:7;N;i:8;N;i:9;N;i:10;N;i:11;s:47:\"index.php?option=com_contact&view=category&id=4\";i:12;N;i:13;s:19:\"2010-06-28 13:27:57\";i:14;i:1;i:15;a:2:{s:4:\"Type\";a:1:{i:0;O:8:\"stdClass\":6:{s:5:\"title\";s:8:\"Category\";s:5:\"state\";i:1;s:6:\"access\";i:1;s:8:\"language\";s:0:\"\";s:6:\"nested\";b:0;s:2:\"id\";i:3;}}s:8:\"Language\";a:1:{i:0;O:8:\"stdClass\":6:{s:5:\"title\";s:1:\"*\";s:5:\"state\";i:1;s:6:\"access\";i:1;s:8:\"language\";s:0:\"\";s:6:\"nested\";b:0;s:2:\"id\";i:5;}}}i:16;s:13:\"Uncategorised\";i:17;i:2;i:18;s:47:\"index.php?option=com_contact&view=category&id=4\";}'),
('3', 'index.php?option=com_newsfeeds&view=category&id=5', 'index.php?option=com_newsfeeds&view=category&id=5', 'Uncategorised', '', '2023-04-26 12:28:27', '4bd825969033c189649d8fc4af3ac098', '1', '1', '1', '*', NULL, NULL, '2010-06-28 13:28:15', NULL, '0', '0', '2', 'O:52:\"Joomla\\Component\\Finder\\Administrator\\Indexer\\Result\":19:{i:0;i:1;i:1;s:5:\"en-GB\";i:2;s:0:\"\";i:3;a:18:{s:2:\"id\";i:5;s:5:\"alias\";s:13:\"uncategorised\";s:9:\"extension\";s:13:\"com_newsfeeds\";s:7:\"metakey\";s:0:\"\";s:8:\"metadesc\";s:0:\"\";s:8:\"metadata\";O:24:\"Joomla\\Registry\\Registry\":3:{s:7:\"\0*\0data\";O:8:\"stdClass\":3:{s:10:\"page_title\";s:0:\"\";s:6:\"author\";s:0:\"\";s:6:\"robots\";s:0:\"\";}s:14:\"\0*\0initialized\";b:1;s:12:\"\0*\0separator\";s:1:\".\";}s:3:\"lft\";i:7;s:9:\"parent_id\";i:1;s:5:\"level\";i:1;s:6:\"params\";O:24:\"Joomla\\Registry\\Registry\":3:{s:7:\"\0*\0data\";O:8:\"stdClass\":2:{s:6:\"target\";s:0:\"\";s:5:\"image\";s:0:\"\";}s:14:\"\0*\0initialized\";b:1;s:12:\"\0*\0separator\";s:1:\".\";}s:7:\"summary\";s:0:\"\";s:10:\"created_by\";i:107;s:8:\"modified\";s:19:\"2010-06-28 13:28:15\";s:11:\"modified_by\";i:107;s:4:\"slug\";s:15:\"5:uncategorised\";s:4:\"mime\";N;s:6:\"layout\";s:8:\"category\";s:10:\"metaauthor\";N;}i:4;N;i:5;a:5:{i:1;a:3:{i:0;s:5:\"title\";i:1;s:8:\"subtitle\";i:2;s:2:\"id\";}i:2;a:2:{i:0;s:7:\"summary\";i:1;s:4:\"body\";}i:3;a:8:{i:0;s:4:\"meta\";i:1;s:10:\"list_price\";i:2;s:10:\"sale_price\";i:3;s:4:\"link\";i:4;s:7:\"metakey\";i:5;s:8:\"metadesc\";i:6;s:10:\"metaauthor\";i:7;s:6:\"author\";}i:4;a:2:{i:0;s:4:\"path\";i:1;s:5:\"alias\";}i:5;a:1:{i:0;s:8:\"comments\";}}i:6;s:1:\"*\";i:7;N;i:8;N;i:9;N;i:10;N;i:11;s:49:\"index.php?option=com_newsfeeds&view=category&id=5\";i:12;N;i:13;s:19:\"2010-06-28 13:28:15\";i:14;i:1;i:15;a:2:{s:4:\"Type\";a:1:{i:0;O:8:\"stdClass\":6:{s:5:\"title\";s:8:\"Category\";s:5:\"state\";i:1;s:6:\"access\";i:1;s:8:\"language\";s:0:\"\";s:6:\"nested\";b:0;s:2:\"id\";i:3;}}s:8:\"Language\";a:1:{i:0;O:8:\"stdClass\":6:{s:5:\"title\";s:1:\"*\";s:5:\"state\";i:1;s:6:\"access\";i:1;s:8:\"language\";s:0:\"\";s:6:\"nested\";b:0;s:2:\"id\";i:5;}}}i:16;s:13:\"Uncategorised\";i:17;i:2;i:18;s:49:\"index.php?option=com_newsfeeds&view=category&id=5\";}'),
('4', 'index.php?option=com_content&view=category&id=7', 'index.php?option=com_content&view=category&id=7', 'Blog', '', '2023-04-26 12:28:27', '1ad4ac045be1d70d943315c253b7e0b1', '1', '1', '1', '*', NULL, NULL, '2011-05-02 11:42:21', NULL, '0', '0', '2', 'O:52:\"Joomla\\Component\\Finder\\Administrator\\Indexer\\Result\":19:{i:0;i:1;i:1;s:5:\"en-GB\";i:2;s:0:\"\";i:3;a:18:{s:2:\"id\";i:7;s:5:\"alias\";s:4:\"blog\";s:9:\"extension\";s:11:\"com_content\";s:7:\"metakey\";s:0:\"\";s:8:\"metadesc\";s:0:\"\";s:8:\"metadata\";O:24:\"Joomla\\Registry\\Registry\":3:{s:7:\"\0*\0data\";O:8:\"stdClass\":2:{s:6:\"author\";s:0:\"\";s:6:\"robots\";s:0:\"\";}s:14:\"\0*\0initialized\";b:1;s:12:\"\0*\0separator\";s:1:\".\";}s:3:\"lft\";i:11;s:9:\"parent_id\";i:1;s:5:\"level\";i:1;s:6:\"params\";O:24:\"Joomla\\Registry\\Registry\":3:{s:7:\"\0*\0data\";O:8:\"stdClass\":2:{s:15:\"category_layout\";s:0:\"\";s:5:\"image\";s:0:\"\";}s:14:\"\0*\0initialized\";b:1;s:12:\"\0*\0separator\";s:1:\".\";}s:7:\"summary\";s:0:\"\";s:10:\"created_by\";i:107;s:8:\"modified\";s:19:\"2011-05-02 11:42:21\";s:11:\"modified_by\";i:107;s:4:\"slug\";s:6:\"7:blog\";s:4:\"mime\";N;s:6:\"layout\";s:8:\"category\";s:10:\"metaauthor\";N;}i:4;N;i:5;a:5:{i:1;a:3:{i:0;s:5:\"title\";i:1;s:8:\"subtitle\";i:2;s:2:\"id\";}i:2;a:2:{i:0;s:7:\"summary\";i:1;s:4:\"body\";}i:3;a:8:{i:0;s:4:\"meta\";i:1;s:10:\"list_price\";i:2;s:10:\"sale_price\";i:3;s:4:\"link\";i:4;s:7:\"metakey\";i:5;s:8:\"metadesc\";i:6;s:10:\"metaauthor\";i:7;s:6:\"author\";}i:4;a:2:{i:0;s:4:\"path\";i:1;s:5:\"alias\";}i:5;a:1:{i:0;s:8:\"comments\";}}i:6;s:1:\"*\";i:7;N;i:8;N;i:9;N;i:10;N;i:11;s:47:\"index.php?option=com_content&view=category&id=7\";i:12;N;i:13;s:19:\"2011-05-02 11:42:21\";i:14;i:1;i:15;a:2:{s:4:\"Type\";a:1:{i:0;O:8:\"stdClass\":6:{s:5:\"title\";s:8:\"Category\";s:5:\"state\";i:1;s:6:\"access\";i:1;s:8:\"language\";s:0:\"\";s:6:\"nested\";b:0;s:2:\"id\";i:3;}}s:8:\"Language\";a:1:{i:0;O:8:\"stdClass\":6:{s:5:\"title\";s:1:\"*\";s:5:\"state\";i:1;s:6:\"access\";i:1;s:8:\"language\";s:0:\"\";s:6:\"nested\";b:0;s:2:\"id\";i:5;}}}i:16;s:4:\"Blog\";i:17;i:2;i:18;s:47:\"index.php?option=com_content&view=category&id=7\";}'),
('5', 'index.php?option=com_contact&view=category&id=8', 'index.php?option=com_contact&view=category&id=8', 'Contacts', '', '2023-04-26 12:28:27', 'f816193719dbddfb20d14d10c100180e', '1', '1', '1', '*', NULL, NULL, '2011-11-18 16:32:10', NULL, '0', '0', '2', 'O:52:\"Joomla\\Component\\Finder\\Administrator\\Indexer\\Result\":19:{i:0;i:1;i:1;s:5:\"en-GB\";i:2;s:0:\"\";i:3;a:18:{s:2:\"id\";i:8;s:5:\"alias\";s:8:\"contacts\";s:9:\"extension\";s:11:\"com_contact\";s:7:\"metakey\";s:0:\"\";s:8:\"metadesc\";s:0:\"\";s:8:\"metadata\";O:24:\"Joomla\\Registry\\Registry\":3:{s:7:\"\0*\0data\";O:8:\"stdClass\":2:{s:6:\"author\";s:0:\"\";s:6:\"robots\";s:0:\"\";}s:14:\"\0*\0initialized\";b:1;s:12:\"\0*\0separator\";s:1:\".\";}s:3:\"lft\";i:13;s:9:\"parent_id\";i:1;s:5:\"level\";i:1;s:6:\"params\";O:24:\"Joomla\\Registry\\Registry\":3:{s:7:\"\0*\0data\";O:8:\"stdClass\":2:{s:15:\"category_layout\";s:0:\"\";s:5:\"image\";s:0:\"\";}s:14:\"\0*\0initialized\";b:1;s:12:\"\0*\0separator\";s:1:\".\";}s:7:\"summary\";s:0:\"\";s:10:\"created_by\";i:107;s:8:\"modified\";s:19:\"2011-11-18 16:32:13\";s:11:\"modified_by\";i:42;s:4:\"slug\";s:10:\"8:contacts\";s:4:\"mime\";N;s:6:\"layout\";s:8:\"category\";s:10:\"metaauthor\";N;}i:4;N;i:5;a:5:{i:1;a:3:{i:0;s:5:\"title\";i:1;s:8:\"subtitle\";i:2;s:2:\"id\";}i:2;a:2:{i:0;s:7:\"summary\";i:1;s:4:\"body\";}i:3;a:8:{i:0;s:4:\"meta\";i:1;s:10:\"list_price\";i:2;s:10:\"sale_price\";i:3;s:4:\"link\";i:4;s:7:\"metakey\";i:5;s:8:\"metadesc\";i:6;s:10:\"metaauthor\";i:7;s:6:\"author\";}i:4;a:2:{i:0;s:4:\"path\";i:1;s:5:\"alias\";}i:5;a:1:{i:0;s:8:\"comments\";}}i:6;s:1:\"*\";i:7;N;i:8;N;i:9;N;i:10;N;i:11;s:47:\"index.php?option=com_contact&view=category&id=8\";i:12;N;i:13;s:19:\"2011-11-18 16:32:10\";i:14;i:1;i:15;a:2:{s:4:\"Type\";a:1:{i:0;O:8:\"stdClass\":6:{s:5:\"title\";s:8:\"Category\";s:5:\"state\";i:1;s:6:\"access\";i:1;s:8:\"language\";s:0:\"\";s:6:\"nested\";b:0;s:2:\"id\";i:3;}}s:8:\"Language\";a:1:{i:0;O:8:\"stdClass\":6:{s:5:\"title\";s:1:\"*\";s:5:\"state\";i:1;s:6:\"access\";i:1;s:8:\"language\";s:0:\"\";s:6:\"nested\";b:0;s:2:\"id\";i:5;}}}i:16;s:8:\"Contacts\";i:17;i:2;i:18;s:47:\"index.php?option=com_contact&view=category&id=8\";}'),
('6', 'index.php?option=com_content&view=category&id=10', 'index.php?option=com_content&view=category&id=10', 'News', '', '2023-04-26 12:28:27', '4fc3c86d716c2bfac829085e938ff43b', '1', '1', '1', '*', NULL, NULL, '2015-08-14 03:00:37', NULL, '0', '0', '2', 'O:52:\"Joomla\\Component\\Finder\\Administrator\\Indexer\\Result\":19:{i:0;i:1;i:1;s:5:\"en-GB\";i:2;s:0:\"\";i:3;a:18:{s:2:\"id\";i:10;s:5:\"alias\";s:4:\"news\";s:9:\"extension\";s:11:\"com_content\";s:7:\"metakey\";s:0:\"\";s:8:\"metadesc\";s:0:\"\";s:8:\"metadata\";O:24:\"Joomla\\Registry\\Registry\":3:{s:7:\"\0*\0data\";O:8:\"stdClass\":2:{s:6:\"author\";s:0:\"\";s:6:\"robots\";s:0:\"\";}s:14:\"\0*\0initialized\";b:1;s:12:\"\0*\0separator\";s:1:\".\";}s:3:\"lft\";i:17;s:9:\"parent_id\";i:1;s:5:\"level\";i:1;s:6:\"params\";O:24:\"Joomla\\Registry\\Registry\":3:{s:7:\"\0*\0data\";O:8:\"stdClass\":3:{s:15:\"category_layout\";s:0:\"\";s:5:\"image\";s:0:\"\";s:9:\"image_alt\";s:0:\"\";}s:14:\"\0*\0initialized\";b:1;s:12:\"\0*\0separator\";s:1:\".\";}s:7:\"summary\";s:0:\"\";s:10:\"created_by\";i:107;s:8:\"modified\";s:19:\"2016-09-03 04:19:44\";s:11:\"modified_by\";i:107;s:4:\"slug\";s:7:\"10:news\";s:4:\"mime\";N;s:6:\"layout\";s:8:\"category\";s:10:\"metaauthor\";N;}i:4;N;i:5;a:5:{i:1;a:3:{i:0;s:5:\"title\";i:1;s:8:\"subtitle\";i:2;s:2:\"id\";}i:2;a:2:{i:0;s:7:\"summary\";i:1;s:4:\"body\";}i:3;a:8:{i:0;s:4:\"meta\";i:1;s:10:\"list_price\";i:2;s:10:\"sale_price\";i:3;s:4:\"link\";i:4;s:7:\"metakey\";i:5;s:8:\"metadesc\";i:6;s:10:\"metaauthor\";i:7;s:6:\"author\";}i:4;a:2:{i:0;s:4:\"path\";i:1;s:5:\"alias\";}i:5;a:1:{i:0;s:8:\"comments\";}}i:6;s:1:\"*\";i:7;N;i:8;N;i:9;N;i:10;N;i:11;s:48:\"index.php?option=com_content&view=category&id=10\";i:12;N;i:13;s:19:\"2015-08-14 03:00:37\";i:14;i:1;i:15;a:2:{s:4:\"Type\";a:1:{i:0;O:8:\"stdClass\":6:{s:5:\"title\";s:8:\"Category\";s:5:\"state\";i:1;s:6:\"access\";i:1;s:8:\"language\";s:0:\"\";s:6:\"nested\";b:0;s:2:\"id\";i:3;}}s:8:\"Language\";a:1:{i:0;O:8:\"stdClass\":6:{s:5:\"title\";s:1:\"*\";s:5:\"state\";i:1;s:6:\"access\";i:1;s:8:\"language\";s:0:\"\";s:6:\"nested\";b:0;s:2:\"id\";i:5;}}}i:16;s:4:\"News\";i:17;i:2;i:18;s:48:\"index.php?option=com_content&view=category&id=10\";}'),
('7', 'index.php?option=com_content&view=category&id=11', 'index.php?option=com_content&view=category&id=11', 'Features', '', '2023-04-26 12:28:27', '36fd02ef14c7585e99a64efe624c0073', '1', '1', '1', '*', NULL, NULL, '2015-12-21 15:03:17', NULL, '0', '0', '2', 'O:52:\"Joomla\\Component\\Finder\\Administrator\\Indexer\\Result\":19:{i:0;i:1;i:1;s:5:\"en-GB\";i:2;s:0:\"\";i:3;a:18:{s:2:\"id\";i:11;s:5:\"alias\";s:8:\"features\";s:9:\"extension\";s:11:\"com_content\";s:7:\"metakey\";s:0:\"\";s:8:\"metadesc\";s:0:\"\";s:8:\"metadata\";O:24:\"Joomla\\Registry\\Registry\":3:{s:7:\"\0*\0data\";O:8:\"stdClass\":2:{s:6:\"author\";s:0:\"\";s:6:\"robots\";s:0:\"\";}s:14:\"\0*\0initialized\";b:1;s:12:\"\0*\0separator\";s:1:\".\";}s:3:\"lft\";i:19;s:9:\"parent_id\";i:1;s:5:\"level\";i:1;s:6:\"params\";O:24:\"Joomla\\Registry\\Registry\":3:{s:7:\"\0*\0data\";O:8:\"stdClass\":3:{s:15:\"category_layout\";s:0:\"\";s:5:\"image\";s:0:\"\";s:9:\"image_alt\";s:0:\"\";}s:14:\"\0*\0initialized\";b:1;s:12:\"\0*\0separator\";s:1:\".\";}s:7:\"summary\";s:0:\"\";s:10:\"created_by\";i:107;s:8:\"modified\";s:19:\"2021-05-13 20:39:44\";s:11:\"modified_by\";i:107;s:4:\"slug\";s:11:\"11:features\";s:4:\"mime\";N;s:6:\"layout\";s:8:\"category\";s:10:\"metaauthor\";N;}i:4;N;i:5;a:5:{i:1;a:3:{i:0;s:5:\"title\";i:1;s:8:\"subtitle\";i:2;s:2:\"id\";}i:2;a:2:{i:0;s:7:\"summary\";i:1;s:4:\"body\";}i:3;a:8:{i:0;s:4:\"meta\";i:1;s:10:\"list_price\";i:2;s:10:\"sale_price\";i:3;s:4:\"link\";i:4;s:7:\"metakey\";i:5;s:8:\"metadesc\";i:6;s:10:\"metaauthor\";i:7;s:6:\"author\";}i:4;a:2:{i:0;s:4:\"path\";i:1;s:5:\"alias\";}i:5;a:1:{i:0;s:8:\"comments\";}}i:6;s:1:\"*\";i:7;N;i:8;N;i:9;N;i:10;N;i:11;s:48:\"index.php?option=com_content&view=category&id=11\";i:12;N;i:13;s:19:\"2015-12-21 15:03:17\";i:14;i:1;i:15;a:2:{s:4:\"Type\";a:1:{i:0;O:8:\"stdClass\":6:{s:5:\"title\";s:8:\"Category\";s:5:\"state\";i:1;s:6:\"access\";i:1;s:8:\"language\";s:0:\"\";s:6:\"nested\";b:0;s:2:\"id\";i:3;}}s:8:\"Language\";a:1:{i:0;O:8:\"stdClass\":6:{s:5:\"title\";s:1:\"*\";s:5:\"state\";i:1;s:6:\"access\";i:1;s:8:\"language\";s:0:\"\";s:6:\"nested\";b:0;s:2:\"id\";i:5;}}}i:16;s:8:\"Features\";i:17;i:2;i:18;s:48:\"index.php?option=com_content&view=category&id=11\";}'),
('8', 'index.php?option=com_contact&view=contact&id=1', 'index.php?option=com_contact&view=contact&id=1:john-q-public&catid=8:contacts', 'John Q. Public', ' Please feel free to get in touch anytime, whether for work inquiries or to just say hello@website.com. We\'re currently accepting new freelance design projects, and always excited to hear interesting proposals. ', '2023-04-26 12:28:27', 'a58ddb8d0e859d0ff4ea876f8a556ae3', '1', '1', '1', '*', '2021-05-15 23:48:51', NULL, '2011-11-18 16:33:47', NULL, '0', '0', '3', 'O:52:\"Joomla\\Component\\Finder\\Administrator\\Indexer\\Result\":19:{i:0;i:1;i:1;s:5:\"en-GB\";i:2;s:211:\" Please feel free to get in touch anytime, whether for work inquiries or to just say hello@website.com. We\'re currently accepting new freelance design projects, and always excited to hear interesting proposals. \";i:3;a:34:{s:2:\"id\";i:1;s:5:\"alias\";s:13:\"john q public\";s:8:\"position\";s:0:\"\";s:7:\"address\";s:63:\"15th Avenue at St. Marks Place, Cathedral District Brooklyn, NY\";s:16:\"created_by_alias\";s:0:\"\";s:8:\"modified\";s:19:\"2023-04-22 14:28:39\";s:11:\"modified_by\";i:107;s:7:\"metakey\";s:0:\"\";s:8:\"metadesc\";s:0:\"\";s:8:\"metadata\";s:25:\"{\"robots\":\"\",\"rights\":\"\"}\";s:9:\"sortname1\";s:0:\"\";s:9:\"sortname2\";s:0:\"\";s:9:\"sortname3\";s:0:\"\";s:4:\"city\";s:0:\"\";s:6:\"region\";s:0:\"\";s:7:\"country\";s:0:\"\";s:3:\"zip\";s:0:\"\";s:9:\"telephone\";s:13:\"0100-5200-369\";s:3:\"fax\";s:0:\"\";s:7:\"summary\";s:236:\"<p>\r\n  Please feel free to get in touch anytime, whether for work inquiries or to just say hello@website.com.\r\n</p>\r\n<p>\r\n  We\'re currently accepting new freelance design projects, and always excited to hear interesting proposals.\r\n</p>\";s:5:\"email\";s:21:\"support@my-domain.com\";s:6:\"mobile\";s:0:\"\";s:7:\"webpage\";s:0:\"\";s:8:\"ordering\";i:1;s:6:\"params\";O:24:\"Joomla\\Registry\\Registry\":3:{s:7:\"\0*\0data\";O:8:\"stdClass\":40:{s:21:\"show_contact_category\";s:0:\"\";s:17:\"show_contact_list\";s:0:\"\";s:9:\"show_tags\";s:0:\"\";s:9:\"show_info\";s:0:\"\";s:9:\"show_name\";s:0:\"\";s:13:\"show_position\";s:0:\"\";s:10:\"show_email\";s:0:\"\";s:15:\"add_mailto_link\";s:0:\"\";s:19:\"show_street_address\";s:0:\"\";s:11:\"show_suburb\";s:0:\"\";s:10:\"show_state\";s:0:\"\";s:13:\"show_postcode\";s:0:\"\";s:12:\"show_country\";s:0:\"\";s:14:\"show_telephone\";s:0:\"\";s:11:\"show_mobile\";s:0:\"\";s:8:\"show_fax\";s:0:\"\";s:12:\"show_webpage\";s:0:\"\";s:10:\"show_image\";s:0:\"\";s:9:\"show_misc\";s:0:\"\";s:11:\"allow_vcard\";s:0:\"\";s:13:\"show_articles\";s:0:\"\";s:20:\"articles_display_num\";s:0:\"\";s:12:\"show_profile\";s:0:\"\";s:14:\"contact_layout\";s:0:\"\";s:10:\"show_links\";s:0:\"\";s:10:\"linka_name\";s:0:\"\";s:5:\"linka\";s:0:\"\";s:10:\"linkb_name\";s:0:\"\";s:5:\"linkb\";s:0:\"\";s:10:\"linkc_name\";s:0:\"\";s:5:\"linkc\";s:0:\"\";s:10:\"linkd_name\";s:0:\"\";s:5:\"linkd\";s:0:\"\";s:10:\"linke_name\";s:0:\"\";s:5:\"linke\";s:0:\"\";s:15:\"show_email_form\";s:0:\"\";s:15:\"show_email_copy\";s:0:\"\";s:16:\"validate_session\";s:0:\"\";s:12:\"custom_reply\";s:0:\"\";s:8:\"redirect\";s:0:\"\";}s:14:\"\0*\0initialized\";b:1;s:12:\"\0*\0separator\";s:1:\".\";}s:5:\"catid\";i:8;s:8:\"category\";s:8:\"Contacts\";s:9:\"cat_state\";i:1;s:10:\"cat_access\";i:1;s:4:\"slug\";s:15:\"1:john-q-public\";s:7:\"catslug\";s:10:\"8:contacts\";s:4:\"name\";s:5:\"admin\";s:4:\"mime\";N;s:6:\"layout\";s:7:\"contact\";}i:4;N;i:5;a:5:{i:1;a:3:{i:0;s:5:\"title\";i:1;s:8:\"subtitle\";i:2;s:2:\"id\";}i:2;a:2:{i:0;s:7:\"summary\";i:1;s:4:\"body\";}i:3;a:15:{i:0;s:4:\"meta\";i:1;s:10:\"list_price\";i:2;s:10:\"sale_price\";i:3;s:8:\"position\";i:4;s:7:\"address\";i:5;s:4:\"city\";i:6;s:6:\"region\";i:7;s:7:\"country\";i:8;s:3:\"zip\";i:9;s:9:\"telephone\";i:10;s:3:\"fax\";i:11;s:5:\"email\";i:12;s:6:\"mobile\";i:13;s:7:\"webpage\";i:14;s:4:\"user\";}i:4;a:2:{i:0;s:4:\"path\";i:1;s:5:\"alias\";}i:5;a:1:{i:0;s:8:\"comments\";}}i:6;s:1:\"*\";i:7;N;i:8;N;i:9;s:19:\"2021-05-15 23:48:51\";i:10;N;i:11;s:77:\"index.php?option=com_contact&view=contact&id=1:john-q-public&catid=8:contacts\";i:12;N;i:13;s:19:\"2011-11-18 16:33:47\";i:14;i:1;i:15;a:3:{s:4:\"Type\";a:1:{i:0;O:8:\"stdClass\":6:{s:5:\"title\";s:7:\"Contact\";s:5:\"state\";i:1;s:6:\"access\";i:1;s:8:\"language\";s:0:\"\";s:6:\"nested\";b:0;s:2:\"id\";i:6;}}s:8:\"Category\";a:1:{i:0;O:8:\"stdClass\":6:{s:5:\"title\";s:8:\"Contacts\";s:5:\"state\";i:1;s:6:\"access\";i:1;s:8:\"language\";s:1:\"*\";s:6:\"nested\";b:1;s:2:\"id\";i:8;}}s:8:\"Language\";a:1:{i:0;O:8:\"stdClass\":6:{s:5:\"title\";s:1:\"*\";s:5:\"state\";i:1;s:6:\"access\";i:1;s:8:\"language\";s:0:\"\";s:6:\"nested\";b:0;s:2:\"id\";i:5;}}}i:16;s:14:\"John Q. Public\";i:17;i:3;i:18;s:46:\"index.php?option=com_contact&view=contact&id=1\";}'),
('9', 'index.php?option=com_contact&view=contact&id=2', 'index.php?option=com_contact&view=contact&id=2:jane-q-public&catid=8:contacts', 'Jane Q. Public', 'Lorem ipsum dolor sit amet, consetetur sadipscing elitr.', '2023-04-26 12:28:27', '780a2bc0612881ce7f5879774a896544', '1', '-2', '1', '*', '2021-05-15 23:48:51', NULL, '2011-11-18 16:35:05', NULL, '0', '0', '3', 'O:52:\"Joomla\\Component\\Finder\\Administrator\\Indexer\\Result\":19:{i:0;i:1;i:1;s:5:\"en-GB\";i:2;s:56:\"Lorem ipsum dolor sit amet, consetetur sadipscing elitr.\";i:3;a:34:{s:2:\"id\";i:2;s:5:\"alias\";s:13:\"jane q public\";s:8:\"position\";s:25:\"Chief Information Officer\";s:7:\"address\";s:15:\"1 Infinite Loop\";s:16:\"created_by_alias\";s:0:\"\";s:8:\"modified\";s:19:\"2012-01-19 16:37:23\";s:11:\"modified_by\";i:42;s:7:\"metakey\";s:0:\"\";s:8:\"metadesc\";s:0:\"\";s:8:\"metadata\";s:25:\"{\"robots\":\"\",\"rights\":\"\"}\";s:9:\"sortname1\";s:0:\"\";s:9:\"sortname2\";s:0:\"\";s:9:\"sortname3\";s:0:\"\";s:4:\"city\";s:9:\"Cupertino\";s:6:\"region\";s:10:\"California\";s:7:\"country\";s:3:\"USA\";s:3:\"zip\";s:5:\"95014\";s:9:\"telephone\";s:14:\"1-212-555555-1\";s:3:\"fax\";s:14:\"1-212-555555-2\";s:7:\"summary\";s:56:\"Lorem ipsum dolor sit amet, consetetur sadipscing elitr.\";s:5:\"email\";s:13:\"email@0.0.0.0\";s:6:\"mobile\";s:0:\"\";s:7:\"webpage\";s:0:\"\";s:8:\"ordering\";i:2;s:6:\"params\";O:24:\"Joomla\\Registry\\Registry\":3:{s:7:\"\0*\0data\";O:8:\"stdClass\":40:{s:21:\"show_contact_category\";s:0:\"\";s:17:\"show_contact_list\";s:0:\"\";s:18:\"presentation_style\";s:0:\"\";s:9:\"show_name\";s:0:\"\";s:13:\"show_position\";s:0:\"\";s:10:\"show_email\";s:0:\"\";s:19:\"show_street_address\";s:0:\"\";s:11:\"show_suburb\";s:0:\"\";s:10:\"show_state\";s:0:\"\";s:13:\"show_postcode\";s:0:\"\";s:12:\"show_country\";s:0:\"\";s:14:\"show_telephone\";s:0:\"\";s:11:\"show_mobile\";s:0:\"\";s:8:\"show_fax\";s:0:\"\";s:12:\"show_webpage\";s:0:\"\";s:9:\"show_misc\";s:0:\"\";s:10:\"show_image\";s:0:\"\";s:11:\"allow_vcard\";s:0:\"\";s:13:\"show_articles\";s:0:\"\";s:12:\"show_profile\";s:0:\"\";s:10:\"show_links\";s:0:\"\";s:10:\"linka_name\";s:0:\"\";s:5:\"linka\";s:0:\"\";s:10:\"linkb_name\";s:0:\"\";s:5:\"linkb\";s:0:\"\";s:10:\"linkc_name\";s:0:\"\";s:5:\"linkc\";s:0:\"\";s:10:\"linkd_name\";s:0:\"\";s:5:\"linkd\";s:0:\"\";s:10:\"linke_name\";s:0:\"\";s:5:\"linke\";s:0:\"\";s:14:\"contact_layout\";s:0:\"\";s:15:\"show_email_form\";s:0:\"\";s:15:\"show_email_copy\";s:0:\"\";s:12:\"banned_email\";s:0:\"\";s:14:\"banned_subject\";s:0:\"\";s:11:\"banned_text\";s:0:\"\";s:16:\"validate_session\";s:0:\"\";s:12:\"custom_reply\";s:0:\"\";s:8:\"redirect\";s:0:\"\";}s:14:\"\0*\0initialized\";b:1;s:12:\"\0*\0separator\";s:1:\".\";}s:5:\"catid\";i:8;s:8:\"category\";s:8:\"Contacts\";s:9:\"cat_state\";i:1;s:10:\"cat_access\";i:1;s:4:\"slug\";s:15:\"2:jane-q-public\";s:7:\"catslug\";s:10:\"8:contacts\";s:4:\"name\";N;s:4:\"mime\";N;s:6:\"layout\";s:7:\"contact\";}i:4;N;i:5;a:5:{i:1;a:3:{i:0;s:5:\"title\";i:1;s:8:\"subtitle\";i:2;s:2:\"id\";}i:2;a:2:{i:0;s:7:\"summary\";i:1;s:4:\"body\";}i:3;a:15:{i:0;s:4:\"meta\";i:1;s:10:\"list_price\";i:2;s:10:\"sale_price\";i:3;s:8:\"position\";i:4;s:7:\"address\";i:5;s:4:\"city\";i:6;s:6:\"region\";i:7;s:7:\"country\";i:8;s:3:\"zip\";i:9;s:9:\"telephone\";i:10;s:3:\"fax\";i:11;s:5:\"email\";i:12;s:6:\"mobile\";i:13;s:7:\"webpage\";i:14;s:4:\"user\";}i:4;a:2:{i:0;s:4:\"path\";i:1;s:5:\"alias\";}i:5;a:1:{i:0;s:8:\"comments\";}}i:6;s:1:\"*\";i:7;N;i:8;N;i:9;s:19:\"2021-05-15 23:48:51\";i:10;N;i:11;s:77:\"index.php?option=com_contact&view=contact&id=2:jane-q-public&catid=8:contacts\";i:12;N;i:13;s:19:\"2011-11-18 16:35:05\";i:14;i:-2;i:15;a:5:{s:4:\"Type\";a:1:{i:0;O:8:\"stdClass\":6:{s:5:\"title\";s:7:\"Contact\";s:5:\"state\";i:1;s:6:\"access\";i:1;s:8:\"language\";s:0:\"\";s:6:\"nested\";b:0;s:2:\"id\";i:6;}}s:8:\"Category\";a:1:{i:0;O:8:\"stdClass\":6:{s:5:\"title\";s:8:\"Contacts\";s:5:\"state\";i:1;s:6:\"access\";i:1;s:8:\"language\";s:1:\"*\";s:6:\"nested\";b:1;s:2:\"id\";i:8;}}s:8:\"Language\";a:1:{i:0;O:8:\"stdClass\":6:{s:5:\"title\";s:1:\"*\";s:5:\"state\";i:1;s:6:\"access\";i:1;s:8:\"language\";s:0:\"\";s:6:\"nested\";b:0;s:2:\"id\";i:5;}}s:6:\"Region\";a:1:{i:0;O:8:\"stdClass\":6:{s:5:\"title\";s:10:\"California\";s:5:\"state\";i:1;s:6:\"access\";i:1;s:8:\"language\";s:0:\"\";s:6:\"nested\";b:0;s:2:\"id\";i:10;}}s:7:\"Country\";a:1:{i:0;O:8:\"stdClass\":6:{s:5:\"title\";s:3:\"USA\";s:5:\"state\";i:1;s:6:\"access\";i:1;s:8:\"language\";s:0:\"\";s:6:\"nested\";b:0;s:2:\"id\";i:12;}}}i:16;s:14:\"Jane Q. Public\";i:17;i:3;i:18;s:46:\"index.php?option=com_contact&view=contact&id=2\";}'),
('10', 'index.php?option=com_content&view=article&id=1', 'index.php?option=com_content&view=article&id=1:theme-typography&catid=11', 'Theme Typography', ' We\'ve used Inter font family for all of the themes because it\'s a beautiful font for UI design and is completely open-source and free. Using a custom font is nice because it allows us to make the components look the same on all browsers and operating systems. You can choose Google font via theme settings instead using local font. It\'s optional. Headings All HTML headings, through are available. Typography (h1) Lorem ipsum dolor sit amet, consectetuer adipiscing elit, sed diam nonummy nibh euismod tincidunt ut laoreet dolore magna aliquam erat volutpat. Ut wisi enim ad minim veniam, quis nostrud exerci tation ullamcorper suscipit lobortis nisl ut aliquip ex. (p) Lorem Ipsum Dolor Sit Amet (h2) Lorem ipsum dolor sit amet, consectetuer adipiscing elit (strong), sed diam nonummy nibh euismod tincidunt ut laoreet dolore magna aliquam erat volutpat. Ut wisi enim ad minim veniam, quis nostrud exerci tation ullamcorper suscipit lobortis nisl ut aliquip ex. (p) Lorem Ipsum Dolor Sit Amet (h3) Lorem ipsum dolor sit amet, consectetuer adipiscing elit, sed diam nonummy nibh euismod tincidunt ut laoreet dolore magna aliquam erat volutpat. Ut wisi enim ad minim veniam, quis nostrud exerci tation ullamcorper suscipit lobortis nisl ut aliquip ex. (p) Lorem Ipsum Dolor Sit Amet (h4) Lorem ipsum dolor sit amet, consectetuer adipiscing elit, sed diam nonummy nibh euismod tincidunt ut laoreet dolore magna aliquam erat volutpat. Ut wisi enim ad minim veniam, quis nostrud exerci tation ullamcorper suscipit lobortis nisl ut aliquip ex. (p) Lorem Ipsum Dolor Sit Amet (h5) Joomla 4 bootstrap 5 button secondary primary info success warning danger text-secondary text-primary text-info text-success text-warning text-danger Lorem ipsum dolor sit amet, consectetuer adipiscing elit, sed diam nonummy nibh euismod tincidunt ut laoreet dolore magna aliquam erat volutpat. Ut wisi enim ad minim veniam, quis nostrud exerci tation ullamcorper suscipit lobortis nisl ut aliquip ex. (p) Loremipsum dolor (a) Lists (ol)(li) Lorem ipsum dolor sit amet consectetur Lorem ipsum dolor sit amet consectetur (ul)(li) Lorem ipsum dolor sit amet consectetur Lorem ipsum dolor sit amet consectetur Theme Buttons Buttons have a number of great variations to choose from. You should note that in the HTML breakdown we have added a button class in addition to the variation, which is a requirement for these particular variations to work. You can also combine these variations. Default Button Button Primary Button Secondary Button Danger Button Text Default Button Button Primary Button Secondary Button Danger Button Text Notice Styles Nullam quis risus eget urna mollis ornare vel eu leo. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. … Nullam quis risus eget urna mollis ornare vel eu leo. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. … Nullam quis risus eget urna mollis ornare vel eu leo. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. … Nullam quis risus eget urna mollis ornare vel eu leo. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. … Blockquotes For quoting blocks of content from another source within your document. Default blockquote Wrap around any HTML as the quote. For straight quotes we recommend a . Lorem ipsum dolor sit amet, consectetur adipiscing elit. Integer posuere erat a ante. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Integer posuere erat a ante. Blockquote options Style and content changes for simple variations on a standard blockquote. Naming a source Add tag for identifying the source. Wrap the name of the source work in . Lorem ipsum dolor sit amet, consectetur adipiscing elit. Integer posuere erat a ante. Someone famous in Source Title Lorem ipsum dolor sit amet, consectetur adipiscing elit. Integer posuere erat a ante. Someone famous Source Title The blockquote element represents content that is quoted from another source, optionally with a citation which must be within a footer or cite element. Someone famous in Source Title Tables # First Name Last Name Username 1 John Doe JohnDoe 2 Jane Doe JaneDoe 3 Bob Doe BobDoe … ', '2023-04-26 12:28:27', 'f50e2e3cbf4b95321a7257e9048f5141', '1', '1', '1', '*', '2021-05-16 02:42:00', NULL, '1980-01-01 00:00:00', NULL, '0', '0', '4', 'O:52:\"Joomla\\Component\\Finder\\Administrator\\Indexer\\Result\":19:{i:0;i:1;i:1;s:5:\"en-GB\";i:2;s:4238:\" We\'ve used Inter font family for all of the themes because it\'s a beautiful font for UI design and is completely open-source and free. Using a custom font is nice because it allows us to make the components look the same on all browsers and operating systems. You can choose Google font via theme settings instead using local font. It\'s optional. Headings All HTML headings, through are available. Typography (h1) Lorem ipsum dolor sit amet, consectetuer adipiscing elit, sed diam nonummy nibh euismod tincidunt ut laoreet dolore magna aliquam erat volutpat. Ut wisi enim ad minim veniam, quis nostrud exerci tation ullamcorper suscipit lobortis nisl ut aliquip ex. (p) Lorem Ipsum Dolor Sit Amet (h2) Lorem ipsum dolor sit amet, consectetuer adipiscing elit (strong), sed diam nonummy nibh euismod tincidunt ut laoreet dolore magna aliquam erat volutpat. Ut wisi enim ad minim veniam, quis nostrud exerci tation ullamcorper suscipit lobortis nisl ut aliquip ex. (p) Lorem Ipsum Dolor Sit Amet (h3) Lorem ipsum dolor sit amet, consectetuer adipiscing elit, sed diam nonummy nibh euismod tincidunt ut laoreet dolore magna aliquam erat volutpat. Ut wisi enim ad minim veniam, quis nostrud exerci tation ullamcorper suscipit lobortis nisl ut aliquip ex. (p) Lorem Ipsum Dolor Sit Amet (h4) Lorem ipsum dolor sit amet, consectetuer adipiscing elit, sed diam nonummy nibh euismod tincidunt ut laoreet dolore magna aliquam erat volutpat. Ut wisi enim ad minim veniam, quis nostrud exerci tation ullamcorper suscipit lobortis nisl ut aliquip ex. (p) Lorem Ipsum Dolor Sit Amet (h5) Joomla 4 bootstrap 5 button secondary primary info success warning danger text-secondary text-primary text-info text-success text-warning text-danger Lorem ipsum dolor sit amet, consectetuer adipiscing elit, sed diam nonummy nibh euismod tincidunt ut laoreet dolore magna aliquam erat volutpat. Ut wisi enim ad minim veniam, quis nostrud exerci tation ullamcorper suscipit lobortis nisl ut aliquip ex. (p) Loremipsum dolor (a) Lists (ol)(li) Lorem ipsum dolor sit amet consectetur Lorem ipsum dolor sit amet consectetur (ul)(li) Lorem ipsum dolor sit amet consectetur Lorem ipsum dolor sit amet consectetur Theme Buttons Buttons have a number of great variations to choose from. You should note that in the HTML breakdown we have added a button class in addition to the variation, which is a requirement for these particular variations to work. You can also combine these variations. Default Button Button Primary Button Secondary Button Danger Button Text Default Button Button Primary Button Secondary Button Danger Button Text Notice Styles Nullam quis risus eget urna mollis ornare vel eu leo. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. … Nullam quis risus eget urna mollis ornare vel eu leo. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. … Nullam quis risus eget urna mollis ornare vel eu leo. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. … Nullam quis risus eget urna mollis ornare vel eu leo. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. … Blockquotes For quoting blocks of content from another source within your document. Default blockquote Wrap around any HTML as the quote. For straight quotes we recommend a . Lorem ipsum dolor sit amet, consectetur adipiscing elit. Integer posuere erat a ante. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Integer posuere erat a ante. Blockquote options Style and content changes for simple variations on a standard blockquote. Naming a source Add tag for identifying the source. Wrap the name of the source work in . Lorem ipsum dolor sit amet, consectetur adipiscing elit. Integer posuere erat a ante. Someone famous in Source Title Lorem ipsum dolor sit amet, consectetur adipiscing elit. Integer posuere erat a ante. Someone famous Source Title The blockquote element represents content that is quoted from another source, optionally with a citation which must be within a footer or cite element. Someone famous in Source Title Tables # First Name Last Name Username 1 John Doe JohnDoe 2 Jane Doe JaneDoe 3 Bob Doe BobDoe … \";i:3;a:26:{s:2:\"id\";i:1;s:5:\"alias\";s:16:\"theme typography\";s:7:\"summary\";s:7548:\"<p>We\'ve used <a href=\"https://rsms.me/inter\">Inter</a> font family for all of the themes because it\'s a beautiful font for UI design and is completely open-source and free. Using a custom font is nice because it allows us to make the components look the same on all browsers and operating systems. You can choose Google font via theme settings instead using local font. It\'s optional.</p>\r\n <h1>Headings</h1>\r\n    <p>All HTML headings, <code>&lt;h1&gt;</code> through <code>&lt;h6&gt;</code> are available.</p>\r\n<h1>Typography (h1)</h1><p>Lorem ipsum dolor sit amet, consectetuer adipiscing elit, sed diam nonummy nibh euismod tincidunt ut laoreet dolore magna aliquam erat volutpat. Ut wisi enim ad minim veniam, quis nostrud exerci tation ullamcorper suscipit lobortis nisl ut aliquip ex. (p)</p><h2>Lorem Ipsum Dolor Sit Amet (h2)</h2><p><strong>Lorem ipsum dolor sit amet, consectetuer adipiscing elit </strong> (strong), sed diam nonummy nibh euismod tincidunt ut laoreet dolore magna aliquam erat volutpat. Ut wisi enim ad minim veniam, quis nostrud exerci tation ullamcorper suscipit lobortis nisl ut aliquip ex. (p)</p><h3>Lorem Ipsum Dolor Sit Amet (h3)</h3><p>Lorem ipsum dolor sit amet, consectetuer adipiscing elit, sed diam nonummy nibh euismod tincidunt ut laoreet dolore magna aliquam erat volutpat. Ut wisi enim ad minim veniam, quis nostrud exerci tation ullamcorper suscipit lobortis nisl ut aliquip ex. (p)</p><h4>Lorem Ipsum Dolor Sit Amet (h4)</h4><p>Lorem ipsum dolor sit amet, consectetuer adipiscing elit, sed diam nonummy nibh euismod tincidunt ut laoreet dolore magna aliquam erat volutpat. Ut wisi enim ad minim veniam, quis nostrud exerci tation ullamcorper suscipit lobortis nisl ut aliquip ex. (p)</p><h5>Lorem Ipsum Dolor Sit Amet (h5)</h5>\r\n<h1>Joomla 4 bootstrap 5 button</h1> <p> <span class=\"btn btn-secondary\">secondary</span>   <span class=\"btn btn-primary\">primary</span>   <span class=\"btn btn-info\">info</span>   <span class=\"btn btn-success\">success</span>   <span class=\"btn btn-warning\">warning</span>   <span class=\"btn btn-danger\">danger</span> </p> <p><span class=\"text text-secondary\">text-secondary</span>  <span class=\"text text-primary\">text-primary</span>  <span class=\"text text-info\">text-info</span>  <span class=\"text text-success\">text-success</span>  <span class=\"text text-warning\">text-warning</span>  <span class=\"text text-danger\">text-danger</span></p><p>Lorem ipsum dolor sit amet, consectetuer adipiscing elit, sed diam nonummy nibh euismod tincidunt ut laoreet dolore magna aliquam erat volutpat. Ut wisi enim ad minim veniam, quis nostrud exerci tation ullamcorper suscipit lobortis nisl ut aliquip ex. (p)</p> <p><a href=\"index.php\"> Lorem ipsum dolor (a)</a></p><h1>Lists</h1> <p>(ol)(li)</p> <ol> <li>Lorem ipsum dolor sit amet consectetur</li> <li>Lorem ipsum dolor sit amet consectetur</li> </ol> <p>(ul)(li)</p> <ul> <li>Lorem ipsum dolor sit amet consectetur</li> <li>Lorem ipsum dolor sit amet consectetur</li> </ul> \r\n\r\n<h2>Theme Buttons</h2>\r\n\r\n<p>Buttons have a number of great variations to choose from. You should note that in the HTML breakdown we have added a <code>button</code> class in addition to the variation, which is a requirement for these particular variations to work. You can also combine these variations.</p>\r\n\r\n<p><a href=\"#\" class=\"jl-button jl-button-default\">Default Button</a>&nbsp;&nbsp;&nbsp;<a href=\"#\" class=\"jl-button jl-button-primary\">Button Primary</a>&nbsp;&nbsp;&nbsp;<a href=\"#\" class=\"jl-button jl-button-secondary\">Button Secondary</a>&nbsp;&nbsp;&nbsp;<a href=\"#\" class=\"jl-button jl-button-danger\">Button Danger</a>&nbsp;&nbsp;&nbsp;<a href=\"#\" class=\"jl-button jl-button-text\">Button Text</a></p>\r\n<pre>&#x3C;a href=&#x22;#&#x22; class=&#x22;jl-button jl-button-default&#x22;&#x3E;Default Button&#x3C;/a&#x3E;\r\n&#x3C;a href=&#x22;#&#x22; class=&#x22;jl-button jl-button-primary&#x22;&#x3E;Button Primary&#x3C;/a&#x3E;\r\n&#x3C;a href=&#x22;#&#x22; class=&#x22;jl-button jl-button-secondary&#x22;&#x3E;Button Secondary&#x3C;/a&#x3E;\r\n&#x3C;a href=&#x22;#&#x22; class=&#x22;jl-button jl-button-danger&#x22;&#x3E;Button Danger&#x3C;/a&#x3E;\r\n&#x3C;a href=&#x22;#&#x22; class=&#x22;jl-button jl-button-text&#x22;&#x3E;Button Text&#x3C;/a&#x3E;\r\n\r\n</pre>\r\n\r\n<h1>Notice Styles</h1>\r\n<p class=\"alert alert-success\">Nullam quis risus eget urna mollis ornare vel eu leo. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus.</p>\r\n<pre>&lt;p class=\"alert alert-success\"&gt;&hellip;&lt;/p&gt;</pre>\r\n<p class=\"alert alert-info\">Nullam quis risus eget urna mollis ornare vel eu leo. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus.</p>\r\n<pre>&lt;p class=\"alert alert-info\"&gt;&hellip;&lt;/p&gt;</pre>\r\n<p class=\"alert alert-warning\">Nullam quis risus eget urna mollis ornare vel eu leo. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus.</p>\r\n<pre>&lt;p class=\"alert alert-warning\"&gt;&hellip;&lt;/p&gt;</pre>\r\n<p class=\"alert alert-error\">Nullam quis risus eget urna mollis ornare vel eu leo. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus.</p>\r\n<pre>&lt;p class=\"alert alert-error\"&gt;&hellip;&lt;/p&gt;</pre>\r\n\r\n<h1>Blockquotes</h1>\r\n<p>For quoting blocks of content from another source within your document.</p>\r\n<h3>Default blockquote</h3>\r\n<p>Wrap <code>&lt;blockquote&gt;</code> around any <abbr title=\r\n\"HyperText Markup Language\">HTML</abbr> as the quote. For straight quotes we\r\nrecommend a <code>&lt;p&gt;</code>.</p>\r\n<blockquote>\r\n    <p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Integer posuere\r\n    erat a ante.</p>\r\n</blockquote>\r\n<pre>&lt;blockquote&gt;\r\n&lt;p&gt;Lorem ipsum dolor sit amet, consectetur adipiscing elit. Integer posuere erat a ante.&lt;/p&gt;\r\n&lt;/blockquote&gt;</pre>\r\n<h3>Blockquote options</h3><span>Style and content changes for simple\r\nvariations on a standard blockquote.</span><br>\r\n<h4>Naming a source</h4>\r\n<p>Add <code>&lt;small&gt;</code> tag for identifying the source. Wrap the name\r\nof the source work in <code>&lt;cite&gt;</code>.</p>\r\n<blockquote>\r\n    <p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Integer posuere\r\n    erat a ante.</p><small>Someone famous in <cite title=\"Source Title\">Source\r\n    Title</cite></small>\r\n</blockquote>\r\n<pre>&lt;blockquote&gt;&lt;p&gt;Lorem ipsum dolor sit amet, consectetur adipiscing elit. Integer posuere erat a ante.&lt;/p&gt;&lt;small&gt;Someone famous &lt;cite title=\"Source Title\"&gt;Source Title&lt;/cite&gt;&lt;/small&gt;&lt;/blockquote&gt;</pre>\r\n\r\n<blockquote class=\"jl-margin-medium\" cite=\"#\">\r\n    <p>The blockquote element represents content that is quoted from another source, optionally with a\r\n        citation which must be within a footer or cite element.</p>\r\n    <footer>Someone famous in <cite><a href=\"#\">Source Title</a></cite></footer>\r\n</blockquote>\r\n\r\n<h1>Tables</h1>\r\n<table>\r\n    <thead><tr>\r\n        <th>#</th>\r\n        <th>First Name</th>\r\n        <th>Last Name</th>\r\n        <th>Username</th>\r\n    </tr></thead>\r\n    <tbody>\r\n    <tr>\r\n        <td>1</td>\r\n        <td>John</td>\r\n        <td>Doe</td>\r\n        <td>JohnDoe</td>\r\n    </tr>\r\n    <tr>\r\n        <td>2</td>\r\n        <td>Jane</td>\r\n        <td>Doe</td>\r\n        <td>JaneDoe</td>\r\n    </tr>\r\n    <tr>\r\n        <td>3</td>\r\n        <td>Bob</td>\r\n        <td>Doe</td>\r\n        <td>BobDoe</td>\r\n    </tr>\r\n    </tbody>\r\n</table>\r\n<p>\r\n  <pre>&lt;table class=\"table\"&gt;&hellip;&lt;/table&gt;</pre>\r\n</p>\";s:4:\"body\";s:0:\"\";s:6:\"images\";s:173:\"{\"image_intro\":\"\",\"image_intro_alt\":\"\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}\";s:5:\"catid\";i:11;s:10:\"created_by\";i:107;s:16:\"created_by_alias\";s:0:\"\";s:8:\"modified\";s:19:\"2021-10-25 17:52:15\";s:11:\"modified_by\";i:107;s:6:\"params\";O:24:\"Joomla\\Registry\\Registry\":3:{s:7:\"\0*\0data\";O:8:\"stdClass\":88:{s:14:\"article_layout\";s:9:\"_:default\";s:10:\"show_title\";s:1:\"1\";s:11:\"link_titles\";s:1:\"1\";s:10:\"show_intro\";s:1:\"1\";s:19:\"info_block_position\";s:1:\"1\";s:21:\"info_block_show_title\";s:1:\"1\";s:13:\"show_category\";s:1:\"1\";s:13:\"link_category\";s:1:\"1\";s:20:\"show_parent_category\";s:1:\"0\";s:20:\"link_parent_category\";s:1:\"0\";s:17:\"show_associations\";s:1:\"0\";s:5:\"flags\";s:1:\"1\";s:11:\"show_author\";s:1:\"1\";s:11:\"link_author\";s:1:\"0\";s:16:\"show_create_date\";s:1:\"0\";s:16:\"show_modify_date\";s:1:\"0\";s:17:\"show_publish_date\";s:1:\"1\";s:20:\"show_item_navigation\";s:1:\"1\";s:9:\"show_vote\";s:1:\"0\";s:13:\"show_readmore\";s:1:\"1\";s:19:\"show_readmore_title\";s:1:\"0\";s:14:\"readmore_limit\";i:100;s:9:\"show_tags\";s:1:\"1\";s:11:\"record_hits\";s:1:\"0\";s:9:\"show_hits\";s:1:\"0\";s:11:\"show_noauth\";s:1:\"0\";s:13:\"urls_position\";i:0;s:7:\"captcha\";s:0:\"\";s:23:\"show_publishing_options\";s:1:\"1\";s:20:\"show_article_options\";s:1:\"1\";s:27:\"show_configure_edit_options\";s:1:\"1\";s:16:\"show_permissions\";s:1:\"1\";s:22:\"show_associations_edit\";s:1:\"1\";s:12:\"save_history\";s:1:\"0\";s:13:\"history_limit\";i:10;s:25:\"show_urls_images_frontend\";s:1:\"1\";s:24:\"show_urls_images_backend\";s:1:\"1\";s:7:\"targeta\";i:0;s:7:\"targetb\";i:0;s:7:\"targetc\";i:0;s:11:\"float_intro\";s:4:\"none\";s:14:\"float_fulltext\";s:4:\"none\";s:15:\"category_layout\";s:6:\"_:blog\";s:19:\"show_category_title\";s:1:\"0\";s:16:\"show_description\";s:1:\"0\";s:22:\"show_description_image\";s:1:\"0\";s:8:\"maxLevel\";s:1:\"1\";s:21:\"show_empty_categories\";s:1:\"0\";s:16:\"show_no_articles\";s:1:\"1\";s:32:\"show_category_heading_title_text\";s:1:\"1\";s:16:\"show_subcat_desc\";s:1:\"1\";s:21:\"show_cat_num_articles\";s:1:\"0\";s:13:\"show_cat_tags\";s:1:\"1\";s:21:\"show_base_description\";s:1:\"1\";s:11:\"maxLevelcat\";s:2:\"-1\";s:25:\"show_empty_categories_cat\";s:1:\"0\";s:20:\"show_subcat_desc_cat\";s:1:\"1\";s:25:\"show_cat_num_articles_cat\";s:1:\"1\";s:20:\"num_leading_articles\";i:1;s:18:\"blog_class_leading\";s:0:\"\";s:18:\"num_intro_articles\";i:4;s:10:\"blog_class\";s:0:\"\";s:11:\"num_columns\";i:2;s:18:\"multi_column_order\";s:1:\"0\";s:9:\"num_links\";i:4;s:24:\"show_subcategory_content\";s:1:\"0\";s:16:\"link_intro_image\";s:1:\"1\";s:21:\"show_pagination_limit\";s:1:\"1\";s:12:\"filter_field\";s:4:\"hide\";s:13:\"show_headings\";s:1:\"1\";s:14:\"list_show_date\";s:1:\"0\";s:11:\"date_format\";s:0:\"\";s:14:\"list_show_hits\";s:1:\"1\";s:16:\"list_show_author\";s:1:\"1\";s:15:\"list_show_votes\";s:1:\"0\";s:17:\"list_show_ratings\";s:1:\"0\";s:11:\"orderby_pri\";s:5:\"order\";s:11:\"orderby_sec\";s:5:\"rdate\";s:10:\"order_date\";s:9:\"published\";s:15:\"show_pagination\";s:1:\"2\";s:23:\"show_pagination_results\";s:1:\"1\";s:13:\"show_featured\";s:4:\"show\";s:14:\"show_feed_link\";s:1:\"1\";s:12:\"feed_summary\";s:1:\"0\";s:18:\"feed_show_readmore\";s:1:\"0\";s:7:\"sef_ids\";i:1;s:20:\"custom_fields_enable\";s:1:\"1\";s:16:\"workflow_enabled\";s:1:\"0\";}s:14:\"\0*\0initialized\";b:1;s:12:\"\0*\0separator\";s:1:\".\";}s:7:\"metakey\";s:0:\"\";s:8:\"metadesc\";s:0:\"\";s:8:\"metadata\";O:24:\"Joomla\\Registry\\Registry\":3:{s:7:\"\0*\0data\";O:8:\"stdClass\":3:{s:6:\"robots\";s:0:\"\";s:6:\"author\";s:0:\"\";s:6:\"rights\";s:0:\"\";}s:14:\"\0*\0initialized\";b:1;s:12:\"\0*\0separator\";s:1:\".\";}s:7:\"version\";i:64;s:8:\"ordering\";i:2;s:8:\"category\";s:8:\"Features\";s:9:\"cat_state\";i:1;s:10:\"cat_access\";i:1;s:4:\"slug\";s:18:\"1:theme-typography\";s:7:\"catslug\";s:11:\"11:features\";s:6:\"author\";s:5:\"admin\";s:4:\"mime\";N;s:6:\"layout\";s:7:\"article\";s:7:\"context\";s:19:\"com_content.article\";s:10:\"metaauthor\";N;}i:4;N;i:5;a:5:{i:1;a:3:{i:0;s:5:\"title\";i:1;s:8:\"subtitle\";i:2;s:2:\"id\";}i:2;a:2:{i:0;s:7:\"summary\";i:1;s:4:\"body\";}i:3;a:8:{i:0;s:4:\"meta\";i:1;s:10:\"list_price\";i:2;s:10:\"sale_price\";i:3;s:7:\"metakey\";i:4;s:8:\"metadesc\";i:5;s:10:\"metaauthor\";i:6;s:6:\"author\";i:7;s:16:\"created_by_alias\";}i:4;a:2:{i:0;s:4:\"path\";i:1;s:5:\"alias\";}i:5;a:1:{i:0;s:8:\"comments\";}}i:6;s:1:\"*\";i:7;N;i:8;N;i:9;s:19:\"2021-05-16 02:42:00\";i:10;N;i:11;s:72:\"index.php?option=com_content&view=article&id=1:theme-typography&catid=11\";i:12;N;i:13;s:19:\"1980-01-01 00:00:00\";i:14;i:1;i:15;a:4:{s:4:\"Type\";a:1:{i:0;O:8:\"stdClass\":6:{s:5:\"title\";s:7:\"Article\";s:5:\"state\";i:1;s:6:\"access\";i:1;s:8:\"language\";s:0:\"\";s:6:\"nested\";b:0;s:2:\"id\";i:13;}}s:6:\"Author\";a:1:{i:0;O:8:\"stdClass\":6:{s:5:\"title\";s:5:\"admin\";s:5:\"state\";i:1;s:6:\"access\";i:1;s:8:\"language\";s:0:\"\";s:6:\"nested\";b:0;s:2:\"id\";i:15;}}s:8:\"Category\";a:1:{i:0;O:8:\"stdClass\":6:{s:5:\"title\";s:8:\"Features\";s:5:\"state\";i:1;s:6:\"access\";i:1;s:8:\"language\";s:1:\"*\";s:6:\"nested\";b:1;s:2:\"id\";i:16;}}s:8:\"Language\";a:1:{i:0;O:8:\"stdClass\":6:{s:5:\"title\";s:1:\"*\";s:5:\"state\";i:1;s:6:\"access\";i:1;s:8:\"language\";s:0:\"\";s:6:\"nested\";b:0;s:2:\"id\";i:5;}}}i:16;s:16:\"Theme Typography\";i:17;i:4;i:18;s:46:\"index.php?option=com_content&view=article&id=1\";}'),
('11', 'index.php?option=com_content&view=article&id=4', 'index.php?option=com_content&view=article&id=4:uikit-overview&catid=2', 'UIkit Overview', ' Logo Active Parent Active Parent Sub item Sub item Header Item Item Item Item Item Home Blog Category Post Article Title Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum. Written by Super User on 12 April 2012. Posted in Blog  Default Primary Secondary Danger Disabled a element abbr element code element del element dfn element Link Muted em element ins element mark element q inside a q strong element Link Reset Text Muted Text Emphasis Text Primary Text Secondary Text Success Text Warning Text Danger Text Meta Default Success Warning Danger 1  ... The blockquote element represents content that is quoted from another source, optionally with a citation which must be within a footer or cite element. Someone famous in Source Title Read more 5 Comments Author 12 days ago Reply  Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. 1 ... 4 5 6 7 8 9 10 ... 20 Active Parent Sub item Sub item Sub item Sub item Parent Sub item Sub item Header Item Item Item Default Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Primary Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Secondary Lorem ipsum dolor sitamet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Hover Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. 2X-Large X-Large Heading L Heading M Heading S Heading H1 Heading H2 Heading H3 Heading H4 Heading H5 Heading H6 Heading Divider Heading Bullet Heading Line Table Heading Table Heading Table Heading Table Data Table Data Table Data Table Data Table Data Table Data Table Data Table Data Table Data Table Data Table Data Table Data 365 : 18 : 21 : 05 Text  Option 01 Option 02 Radio Checkbox States Active Item Item Item Active Subtitle lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do. Item Subtitle lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do. Item Subtitle lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do. Item Subtitle lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do. Default Primary Success Warning Danger Default Lorem ipsum dolor sit amet, consectetur. Primary Lorem ipsum dolor sit amet, consectetur.  Item 1 Item 2 Item 3 Item 4 Item 5 Item 6 Tooltip Active Item Disabled Active Item Disabled Active Item Disabled List item 1 List item 2 List item 3 List item 1 List item 2 List item 3 List item 1 List item 2 List item 3 Description lists A description text Description lists A description text Item 1 Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco.  Item 2 Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco. Item 3 Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco. Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor. Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor. Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor. Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor. Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor. Button Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor. Button Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor. Button Lorem ipsum dolor sit amet, consecteturadipiscing elit, sed do eiusmod tempor. Button Headline Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum. Cancel Save Active Item Item Item Active Parent Sub item Sub item Header Item Item Item Title Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. ', '2023-04-26 12:28:27', 'ca83d11b3ed1a0dd2fe9bd39642c9fba', '1', '1', '1', '*', '2021-05-15 23:36:07', NULL, '1980-01-01 00:00:00', NULL, '0', '0', '4', 'O:52:\"Joomla\\Component\\Finder\\Administrator\\Indexer\\Result\":19:{i:0;i:1;i:1;s:5:\"en-GB\";i:2;s:5306:\" Logo Active Parent Active Parent Sub item Sub item Header Item Item Item Item Item Home Blog Category Post Article Title Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum. Written by Super User on 12 April 2012. Posted in Blog  Default Primary Secondary Danger Disabled a element abbr element code element del element dfn element Link Muted em element ins element mark element q inside a q strong element Link Reset Text Muted Text Emphasis Text Primary Text Secondary Text Success Text Warning Text Danger Text Meta Default Success Warning Danger 1  ... The blockquote element represents content that is quoted from another source, optionally with a citation which must be within a footer or cite element. Someone famous in Source Title Read more 5 Comments Author 12 days ago Reply  Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. 1 ... 4 5 6 7 8 9 10 ... 20 Active Parent Sub item Sub item Sub item Sub item Parent Sub item Sub item Header Item Item Item Default Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Primary Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Secondary Lorem ipsum dolor sitamet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Hover Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. 2X-Large X-Large Heading L Heading M Heading S Heading H1 Heading H2 Heading H3 Heading H4 Heading H5 Heading H6 Heading Divider Heading Bullet Heading Line Table Heading Table Heading Table Heading Table Data Table Data Table Data Table Data Table Data Table Data Table Data Table Data Table Data Table Data Table Data Table Data 365 : 18 : 21 : 05 Text  Option 01 Option 02 Radio Checkbox States Active Item Item Item Active Subtitle lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do. Item Subtitle lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do. Item Subtitle lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do. Item Subtitle lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do. Default Primary Success Warning Danger Default Lorem ipsum dolor sit amet, consectetur. Primary Lorem ipsum dolor sit amet, consectetur.  Item 1 Item 2 Item 3 Item 4 Item 5 Item 6 Tooltip Active Item Disabled Active Item Disabled Active Item Disabled List item 1 List item 2 List item 3 List item 1 List item 2 List item 3 List item 1 List item 2 List item 3 Description lists A description text Description lists A description text Item 1 Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco.  Item 2 Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco. Item 3 Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco. Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor. Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor. Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor. Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor. Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor. Button Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor. Button Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor. Button Lorem ipsum dolor sit amet, consecteturadipiscing elit, sed do eiusmod tempor. Button Headline Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum. Cancel Save Active Item Item Item Active Parent Sub item Sub item Header Item Item Item Title Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. \";i:3;a:26:{s:2:\"id\";i:4;s:5:\"alias\";s:14:\"uikit overview\";s:7:\"summary\";s:38754:\"<nav class=\"jl-navbar-container\">\r\n    <div jl-navbar class=\"jl-navbar jl-margin-small-left jl-margin-small-right\">\r\n        <div class=\"jl-navbar-left\">\r\n\r\n            <a class=\"jl-navbar-item jl-logo\" href=\"#\">Logo</a>\r\n\r\n            <ul class=\"jl-navbar-nav\">\r\n                <li class=\"jl-active\"><a href=\"#\">Active</a></li>\r\n                <li>\r\n                    <a href=\"#\" aria-expanded=\"false\">Parent<span jl-navbar-parent-icon></span></a>\r\n                    <div class=\"jl-navbar-dropdown\">\r\n                        <ul class=\"jl-nav jl-navbar-dropdown-nav\">\r\n                            <li class=\"jl-active\"><a href=\"#\">Active</a></li>\r\n                            <li class=\"jl-parent\">\r\n                                <a href=\"#\">Parent</a>\r\n                                <ul class=\"jl-nav-sub\">\r\n                                    <li><a href=\"#\">Sub item</a></li>\r\n                                    <li><a href=\"#\">Sub item</a></li>\r\n                                </ul>\r\n                            </li>\r\n                            <li class=\"jl-nav-header\">Header</li>\r\n                            <li><a href=\"#\"><span class=\"jl-margin-small-right jl-icon\" jl-icon=\"icon: table\"></span>\r\n                                    Item</a></li>\r\n                            <li><a href=\"#\"><span class=\"jl-margin-small-right jl-icon\"\r\n                                        jl-icon=\"icon: thumbnails\"></span> Item</a></li>\r\n                            <li class=\"jl-nav-divider\"></li>\r\n                            <li><a href=\"#\"><span class=\"jl-margin-small-right jl-icon\" jl-icon=\"icon: trash\"></span>\r\n                                    Item</a></li>\r\n                        </ul>\r\n                    </div>\r\n                </li>\r\n                <li><a href=\"#\">Item</a></li>\r\n                <li><a href=\"#\">Item</a></li>\r\n            </ul>\r\n\r\n        </div>\r\n        <div class=\"jl-navbar-right\">\r\n            <a class=\"jl-navbar-toggle jl-icon\" href=\"#modal\" jl-icon=\"icon: more-vertical\" jl-toggle></a>\r\n            <a class=\"jl-navbar-toggle jl-icon jl-search-icon\" href=\"#modal-search\" jl-search-icon jl-toggle></a>\r\n            <a class=\"jl-navbar-toggle jl-navbar-toggle-animate\" href=\"#offcanvas\" jl-navbar-toggle-icon jl-toggle></a>\r\n        </div>\r\n    </div>\r\n</nav>\r\n\r\n<div class=\"jl-section jl-section-default\">\r\n\r\n    <div jl-grid class=\"jl-grid\">\r\n        <div class=\"jl-width-2-3@m\">\r\n\r\n            <ul class=\"jl-breadcrumb\">\r\n                <li><a href=\"#\">Home</a></li>\r\n                <li><a href=\"#\">Blog</a></li>\r\n                <li class=\"jl-disabled\"><a>Category</a></li>\r\n                <li><span>Post</span></li>\r\n            </ul>\r\n\r\n            <article class=\"jl-article\">\r\n\r\n                <h1 class=\"jl-article-title\"><a class=\"jl-link-reset\" href=\"#\">Article Title</a></h1>\r\n\r\n                <hr class=\"jl-divider-small\">\r\n\r\n                <p class=\"jl-text-lead\">Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor\r\n                    incididunt ut labore et dolore magna aliqua.</p>\r\n\r\n                <p class=\"jl-column-1-2@s jl-dropcap\">Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do\r\n                    eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud\r\n                    exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in\r\n                    reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint\r\n                    occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.</p>\r\n\r\n                <p class=\"jl-article-meta\">Written by <a href=\"#\">Super User</a> on 12 April 2012. Posted in <a\r\n                        href=\"#\">Blog</a></p>\r\n\r\n                <hr class=\"jl-divider-icon jl-margin-medium\">\r\n\r\n                <div class=\"jl-grid-small jl-child-width-auto jl-flex-middle jl-margin-medium\" jl-grid>\r\n                    <div>\r\n                        <button class=\"jl-button jl-button-default\" aria-expanded=\"false\">Default</button>\r\n                    </div>\r\n                    <div>\r\n                        <button class=\"jl-button jl-button-primary\">Primary</button>\r\n                    </div>\r\n                    <div>\r\n                        <button class=\"jl-button jl-button-secondary\">Secondary</button>\r\n                    </div>\r\n                    <div>\r\n                        <button class=\"jl-button jl-button-danger\">Danger</button>\r\n                    </div>\r\n                    <div>\r\n                        <button class=\"jl-button jl-button-default\" disabled=\"\">Disabled</button>\r\n                    </div>\r\n\r\n                </div>\r\n\r\n                <hr class=\"jl-margin-medium\">\r\n\r\n                <div class=\"jl-child-width-1-2 jl-child-width-1-4@s jl-margin\" jl-grid>\r\n                    <div>\r\n                        <ul class=\"jl-list\">\r\n                            <li><a href=\"#\">a element</a></li>\r\n                            <li><abbr title=\"Title text\">abbr element</abbr></li>\r\n                            <li><code>code element</code></li>\r\n                            <li><del>del element</del></li>\r\n                            <li><dfn title=\"Title text\">dfn element</dfn></li>\r\n                            <li><a href=\"#\" class=\"jl-link-muted\">Link Muted</a></li>\r\n                        </ul>\r\n                    </div>\r\n                    <div>\r\n                        <ul class=\"jl-list\">\r\n                            <li><em>em element</em></li>\r\n                            <li><ins>ins element</ins></li>\r\n                            <li><mark>mark element</mark></li>\r\n                            <li><q>q <q>inside</q> a q</q></li>\r\n                            <li><strong>strong element</strong></li>\r\n                            <li><a href=\"#\" class=\"jl-link-reset\">Link Reset</a></li>\r\n                        </ul>\r\n                    </div>\r\n                    <div>\r\n                        <ul class=\"jl-list\">\r\n                            <li class=\"jl-text-muted\">Text Muted</li>\r\n                            <li class=\"jl-text-emphasis\">Text Emphasis</li>\r\n                            <li class=\"jl-text-primary\">Text Primary</li>\r\n                            <li class=\"jl-text-secondary\">Text Secondary</li>\r\n                            <li class=\"jl-text-success\">Text Success</li>\r\n                            <li class=\"jl-text-warning\">Text Warning</li>\r\n                            <li class=\"jl-text-danger\">Text Danger</li>\r\n                            <li class=\"jl-text-meta\">Text Meta</li>\r\n                        </ul>\r\n                    </div>\r\n                    <div>\r\n                        <ul class=\"jl-list\">\r\n                            <li><span class=\"jl-label\">Default</span></li>\r\n                            <li><span class=\"jl-label jl-label-success\">Success</span></li>\r\n                            <li><span class=\"jl-label jl-label-warning\">Warning</span></li>\r\n                            <li><span class=\"jl-label jl-label-danger\">Danger</span></li>\r\n                            <li><a class=\"jl-badge\" href=\"#\">1</a></li>\r\n                            <li>\r\n                                <a class=\"jl-icon-button jl-icon\" href=\"#\" jl-icon=\"icon: home\">\r\n                                    <svg width=\"20\" height=\"20\" viewBox=\"0 0 20 20\" xmlns=\"http://www.w3.org/2000/svg\">\r\n                                        <polygon points=\"18.65 11.35 10 2.71 1.35 11.35 0.65 10.65 10 1.29 19.35 10.65\">\r\n                                        </polygon>\r\n                                        <polygon points=\"15 4 18 4 18 7 17 7 17 5 15 5\"></polygon>\r\n                                        <polygon\r\n                                            points=\"3 11 4 11 4 18 7 18 7 12 12 12 12 18 16 18 16 11 17 11 17 19 11 19 11 13 8 13 8 19 3 19\">\r\n                                        </polygon>\r\n                                    </svg>\r\n                                </a>\r\n                                <a class=\"jl-icon-button jl-icon\" href=\"#\" jl-icon=\"icon: github\">\r\n                                    <svg width=\"20\" height=\"20\" viewBox=\"0 0 20 20\" xmlns=\"http://www.w3.org/2000/svg\">\r\n                                        <path\r\n                                            d=\"M10,1 C5.03,1 1,5.03 1,10 C1,13.98 3.58,17.35 7.16,18.54 C7.61,18.62 7.77,18.34 7.77,18.11 C7.77,17.9 7.76,17.33 7.76,16.58 C5.26,17.12 4.73,15.37 4.73,15.37 C4.32,14.33 3.73,14.05 3.73,14.05 C2.91,13.5 3.79,13.5 3.79,13.5 C4.69,13.56 5.17,14.43 5.17,14.43 C5.97,15.8 7.28,15.41 7.79,15.18 C7.87,14.6 8.1,14.2 8.36,13.98 C6.36,13.75 4.26,12.98 4.26,9.53 C4.26,8.55 4.61,7.74 5.19,7.11 C5.1,6.88 4.79,5.97 5.28,4.73 C5.28,4.73 6.04,4.49 7.75,5.65 C8.47,5.45 9.24,5.35 10,5.35 C10.76,5.35 11.53,5.45 12.25,5.65 C13.97,4.48 14.72,4.73 14.72,4.73 C15.21,5.97 14.9,6.88 14.81,7.11 C15.39,7.74 15.73,8.54 15.73,9.53 C15.73,12.99 13.63,13.75 11.62,13.97 C11.94,14.25 12.23,14.8 12.23,15.64 C12.23,16.84 12.22,17.81 12.22,18.11 C12.22,18.35 12.38,18.63 12.84,18.54 C16.42,17.35 19,13.98 19,10 C19,5.03 14.97,1 10,1 L10,1 Z\">\r\n                                        </path>\r\n                                    </svg>\r\n                                </a>\r\n                                <a class=\"jl-icon-link jl-icon\" href=\"#\" jl-icon=\"icon: trash\">\r\n                                    <svg width=\"20\" height=\"20\" viewBox=\"0 0 20 20\" xmlns=\"http://www.w3.org/2000/svg\">\r\n                                        <polyline fill=\"none\" stroke=\"#000\" points=\"6.5 3 6.5 1.5 13.5 1.5 13.5 3\">\r\n                                        </polyline>\r\n                                        <polyline fill=\"none\" stroke=\"#000\" points=\"4.5 4 4.5 18.5 15.5 18.5 15.5 4\">\r\n                                        </polyline>\r\n                                        <rect x=\"8\" y=\"7\" width=\"1\" height=\"9\"></rect>\r\n                                        <rect x=\"11\" y=\"7\" width=\"1\" height=\"9\"></rect>\r\n                                        <rect x=\"2\" y=\"3\" width=\"16\" height=\"1\"></rect>\r\n                                    </svg>\r\n                                </a>\r\n                            </li>\r\n                        </ul>\r\n                    </div>\r\n                </div>\r\n\r\n                <pre class=\"jl-pre jl-margin-medium\"><code>&lt;div class=\"myclass\"&gt;...&lt;div&gt;</code></pre>\r\n\r\n                <blockquote class=\"jl-margin-medium\" cite=\"#\">\r\n                    <p>The blockquote element represents content that is quoted from another source, optionally with a\r\n                        citation which must be within a footer or cite element.</p>\r\n                    <footer>Someone famous in <cite><a href=\"#\">Source Title</a></cite></footer>\r\n                </blockquote>\r\n\r\n                <div class=\"jl-grid-small\" jl-grid>\r\n                    <div>\r\n                        <a class=\"jl-button jl-button-text\" href=\"#\">Read more</a>\r\n                    </div>\r\n                    <div>\r\n                        <a class=\"jl-button jl-button-text\" href=\"#\">5 Comments</a>\r\n                    </div>\r\n                </div>\r\n\r\n            </article>\r\n\r\n            <hr class=\"jl-margin-medium\">\r\n\r\n            <ul class=\"jl-comment-list jl-margin-medium\">\r\n                <li>\r\n                    <article class=\"jl-comment jl-visible-toggle\" tabindex=\"-1\">\r\n                        <header class=\"jl-comment-header jl-position-relative\">\r\n                            <div class=\"jl-grid-medium jl-flex-middle\" jl-grid>\r\n                                <div class=\"jl-width-auto\">\r\n                                    <img class=\"jl-comment-avatar test-img-small\"\r\n                                        src=\"https://source.unsplash.com/random/50x50\" width=\"50\" height=\"50\" alt=\"\">\r\n                                </div>\r\n                                <div class=\"jl-width-expand\">\r\n                                    <h4 class=\"jl-comment-title jl-margin-remove\"><a class=\"jl-link-reset\"\r\n                                            href=\"#\">Author</a></h4>\r\n                                    <p class=\"jl-comment-meta jl-margin-remove-top\"><a class=\"jl-link-reset\" href=\"#\">12\r\n                                            days ago</a></p>\r\n                                </div>\r\n                            </div>\r\n                            <div class=\"jl-position-top-right jl-position-small jl-hidden-hover\"><a\r\n                                    class=\"jl-button jl-button-text\" href=\"#\">Reply</a></div>\r\n                        </header>\r\n                        <div class=\"jl-comment-body\">\r\n                            <p>Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor\r\n                                invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.</p>\r\n                        </div>\r\n                    </article>\r\n                </li>\r\n            </ul>\r\n\r\n            <ul class=\"jl-pagination jl-flex-center\" jl-margin=\"\">\r\n                <li><a href=\"#\"><span jl-pagination-previous=\"\"\r\n                            class=\"jl-icon jl-pagination-previous\"></span></a></li>\r\n                <li><a href=\"#\">1</a></li>\r\n                <li class=\"jl-disabled\"><span>...</span></li>\r\n                <li><a href=\"#\">4</a></li>\r\n                <li><a href=\"#\">5</a></li>\r\n                <li><a href=\"#\">6</a></li>\r\n                <li class=\"jl-active\"><span>7</span></li>\r\n                <li><a href=\"#\">8</a></li>\r\n                <li><a href=\"#\">9</a></li>\r\n                <li><a href=\"#\">10</a></li>\r\n                <li class=\"jl-disabled\"><span>...</span></li>\r\n                <li><a href=\"#\">20</a></li>\r\n                <li><a href=\"#\"><span jl-pagination-next=\"\" class=\"jl-icon jl-pagination-next\"></span></a></li>\r\n            </ul>\r\n\r\n        </div>\r\n        <div class=\"jl-width-expand@m\">\r\n\r\n            <div class=\"jl-margin-medium-bottom\">\r\n                <form class=\"jl-search jl-search-default jl-width-1-1\">\r\n                    <span jl-search-icon class=\"jl-icon jl-search-icon\"></span>\r\n                    <input class=\"jl-search-input\" type=\"search\" placeholder=\"Search...\">\r\n                </form>\r\n            </div>\r\n\r\n            <ul class=\"jl-nav-default jl-nav-parent-icon jl-margin-medium jl-nav\" jl-nav>\r\n                <li class=\"jl-active\"><a href=\"#\">Active</a></li>\r\n                <li class=\"jl-parent\">\r\n                    <a href=\"#\">Parent <span jl-nav-parent-icon></span></a>\r\n                    <ul class=\"jl-nav-sub\" hidden aria-hidden=\"true\">\r\n                        <li><a href=\"#\">Sub item</a></li>\r\n                        <li><a href=\"#\">Sub item</a>\r\n                            <ul>\r\n                                <li><a href=\"#\">Sub item</a></li>\r\n                                <li><a href=\"#\">Sub item</a></li>\r\n                            </ul>\r\n                        </li>\r\n                    </ul>\r\n                </li>\r\n                <li class=\"jl-parent\">\r\n                    <a href=\"#\">Parent <span jl-nav-parent-icon></span></a>\r\n                    <ul class=\"jl-nav-sub\" hidden aria-hidden=\"true\">\r\n                        <li><a href=\"#\">Sub item</a></li>\r\n                        <li><a href=\"#\">Sub item</a></li>\r\n                    </ul>\r\n                </li>\r\n                <li class=\"jl-nav-header\">Header</li>\r\n                    <li><a href=\"#\"><span class=\"jl-margin-small-right jl-icon\" jl-icon=\"icon: table\"><svg width=\"20\" height=\"20\" viewBox=\"0 0 20 20\" xmlns=\"http://www.w3.org/2000/svg\"><rect x=\"1\" y=\"3\" width=\"18\" height=\"1\"></rect><rect x=\"1\" y=\"7\" width=\"18\" height=\"1\"></rect><rect x=\"1\" y=\"11\" width=\"18\" height=\"1\"></rect><rect x=\"1\" y=\"15\" width=\"18\" height=\"1\"></rect></svg></span> Item</a></li>\r\n                    <li><a href=\"#\"><span class=\"jl-margin-small-right jl-icon\" jl-icon=\"icon: thumbnails\"><svg width=\"20\" height=\"20\" viewBox=\"0 0 20 20\" xmlns=\"http://www.w3.org/2000/svg\"><rect fill=\"none\" stroke=\"#000\" x=\"3.5\" y=\"3.5\" width=\"5\" height=\"5\"></rect><rect fill=\"none\" stroke=\"#000\" x=\"11.5\" y=\"3.5\" width=\"5\" height=\"5\"></rect><rect fill=\"none\" stroke=\"#000\" x=\"11.5\" y=\"11.5\" width=\"5\" height=\"5\"></rect><rect fill=\"none\" stroke=\"#000\" x=\"3.5\" y=\"11.5\" width=\"5\" height=\"5\"></rect></svg></span> Item</a></li>\r\n                    <li class=\"jl-nav-divider\"></li>\r\n                    <li><a href=\"#\"><span class=\"jl-margin-small-right jl-icon\" jl-icon=\"icon: trash\"><svg width=\"20\" height=\"20\" viewBox=\"0 0 20 20\" xmlns=\"http://www.w3.org/2000/svg\"><polyline fill=\"none\" stroke=\"#000\" points=\"6.5 3 6.5 1.5 13.5 1.5 13.5 3\"></polyline><polyline fill=\"none\" stroke=\"#000\" points=\"4.5 4 4.5 18.5 15.5 18.5 15.5 4\"></polyline><rect x=\"8\" y=\"7\" width=\"1\" height=\"9\"></rect><rect x=\"11\" y=\"7\" width=\"1\" height=\"9\"></rect><rect x=\"2\" y=\"3\" width=\"16\" height=\"1\"></rect></svg></span> Item</a></li>\r\n                </ul>\r\n\r\n            <div class=\"jl-card jl-card-body jl-card-default jl-card-hover\">\r\n                <h3 class=\"jl-card-title\">Default</h3>\r\n                <p>Lorem ipsum <a href=\"#\">dolor</a> sit amet, consectetur adipiscing elit, sed do eiusmod tempor\r\n                    incididunt ut labore et dolore magna aliqua.</p>\r\n            </div>\r\n\r\n            <div class=\"jl-margin jl-card jl-card-body jl-card-primary jl-light jl-card-hover\">\r\n                <h3 class=\"jl-card-title\">Primary</h3>\r\n                <p>Lorem ipsum <a href=\"#\">dolor</a> sit amet, consectetur adipiscing elit, sed do eiusmod tempor\r\n                    incididunt ut labore et dolore magna aliqua.</p>\r\n            </div>\r\n\r\n            <div class=\"jl-margin jl-card jl-card-body jl-card-secondary jl-light jl-card-hover\">\r\n                <h3 class=\"jl-card-title\">Secondary</h3>\r\n                <p>Lorem ipsum <a href=\"#\">dolor</a> sit amet, consectetur adipiscing elit, sed do eiusmod tempor\r\n                    incididunt ut labore et dolore magna aliqua.</p>\r\n            </div>\r\n\r\n            <div class=\"jl-margin jl-card jl-card-body jl-card-hover\">\r\n                <h3 class=\"jl-card-title\">Hover</h3>\r\n                <p>Lorem ipsum <a href=\"#\">dolor</a> sit amet, consectetur adipiscing elit, sed do eiusmod tempor\r\n                    incididunt ut labore et dolore magna aliqua.</p>\r\n            </div>\r\n\r\n        </div>\r\n    </div>\r\n\r\n<hr class=\"jl-margin-large\">\r\n\r\n<div class=\"jl-grid-divider\" jl-grid>\r\n    <div class=\"jl-width-2-3@m\">\r\n\r\n        <h1 class=\"jl-heading-2xlarge jl-margin-small\">2X-Large</h1>\r\n        <h1 class=\"jl-heading-xlarge jl-margin-small\">X-Large</h1>\r\n        <h1 class=\"jl-heading-large jl-margin-small\">Heading L</h1>\r\n        <h1 class=\"jl-heading-medium jl-margin-small\">Heading M</h1>\r\n        <h1 class=\"jl-heading-small jl-margin-small\">Heading S</h1>\r\n\r\n        <h1 class=\"jl-margin-small\">Heading H1</h1>\r\n        <h2 class=\"jl-margin-small\">Heading H2</h2>\r\n        <h3 class=\"jl-margin-small\">Heading H3</h3>\r\n        <h4 class=\"jl-margin-small\">Heading H4</h4>\r\n        <h5 class=\"jl-margin-small\">Heading H5</h5>\r\n        <h6 class=\"jl-margin-small\">Heading H6</h6>\r\n\r\n        <h3 class=\"jl-heading-divider\">Heading Divider</h3>\r\n        <h3 class=\"jl-heading-bullet\">Heading Bullet</h3>\r\n        <h3 class=\"jl-heading-line\"><span>Heading Line</span></h3>\r\n\r\n        <div class=\"jl-overflow-auto jl-margin-medium-top\">\r\n            <table class=\"jl-table jl-table-divider jl-table-hover jl-table-small\">\r\n                <thead>\r\n                    <tr>\r\n                        <th>Table Heading</th>\r\n                        <th>Table Heading</th>\r\n                        <th>Table Heading</th>\r\n                    </tr>\r\n                </thead>\r\n                <tbody>\r\n                    <tr>\r\n                        <td>Table Data</td>\r\n                        <td>Table Data</td>\r\n                        <td>Table Data</td>\r\n                    </tr>\r\n                    <tr>\r\n                        <td>Table Data</td>\r\n                        <td>Table Data</td>\r\n                        <td>Table Data</td>\r\n                    </tr>\r\n                    <tr>\r\n                        <td>Table Data</td>\r\n                        <td>Table Data</td>\r\n                        <td>Table Data</td>\r\n                    </tr>\r\n                    <tr>\r\n                        <td>Table Data</td>\r\n                        <td>Table Data</td>\r\n                        <td>Table Data</td>\r\n                    </tr>\r\n                </tbody>\r\n            </table>\r\n        </div>\r\n\r\n        <div class=\"jl-grid-small jl-child-width-auto jl-margin-medium-top\" jl-grid js-countdown>\r\n            <div>\r\n                <div class=\"jl-countdown-number jl-countdown-days\">365</div>\r\n            </div>\r\n            <div class=\"jl-countdown-separator\">:</div>\r\n            <div>\r\n                <div class=\"jl-countdown-number jl-countdown-hours\">18</div>\r\n            </div>\r\n            <div class=\"jl-countdown-separator\">:</div>\r\n            <div>\r\n                <div class=\"jl-countdown-number jl-countdown-minutes\">21</div>\r\n            </div>\r\n            <div class=\"jl-countdown-separator\">:</div>\r\n            <div>\r\n                <div class=\"jl-countdown-number jl-countdown-seconds\">05</div>\r\n            </div>\r\n        </div>\r\n\r\n\r\n    </div>\r\n    <div class=\"jl-width-1-3@m\">\r\n\r\n        <form class=\"jl-form-stacked\">\r\n\r\n            <div class=\"jl-margin-small\">\r\n                <label class=\"jl-form-label\">Text</label>\r\n                <input class=\"jl-input\" type=\"text\" placeholder=\"Some text...\">\r\n            </div>\r\n\r\n            <div class=\"jl-margin-small\">\r\n                <select class=\"jl-select\">\r\n                    <option>Option 01</option>\r\n                    <option>Option 02</option>\r\n                </select>\r\n            </div>\r\n\r\n            <div class=\"jl-margin-small\">\r\n                 <textarea class=\"jl-textarea\" rows=\"2\" placeholder=\"Some text...\"></textarea>\r\n            </div>\r\n\r\n            <div class=\"jl-grid-small jl-child-width-auto\" jl-grid>\r\n                <div>\r\n                    <label><input class=\"jl-radio\" type=\"radio\" name=\"radio\"> Radio</label>\r\n                </div>\r\n                <div>\r\n                    <label><input class=\"jl-checkbox\" type=\"checkbox\"> Checkbox</label>\r\n                </div>\r\n            </div>\r\n\r\n            <div class=\"jl-margin-small\">\r\n                <input class=\"jl-range\" type=\"range\" value=\"2\" min=\"0\" max=\"10\" step=\"0.1\">\r\n            </div>\r\n\r\n            <div class=\"jl-margin-small\">\r\n                <label class=\"jl-form-label\">States</label>\r\n                <input class=\"jl-input\" type=\"text\" placeholder=\":disabled\" disabled>\r\n            </div>\r\n\r\n            <div class=\"jl-margin-small\">\r\n                <input class=\"jl-input jl-form-danger\" type=\"text\" placeholder=\"form-danger\" value=\"form-danger\">\r\n            </div>\r\n            <div class=\"jl-margin-small\">\r\n                <input class=\"jl-input jl-form-success\" type=\"text\" placeholder=\"form-success\" value=\"form-success\">\r\n            </div>\r\n            <div class=\"jl-margin-small\">\r\n                <input class=\"jl-input jl-form-blank\" type=\"text\" placeholder=\"form-blank\">\r\n            </div>\r\n\r\n        </form>\r\n\r\n        <ul class=\"jl-nav jl-nav-primary jl-margin-medium\">\r\n            <li class=\"jl-active\"><a href=\"#\">Active</a></li>\r\n            <li><a href=\"#\">Item</a></li>\r\n            <li><a href=\"#\">Item</a></li>\r\n            <li><a href=\"#\">Item</a></li>\r\n        </ul>\r\n\r\n        <ul class=\"jl-nav jl-nav-secondary jl-margin-medium\">\r\n            <li class=\"jl-active\"><a href=\"#\"><div>Active<div class=\"jl-nav-subtitle\">Subtitle lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do.</div></div></a></li>\r\n            <li><a href=\"#\"><div>Item<div class=\"jl-nav-subtitle\">Subtitle lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do.</div></div></a></li>\r\n            <li><a href=\"#\"><div>Item<div class=\"jl-nav-subtitle\">Subtitle lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do.</div></div></a></li>\r\n            <li><a href=\"#\"><div>Item<div class=\"jl-nav-subtitle\">Subtitle lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do.</div></div></a></li>\r\n        </ul>\r\n\r\n        <div class=\"jl-margin-medium-top\" jl-alert>\r\n            <a href=\"#\" class=\"jl-alert-close\" jl-close></a>\r\n            <p>Default</p>\r\n        </div>\r\n\r\n        <div class=\"jl-alert-primary\" jl-alert>\r\n            <a href=\"#\" class=\"jl-alert-close\" jl-close></a>\r\n            <p>Primary</p>\r\n        </div>\r\n\r\n        <div class=\"jl-alert-success\" jl-alert>\r\n            <a href=\"#\" class=\"jl-alert-close\" jl-close></a>\r\n            <p>Success</p>\r\n        </div>\r\n\r\n        <div class=\"jl-alert-warning\" jl-alert>\r\n            <a href=\"#\" class=\"jl-alert-close\" jl-close></a>\r\n            <p>Warning</p>\r\n        </div>\r\n\r\n        <div class=\"jl-alert-danger jl-margin-remove-bottom\" jl-alert>\r\n            <a href=\"#\" class=\"jl-alert-close\" jl-close></a>\r\n            <p>Danger</p>\r\n        </div>\r\n\r\n    </div>\r\n</div>\r\n\r\n<hr class=\"jl-margin-medium\">\r\n\r\n    <div class=\"jl-child-width-1-2@s jl-child-width-expand@m\" jl-grid>\r\n        <div>\r\n            <div class=\"jl-inline\">\r\n                <img src=\"https://source.unsplash.com/random/800x600\" width=\"\" height=\"\" alt=\"\">\r\n                <a class=\"jl-position-absolute jl-transform-center jl-icon jl-marker\" style=\"left: 20%; top: 30%\"\r\n                    href=\"#\" jl-marker></a>\r\n                <a class=\"jl-position-absolute jl-transform-center jl-icon jl-marker\" style=\"left: 60%; top: 40%\"\r\n                    href=\"#\" jl-marker></a>\r\n                <a class=\"jl-position-absolute jl-transform-center jl-icon jl-marker\" style=\"left: 80%; top: 70%\"\r\n                    href=\"#\" jl-marker></a>\r\n            </div>\r\n        </div>\r\n        <div>\r\n\r\n            <div class=\"jl-inline-clip\">\r\n                <img src=\"https://source.unsplash.com/random/800x600\" width=\"\" height=\"\" alt=\"\">\r\n                <div class=\"jl-overlay jl-overlay-default jl-position-bottom\">\r\n                    <p>Default Lorem ipsum dolor sit amet, consectetur.</p>\r\n                </div>\r\n            </div>\r\n\r\n        </div>\r\n        <div>\r\n\r\n            <div class=\"jl-inline-clip\">\r\n                <img src=\"https://source.unsplash.com/random/800x600\" width=\"\" height=\"\" alt=\"\">\r\n                <div class=\"jl-overlay jl-overlay-primary jl-light jl-position-bottom\">\r\n                    <p>Primary Lorem ipsum dolor sit amet, consectetur.</p>\r\n                </div>\r\n            </div>\r\n\r\n        </div>\r\n        <div>\r\n\r\n            <div class=\"jl-inline\">\r\n                <img src=\"https://source.unsplash.com/random/800x600\" width=\"\" height=\"\" alt=\"\">\r\n                <div class=\"jl-position-center\">\r\n                    <span jl-overlay-icon=\"\" class=\"jl-icon jl-overlay-icon\"></span>\r\n                </div>\r\n            </div>\r\n\r\n        </div>\r\n    </div>\r\n\r\n    <hr class=\"jl-margin-medium\">\r\n\r\n    <div class=\"jl-grid-divider jl-child-width-auto@m\" jl-grid>\r\n        <div>\r\n\r\n            <ul class=\"jl-dotnav\">\r\n                <li class=\"jl-active\"><a href=\"#\">Item 1</a></li>\r\n                <li><a href=\"#\">Item 2</a></li>\r\n                <li><a href=\"#\">Item 3</a></li>\r\n                <li><a href=\"#\">Item 4</a></li>\r\n                <li><a href=\"#\">Item 5</a></li>\r\n                <li><a href=\"#\">Item 6</a></li>\r\n            </ul>\r\n\r\n        </div>\r\n        <div>\r\n\r\n            <a href=\"#\" jl-slidenav-previous=\"\" class=\"jl-icon jl-slidenav-previous jl-slidenav\"></a>\r\n            <a href=\"#\" jl-slidenav-next=\"\" class=\"jl-icon jl-slidenav-next jl-slidenav\"></a>\r\n\r\n        </div>\r\n        <div>\r\n\r\n            <ul class=\"jl-thumbnav\">\r\n                <li class=\"jl-active\"><a href=\"#\"><img src=\"https://source.unsplash.com/random/60x40\" width=\"60\"\r\n                            height=\"40\" alt=\"\"></a></li>\r\n                <li><a href=\"#\"><img src=\"https://source.unsplash.com/random/60x40\" width=\"60\" height=\"40\" alt=\"\"></a>\r\n                </li>\r\n                <li><a href=\"#\"><img src=\"https://source.unsplash.com/random/60x40\" width=\"60\" height=\"40\" alt=\"\"></a>\r\n                </li>\r\n            </ul>\r\n\r\n        </div>\r\n        <div>\r\n\r\n            <div class=\"jl-tooltip jl-tooltip-top-center jl-display-inline-block jl-margin-remove jl-position-relative\">\r\n                Tooltip</div>\r\n\r\n        </div>\r\n\r\n        <div>\r\n\r\n            <button type=\"button\" jl-close class=\"jl-icon jl-close\"></button>\r\n\r\n        </div>\r\n        <div>\r\n\r\n            <a href=\"#\" jl-totop=\"\" class=\"jl-icon jl-totop\"></a>\r\n\r\n        </div>\r\n    </div>\r\n\r\n    <hr class=\"jl-margin-medium\">\r\n\r\n    <div class=\"jl-grid-divider jl-child-width-expand@m\" jl-grid>\r\n        <div>\r\n\r\n            <ul class=\"jl-subnav jl-subnav-divider\" jl-margin=\"\">\r\n                <li class=\"jl-active\"><a href=\"#\">Active</a></li>\r\n                <li><a href=\"#\">Item</a></li>\r\n                <li class=\"jl-disabled\"><a>Disabled</a></li>\r\n            </ul>\r\n\r\n        </div>\r\n        <div>\r\n\r\n            <ul class=\"jl-subnav jl-subnav-pill\" jl-margin=\"\">\r\n                <li class=\"jl-active\"><a href=\"#\">Active</a></li>\r\n                <li><a href=\"#\">Item</a></li>\r\n                <li class=\"jl-disabled\"><a>Disabled</a></li>\r\n            </ul>\r\n\r\n        </div>\r\n        <div>\r\n\r\n            <ul jl-tab=\"\" class=\"jl-tab\">\r\n                <li class=\"jl-active\"><a href=\"#\">Active</a></li>\r\n                <li><a href=\"#\">Item</a></li>\r\n                <li class=\"jl-disabled\"><a>Disabled</a></li>\r\n            </ul>\r\n\r\n        </div>\r\n    </div>\r\n\r\n    <hr class=\"jl-margin-medium\">\r\n\r\n    <div class=\"jl-grid-divider jl-child-width-expand@m\" jl-grid>\r\n        <div>\r\n\r\n            <ul class=\"jl-list jl-list-bullet jl-margin-medium\">\r\n                <li>List item 1</li>\r\n                <li>List item 2</li>\r\n                <li>List item 3</li>\r\n            </ul>\r\n\r\n            <ul class=\"jl-list jl-list-striped\">\r\n                <li>List item 1</li>\r\n                <li>List item 2</li>\r\n                <li>List item 3</li>\r\n            </ul>\r\n\r\n        </div>\r\n        <div>\r\n\r\n            <ul class=\"jl-list jl-list-divider jl-margin-medium\">\r\n                <li>List item 1</li>\r\n                <li>List item 2</li>\r\n                <li>List item 3</li>\r\n            </ul>\r\n\r\n            <dl class=\"jl-description-list jl-description-list-divider\">\r\n                <dt>Description lists</dt>\r\n                <dd>A description text</dd>\r\n                <dt>Description lists</dt>\r\n                <dd>A description text</dd>\r\n            </dl>\r\n\r\n        </div>\r\n        <div>\r\n\r\n            <ul jl-accordion=\"\" class=\"jl-accordion\">\r\n                <li class=\"jl-open\">\r\n\r\n                    <a class=\"jl-accordion-title\" href=\"#\">Item 1</a>\r\n                    <div class=\"jl-accordion-content\" aria-hidden=\"false\">\r\n                        <p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut\r\n                            labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco.\r\n                        </p>\r\n                    </div>\r\n\r\n                </li>\r\n                <li>\r\n\r\n                    <a class=\"jl-accordion-title\" href=\"#\">Item 2</a>\r\n                    <div class=\"jl-accordion-content\" hidden aria-hidden=\"true\">\r\n                        <p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut\r\n                            labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco.\r\n                        </p>\r\n                    </div>\r\n\r\n                </li>\r\n                <li>\r\n\r\n                    <a class=\"jl-accordion-title\" href=\"#\">Item 3</a>\r\n                    <div class=\"jl-accordion-content\" hidden aria-hidden=\"true\">\r\n                        <p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut\r\n                            labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco.\r\n                        </p>\r\n                    </div>\r\n\r\n                </li>\r\n            </ul>\r\n\r\n        </div>\r\n    </div>\r\n</div>\r\n\r\n<div class=\"jl-section jl-padding-remove-vertical\">\r\n    <div class=\"jl-child-width-1-2@s jl-child-width-1-4@l jl-grid-collapse jl-grid-match\" jl-grid>\r\n        <div>\r\n            <div class=\"jl-tile jl-tile-default\">Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod\r\n                tempor.</div>\r\n        </div>\r\n        <div>\r\n            <div class=\"jl-tile jl-tile-muted\">Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod\r\n                tempor.</div>\r\n        </div>\r\n        <div>\r\n            <div class=\"jl-tile jl-tile-primary jl-light\">Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed\r\n                do eiusmod\r\n                tempor.</div>\r\n        </div>\r\n        <div>\r\n            <div class=\"jl-tile jl-tile-secondary jl-light\">Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed\r\n                do\r\n                eiusmod tempor.</div>\r\n        </div>\r\n    </div>\r\n</div>\r\n\r\n<div class=\"jl-section jl-section-default\">\r\n    <div class=\"jl-grid-large jl-flex-middle\" jl-grid>\r\n        <div class=\"jl-width-expand@m\">\r\n            <p class=\"jl-text-large\">Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor.</p>\r\n        </div>\r\n        <div class=\"jl-width-auto@m\">\r\n            <a class=\"jl-button jl-button-default jl-button-large\" href=\"#\">Button</a>\r\n        </div>\r\n    </div>\r\n</div>\r\n\r\n<div class=\"jl-section jl-section-muted jl-padding\">\r\n\r\n    <div class=\"jl-grid-large jl-flex-middle\" jl-grid>\r\n        <div class=\"jl-width-expand@m\">\r\n            <p class=\"jl-text-large\">Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor.</p>\r\n        </div>\r\n        <div class=\"jl-width-auto@m\">\r\n            <a class=\"jl-button jl-button-default jl-button-large\" href=\"#\">Button</a>\r\n        </div>\r\n    </div>\r\n</div>\r\n\r\n<div class=\"jl-section jl-section-primary jl-padding jl-light\">\r\n\r\n    <div class=\"jl-grid-large jl-flex-middle\" jl-grid>\r\n        <div class=\"jl-width-expand@m\">\r\n            <p class=\"jl-text-large\">Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor.</p>\r\n        </div>\r\n        <div class=\"jl-width-auto@m\">\r\n            <a class=\"jl-button jl-button-default jl-button-large\" href=\"#\">Button</a>\r\n        </div>\r\n    </div>\r\n\r\n</div>\r\n\r\n<div class=\"jl-section jl-section-secondary jl-padding jl-light\">\r\n    <div class=\"jl-grid-large jl-flex-middle\" jl-grid>\r\n        <div class=\"jl-width-expand@m\">\r\n            <p class=\"jl-text-large\">Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor.</p>\r\n        </div>\r\n        <div class=\"jl-width-auto@m\">\r\n            <a class=\"jl-button jl-button-default jl-button-large\" href=\"#\">Button</a>\r\n        </div>\r\n    </div>\r\n</div>\r\n\r\n<div id=\"modal\" jl-modal class=\"jl-modal\">\r\n    <div class=\"jl-modal-dialog\">\r\n        <button class=\"jl-modal-close-default jl-icon jl-close\" type=\"button\" jl-close></button>\r\n        <div class=\"jl-modal-header\">\r\n            <h2 class=\"jl-modal-title\">Headline</h2>\r\n        </div>\r\n        <div class=\"jl-modal-body\">\r\n            <p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et\r\n                dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip\r\n                ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu\r\n                fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia\r\n                deserunt mollit anim id est laborum.</p>\r\n        </div>\r\n        <div class=\"jl-modal-footer jl-text-right\">\r\n            <button class=\"jl-button jl-button-default jl-modal-close\" type=\"button\">Cancel</button>\r\n            <button class=\"jl-button jl-button-primary\" type=\"button\">Save</button>\r\n        </div>\r\n    </div>\r\n</div>\r\n\r\n<div id=\"modal-search\" class=\"jl-modal-full jl-modal\" jl-modal>\r\n    <div class=\"jl-modal-dialog jl-flex jl-flex-center jl-flex-middle\" jl-height-viewport>\r\n\r\n        <button class=\"jl-modal-close-full jl-close-large jl-icon jl-close\" type=\"button\" jl-close></button>\r\n\r\n        <div>\r\n\r\n            <ul class=\"jl-nav-primary jl-nav-center jl-nav\" jl-nav>\r\n                <li class=\"jl-active\"><a href=\"#\">Active</a></li>\r\n                <li><a href=\"#\">Item</a></li>\r\n                <li><a href=\"#\">Item</a></li>\r\n                <li><a href=\"#\">Item</a></li>\r\n            </ul>\r\n\r\n            <div class=\"jl-margin\">\r\n                <form class=\"jl-search jl-search-large\">\r\n                    <input class=\"jl-search-input jl-text-center\" type=\"search\" placeholder=\"Search...\">\r\n                </form>\r\n            </div>\r\n\r\n        </div>\r\n\r\n    </div>\r\n</div>\r\n\r\n<div id=\"offcanvas\" jl-offcanvas=\"flip: true; overlay: true\" class=\"jl-offcanvas\">\r\n    <div class=\"jl-offcanvas-bar\">\r\n\r\n        <button class=\"jl-offcanvas-close jl-icon jl-close\" type=\"button\" jl-close></button>\r\n\r\n        <ul class=\"jl-nav jl-nav-default\">\r\n            <li class=\"jl-active\"><a href=\"#\">Active</a></li>\r\n            <li class=\"jl-parent\">\r\n                <a href=\"#\">Parent</a>\r\n                <ul class=\"jl-nav-sub\">\r\n                    <li><a href=\"#\">Sub item</a></li>\r\n                    <li><a href=\"#\">Sub item</a></li>\r\n                </ul>\r\n            </li>\r\n            <li class=\"jl-nav-header\">Header</li>\r\n            <li><a href=\"#\"><span class=\"jl-margin-small-right jl-icon\" jl-icon=\"icon: table\"></span> Item</a></li>\r\n            <li><a href=\"#\"><span class=\"jl-margin-small-right jl-icon\" jl-icon=\"icon: thumbnails\"></span> Item</a></li>\r\n            <li class=\"jl-nav-divider\"></li>\r\n            <li><a href=\"#\"><span class=\"jl-margin-small-right jl-icon\" jl-icon=\"icon: trash\"></span> Item</a></li>\r\n        </ul>\r\n\r\n        <h3>Title</h3>\r\n\r\n        <p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore\r\n            magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea\r\n            commodo consequat.</p>\r\n\r\n    </div>\r\n</div>\";s:4:\"body\";s:0:\"\";s:6:\"images\";s:173:\"{\"image_intro\":\"\",\"image_intro_alt\":\"\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}\";s:5:\"catid\";i:2;s:10:\"created_by\";i:107;s:16:\"created_by_alias\";s:0:\"\";s:8:\"modified\";s:19:\"2022-07-18 02:08:06\";s:11:\"modified_by\";i:107;s:6:\"params\";O:24:\"Joomla\\Registry\\Registry\":3:{s:7:\"\0*\0data\";O:8:\"stdClass\":88:{s:14:\"article_layout\";s:9:\"_:default\";s:10:\"show_title\";s:1:\"1\";s:11:\"link_titles\";s:1:\"1\";s:10:\"show_intro\";s:1:\"1\";s:19:\"info_block_position\";s:1:\"1\";s:21:\"info_block_show_title\";s:1:\"1\";s:13:\"show_category\";s:1:\"1\";s:13:\"link_category\";s:1:\"1\";s:20:\"show_parent_category\";s:1:\"0\";s:20:\"link_parent_category\";s:1:\"0\";s:17:\"show_associations\";s:1:\"0\";s:5:\"flags\";s:1:\"1\";s:11:\"show_author\";s:1:\"1\";s:11:\"link_author\";s:1:\"0\";s:16:\"show_create_date\";s:1:\"0\";s:16:\"show_modify_date\";s:1:\"0\";s:17:\"show_publish_date\";s:1:\"1\";s:20:\"show_item_navigation\";s:1:\"1\";s:9:\"show_vote\";s:1:\"0\";s:13:\"show_readmore\";s:1:\"1\";s:19:\"show_readmore_title\";s:1:\"0\";s:14:\"readmore_limit\";i:100;s:9:\"show_tags\";s:1:\"1\";s:11:\"record_hits\";s:1:\"0\";s:9:\"show_hits\";s:1:\"0\";s:11:\"show_noauth\";s:1:\"0\";s:13:\"urls_position\";i:0;s:7:\"captcha\";s:0:\"\";s:23:\"show_publishing_options\";s:1:\"1\";s:20:\"show_article_options\";s:1:\"1\";s:27:\"show_configure_edit_options\";s:1:\"1\";s:16:\"show_permissions\";s:1:\"1\";s:22:\"show_associations_edit\";s:1:\"1\";s:12:\"save_history\";s:1:\"0\";s:13:\"history_limit\";i:10;s:25:\"show_urls_images_frontend\";s:1:\"1\";s:24:\"show_urls_images_backend\";s:1:\"1\";s:7:\"targeta\";i:0;s:7:\"targetb\";i:0;s:7:\"targetc\";i:0;s:11:\"float_intro\";s:4:\"none\";s:14:\"float_fulltext\";s:4:\"none\";s:15:\"category_layout\";s:6:\"_:blog\";s:19:\"show_category_title\";s:1:\"0\";s:16:\"show_description\";s:1:\"0\";s:22:\"show_description_image\";s:1:\"0\";s:8:\"maxLevel\";s:1:\"1\";s:21:\"show_empty_categories\";s:1:\"0\";s:16:\"show_no_articles\";s:1:\"1\";s:32:\"show_category_heading_title_text\";s:1:\"1\";s:16:\"show_subcat_desc\";s:1:\"1\";s:21:\"show_cat_num_articles\";s:1:\"0\";s:13:\"show_cat_tags\";s:1:\"1\";s:21:\"show_base_description\";s:1:\"1\";s:11:\"maxLevelcat\";s:2:\"-1\";s:25:\"show_empty_categories_cat\";s:1:\"0\";s:20:\"show_subcat_desc_cat\";s:1:\"1\";s:25:\"show_cat_num_articles_cat\";s:1:\"1\";s:20:\"num_leading_articles\";i:1;s:18:\"blog_class_leading\";s:0:\"\";s:18:\"num_intro_articles\";i:4;s:10:\"blog_class\";s:0:\"\";s:11:\"num_columns\";i:2;s:18:\"multi_column_order\";s:1:\"0\";s:9:\"num_links\";i:4;s:24:\"show_subcategory_content\";s:1:\"0\";s:16:\"link_intro_image\";s:1:\"1\";s:21:\"show_pagination_limit\";s:1:\"1\";s:12:\"filter_field\";s:4:\"hide\";s:13:\"show_headings\";s:1:\"1\";s:14:\"list_show_date\";s:1:\"0\";s:11:\"date_format\";s:0:\"\";s:14:\"list_show_hits\";s:1:\"1\";s:16:\"list_show_author\";s:1:\"1\";s:15:\"list_show_votes\";s:1:\"0\";s:17:\"list_show_ratings\";s:1:\"0\";s:11:\"orderby_pri\";s:5:\"order\";s:11:\"orderby_sec\";s:5:\"rdate\";s:10:\"order_date\";s:9:\"published\";s:15:\"show_pagination\";s:1:\"2\";s:23:\"show_pagination_results\";s:1:\"1\";s:13:\"show_featured\";s:4:\"show\";s:14:\"show_feed_link\";s:1:\"1\";s:12:\"feed_summary\";s:1:\"0\";s:18:\"feed_show_readmore\";s:1:\"0\";s:7:\"sef_ids\";i:1;s:20:\"custom_fields_enable\";s:1:\"1\";s:16:\"workflow_enabled\";s:1:\"0\";}s:14:\"\0*\0initialized\";b:1;s:12:\"\0*\0separator\";s:1:\".\";}s:7:\"metakey\";s:0:\"\";s:8:\"metadesc\";s:0:\"\";s:8:\"metadata\";O:24:\"Joomla\\Registry\\Registry\":3:{s:7:\"\0*\0data\";O:8:\"stdClass\":3:{s:6:\"robots\";s:0:\"\";s:6:\"author\";s:0:\"\";s:6:\"rights\";s:0:\"\";}s:14:\"\0*\0initialized\";b:1;s:12:\"\0*\0separator\";s:1:\".\";}s:7:\"version\";i:50;s:8:\"ordering\";i:2;s:8:\"category\";s:13:\"Uncategorised\";s:9:\"cat_state\";i:1;s:10:\"cat_access\";i:1;s:4:\"slug\";s:16:\"4:uikit-overview\";s:7:\"catslug\";s:15:\"2:uncategorised\";s:6:\"author\";s:5:\"admin\";s:4:\"mime\";N;s:6:\"layout\";s:7:\"article\";s:7:\"context\";s:19:\"com_content.article\";s:10:\"metaauthor\";N;}i:4;N;i:5;a:5:{i:1;a:3:{i:0;s:5:\"title\";i:1;s:8:\"subtitle\";i:2;s:2:\"id\";}i:2;a:2:{i:0;s:7:\"summary\";i:1;s:4:\"body\";}i:3;a:8:{i:0;s:4:\"meta\";i:1;s:10:\"list_price\";i:2;s:10:\"sale_price\";i:3;s:7:\"metakey\";i:4;s:8:\"metadesc\";i:5;s:10:\"metaauthor\";i:6;s:6:\"author\";i:7;s:16:\"created_by_alias\";}i:4;a:2:{i:0;s:4:\"path\";i:1;s:5:\"alias\";}i:5;a:1:{i:0;s:8:\"comments\";}}i:6;s:1:\"*\";i:7;N;i:8;N;i:9;s:19:\"2021-05-15 23:36:07\";i:10;N;i:11;s:69:\"index.php?option=com_content&view=article&id=4:uikit-overview&catid=2\";i:12;N;i:13;s:19:\"1980-01-01 00:00:00\";i:14;i:1;i:15;a:4:{s:4:\"Type\";a:1:{i:0;O:8:\"stdClass\":6:{s:5:\"title\";s:7:\"Article\";s:5:\"state\";i:1;s:6:\"access\";i:1;s:8:\"language\";s:0:\"\";s:6:\"nested\";b:0;s:2:\"id\";i:13;}}s:6:\"Author\";a:1:{i:0;O:8:\"stdClass\":6:{s:5:\"title\";s:5:\"admin\";s:5:\"state\";i:1;s:6:\"access\";i:1;s:8:\"language\";s:0:\"\";s:6:\"nested\";b:0;s:2:\"id\";i:15;}}s:8:\"Category\";a:1:{i:0;O:8:\"stdClass\":6:{s:5:\"title\";s:13:\"Uncategorised\";s:5:\"state\";i:1;s:6:\"access\";i:1;s:8:\"language\";s:1:\"*\";s:6:\"nested\";b:1;s:2:\"id\";i:17;}}s:8:\"Language\";a:1:{i:0;O:8:\"stdClass\":6:{s:5:\"title\";s:1:\"*\";s:5:\"state\";i:1;s:6:\"access\";i:1;s:8:\"language\";s:0:\"\";s:6:\"nested\";b:0;s:2:\"id\";i:5;}}}i:16;s:14:\"UIkit Overview\";i:17;i:4;i:18;s:46:\"index.php?option=com_content&view=article&id=4\";}'),
('12', 'index.php?option=com_content&view=article&id=8', 'index.php?option=com_content&view=article&id=8:key-factors-for-productive-work-as-a-team&catid=7', 'Key factors for productive work as a team', ' Lorem ipsum dolor sit amet, consectetur adipisici elit, sed eiusmod tempor incidunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquid ex ea commodi consequat. ', '2023-04-26 12:28:27', '405416e89b6414a3a3b3379efe321c37', '1', '1', '1', '*', '2021-05-15 20:52:53', NULL, '1980-01-01 00:00:00', NULL, '0', '0', '4', 'O:52:\"Joomla\\Component\\Finder\\Administrator\\Indexer\\Result\":19:{i:0;i:1;i:1;s:5:\"en-GB\";i:2;s:227:\" Lorem ipsum dolor sit amet, consectetur adipisici elit, sed eiusmod tempor incidunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquid ex ea commodi consequat. \";i:3;a:28:{s:2:\"id\";i:8;s:5:\"alias\";s:41:\"key factors for productive work as a team\";s:7:\"summary\";s:232:\"<p>Lorem ipsum dolor sit amet, consectetur adipisici elit, sed eiusmod tempor incidunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquid ex ea commodi consequat.</p>\";s:4:\"body\";s:3729:\"\r\n<p>Quis aute iure reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint obcaecat cupiditat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum. Duis autem vel eum iriure dolor in hendrerit in vulputate velit esse molestie consequat, vel illum dolore eu feugiat nulla facilisis at vero eros et accumsan et iusto odio dignissim qui blandit praesent luptatum zzril delenit augue duis dolore te feugait nulla facilisi.</p>\r\n \r\n<p>Lorem ipsum dolor sit amet, consectetuer adipiscing elit, sed diam nonummy nibh euismod tincidunt ut laoreet dolore magna aliquam erat volutpat. Ut wisi enim ad minim veniam, quis nostrud exerci tation ullamcorper suscipit lobortis nisl ut aliquip ex ea commodo consequat. Nam liber tempor cum soluta nobis eleifend option congue nihil imperdiet doming id quod mazim placerat facer possim assum. Lorem ipsum dolor sit amet, consectetuer adipiscing elit, sed diam nonummy nibh euismod tincidunt ut laoreet dolore magna aliquam erat volutpat. Ut wisi enim ad minim veniam, quis nostrud exerci tation ullamcorper suscipit lobortis nisl ut aliquip ex ea commodo consequat.</p>\r\n<h2>Daily Inspiration</h2>\r\n<p>Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, At accusam aliquyam diam diam dolore dolores duo eirmod eos erat, et nonumy sed tempor et et invidunt justo labore Stet clita ea et gubergren, kasd magna no rebum. sanctus sea sed takimata ut vero voluptua.</p>\r\n\r\n<p class=\"jl-margin-medium\">\r\n    <img width=\"900\" height=\"300\" alt=\"\" src=\"images/lead/blog_themes.jpg\">\r\n</p>\r\n\r\n<p>Consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.</p>\r\n<blockquote class=\"jl-margin-medium\">It comes after new research revealed that late payments and poor cash flow were causing up to 50,000 small businesses to fail each year.<footer>John Doe</footer></blockquote>\r\n<p>At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.</p>\r\n\r\n<h2>Wrapping Up</h2>\r\n\r\n<p>Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.</p>\r\n\r\n<p>Consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.</p>\";s:6:\"images\";s:387:\"{\"image_intro\":\"images\\/sampledata\\/blog7.jpg#joomlaImage:\\/\\/local-images\\/sampledata\\/blog7.jpg?width=1170&height=780\",\"image_intro_alt\":\"\",\"float_intro\":\"none\",\"image_intro_caption\":\"\",\"image_fulltext\":\"images\\/sampledata\\/blog7.jpg#joomlaImage:\\/\\/local-images\\/sampledata\\/blog7.jpg?width=1170&height=780\",\"image_fulltext_alt\":\"\",\"float_fulltext\":\"none\",\"image_fulltext_caption\":\"\"}\";s:5:\"catid\";i:7;s:10:\"created_by\";i:107;s:16:\"created_by_alias\";s:0:\"\";s:8:\"modified\";s:19:\"2021-11-19 17:13:21\";s:11:\"modified_by\";i:107;s:6:\"params\";O:24:\"Joomla\\Registry\\Registry\":3:{s:7:\"\0*\0data\";O:8:\"stdClass\":88:{s:14:\"article_layout\";s:9:\"_:default\";s:10:\"show_title\";s:1:\"1\";s:11:\"link_titles\";s:1:\"1\";s:10:\"show_intro\";s:1:\"1\";s:19:\"info_block_position\";s:1:\"1\";s:21:\"info_block_show_title\";s:1:\"1\";s:13:\"show_category\";s:1:\"1\";s:13:\"link_category\";s:1:\"1\";s:20:\"show_parent_category\";s:1:\"0\";s:20:\"link_parent_category\";s:1:\"0\";s:17:\"show_associations\";s:1:\"0\";s:5:\"flags\";s:1:\"1\";s:11:\"show_author\";s:1:\"1\";s:11:\"link_author\";s:1:\"0\";s:16:\"show_create_date\";s:1:\"0\";s:16:\"show_modify_date\";s:1:\"0\";s:17:\"show_publish_date\";s:1:\"1\";s:20:\"show_item_navigation\";s:1:\"1\";s:9:\"show_vote\";s:1:\"0\";s:13:\"show_readmore\";s:1:\"1\";s:19:\"show_readmore_title\";s:1:\"0\";s:14:\"readmore_limit\";i:100;s:9:\"show_tags\";s:1:\"1\";s:11:\"record_hits\";s:1:\"0\";s:9:\"show_hits\";s:1:\"0\";s:11:\"show_noauth\";s:1:\"0\";s:13:\"urls_position\";i:0;s:7:\"captcha\";s:0:\"\";s:23:\"show_publishing_options\";s:1:\"1\";s:20:\"show_article_options\";s:1:\"1\";s:27:\"show_configure_edit_options\";s:1:\"1\";s:16:\"show_permissions\";s:1:\"1\";s:22:\"show_associations_edit\";s:1:\"1\";s:12:\"save_history\";s:1:\"0\";s:13:\"history_limit\";i:10;s:25:\"show_urls_images_frontend\";s:1:\"1\";s:24:\"show_urls_images_backend\";s:1:\"1\";s:7:\"targeta\";i:0;s:7:\"targetb\";i:0;s:7:\"targetc\";i:0;s:11:\"float_intro\";s:4:\"none\";s:14:\"float_fulltext\";s:4:\"none\";s:15:\"category_layout\";s:6:\"_:blog\";s:19:\"show_category_title\";s:1:\"0\";s:16:\"show_description\";s:1:\"0\";s:22:\"show_description_image\";s:1:\"0\";s:8:\"maxLevel\";s:1:\"1\";s:21:\"show_empty_categories\";s:1:\"0\";s:16:\"show_no_articles\";s:1:\"1\";s:32:\"show_category_heading_title_text\";s:1:\"1\";s:16:\"show_subcat_desc\";s:1:\"1\";s:21:\"show_cat_num_articles\";s:1:\"0\";s:13:\"show_cat_tags\";s:1:\"1\";s:21:\"show_base_description\";s:1:\"1\";s:11:\"maxLevelcat\";s:2:\"-1\";s:25:\"show_empty_categories_cat\";s:1:\"0\";s:20:\"show_subcat_desc_cat\";s:1:\"1\";s:25:\"show_cat_num_articles_cat\";s:1:\"1\";s:20:\"num_leading_articles\";i:1;s:18:\"blog_class_leading\";s:0:\"\";s:18:\"num_intro_articles\";i:4;s:10:\"blog_class\";s:0:\"\";s:11:\"num_columns\";i:2;s:18:\"multi_column_order\";s:1:\"0\";s:9:\"num_links\";i:4;s:24:\"show_subcategory_content\";s:1:\"0\";s:16:\"link_intro_image\";s:1:\"1\";s:21:\"show_pagination_limit\";s:1:\"1\";s:12:\"filter_field\";s:4:\"hide\";s:13:\"show_headings\";s:1:\"1\";s:14:\"list_show_date\";s:1:\"0\";s:11:\"date_format\";s:0:\"\";s:14:\"list_show_hits\";s:1:\"1\";s:16:\"list_show_author\";s:1:\"1\";s:15:\"list_show_votes\";s:1:\"0\";s:17:\"list_show_ratings\";s:1:\"0\";s:11:\"orderby_pri\";s:5:\"order\";s:11:\"orderby_sec\";s:5:\"rdate\";s:10:\"order_date\";s:9:\"published\";s:15:\"show_pagination\";s:1:\"2\";s:23:\"show_pagination_results\";s:1:\"1\";s:13:\"show_featured\";s:4:\"show\";s:14:\"show_feed_link\";s:1:\"1\";s:12:\"feed_summary\";s:1:\"0\";s:18:\"feed_show_readmore\";s:1:\"0\";s:7:\"sef_ids\";i:1;s:20:\"custom_fields_enable\";s:1:\"1\";s:16:\"workflow_enabled\";s:1:\"0\";}s:14:\"\0*\0initialized\";b:1;s:12:\"\0*\0separator\";s:1:\".\";}s:7:\"metakey\";s:0:\"\";s:8:\"metadesc\";s:0:\"\";s:8:\"metadata\";O:24:\"Joomla\\Registry\\Registry\":3:{s:7:\"\0*\0data\";O:8:\"stdClass\":3:{s:6:\"robots\";s:0:\"\";s:6:\"author\";s:0:\"\";s:6:\"rights\";s:0:\"\";}s:14:\"\0*\0initialized\";b:1;s:12:\"\0*\0separator\";s:1:\".\";}s:7:\"version\";i:69;s:8:\"ordering\";i:1;s:8:\"category\";s:4:\"Blog\";s:9:\"cat_state\";i:1;s:10:\"cat_access\";i:1;s:4:\"slug\";s:43:\"8:key-factors-for-productive-work-as-a-team\";s:7:\"catslug\";s:6:\"7:blog\";s:6:\"author\";s:5:\"admin\";s:4:\"mime\";N;s:6:\"layout\";s:7:\"article\";s:7:\"context\";s:19:\"com_content.article\";s:8:\"imageUrl\";s:97:\"images/sampledata/blog7.jpg#joomlaImage://local-images/sampledata/blog7.jpg?width=1170&height=780\";s:8:\"imageAlt\";s:0:\"\";s:10:\"metaauthor\";N;}i:4;N;i:5;a:5:{i:1;a:3:{i:0;s:5:\"title\";i:1;s:8:\"subtitle\";i:2;s:2:\"id\";}i:2;a:2:{i:0;s:7:\"summary\";i:1;s:4:\"body\";}i:3;a:8:{i:0;s:4:\"meta\";i:1;s:10:\"list_price\";i:2;s:10:\"sale_price\";i:3;s:7:\"metakey\";i:4;s:8:\"metadesc\";i:5;s:10:\"metaauthor\";i:6;s:6:\"author\";i:7;s:16:\"created_by_alias\";}i:4;a:2:{i:0;s:4:\"path\";i:1;s:5:\"alias\";}i:5;a:1:{i:0;s:8:\"comments\";}}i:6;s:1:\"*\";i:7;N;i:8;N;i:9;s:19:\"2021-05-15 20:52:53\";i:10;N;i:11;s:96:\"index.php?option=com_content&view=article&id=8:key-factors-for-productive-work-as-a-team&catid=7\";i:12;N;i:13;s:19:\"1980-01-01 00:00:00\";i:14;i:1;i:15;a:4:{s:4:\"Type\";a:1:{i:0;O:8:\"stdClass\":6:{s:5:\"title\";s:7:\"Article\";s:5:\"state\";i:1;s:6:\"access\";i:1;s:8:\"language\";s:0:\"\";s:6:\"nested\";b:0;s:2:\"id\";i:13;}}s:6:\"Author\";a:1:{i:0;O:8:\"stdClass\":6:{s:5:\"title\";s:5:\"admin\";s:5:\"state\";i:1;s:6:\"access\";i:1;s:8:\"language\";s:0:\"\";s:6:\"nested\";b:0;s:2:\"id\";i:15;}}s:8:\"Category\";a:1:{i:0;O:8:\"stdClass\":6:{s:5:\"title\";s:4:\"Blog\";s:5:\"state\";i:1;s:6:\"access\";i:1;s:8:\"language\";s:1:\"*\";s:6:\"nested\";b:1;s:2:\"id\";i:18;}}s:8:\"Language\";a:1:{i:0;O:8:\"stdClass\":6:{s:5:\"title\";s:1:\"*\";s:5:\"state\";i:1;s:6:\"access\";i:1;s:8:\"language\";s:0:\"\";s:6:\"nested\";b:0;s:2:\"id\";i:5;}}}i:16;s:41:\"Key factors for productive work as a team\";i:17;i:4;i:18;s:46:\"index.php?option=com_content&view=article&id=8\";}'),
('13', 'index.php?option=com_content&view=article&id=9', 'index.php?option=com_content&view=article&id=9:our-guide-to-3d-graphic-design-for-beginners&catid=7', 'Our guide to 3D graphic design for beginners', ' Lorem ipsum dolor sit amet, consectetur adipisici elit, sed eiusmod tempor incidunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquid ex ea commodi consequat. ', '2023-04-26 12:28:27', 'e48ae97d829f2f5a045c40aa7deadba3', '1', '1', '1', '*', '2021-05-15 20:55:59', NULL, '1980-01-01 00:00:00', NULL, '0', '0', '4', 'O:52:\"Joomla\\Component\\Finder\\Administrator\\Indexer\\Result\":19:{i:0;i:1;i:1;s:5:\"en-GB\";i:2;s:227:\" Lorem ipsum dolor sit amet, consectetur adipisici elit, sed eiusmod tempor incidunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquid ex ea commodi consequat. \";i:3;a:28:{s:2:\"id\";i:9;s:5:\"alias\";s:44:\"our guide to 3d graphic design for beginners\";s:7:\"summary\";s:232:\"<p>Lorem ipsum dolor sit amet, consectetur adipisici elit, sed eiusmod tempor incidunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquid ex ea commodi consequat.</p>\";s:4:\"body\";s:3729:\"\r\n<p>Quis aute iure reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint obcaecat cupiditat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum. Duis autem vel eum iriure dolor in hendrerit in vulputate velit esse molestie consequat, vel illum dolore eu feugiat nulla facilisis at vero eros et accumsan et iusto odio dignissim qui blandit praesent luptatum zzril delenit augue duis dolore te feugait nulla facilisi.</p>\r\n \r\n<p>Lorem ipsum dolor sit amet, consectetuer adipiscing elit, sed diam nonummy nibh euismod tincidunt ut laoreet dolore magna aliquam erat volutpat. Ut wisi enim ad minim veniam, quis nostrud exerci tation ullamcorper suscipit lobortis nisl ut aliquip ex ea commodo consequat. Nam liber tempor cum soluta nobis eleifend option congue nihil imperdiet doming id quod mazim placerat facer possim assum. Lorem ipsum dolor sit amet, consectetuer adipiscing elit, sed diam nonummy nibh euismod tincidunt ut laoreet dolore magna aliquam erat volutpat. Ut wisi enim ad minim veniam, quis nostrud exerci tation ullamcorper suscipit lobortis nisl ut aliquip ex ea commodo consequat.</p>\r\n<h2>Daily Inspiration</h2>\r\n<p>Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, At accusam aliquyam diam diam dolore dolores duo eirmod eos erat, et nonumy sed tempor et et invidunt justo labore Stet clita ea et gubergren, kasd magna no rebum. sanctus sea sed takimata ut vero voluptua.</p>\r\n\r\n<p class=\"jl-margin-medium\">\r\n    <img width=\"900\" height=\"300\" alt=\"\" src=\"images/lead/blog_themes.jpg\">\r\n</p>\r\n\r\n<p>Consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.</p>\r\n<blockquote class=\"jl-margin-medium\">It comes after new research revealed that late payments and poor cash flow were causing up to 50,000 small businesses to fail each year.<footer>John Doe</footer></blockquote>\r\n<p>At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.</p>\r\n\r\n<h2>Wrapping Up</h2>\r\n\r\n<p>Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.</p>\r\n\r\n<p>Consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.</p>\";s:6:\"images\";s:381:\"{\"image_intro\":\"images\\/sampledata\\/blog5.jpg#joomlaImage:\\/\\/local-images\\/sampledata\\/blog5.jpg?width=2400&height=1599\",\"image_intro_alt\":\"\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"images\\/sampledata\\/blog5.jpg#joomlaImage:\\/\\/local-images\\/sampledata\\/blog5.jpg?width=2400&height=1599\",\"image_fulltext_alt\":\"\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}\";s:5:\"catid\";i:7;s:10:\"created_by\";i:107;s:16:\"created_by_alias\";s:0:\"\";s:8:\"modified\";s:19:\"2021-11-19 17:13:00\";s:11:\"modified_by\";i:107;s:6:\"params\";O:24:\"Joomla\\Registry\\Registry\":3:{s:7:\"\0*\0data\";O:8:\"stdClass\":88:{s:14:\"article_layout\";s:9:\"_:default\";s:10:\"show_title\";s:1:\"1\";s:11:\"link_titles\";s:1:\"1\";s:10:\"show_intro\";s:1:\"1\";s:19:\"info_block_position\";s:1:\"1\";s:21:\"info_block_show_title\";s:1:\"1\";s:13:\"show_category\";s:1:\"1\";s:13:\"link_category\";s:1:\"1\";s:20:\"show_parent_category\";s:1:\"0\";s:20:\"link_parent_category\";s:1:\"0\";s:17:\"show_associations\";s:1:\"0\";s:5:\"flags\";s:1:\"1\";s:11:\"show_author\";s:1:\"1\";s:11:\"link_author\";s:1:\"0\";s:16:\"show_create_date\";s:1:\"0\";s:16:\"show_modify_date\";s:1:\"0\";s:17:\"show_publish_date\";s:1:\"1\";s:20:\"show_item_navigation\";s:1:\"1\";s:9:\"show_vote\";s:1:\"0\";s:13:\"show_readmore\";s:1:\"1\";s:19:\"show_readmore_title\";s:1:\"0\";s:14:\"readmore_limit\";i:100;s:9:\"show_tags\";s:1:\"1\";s:11:\"record_hits\";s:1:\"0\";s:9:\"show_hits\";s:1:\"0\";s:11:\"show_noauth\";s:1:\"0\";s:13:\"urls_position\";i:0;s:7:\"captcha\";s:0:\"\";s:23:\"show_publishing_options\";s:1:\"1\";s:20:\"show_article_options\";s:1:\"1\";s:27:\"show_configure_edit_options\";s:1:\"1\";s:16:\"show_permissions\";s:1:\"1\";s:22:\"show_associations_edit\";s:1:\"1\";s:12:\"save_history\";s:1:\"0\";s:13:\"history_limit\";i:10;s:25:\"show_urls_images_frontend\";s:1:\"1\";s:24:\"show_urls_images_backend\";s:1:\"1\";s:7:\"targeta\";i:0;s:7:\"targetb\";i:0;s:7:\"targetc\";i:0;s:11:\"float_intro\";s:4:\"none\";s:14:\"float_fulltext\";s:4:\"none\";s:15:\"category_layout\";s:6:\"_:blog\";s:19:\"show_category_title\";s:1:\"0\";s:16:\"show_description\";s:1:\"0\";s:22:\"show_description_image\";s:1:\"0\";s:8:\"maxLevel\";s:1:\"1\";s:21:\"show_empty_categories\";s:1:\"0\";s:16:\"show_no_articles\";s:1:\"1\";s:32:\"show_category_heading_title_text\";s:1:\"1\";s:16:\"show_subcat_desc\";s:1:\"1\";s:21:\"show_cat_num_articles\";s:1:\"0\";s:13:\"show_cat_tags\";s:1:\"1\";s:21:\"show_base_description\";s:1:\"1\";s:11:\"maxLevelcat\";s:2:\"-1\";s:25:\"show_empty_categories_cat\";s:1:\"0\";s:20:\"show_subcat_desc_cat\";s:1:\"1\";s:25:\"show_cat_num_articles_cat\";s:1:\"1\";s:20:\"num_leading_articles\";i:1;s:18:\"blog_class_leading\";s:0:\"\";s:18:\"num_intro_articles\";i:4;s:10:\"blog_class\";s:0:\"\";s:11:\"num_columns\";i:2;s:18:\"multi_column_order\";s:1:\"0\";s:9:\"num_links\";i:4;s:24:\"show_subcategory_content\";s:1:\"0\";s:16:\"link_intro_image\";s:1:\"1\";s:21:\"show_pagination_limit\";s:1:\"1\";s:12:\"filter_field\";s:4:\"hide\";s:13:\"show_headings\";s:1:\"1\";s:14:\"list_show_date\";s:1:\"0\";s:11:\"date_format\";s:0:\"\";s:14:\"list_show_hits\";s:1:\"1\";s:16:\"list_show_author\";s:1:\"1\";s:15:\"list_show_votes\";s:1:\"0\";s:17:\"list_show_ratings\";s:1:\"0\";s:11:\"orderby_pri\";s:5:\"order\";s:11:\"orderby_sec\";s:5:\"rdate\";s:10:\"order_date\";s:9:\"published\";s:15:\"show_pagination\";s:1:\"2\";s:23:\"show_pagination_results\";s:1:\"1\";s:13:\"show_featured\";s:4:\"show\";s:14:\"show_feed_link\";s:1:\"1\";s:12:\"feed_summary\";s:1:\"0\";s:18:\"feed_show_readmore\";s:1:\"0\";s:7:\"sef_ids\";i:1;s:20:\"custom_fields_enable\";s:1:\"1\";s:16:\"workflow_enabled\";s:1:\"0\";}s:14:\"\0*\0initialized\";b:1;s:12:\"\0*\0separator\";s:1:\".\";}s:7:\"metakey\";s:0:\"\";s:8:\"metadesc\";s:0:\"\";s:8:\"metadata\";O:24:\"Joomla\\Registry\\Registry\":3:{s:7:\"\0*\0data\";O:8:\"stdClass\":3:{s:6:\"robots\";s:0:\"\";s:6:\"author\";s:0:\"\";s:6:\"rights\";s:0:\"\";}s:14:\"\0*\0initialized\";b:1;s:12:\"\0*\0separator\";s:1:\".\";}s:7:\"version\";i:31;s:8:\"ordering\";i:4;s:8:\"category\";s:4:\"Blog\";s:9:\"cat_state\";i:1;s:10:\"cat_access\";i:1;s:4:\"slug\";s:46:\"9:our-guide-to-3d-graphic-design-for-beginners\";s:7:\"catslug\";s:6:\"7:blog\";s:6:\"author\";s:5:\"admin\";s:4:\"mime\";N;s:6:\"layout\";s:7:\"article\";s:7:\"context\";s:19:\"com_content.article\";s:8:\"imageUrl\";s:98:\"images/sampledata/blog5.jpg#joomlaImage://local-images/sampledata/blog5.jpg?width=2400&height=1599\";s:8:\"imageAlt\";s:0:\"\";s:10:\"metaauthor\";N;}i:4;N;i:5;a:5:{i:1;a:3:{i:0;s:5:\"title\";i:1;s:8:\"subtitle\";i:2;s:2:\"id\";}i:2;a:2:{i:0;s:7:\"summary\";i:1;s:4:\"body\";}i:3;a:8:{i:0;s:4:\"meta\";i:1;s:10:\"list_price\";i:2;s:10:\"sale_price\";i:3;s:7:\"metakey\";i:4;s:8:\"metadesc\";i:5;s:10:\"metaauthor\";i:6;s:6:\"author\";i:7;s:16:\"created_by_alias\";}i:4;a:2:{i:0;s:4:\"path\";i:1;s:5:\"alias\";}i:5;a:1:{i:0;s:8:\"comments\";}}i:6;s:1:\"*\";i:7;N;i:8;N;i:9;s:19:\"2021-05-15 20:55:59\";i:10;N;i:11;s:99:\"index.php?option=com_content&view=article&id=9:our-guide-to-3d-graphic-design-for-beginners&catid=7\";i:12;N;i:13;s:19:\"1980-01-01 00:00:00\";i:14;i:1;i:15;a:4:{s:4:\"Type\";a:1:{i:0;O:8:\"stdClass\":6:{s:5:\"title\";s:7:\"Article\";s:5:\"state\";i:1;s:6:\"access\";i:1;s:8:\"language\";s:0:\"\";s:6:\"nested\";b:0;s:2:\"id\";i:13;}}s:6:\"Author\";a:1:{i:0;O:8:\"stdClass\":6:{s:5:\"title\";s:5:\"admin\";s:5:\"state\";i:1;s:6:\"access\";i:1;s:8:\"language\";s:0:\"\";s:6:\"nested\";b:0;s:2:\"id\";i:15;}}s:8:\"Category\";a:1:{i:0;O:8:\"stdClass\":6:{s:5:\"title\";s:4:\"Blog\";s:5:\"state\";i:1;s:6:\"access\";i:1;s:8:\"language\";s:1:\"*\";s:6:\"nested\";b:1;s:2:\"id\";i:18;}}s:8:\"Language\";a:1:{i:0;O:8:\"stdClass\":6:{s:5:\"title\";s:1:\"*\";s:5:\"state\";i:1;s:6:\"access\";i:1;s:8:\"language\";s:0:\"\";s:6:\"nested\";b:0;s:2:\"id\";i:5;}}}i:16;s:44:\"Our guide to 3D graphic design for beginners\";i:17;i:4;i:18;s:46:\"index.php?option=com_content&view=article&id=9\";}');/**ABDB**/
